<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>ترنسمیتال - {{ $trans->transmittal_number }}</title>
    <style>
        body {
            font-family: 'vazir', sans-serif;
            direction: rtl;
            padding: 20px;
            background-color: #f9f9f9;
        }

        h2 {
            text-align: center;
            color: #2c3e50;
            margin-bottom: 20px;
            border-bottom: 2px solid #ddd;
            padding-bottom: 10px;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }

        .label {
            font-weight: bold;
            width: 100px;
            min-width: 100px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 25px;
            background-color: #fff;
            box-shadow: 0 0 4px rgba(0,0,0,0.05);
        }

        th, td {
            border: 1px solid #ccc;
            padding: 10px;
            font-size: 12px;
            text-align: right;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px dashed #ccc;
            padding-top: 10px;
        }

        .qr-code {
            text-align: center;
            margin-top: 30px;
        }
    </style>
</head>
<body>

<h2>{{ $trans->transmittal_number }}</h2>

<div class="info-row">
    <div><span class="label">پروژه:</span> {{ optional($trans->project)->name ?? '-' }}</div>
    <div><span class="label">فرستنده:</span> {{ optional($trans->sender)->name ?? '-' }}</div>
    <div><span class="label">گیرنده:</span> {{ optional($trans->receiver)->name ?? '-' }}</div>
</div>

<div class="info-row">
    <div><span class="label">هدف:</span> {{ $trans->purpose ?? '-' }}</div>
    <div><span class="label">توضیحات:</span> {{ $trans->description ?? '-' }}</div>
    <div><span class="label">تاریخ:</span> {{ $trans->date ?? jdate($trans->created_at)->format('Y/m/d') }}</div>
</div>

<!-- جدول مدارک -->
<h4 style="margin-top: 30px;">لیست مدارک ارسالی</h4>
<table>
    <thead>
    <tr>
        <th>#</th>
        <th>شماره سند</th>
        <th>عنوان</th>
        <th>ریویژن</th>
        <th>توضیحات</th>
    </tr>
    </thead>
    <tbody>
    @foreach($trans->documents as $index => $doc)
        <tr>
            <td>{{ $loop->iteration }}</td>
            <td>{{ optional($doc->masterDocument)->document_number ?? '-' }}</td>
            <td>{{ optional($doc->masterDocument)->title ?? '-' }}</td>
            <td>{{ $doc->revision ?? '-' }}</td>
            <td>{{ $doc->description ?? '-' }}</td>
        </tr>
    @endforeach
    </tbody>
</table>

<!-- گیرندگان CC -->
@if(optional($trans->recipients)->isNotEmpty())
    <h4 style="margin-top: 25px;">گیرندگان CC</h4>
    <ul style="list-style: none; padding: 0;">
        @foreach($trans->recipients as $recipient)
            <li>
                {{ optional($recipient->user)->name ?? 'نامشخص' }} ({{ $recipient->role }})
            </li>
        @endforeach
    </ul>
@endif

<!-- QR Code -->
<div class="qr-code">
    {!! QrCode::size(200)->generate(route('transmittal.show', $trans->id)) !!}
</div>

<!-- Footer -->
<div class="footer">
    تولید شده در {{ now()->format('Y-m-d H:i') }}
</div>

</body>
</html>
