<div>
    <div class="admin-dashboard" id="top-of-page">
        <!-- آمار کاربران با طراحی مدرن -->
        <div class="stats-grid">
            <div class="stat-card primary-gradient">
                <div class="stat-content">
                    <div class="stat-info">
                        <div class="stat-number">{{ $totalUsers }}</div>
                        <div class="stat-label">کل کاربران سیستم</div>
                    </div>
                    <div class="stat-icon">
                        <i class="ti ti-users"></i>
                    </div>
                </div>
                <div class="stat-footer">
                    <i class="ti ti-trending-up"></i>
                    <span>کل کاربران ثبت‌شده</span>
                </div>
            </div>

            <div class="stat-card success-gradient">
                <div class="stat-content">
                    <div class="stat-info">
                        <div class="stat-number">{{ $activeCount }}</div>
                        <div class="stat-label">کاربران فعال</div>
                    </div>
                    <div class="stat-icon">
                        <i class="ti ti-user-check"></i>
                    </div>
                </div>
                <div class="stat-footer">
                    <i class="ti ti-circle-filled"></i>
                    <span>آنلاین</span>
                </div>
            </div>

            <div class="stat-card warning-gradient">
                <div class="stat-content">
                    <div class="stat-info">
                        <div class="stat-number">{{ $inactiveCount }}</div>
                        <div class="stat-label">کاربران غیرفعال</div>
                    </div>
                    <div class="stat-icon">
                        <i class="ti ti-user-off"></i>
                    </div>
                </div>
                <div class="stat-footer">
                    <i class="ti ti-clock"></i>
                    <span>آفلاین</span>
                </div>
            </div>
        </div>

        <!-- آلرت‌های سیستم -->
        @if(session()->has('success') || session()->has('error'))
            <div class="alert-system {{ session()->has('success') ? 'success' : 'error' }}">
                <div class="alert-icon">
                    <i class="ti ti-{{ session()->has('success') ? 'check' : 'alert-triangle' }}"></i>
                </div>
                <div class="alert-content">
                    <div class="alert-title">{{ session()->has('success') ? 'موفقیت' : 'خطا' }}</div>
                    <div class="alert-message">{{ session('success') ?? session('error') }}</div>
                </div>
                <button type="button" class="alert-close" data-bs-dismiss="alert">
                    <i class="ti ti-x"></i>
                </button>
            </div>
        @endif

        <!-- هدر فرم کاربر -->
        <div class="section-header">
            <div class="header-content">
                <div class="header-title">
                    <i class="ti ti-user-plus"></i>
                    <h2>{{ $editMode ? 'ویرایش کاربر: ' . $name : 'ایجاد کاربر جدید' }}</h2>
                </div>
                <div class="header-badge">
                    <span>{{ $editMode ? 'شناسه: ' . $userId : 'فرم مدیریت کاربران' }}</span>
                </div>
            </div>
        </div>

        <!-- فرم کاربر با تب‌های مدرن -->
        <div class="form-container">
            <div class="form-tabs">
                <div class="tab-nav">
                    <button class="tab-button active" data-tab="personal">
                        <i class="ti ti-user-circle"></i>
                        <span>مشخصات شخصی</span>
                    </button>
                    <button class="tab-button" data-tab="advanced">
                        <i class="ti ti-lock"></i>
                        <span>امنیت و نقش‌ها</span>
                    </button>
                </div>

                <div class="tab-content">
                    <form wire:submit.prevent="saveUser">
                        <!-- تب مشخصات شخصی -->
                        <div class="tab-pane active" id="personal">
                            <div class="form-grid">
                                <div class="form-column">
                                    <div class="input-group">
                                        <label class="input-label">نام کامل <span class="required">*</span></label>
                                        <input type="text"
                                               class="input-field @error('name') error @enderror"
                                               wire:model.defer="name"
                                               placeholder="نام و نام خانوادگی">
                                        @error('name')
                                        <div class="input-error">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-row">
                                        <div class="input-group">
                                            <label class="input-label">ایمیل <span class="required">*</span></label>
                                            <input type="email"
                                                   class="input-field @error('email') error @enderror"
                                                   wire:model.defer="email"
                                                   placeholder="example@company.com">
                                            @error('email')
                                            <div class="input-error">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="input-group">
                                            <label class="input-label">موبایل <span class="required">*</span></label>
                                            <input type="tel"
                                                   class="input-field @error('mobile') error @enderror"
                                                   wire:model.defer="mobile"
                                                   placeholder="09123456789">
                                            @error('mobile')
                                            <div class="input-error">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="input-group">
                                            <label class="input-label">کد ملی <span class="required">*</span></label>
                                            <input type="text"
                                                   class="input-field @error('ncode') error @enderror"
                                                   wire:model.defer="ncode"
                                                   placeholder="0123456789">
                                            @error('ncode')
                                            <div class="input-error">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="input-group">
                                            <label class="input-label">شماره داخلی</label>
                                            <input type="text"
                                                   class="input-field @error('internal_number') error @enderror"
                                                   wire:model.defer="internal_number"
                                                   placeholder="101">
                                            @error('internal_number')
                                            <div class="input-error">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="form-column">
                                    <div class="form-row">
                                        <div class="input-group">
                                            <label class="input-label">شرکت</label>
                                            <select class="input-field" wire:model.live="company_id">
                                                <option value="">انتخاب شرکت</option>
                                                @foreach($companies as $company)
                                                    <option value="{{ $company->id }}">{{ $company->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="input-group">
                                            <label class="input-label">دپارتمان</label>
                                            <select class="input-field @error('department_id') error @enderror"
                                                    wire:model.defer="department_id"
                                                @disabled(!$company_id)>
                                                <option value="">انتخاب دپارتمان</option>
                                                @foreach($departments as $dep)
                                                    <option value="{{ $dep->id }}">{{ $dep->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('department_id')
                                            <div class="input-error">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="input-group">
                                        <label class="input-label">مدرک تحصیلی</label>
                                        <select class="input-field" wire:model.defer="degree">
                                            <option value="">انتخاب مدرک</option>
                                            @foreach($degrees as $deg)
                                                <option value="{{ $deg }}">{{ $deg }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="file-upload-section">
                                        <div class="file-upload-group">
                                            <label class="input-label">تصویر پروفایل</label>
                                            <div class="file-input-container">
                                                <input type="file"
                                                       class="file-input @error('image') error @enderror"
                                                       wire:model="image"
                                                       accept="image/*">
                                                <div class="file-input-button">
                                                    <i class="ti ti-upload"></i>
                                                    <span>انتخاب فایل</span>
                                                </div>
                                            </div>
                                            <div wire:loading wire:target="image" class="upload-loading">
                                                <i class="ti ti-loader animate-spin"></i>
                                                <span>در حال بارگذاری...</span>
                                            </div>
                                            @error('image')
                                            <div class="input-error">{{ $message }}</div>
                                            @enderror

                                            <div class="file-preview">
                                                @if($image)
                                                    <img src="{{ $image->temporaryUrl() }}" class="preview-image">
                                                    <button type="button" class="preview-remove" wire:click="$set('image', null)">
                                                        <i class="ti ti-x"></i>
                                                    </button>
                                                @elseif($currentImage)
                                                    <img src="{{ $this->getImageUrl($currentImage) }}" class="preview-image">
                                                    <button type="button" class="preview-remove" title="حذف تصویر فعلی" wire:click="deleteCurrentFile('image')">
                                                        <i class="ti ti-trash"></i>
                                                    </button>
                                                @else
                                                    <div class="preview-placeholder">
                                                        <i class="ti ti-user"></i>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="file-upload-group">
                                            <label class="input-label">امضای دیجیتال</label>
                                            <div class="file-input-container">
                                                <input type="file"
                                                       class="file-input @error('sign') error @enderror"
                                                       wire:model="sign"
                                                       accept="image/*">
                                                <div class="file-input-button">
                                                    <i class="ti ti-upload"></i>
                                                    <span>انتخاب فایل</span>
                                                </div>
                                            </div>
                                            <div wire:loading wire:target="sign" class="upload-loading">
                                                <i class="ti ti-loader animate-spin"></i>
                                                <span>در حال بارگذاری...</span>
                                            </div>
                                            @error('sign')
                                            <div class="input-error">{{ $message }}</div>
                                            @enderror

                                            <div class="file-preview signature">
                                                @if($sign)
                                                    <img src="{{ $sign->temporaryUrl() }}" class="preview-image">
                                                    <button type="button" class="preview-remove" wire:click="$set('sign', null)">
                                                        <i class="ti ti-x"></i>
                                                    </button>
                                                @elseif($currentSign)
                                                    <img src="{{ $this->getImageUrl($currentSign, true) }}" class="preview-image">
                                                    <button type="button" class="preview-remove" title="حذف امضای فعلی" wire:click="deleteCurrentFile('sign')">
                                                        <i class="ti ti-trash"></i>
                                                    </button>
                                                @else
                                                    <div class="preview-placeholder signature">
                                                        <i class="ti ti-signature"></i>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- تب امنیت و نقش‌ها -->
                        <div class="tab-pane" id="advanced">
                            <div class="form-grid">
                                <div class="input-group">
                                    <label class="input-label">جنسیت</label>
                                    <div class="radio-group">
                                        <label class="radio-option">
                                            <input type="radio" value="male" wire:model.defer="gender">
                                            <span class="radio-checkmark"></span>
                                            <i class="ti ti-gender-male"></i>
                                            <span>مرد</span>
                                        </label>
                                        <label class="radio-option">
                                            <input type="radio" value="female" wire:model.defer="gender">
                                            <span class="radio-checkmark"></span>
                                            <i class="ti ti-gender-female"></i>
                                            <span>زن</span>
                                        </label>
                                    </div>
                                </div>

                                <div class="input-group">
                                    <label class="input-label">نقش کاربر</label>
                                    <select class="input-field" wire:model.defer="role">
                                        <option value="">انتخاب نقش</option>
                                        <option value="admin">مدیر سیستم</option>
                                        <option value="manager">مدیر </option>
                                        <option value="editor">ویرایشگر</option>
                                        <option value="user">کاربر عادی</option>
                                        <option value="guest">مهمان</option>
                                    </select>
                                    @error('role')
                                    <div class="input-error">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="input-group">
                                    <label class="input-label">وضعیت</label>
                                    <select class="input-field" wire:model.defer="status">
                                        <option value="">انتخاب وضعیت</option>
                                        <option value="active">فعال</option>
                                        <option value="inactive">غیرفعال</option>
                                    </select>
                                    @error('status')
                                    <div class="input-error">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="security-settings">
                                    <div class="security-header">
                                        <i class="ti ti-key"></i>
                                        <h4>تنظیمات رمز عبور</h4>
                                    </div>

                                    @if(!$editMode)
                                        <div class="input-group">
                                            <label class="input-label">رمز عبور <span class="required">*</span></label>
                                            <input type="password"
                                                   class="input-field @error('password') error @enderror"
                                                   wire:model.defer="password"
                                                   placeholder="حداقل 6 کاراکتر">
                                            @error('password')
                                            <div class="input-error">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="input-group">
                                            <label class="input-label">تکرار رمز عبور <span class="required">*</span></label>
                                            <input type="password"
                                                   class="input-field"
                                                   wire:model.defer="password_confirmation"
                                                   placeholder="تکرار رمز عبور">
                                            @error('password_confirmation')
                                            <div class="input-error d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    @else
                                        <div class="info-notice">
                                            <i class="ti ti-info-circle"></i>
                                            <span>برای عدم تغییر، فیلدها را خالی بگذارید.</span>
                                        </div>
                                        <div class="input-group">
                                            <label class="input-label">رمز عبور جدید</label>
                                            <input type="password"
                                                   class="input-field @error('password') error @enderror"
                                                   wire:model.defer="password"
                                                   placeholder="حداقل 6 کاراکتر">
                                            @error('password')
                                            <div class="input-error">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="input-group">
                                            <label class="input-label">تکرار رمز عبور جدید</label>
                                            <input type="password"
                                                   class="input-field @error('password_confirmation') error @enderror"
                                                   wire:model.defer="password_confirmation"
                                                   placeholder="تکرار رمز عبور">
                                            @error('password_confirmation')
                                            <div class="input-error d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- دکمه‌های فرم -->
                        <div class="form-actions">
                            @if($editMode)
                                <button type="button"
                                        wire:click="cancelEdit"
                                        class="btn btn-secondary">
                                    <i class="ti ti-x"></i>
                                    <span>انصراف</span>
                                </button>
                                <button type="submit"
                                        class="btn btn-primary"
                                        wire:loading.attr="disabled">
                                <span wire:loading.remove>
                                    <i class="ti ti-device-floppy"></i>
                                    <span>ذخیره تغییرات</span>
                                </span>
                                    <span wire:loading>
                                    <i class="ti ti-loader animate-spin"></i>
                                    <span>در حال ذخیره...</span>
                                </span>
                                </button>
                            @else
                                <button type="button"
                                        wire:click="resetForm"
                                        class="btn btn-warning">
                                    <i class="ti ti-refresh"></i>
                                    <span>پاک کردن</span>
                                </button>
                                <button type="submit"
                                        class="btn btn-success"
                                        wire:loading.attr="disabled">
                                <span wire:loading.remove>
                                    <i class="ti ti-plus"></i>
                                    <span>ایجاد کاربر</span>
                                </span>
                                    <span wire:loading>
                                    <i class="ti ti-loader animate-spin"></i>
                                    <span>در حال ایجاد...</span>
                                </span>
                                </button>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- لیست کاربران -->
        <div class="users-list-section">
            <div class="section-header">
                <div class="header-content">
                    <div class="header-title">
                        <i class="ti ti-list-details"></i>
                        <h2>فهرست جامع کاربران</h2>
                    </div>

                    <div class="list-controls">
                        <div class="search-box">
                            <i class="ti ti-search"></i>
                            <input type="text"
                                   placeholder="جستجوی نام، ایمیل، موبایل یا داخلی..."
                                   wire:model.live.debounce.300ms="search">
                        </div>

                        <button wire:click="resetListFilters" class="control-btn" title="حذف همه فیلترها">
                            <i class="ti ti-filter-off"></i>
                        </button>

                        <div class="filter-dropdown">
                            <button class="control-btn dropdown-toggle">
                                <i class="ti ti-adjustments-alt"></i>
                                <span>فیلترهای پیشرفته</span>
                            </button>
                            <div class="dropdown-menu">
                                <div class="dropdown-header">
                                    <h6>تنظیمات فهرست</h6>
                                </div>

                                <div class="filter-group">
                                    <label>تعداد در صفحه:</label>
                                    <select wire:model.live="perPage">
                                        @foreach($perPageOptions as $p)
                                            <option value="{{ $p }}">{{ $p }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="filter-divider"></div>

                                <div class="filter-group">
                                    <label>شرکت:</label>
                                    <select wire:model.live="filterCompanyId">
                                        <option value="">همه شرکت‌ها</option>
                                        @foreach($companies as $c)
                                            <option value="{{ $c->id }}">{{ $c->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="filter-group">
                                    <label>دپارتمان:</label>
                                    <select wire:model.live="filterDepartmentId" @disabled(!$filterCompanyId)>
                                        <option value="">همه دپارتمان‌ها</option>
                                        @foreach($filterDepartments as $fd)
                                            <option value="{{ $fd->id }}">{{ $fd->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="filter-group">
                                    <label>نقش:</label>
                                    <select wire:model.live="filterRole">
                                        <option value="">همه نقش‌ها</option>
                                        @foreach($roles as $r)
                                            <option value="{{ $r }}">{{ $r }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="filter-group">
                                    <label>وضعیت:</label>
                                    <select wire:model.live="filterStatus">
                                        <option value="">همه وضعیت‌ها</option>
                                        <option value="active">فعال</option>
                                        <option value="inactive">غیرفعال</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="table-container">
                <table class="users-table">
                    <thead>
                    <tr>
                        <th style="width: 50px;">#</th>
                        <th class="sortable" wire:click="sortBy('name')">
                            <span>نام</span>
                            <i class="ti {{ $sortField==='name' ? ($sortDirection==='asc'?'ti-sort-ascending':'ti-sort-descending') : 'ti-sort' }}"></i>
                        </th>
                        <th class="sortable" wire:click="sortBy('email')">
                            <span>ایمیل</span>
                            <i class="ti {{ $sortField==='email' ? ($sortDirection==='asc'?'ti-sort-ascending':'ti-sort-descending') : 'ti-sort' }}"></i>
                        </th>
                        <th class="sortable" wire:click="sortBy('mobile')">
                            <span>موبایل</span>
                            <i class="ti {{ $sortField==='mobile' ? ($sortDirection==='asc'?'ti-sort-ascending':'ti-sort-descending') : 'ti-sort' }}"></i>
                        </th>
                        <th>شماره داخلی</th>
                        <th class="sortable" wire:click="sortBy('role')">
                            <span>نقش</span>
                            <i class="ti {{ $sortField==='role' ? ($sortDirection==='asc'?'ti-sort-ascending':'ti-sort-descending') : 'ti-sort' }}"></i>
                        </th>
                        <th class="sortable" wire:click="sortBy('status')">
                            <span>وضعیت</span>
                            <i class="ti {{ $sortField==='status' ? ($sortDirection==='asc'?'ti-sort-ascending':'ti-sort-descending') : 'ti-sort' }}"></i>
                        </th>
                        <th class="sortable" wire:click="sortBy('last_login_at')">
                            <span>آخرین ورود</span>
                            <i class="ti {{ $sortField==='last_login_at' ? ($sortDirection==='asc'?'ti-sort-ascending':'ti-sort-descending') : 'ti-sort' }}"></i>
                        </th>
                        <th class="actions">عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($users as $index => $user)
                        <tr>
                            <td>{{ $index + 1 + ($users->currentPage() - 1) * $users->perPage() }}</td>
                            <td>
                                <div class="user-cell">
                                    @if($user->image)
                                        <img src="{{ $this->getImageUrl($user->image) }}"
                                             class="user-avatar"
                                             onerror="this.onerror=null;this.src='{{ asset('panel/dist/images/profile/user-1.jpg') }}';">
                                    @else
                                        <div class="user-avatar fallback">
                                            {{ strtoupper(mb_substr($user->name,0,1)) }}
                                        </div>
                                    @endif
                                    <a href="javascript:void(0)"
                                       class="user-name"
                                       wire:click="openQuickView({{ $user->id }})">
                                        {{ $user->name }}
                                    </a>
                                </div>
                            </td>
                            <td>{{ $user->email }}</td>
                            <td>{{ $user->mobile }}</td>
                            <td>{{ $user->internal_number ?? '—' }}</td>
                            <td>
                                @php
                                    $roleLabels = [
                                        'admin' => 'مدیر سیستم', 'manager' => 'مدیر پروژه', 'editor' => 'ویرایشگر',
                                        'user' => 'کاربر عادی', 'guest' => 'مهمان'
                                    ];
                                    $roleColors = [
                                        'admin' => 'danger', 'manager' => 'warning', 'editor' => 'info',
                                        'user' => 'secondary', 'guest' => 'light'
                                    ];
                                    $role = $user->role ?? 'user';
                                @endphp
                                <span class="badge badge-{{ $roleColors[$role] ?? 'secondary' }}">
                                    {{ $roleLabels[$role] ?? 'نامشخص' }}
                                </span>
                            </td>
                            <td>
                                <span class="status-badge {{ $user->status === 'active' ? 'active' : 'inactive' }}">
                                    <i class="ti ti-user-{{ $user->status === 'active' ? 'check' : 'off' }}"></i>
                                    {{ $user->status === 'active' ? 'فعال' : 'غیرفعال' }}
                                </span>
                            </td>
                            <td>
                                <div class="last-login">
                                    <i class="ti ti-clock"></i>
                                    <span>{{ $user->last_login_at ? $user->last_login_at->diffForHumans() : '—' }}</span>
                                </div>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    <button wire:click="editUser({{ $user->id }})"
                                            class="action-btn edit"
                                            title="ویرایش">
                                        <i class="ti ti-edit"></i>
                                    </button>
                                    <button wire:click="showResetPasswordForm({{ $user->id }})"
                                            class="action-btn security"
                                            title="تغییر رمز">
                                        <i class="ti ti-key"></i>
                                    </button>
                                    <button wire:click="deleteUser({{ $user->id }})"
                                            class="action-btn delete"
                                            title="حذف">
                                        <i class="ti ti-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="empty-state">
                                <div class="empty-content">
                                    <i class="ti ti-user-x"></i>
                                    <h3>کاربری یافت نشد</h3>
                                    <p>لطفاً فیلترها یا عبارت جستجو را تغییر دهید.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            <div class="pagination-container">
                {{ $users->links() }}
            </div>
        </div>
    </div>

    <!-- مودال تغییر رمز عبور -->
    @if($resetPasswordUserId)
        <div class="modal-overlay" wire:click.self="closeResetPasswordModal">
            <div class="modal-container">
                <div class="modal-header">
                    <div class="modal-title">
                        <i class="ti ti-key"></i>
                        <h3>تغییر رمز عبور</h3>
                    </div>
                    <button type="button" class="modal-close" wire:click="closeResetPasswordModal">
                        <i class="ti ti-x"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="modal-description">رمز عبور جدید را برای کاربر <strong>{{ $quickViewUser->name ?? 'انتخاب شده' }}</strong> وارد کنید.</p>

                    <div class="input-group">
                        <label class="input-label">رمز عبور جدید</label>
                        <input type="password"
                               class="input-field @error('newPassword') error @enderror"
                               wire:model.defer="newPassword"
                               placeholder="حداقل 6 کاراکتر">
                        @error('newPassword')
                        <div class="input-error">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="input-group">
                        <label class="input-label">تکرار رمز عبور جدید</label>
                        <input type="password"
                               class="input-field @error('newPasswordConfirmation') error @enderror"
                               wire:model.defer="newPasswordConfirmation"
                               placeholder="تکرار رمز عبور">
                        @error('newPasswordConfirmation')
                        <div class="input-error">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button"
                            class="btn btn-secondary"
                            wire:click="closeResetPasswordModal">
                        انصراف
                    </button>
                    <button type="button"
                            class="btn btn-primary"
                            wire:click="updatePassword"
                            wire:loading.attr="disabled">
                    <span wire:loading.remove>
                        <i class="ti ti-device-floppy"></i>
                        <span>ذخیره رمز</span>
                    </span>
                        <span wire:loading>
                        <i class="ti ti-loader animate-spin"></i>
                        <span>ذخیره...</span>
                    </span>
                    </button>
                </div>
            </div>
        </div>
    @endif

    <!-- پنل جزئیات کاربر -->
    @if($showQuickView && $quickViewUser)
        <div class="side-panel-overlay" wire:click="closeQuickView">
            <div class="side-panel">
                <div class="side-panel-header">
                    <div class="panel-title">
                        <i class="ti ti-user-scan"></i>
                        <h3>جزئیات کاربر</h3>
                    </div>
                    <button type="button" class="panel-close" wire:click="closeQuickView">
                        <i class="ti ti-x"></i>
                    </button>
                </div>
                <div class="side-panel-body">
                    <div class="user-profile-header">
                        @if($quickViewUser->image)
                            <img src="{{ $this->getImageUrl($quickViewUser->image) }}"
                                 class="profile-avatar"
                                 onerror="this.onerror=null;this.src='{{ asset('panel/dist/images/profile/user-1.jpg') }}';">
                        @else
                            <div class="profile-avatar fallback">
                                {{ strtoupper(mb_substr($quickViewUser->name,0,1)) }}
                            </div>
                        @endif
                        <div class="profile-info">
                            <h3 class="profile-name">{{ $quickViewUser->name }}</h3>
                            <p class="profile-email">
                                <i class="ti ti-mail"></i>
                                {{ $quickViewUser->email }}
                            </p>
                            <div class="profile-badges">
                            <span class="status-badge {{ $quickViewUser->status === 'active' ? 'active' : 'inactive' }}">
                                <i class="ti ti-user-{{ $quickViewUser->status === 'active' ? 'check' : 'off' }}"></i>
                                {{ $quickViewUser->status === 'active' ? 'فعال' : 'غیرفعال' }}
                            </span>
                                <span class="role-badge">
                                <i class="ti ti-shield"></i>
                                {{ $quickViewUser->role }}
                            </span>
                            </div>
                        </div>
                    </div>

                    <div class="info-section">
                        <h4 class="section-title">
                            <i class="ti ti-building-community"></i>
                            اطلاعات سازمانی
                        </h4>
                        <div class="info-grid">
                            <div class="info-item">
                                <span class="info-label">شرکت:</span>
                                <span class="info-value">{{ optional($quickViewUser->department?->company)->name ?? '—' }}</span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">دپارتمان:</span>
                                <span class="info-value">{{ optional($quickViewUser->department)->name ?? '—' }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="info-section">
                        <h4 class="section-title">
                            <i class="ti ti-id"></i>
                            مشخصات فردی و تماس
                        </h4>
                        <div class="info-grid">
                            <div class="info-item">
                                <span class="info-label">کد ملی:</span>
                                <span class="info-value">{{ $quickViewUser->ncode }}</span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">مدرک تحصیلی:</span>
                                <span class="info-value">{{ $quickViewUser->degree ?? '—' }}</span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">موبایل:</span>
                                <span class="info-value">{{ $quickViewUser->mobile }}</span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">شماره داخلی:</span>
                                <span class="info-value">{{ $quickViewUser->internal_number ?? '—' }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="info-section">
                        <h4 class="section-title">
                            <i class="ti ti-database-cog"></i>
                            لاگ‌های سیستم
                        </h4>
                        <div class="info-grid">
                            <div class="info-item">
                                <span class="info-label">آخرین ورود:</span>
                                <span class="info-value">{{ $quickViewUser->last_login_at ? $quickViewUser->last_login_at->diffForHumans() : '—' }}</span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">تاریخ ایجاد:</span>
                                <span class="info-value">{{ $quickViewUser->created_at->format('Y/m/d H:i') }}</span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">آخرین بروزرسانی:</span>
                                <span class="info-value">{{ $quickViewUser->updated_at->diffForHumans() }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="panel-actions">
                        <button class="btn btn-primary" wire:click="editUser({{ $quickViewUser->id }})">
                            <i class="ti ti-edit"></i>
                            <span>ویرایش</span>
                        </button>
                        <button class="btn btn-secondary" wire:click="showResetPasswordForm({{ $quickViewUser->id }})">
                            <i class="ti ti-key"></i>
                            <span>تغییر رمز</span>
                        </button>
                        <button class="btn btn-danger" wire:click="deleteUser({{ $quickViewUser->id }})">
                            <i class="ti ti-trash"></i>
                            <span>حذف کاربر</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #4895ef;
            --secondary: #6c757d;
            --success: #2ecc71;
            --warning: #f39c12;
            --danger: #e74c3c;
            --info: #3498db;
            --light: #f8f9fa;
            --dark: #343a40;
            --gray-100: #f8f9fa;
            --gray-200: #e9ecef;
            --gray-300: #dee2e6;
            --gray-400: #ced4da;
            --gray-500: #adb5bd;
            --gray-600: #6c757d;
            --gray-700: #495057;
            --gray-800: #343a40;
            --gray-900: #212529;
            --border-radius: 12px;
            --border-radius-sm: 8px;
            --border-radius-lg: 16px;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            --transition: all 0.3s ease;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Vazirmatn', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f7fb;
            color: var(--gray-800);
            line-height: 1.6;
        }

        .admin-dashboard {
            padding: 1.5rem;
            max-width: 1400px;
            margin: 0 auto;
        }

        /* استایل کارت‌های آمار */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .stat-card {
            background: white;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow);
            overflow: hidden;
            transition: var(--transition);
            position: relative;
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-lg);
        }

        .stat-card.primary-gradient {
            background: linear-gradient(135deg, #4361ee, #3a56d4);
        }

        .stat-card.success-gradient {
            background: linear-gradient(135deg, #2ecc71, #27ae60);
        }

        .stat-card.warning-gradient {
            background: linear-gradient(135deg, #f39c12, #e67e22);
        }

        .stat-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1.5rem;
            color: white;
        }

        .stat-info .stat-number {
            font-size: 2.5rem;
            font-weight: 700;
            line-height: 1;
            margin-bottom: 0.5rem;
        }

        .stat-info .stat-label {
            font-size: 0.9rem;
            opacity: 0.9;
        }

        .stat-icon {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .stat-icon i {
            font-size: 1.8rem;
        }

        .stat-footer {
            background: rgba(0, 0, 0, 0.1);
            padding: 0.75rem 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.85rem;
            color: rgba(255, 255, 255, 0.9);
        }

        /* استایل هدر بخش‌ها */
        .section-header {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            margin-bottom: 1.5rem;
            overflow: hidden;
        }

        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1.25rem 1.5rem;
        }

        .header-title {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .header-title i {
            font-size: 1.5rem;
            color: var(--primary);
        }

        .header-title h2 {
            font-size: 1.25rem;
            font-weight: 700;
            margin: 0;
            color: var(--gray-800);
        }

        .header-badge span {
            background: var(--gray-100);
            color: var(--gray-700);
            padding: 0.5rem 1rem;
            border-radius: 50px;
            font-size: 0.85rem;
            font-weight: 500;
        }

        /* استایل فرم */
        .form-container {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            overflow: hidden;
            margin-bottom: 2rem;
        }

        .form-tabs {
            display: flex;
            flex-direction: column;
        }

        .tab-nav {
            display: flex;
            background: var(--gray-100);
            border-bottom: 1px solid var(--gray-200);
        }

        .tab-button {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 1rem 1.5rem;
            background: transparent;
            border: none;
            cursor: pointer;
            transition: var(--transition);
            font-weight: 500;
            color: var(--gray-600);
            border-bottom: 3px solid transparent;
        }

        .tab-button:hover {
            background: var(--gray-200);
            color: var(--gray-800);
        }

        .tab-button.active {
            color: var(--primary);
            border-bottom-color: var(--primary);
            background: white;
        }

        .tab-content {
            padding: 2rem;
        }

        .tab-pane {
            display: none;
        }

        .tab-pane.active {
            display: block;
        }

        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 2rem;
        }

        .form-column {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }

        .input-group {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }

        .input-label {
            font-weight: 600;
            color: var(--gray-700);
            font-size: 0.9rem;
        }

        .input-label .required {
            color: var(--danger);
        }

        .input-field {
            padding: 0.75rem 1rem;
            border: 1px solid var(--gray-300);
            border-radius: var(--border-radius-sm);
            font-size: 0.95rem;
            transition: var(--transition);
            background: white;
        }

        .input-field:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .input-field.error {
            border-color: var(--danger);
        }

        .input-error {
            color: var(--danger);
            font-size: 0.8rem;
            margin-top: 0.25rem;
        }

        /* استایل آپلود فایل */
        .file-upload-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1.5rem;
        }

        .file-upload-group {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }

        .file-input-container {
            position: relative;
            overflow: hidden;
        }

        .file-input {
            position: absolute;
            top: 0;
            left: 0;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }

        .file-input-button {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1rem;
            background: var(--gray-100);
            border: 1px dashed var(--gray-400);
            border-radius: var(--border-radius-sm);
            cursor: pointer;
            transition: var(--transition);
            justify-content: center;
        }

        .file-input-button:hover {
            background: var(--gray-200);
            border-color: var(--gray-500);
        }

        .upload-loading {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--warning);
            font-size: 0.85rem;
        }

        .file-preview {
            position: relative;
            width: 80px;
            height: 80px;
            border-radius: 50%;
            overflow: hidden;
            border: 2px solid var(--gray-200);
        }

        .file-preview.signature {
            width: 120px;
            height: 50px;
            border-radius: var(--border-radius-sm);
        }

        .preview-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .preview-placeholder {
            width: 100%;
            height: 100%;
            background: var(--gray-100);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--gray-500);
        }

        .preview-placeholder.signature {
            font-size: 0.8rem;
        }

        .preview-remove {
            position: absolute;
            top: 0;
            right: 0;
            background: var(--danger);
            color: white;
            border: none;
            width: 24px;
            height: 24px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            font-size: 0.8rem;
        }

        /* استایل رادیو گروه */
        .radio-group {
            display: flex;
            gap: 1rem;
        }

        .radio-option {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            cursor: pointer;
            padding: 0.75rem 1rem;
            background: var(--gray-100);
            border-radius: var(--border-radius-sm);
            transition: var(--transition);
            flex: 1;
        }

        .radio-option:hover {
            background: var(--gray-200);
        }

        .radio-option input {
            display: none;
        }

        .radio-checkmark {
            width: 18px;
            height: 18px;
            border: 2px solid var(--gray-400);
            border-radius: 50%;
            position: relative;
            transition: var(--transition);
        }

        .radio-option input:checked + .radio-checkmark {
            border-color: var(--primary);
        }

        .radio-option input:checked + .radio-checkmark::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 8px;
            height: 8px;
            background: var(--primary);
            border-radius: 50%;
        }

        /* استایل تنظیمات امنیتی */
        .security-settings {
            grid-column: 1 / -1;
            background: var(--gray-100);
            padding: 1.5rem;
            border-radius: var(--border-radius);
        }

        .security-header {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 1rem;
        }

        .security-header i {
            color: var(--primary);
            font-size: 1.25rem;
        }

        .security-header h4 {
            font-size: 1.1rem;
            font-weight: 600;
            margin: 0;
            color: var(--gray-800);
        }

        .info-notice {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            background: rgba(52, 152, 219, 0.1);
            color: var(--info);
            padding: 0.75rem 1rem;
            border-radius: var(--border-radius-sm);
            margin-bottom: 1rem;
            font-size: 0.9rem;
        }

        /* استایل دکمه‌ها */
        .form-actions {
            display: flex;
            justify-content: flex-end;
            gap: 1rem;
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--gray-200);
        }

        .btn {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: var(--border-radius-sm);
            font-weight: 500;
            cursor: pointer;
            transition: var(--transition);
            font-size: 0.9rem;
        }

        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        .btn-secondary {
            background: var(--gray-200);
            color: var(--gray-700);
        }

        .btn-secondary:hover:not(:disabled) {
            background: var(--gray-300);
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover:not(:disabled) {
            background: #3a56d4;
        }

        .btn-success {
            background: var(--success);
            color: white;
        }

        .btn-success:hover:not(:disabled) {
            background: #27ae60;
        }

        .btn-warning {
            background: var(--warning);
            color: white;
        }

        .btn-warning:hover:not(:disabled) {
            background: #e67e22;
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .btn-danger:hover:not(:disabled) {
            background: #c0392b;
        }

        /* استایل لیست کاربران */
        .users-list-section {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            overflow: hidden;
        }

        .list-controls {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .search-box {
            position: relative;
            display: flex;
            align-items: center;
        }

        .search-box i {
            position: absolute;
            right: 1rem;
            color: var(--gray-500);
        }

        .search-box input {
            padding: 0.75rem 1rem 0.75rem 2.5rem;
            border: 1px solid var(--gray-300);
            border-radius: 50px;
            font-size: 0.9rem;
            width: 280px;
            transition: var(--transition);
        }

        .search-box input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .control-btn {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1rem;
            background: var(--gray-100);
            border: 1px solid var(--gray-300);
            border-radius: 50px;
            cursor: pointer;
            transition: var(--transition);
            font-size: 0.9rem;
            color: var(--gray-700);
        }

        .control-btn:hover {
            background: var(--gray-200);
        }

        .filter-dropdown {
            position: relative;
        }

        .filter-dropdown .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow-lg);
            padding: 1.5rem;
            min-width: 280px;
            z-index: 10;
            display: none;
        }

        .filter-dropdown:hover .dropdown-menu {
            display: block;
        }

        .dropdown-header {
            margin-bottom: 1rem;
        }

        .dropdown-header h6 {
            font-size: 1rem;
            font-weight: 700;
            color: var(--primary);
            margin: 0;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
            margin-bottom: 1rem;
        }

        .filter-group label {
            font-size: 0.85rem;
            font-weight: 600;
            color: var(--gray-700);
        }

        .filter-group select {
            padding: 0.5rem 0.75rem;
            border: 1px solid var(--gray-300);
            border-radius: var(--border-radius-sm);
            font-size: 0.85rem;
        }

        .filter-divider {
            height: 1px;
            background: var(--gray-200);
            margin: 1rem 0;
        }

        /* استایل جدول */
        .table-container {
            overflow-x: auto;
        }

        .users-table {
            width: 100%;
            border-collapse: collapse;
        }

        .users-table thead {
            background: var(--gray-800);
        }

        .users-table th {
            padding: 1rem 0.75rem;
            text-align: right;
            color: white;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .users-table th.sortable {
            cursor: pointer;
            user-select: none;
            transition: var(--transition);
        }

        .users-table th.sortable:hover {
            background: var(--gray-700);
        }

        .users-table th.sortable span {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .users-table tbody tr {
            border-bottom: 1px solid var(--gray-200);
            transition: var(--transition);
        }

        .users-table tbody tr:hover {
            background: var(--gray-100);
        }

        .users-table td {
            padding: 1rem 0.75rem;
            font-size: 0.9rem;
        }

        .user-cell {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--gray-200);
        }

        .user-avatar.fallback {
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .user-name {
            color: var(--gray-800);
            font-weight: 600;
            text-decoration: none;
            transition: var(--transition);
        }

        .user-name:hover {
            color: var(--primary);
        }

        .badge {
            display: inline-block;
            padding: 0.35rem 0.75rem;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 600;
        }

        .badge-danger {
            background: rgba(231, 76, 60, 0.1);
            color: var(--danger);
        }

        .badge-warning {
            background: rgba(243, 156, 18, 0.1);
            color: var(--warning);
        }

        .badge-info {
            background: rgba(52, 152, 219, 0.1);
            color: var(--info);
        }

        .badge-secondary {
            background: rgba(108, 117, 125, 0.1);
            color: var(--secondary);
        }

        .badge-light {
            background: var(--gray-200);
            color: var(--gray-700);
        }

        .status-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.35rem;
            padding: 0.35rem 0.75rem;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 600;
        }

        .status-badge.active {
            background: rgba(46, 204, 113, 0.1);
            color: var(--success);
        }

        .status-badge.inactive {
            background: rgba(108, 117, 125, 0.1);
            color: var(--secondary);
        }

        .last-login {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--gray-600);
            font-size: 0.85rem;
        }

        .action-buttons {
            display: flex;
            gap: 0.5rem;
            justify-content: center;
        }

        .action-btn {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            border: none;
            cursor: pointer;
            transition: var(--transition);
            font-size: 0.9rem;
        }

        .action-btn.edit {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary);
        }

        .action-btn.edit:hover {
            background: var(--primary);
            color: white;
        }

        .action-btn.security {
            background: rgba(108, 117, 125, 0.1);
            color: var(--secondary);
        }

        .action-btn.security:hover {
            background: var(--secondary);
            color: white;
        }

        .action-btn.delete {
            background: rgba(231, 76, 60, 0.1);
            color: var(--danger);
        }

        .action-btn.delete:hover {
            background: var(--danger);
            color: white;
        }

        .empty-state {
            text-align: center;
            padding: 3rem 1rem;
        }

        .empty-content i {
            font-size: 3rem;
            color: var(--gray-400);
            margin-bottom: 1rem;
        }

        .empty-content h3 {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--gray-600);
            margin-bottom: 0.5rem;
        }

        .empty-content p {
            color: var(--gray-500);
            font-size: 0.9rem;
        }

        .pagination-container {
            padding: 1.5rem;
            display: flex;
            justify-content: center;
        }

        /* استایل مودال‌ها */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
            padding: 1rem;
        }

        .modal-container {
            background: white;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--shadow-xl);
            width: 100%;
            max-width: 400px;
            overflow: hidden;
        }

        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1.5rem;
            background: var(--primary);
            color: white;
        }

        .modal-title {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .modal-title h3 {
            font-size: 1.25rem;
            font-weight: 600;
            margin: 0;
        }

        .modal-close {
            background: none;
            border: none;
            color: white;
            cursor: pointer;
            font-size: 1.25rem;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 32px;
            height: 32px;
            border-radius: 50%;
            transition: var(--transition);
        }

        .modal-close:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .modal-body {
            padding: 1.5rem;
        }

        .modal-description {
            color: var(--gray-600);
            margin-bottom: 1.5rem;
            font-size: 0.9rem;
        }

        .modal-footer {
            padding: 1rem 1.5rem 1.5rem;
            display: flex;
            justify-content: flex-end;
            gap: 1rem;
        }

        /* استایل پنل کناری */
        .side-panel-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            display: flex;
            justify-content: flex-end;
        }

        .side-panel {
            background: white;
            width: 100%;
            max-width: 480px;
            height: 100%;
            overflow-y: auto;
            box-shadow: var(--shadow-xl);
        }

        .side-panel-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1.5rem;
            background: var(--gray-100);
            border-bottom: 1px solid var(--gray-200);
        }

        .panel-title {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .panel-title h3 {
            font-size: 1.25rem;
            font-weight: 700;
            margin: 0;
            color: var(--primary);
        }

        .panel-close {
            background: none;
            border: none;
            cursor: pointer;
            font-size: 1.25rem;
            color: var(--gray-600);
            display: flex;
            align-items: center;
            justify-content: center;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            transition: var(--transition);
        }

        .panel-close:hover {
            background: var(--gray-200);
        }

        .side-panel-body {
            padding: 1.5rem;
        }

        .user-profile-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding-bottom: 1.5rem;
            margin-bottom: 1.5rem;
            border-bottom: 1px solid var(--gray-200);
        }

        .profile-avatar {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 4px solid var(--primary);
        }

        .profile-avatar.fallback {
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 1.5rem;
        }

        .profile-info {
            flex: 1;
        }

        .profile-name {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 0.25rem;
            color: var(--gray-800);
        }

        .profile-email {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--primary);
            font-weight: 500;
            margin-bottom: 0.75rem;
        }

        .profile-badges {
            display: flex;
            gap: 0.5rem;
        }

        .role-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.35rem;
            padding: 0.35rem 0.75rem;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 600;
            background: rgba(108, 117, 125, 0.1);
            color: var(--secondary);
        }

        .info-section {
            margin-bottom: 1.5rem;
        }

        .section-title {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 1rem;
            font-weight: 600;
            color: var(--gray-800);
            margin-bottom: 1rem;
        }

        .section-title i {
            color: var(--primary);
        }

        .info-grid {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }

        .info-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.75rem 0;
            border-bottom: 1px solid var(--gray-100);
        }

        .info-label {
            color: var(--gray-600);
            font-size: 0.9rem;
        }

        .info-value {
            font-weight: 500;
            color: var(--gray-800);
        }

        .panel-actions {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
            margin-top: 2rem;
        }

        .panel-actions .btn {
            width: 100%;
            justify-content: center;
        }

        /* انیمیشن‌ها */
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .animate-spin {
            animation: spin 1s linear infinite;
        }

        /* رسپانسیو */
        @media (max-width: 1024px) {
            .form-grid {
                grid-template-columns: 1fr;
            }

            .file-upload-section {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .admin-dashboard {
                padding: 1rem;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .header-content {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }

            .list-controls {
                flex-wrap: wrap;
                width: 100%;
            }

            .search-box input {
                width: 100%;
            }

            .form-row {
                grid-template-columns: 1fr;
            }

            .tab-nav {
                flex-direction: column;
            }

            .tab-button {
                justify-content: center;
            }

            .modal-container {
                margin: 1rem;
            }

            .side-panel {
                max-width: 100%;
            }
        }

        @media (max-width: 480px) {
            .radio-group {
                flex-direction: column;
            }

            .action-buttons {
                flex-direction: column;
            }

            .action-btn {
                width: 100%;
                border-radius: var(--border-radius-sm);
            }
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // مدیریت تب‌ها
            const tabButtons = document.querySelectorAll('.tab-button');
            const tabPanes = document.querySelectorAll('.tab-pane');

            tabButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const targetTab = this.getAttribute('data-tab');

                    // حذف کلاس active از همه تب‌ها
                    tabButtons.forEach(btn => btn.classList.remove('active'));
                    tabPanes.forEach(pane => pane.classList.remove('active'));

                    // اضافه کردن کلاس active به تب انتخاب شده
                    this.classList.add('active');
                    document.getElementById(targetTab).classList.add('active');
                });
            });

            // مدیریت نمایش dropdown فیلترها
            const filterDropdown = document.querySelector('.filter-dropdown');
            if (filterDropdown) {
                filterDropdown.addEventListener('mouseenter', function() {
                    this.querySelector('.dropdown-menu').style.display = 'block';
                });

                filterDropdown.addEventListener('mouseleave', function() {
                    this.querySelector('.dropdown-menu').style.display = 'none';
                });
            }

            // مدیریت آپلود فایل
            const fileInputs = document.querySelectorAll('.file-input');
            fileInputs.forEach(input => {
                input.addEventListener('change', function() {
                    const container = this.closest('.file-input-container');
                    const button = container.querySelector('.file-input-button');

                    if (this.files.length > 0) {
                        button.innerHTML = `<i class="ti ti-check"></i><span>فایل انتخاب شد</span>`;
                        button.style.background = 'rgba(46, 204, 113, 0.1)';
                        button.style.borderColor = 'var(--success)';
                        button.style.color = 'var(--success)';
                    }
                });
            });
        });
    </script>

</div>
