<div class="container py-4 user-list-dashboard">

    {{-- 🛑 هدر اصلی و دکمه‌های کنترلی --}}
    <div class="d-flex justify-content-between align-items-center mb-4 pb-3 border-bottom-secondary">
        <h4 class="fw-bold text-dark-primary mb-0">
            <i class="ti ti-users me-2 text-action-primary"></i> مدیریت کاربران
        </h4>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.users.add') }}" class="btn btn-action-primary rounded-pill px-4 shadow-sm animate-hover">
                <i class="ti ti-user-plus me-1"></i> کاربر جدید
            </a>
        </div>
    </div>

    {{-- 🔍 پنل فیلتر و جستجو --}}
    <div class="card shadow-lg-md border-0 rounded-4 p-4 mb-5 bg-white">
        <div class="row g-3 align-items-center">

            <div class="col-md-4">
                <input type="text" wire:model.live.debounce.300ms="search" class="form-control rounded-pill shadow-input" placeholder="جستجوی نام، ایمیل، موبایل...">
            </div>

            <div class="col-md-2">
                <select wire:model.live="filterCompanyId" class="form-select rounded-pill shadow-input">
                    <option value="">همه شرکت‌ها</option>
                    @foreach($companies as $c)
                        <option value="{{ $c->id }}">{{ $c->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-2">
                <select wire:model.live="filterDepartmentId" class="form-select rounded-pill shadow-input" @disabled(!$filterCompanyId)>
                    <option value="">همه دپارتمان‌ها</option>
                    {{-- 🛑 FIX: استفاده از ?? collect() در Blade برای ایمنی نهایی --}}
                    @foreach($filterDepartments ?? collect() as $fd)
                        <option value="{{ $fd->id }}">{{ $fd->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-2">
                <select wire:model.live="filterRole" class="form-select rounded-pill shadow-input">
                    <option value="">همه نقش‌ها</option>
                    @foreach($roles as $r)
                        <option value="{{ $r }}">{{ Str::title($r) }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2">
                <button wire:click="resetListFilters" class="btn btn-outline-secondary rounded-pill animate-hover" title="حذف همه فیلترها">
                    <i class="ti ti-filter-off"></i>
                    <span class="d-none d-md-inline ms-1">پاکسازی</span>
                </button>
            </div>
        </div>
    </div>

    {{-- 📋 جدول کاربران --}}
    <div class="card shadow-xl border-0 rounded-4 overflow-hidden">
        <div class="table-responsive">
            <table class="users-table">
                <thead class="bg-dark-primary-table text-white">
                <tr>
                    <th class="py-3 px-4" style="width: 50px;">#</th>
                    <th class="sortable" wire:click="sortBy('name')"><span>نام</span></th>
                    <th class="sortable" wire:click="sortBy('email')"><span>ایمیل</span></th>
                    <th class="sortable" wire:click="sortBy('role')"><span>نقش</span></th>
                    <th class="sortable" wire:click="sortBy('status')"><span>وضعیت</span></th>
                    <th class="sortable" wire:click="sortBy('last_login_at')"><span>آخرین ورود</span></th>
                    <th class="actions">عملیات</th>
                </tr>
                </thead>
                <tbody>
                @forelse($users as $index => $user)
                    <tr class="table-row-hover">
                        <td>{{ $index + 1 + ($users->currentPage() - 1) * $users->perPage() }}</td>
                        <td>
                            <div class="user-cell">
                                <img src="{{ $this->getImageUrl($user->image) }}" class="user-avatar" alt="{{ $user->name }}">
                                <a href="javascript:void(0)" class="user-name" wire:click="openQuickView({{ $user->id }})">
                                    {{ $user->name }}
                                </a>
                            </div>
                        </td>
                        <td>{{ $user->email }}</td>
                        <td>
                            @php $role = $user->role ?? 'user'; @endphp
                            <span class="badge role-badge badge-{{ $role }}">
                                {{ Str::title($role) }}
                            </span>
                        </td>
                        <td>
                            <span class="status-badge {{ $user->status === 'active' ? 'active' : 'inactive' }}">
                                <i class="ti ti-user-{{ $user->status === 'active' ? 'check' : 'off' }}"></i>
                                {{ $user->status === 'active' ? 'فعال' : 'غیرفعال' }}
                            </span>
                        </td>
                        <td>
                            <div class="last-login">
                                <i class="ti ti-clock"></i>
                                <span>{{ $user->last_login_at ? $user->last_login_at->diffForHumans() : '—' }}</span>
                            </div>
                        </td>
                        <td>
                            <div class="action-buttons">
                                <button wire:click="editUser({{ $user->id }})" class="action-btn edit" title="ویرایش">
                                    <i class="ti ti-edit"></i>
                                </button>
                                <button wire:click="showResetPasswordForm({{ $user->id }})" class="action-btn security" title="تغییر رمز">
                                    <i class="ti ti-key"></i>
                                </button>
                                <button wire:click="deleteUser({{ $user->id }})" class="action-btn delete" title="حذف">
                                    <i class="ti ti-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="empty-state">
                            <div class="empty-content">
                                <i class="ti ti-user-x"></i>
                                <h3>کاربری یافت نشد</h3>
                            </div>
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="pagination-container">
            {{ $users->links() }}
        </div>
    </div>

    {{-- 🛑 Quick View and Password Reset Modals/Panels (Insert your custom modals here) --}}

    <style>
        /* --- General Variables --- */
        :root {
            --primary: #4361ee;
            --primary-dark: #1A2538;
            --secondary-light: #6B7280;
            --border-color: #E5E7EB;
            --gray-100: #F8FAFB;
            --gray-200: #E9ECEF;
            --success: #10B981;
            --danger: #EF4444;
            --warning: #F59E0B;
            --info: #03A9F4;
            --transition: all 0.3s ease;
        }

        /* --- Layout & Base --- */
        .user-list-dashboard { background-color: var(--gray-100); }
        .text-dark-primary { color: var(--primary-dark) !important; }
        .text-action-primary { color: var(--primary) !important; }
        .border-bottom-secondary { border-bottom: 1px solid var(--border-color); }
        .shadow-lg-md { box-shadow: 0 6px 15px rgba(0,0,0,0.08) !important; }
        .shadow-xl { box-shadow: 0 10px 25px rgba(0,0,0,0.15) !important; }

        /* --- Controls --- */
        .form-control, .form-select { border-color: var(--border-color); border-radius: 50px; }
        .shadow-input { box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .btn-action-primary { background-color: var(--primary); border-color: var(--primary); color: white; }

        /* --- Table General --- */
        .users-table { width: 100%; border-collapse: separate; border-spacing: 0; }
        .users-table thead { background-color: var(--primary-dark); }
        .users-table th { color: white; font-weight: 600; padding: 1rem 0.75rem; border: none; }
        .users-table tbody tr { border-bottom: 1px solid var(--gray-200); transition: var(--transition); }
        .users-table tbody tr:hover { background: #F0F3FF; }
        .users-table td { padding: 1rem 0.75rem; }

        /* --- User Cell & Avatar --- */
        .user-cell { display: flex; align-items: center; gap: 0.75rem; }
        .user-avatar { width: 36px; height: 36px; border-radius: 50%; object-fit: cover; border: 2px solid var(--primary); }
        .user-avatar.fallback { background: var(--primary); color: white; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 0.9rem; }
        .user-name { color: var(--primary-dark); font-weight: 600; text-decoration: none; }
        .user-name:hover { color: var(--primary); }

        /* --- Badges & Status --- */
        .badge { font-weight: 600; border-radius: 50px; }
        .status-badge { display: inline-flex; align-items: center; gap: 0.35rem; padding: 0.35rem 0.75rem; border-radius: 50px; font-weight: 600; }
        .status-badge.active { background: rgba(16, 185, 129, 0.1); color: var(--success); }
        .status-badge.inactive { background: rgba(108, 117, 125, 0.1); color: var(--secondary); }
        .badge-danger { background: rgba(231, 76, 60, 0.1); color: var(--danger); }
        .badge-warning { background: rgba(243, 156, 18, 0.1); color: var(--warning); }
        .badge-info { background: rgba(52, 152, 219, 0.1); color: var(--info); }
        .badge-secondary { background: rgba(108, 117, 125, 0.1); color: var(--secondary); }

        /* --- Actions --- */
        .action-buttons { display: flex; gap: 0.5rem; justify-content: center; }
        .action-btn { width: 36px; height: 36px; border-radius: 50%; display: flex; align-items: center; justify-content: center; border: 1px solid var(--gray-300); background: white; color: var(--primary-dark); transition: var(--transition); }
        .action-btn:hover { background: var(--primary); color: white; }
        .action-btn.delete:hover { background: var(--danger); color: white; }

        /* --- Empty State --- */
        .empty-content i { font-size: 3rem; color: var(--gray-400); margin-bottom: 1rem; }
    </style>
</div>
