<div class="container py-4">

    {{-- 📢 پیام موفقیت/خطا --}}
    @if(session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show rounded-3 shadow-sm mb-4 d-flex align-items-center success-alert-custom">
            <i class="ti ti-check-circle me-2 fs-5"></i>
            <span class="fw-semibold">{{ session('message') }}</span>
            <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert" aria-label="بستن"></button>
        </div>
    @endif

    @if(session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show rounded-3 shadow-sm mb-4 d-flex align-items-center danger-alert-custom">
            <i class="ti ti-alert-triangle me-2 fs-5"></i>
            <span class="fw-semibold">{{ session('error') }}</span>
            <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert" aria-label="بستن"></button>
        </div>
    @endif

    <div class="card shadow-2xl border-0 rounded-4">
        {{-- 🛑 FIX: هدر با رنگ متضاد --}}
        <div class="card-header bg-primary-header text-white p-4 header-fix-contrast">
            <h5 class="card-title mb-0 fw-bold d-flex align-items-center">
                <i class="ti ti-edit me-2 fs-4 text-warning-contrast"></i> ویرایش سمت سازمانی
            </h5>
        </div>
        <div class="card-body p-5">
            <form wire:submit.prevent="updateUserPosition">

                {{-- 🛑 User Context Confirmation (Focus Box) --}}
                @if($selectedUserObject)
                    <div class="user-confirmation-box p-4 rounded-4 bg-primary-light border border-warning mb-5 shadow-md">
                        <h6 class="fw-bold text-dark-primary mb-3"><i class="ti ti-user-check me-1 text-warning"></i> کاربر فعلی:</h6>
                        <div class="d-flex align-items-center gap-4">
                            <img src="{{ $selectedUserObject->image ? asset('storage/' . $selectedUserObject->image) : asset('user-default.svg') }}"
                                 class="rounded-circle user-avatar-large border-white" width="60" height="60" alt="{{ $selectedUserObject->name }}">
                            <div>
                                <h4 class="mb-0 text-dark-primary fw-bolder">{{ $selectedUserObject->name }}</h4>
                                <span class="text-secondary-light small">{{ $selectedUserObject->email }}</span>
                            </div>
                        </div>
                    </div>
                @endif

                <h6 class="fw-bold text-dark-primary mb-4 border-bottom pb-3"><i class="ti ti-briefcase me-2 text-warning"></i> اطلاعات سمت</h6>

                {{-- 🛑 User Select (Optional - If you must allow changing the user) --}}
                <div class="mb-4">
                    <label for="user_id" class="form-label text-dark-primary">تغییر کاربر (اختیاری):</label>
                    <select id="user_id" wire:model.defer="user_id" class="form-select rounded-pill @error('user_id') is-invalid @enderror">
                        <option value="">{{ $selectedUserObject->name ?? 'انتخاب کاربر جدید' }}</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}">{{ $user->name }} - {{ $user->email }}</option>
                        @endforeach
                    </select>
                    <small class="text-muted small mt-1">
                        هشدار: تغییر کاربر، سمت فعلی را به فرد دیگری منتقل می‌کند.
                    </small>
                    @error('user_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                </div>


                {{-- 🛑 Position Input --}}
                <div class="mb-5">
                    <label for="position" class="form-label text-dark-primary">سمت سازمانی <span class="text-danger">*</span></label>
                    <input
                        type="text"
                        id="position"
                        wire:model.defer="position"
                        class="form-control rounded-pill @error('position') is-invalid @enderror"
                        placeholder="مثلاً: مدیر پروژه، کارشناس مالی"
                    />
                    @error('position') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                </div>

                <div class="d-flex justify-content-end gap-2 border-top pt-4">
                    <button type="button" wire:click="cancel" class="btn btn-outline-secondary px-4 py-2 fw-bold rounded-pill">
                        <i class="ti ti-x me-2"></i> انصراف
                    </button>
                    <button type="submit" class="btn btn-warning px-5 py-2 fw-bold rounded-pill shadow-action-btn">
                        <i class="ti ti-device-floppy me-2"></i> بروزرسانی سمت
                    </button>
                </div>
            </form>
        </div>
    </div>
    <style>
        :root {
            /* Palette Update: Deep Navy and Vibrant Blue */
            --primary-color: #3858FF;
            --primary-dark: #1A2538;
            --action-color: var(--primary-color);
            --primary-light: #EEF4FF; /* Soft background */
            --dark-primary: #1F2937;
            --secondary-light: #6B7280;
            --border-color: #E5E7EB;
            --shadow-action-btn: 0 6px 15px rgba(245, 158, 11, 0.4); /* Warning shadow for Edit */
            --warning-color: #F59E0B;
            --success-color: #10B981;
            --danger-color: #EF4444;
            --warning-contrast: #FFD699; /* Light Gold/Yellow for header icon/text contrast */
        }

        .bg-primary-header {
            background: var(--primary-dark);
            color: white;
        }

        /* 🛑 FIX: آیکون و متن هدر تیره باید روشن باشند */
        .header-fix-contrast .card-title,
        .header-fix-contrast .ti {
            color: white !important;
        }
        .text-warning-contrast { color: var(--warning-contrast) !important; }

        /* Base Styles */
        .text-dark-primary { color: var(--dark-primary) !important; }
        .text-secondary-light { color: var(--secondary-light) !important; }
        .bg-primary-light { background-color: var(--primary-light) !important; }
        .shadow-2xl { box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04); }
        .shadow-action-btn { box-shadow: var(--shadow-action-btn); }


        /* Forms */
        .form-control, .form-select {
            border-color: var(--border-color);
            padding: 0.75rem 1.25rem;
        }
        .form-control.rounded-pill, .form-select.rounded-pill {
            border-radius: 50rem !important;
        }
        .form-control:focus, .form-select:focus {
            border-color: var(--warning-color); /* تمرکز روی Warning برای Edit */
            box-shadow: 0 0 0 3px rgba(245, 158, 11, 0.3);
        }

        /* User Context */
        .user-confirmation-box {
            box-shadow: inset 0 2px 4px 0 rgba(0, 0, 0, 0.06);
            border-color: var(--warning-color) !important; /* برجسته کردن باکس کاربر */
        }
        .user-avatar-large {
            object-fit: cover;
            border: 3px solid white;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        /* Buttons */
        .btn-warning {
            background-color: var(--warning-color) !important;
            border-color: var(--warning-color) !important;
            color: var(--dark-primary) !important;
            font-weight: 700 !important;
        }
        .btn-warning:hover {
            background-color: #D97706 !important;
            border-color: #D97706 !important;
            color: white !important;
        }
        .btn-outline-secondary {
            color: var(--secondary-light);
            border-color: var(--secondary-light);
        }
        .btn-outline-secondary:hover {
            background-color: var(--secondary-light);
            color: white;
        }

        /* Alerts */
        .success-alert-custom { border-left: 5px solid var(--success-color); }
        .danger-alert-custom { border-left: 5px solid var(--danger-color); }

    </style>
</div>
