<div class="container py-4 modern-position-list">

    {{-- 📢 پیام موفقیت/خطا --}}
    @if(session()->has('success'))
        <div class="alert alert-success alert-dismissible fade show rounded-3 shadow-sm mb-4 d-flex align-items-center success-alert-custom">
            <i class="ti ti-check-circle me-2 fs-5"></i>
            <span class="fw-semibold">{{ session('success') }}</span>
            <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert" aria-label="بستن"></button>
        </div>
    @endif
    @if(session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show rounded-3 shadow-sm mb-4 d-flex align-items-center danger-alert-custom">
            <i class="ti ti-alert-triangle me-2 fs-5"></i>
            <span class="fw-semibold">{{ session('error') }}</span>
            <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert" aria-label="بستن"></button>
        </div>
    @endif

    {{-- 🛑 هدر اصلی و دکمه افزودن --}}
    <div class="card shadow-lg-md border-0 rounded-4 mb-4">
        <div class="card-body d-flex justify-content-between align-items-center p-4 bg-white">
            <h5 class="mb-0 fw-bold text-dark-primary d-flex align-items-center">
                <i class="ti ti-briefcase me-2 fs-4 text-action-primary"></i> لیست سمت‌های سازمانی
            </h5>
            <a href="{{ route('admin.user.position.create') }}" class="btn btn-action-primary fw-bold shadow-md rounded-pill px-4 py-2 animate-hover">
                <i class="ti ti-user-plus me-1"></i> افزودن سمت
            </a>
        </div>
    </div>

    {{-- 🔍 فیلتر و جستجو --}}
    <div class="card shadow-lg-md border-0 rounded-4 p-4 mb-5 bg-white">
        <div class="row g-3 align-items-center">
            <div class="col-md-4">
                <div class="input-group input-group-lg rounded-pill overflow-hidden shadow-input">
                    <span class="input-group-text bg-white border-0"><i class="ti ti-search text-muted"></i></span>
                    <input type="text" wire:model.debounce.300ms="search" class="form-control border-0 py-3" placeholder="جستجوی نام کاربر یا سمت...">
                </div>
            </div>
            <div class="col-md-3">
                <select wire:model.live="companyIdFilter" class="form-select form-select-lg rounded-pill shadow-input">
                    <option value="">همه شرکت‌ها</option>
                    @foreach($companies as $company)
                        <option value="{{ $company->id }}">{{ $company->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <select wire:model.live="departmentIdFilter" class="form-select form-select-lg rounded-pill shadow-input" @disabled(!$companyIdFilter)>
                    <option value="">همه دپارتمان‌ها</option>
                    @foreach($departments as $dept)
                        <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2 text-md-end d-flex align-items-center justify-content-end gap-2">
                <button class="btn btn-outline-secondary btn-sm toggle-view-btn rounded-pill px-3 animate-hover" wire:click="toggleView" title="سوییچ نمایش">
                    <i class="ti ti-layout-{{ $viewType == 'card' ? 'list-details' : 'board-split' }} fs-5"></i>
                    <span class="d-none d-md-inline ms-1">{{ $viewType == 'card' ? 'نمایش جدولی' : 'نمایش کارتی' }}</span>
                </button>
            </div>
        </div>
        <div class="mt-3 small text-muted">
            <i class="ti ti-info-circle me-1"></i>
            نمایش <span class="fw-bold">{{ $usersWithPositions->count() }}</span> کاربر از {{ $usersWithPositions->total() }} کاربر کل.
        </div>
    </div>


    {{-- 🛑 حالت نمایش Card View (سلسله مراتبی و پیش‌فرض) --}}
    @if($viewType == 'card')
        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
            @forelse($usersWithPositions as $user)
                <div class="col" wire:key="user-card-{{ $user->id }}">
                    <div class="card shadow-md border-0 rounded-4 p-4 user-card-hover">
                        <div class="d-flex align-items-center gap-3 border-bottom pb-3 mb-3">
                            <img src="{{ $user->image ? asset('storage/' . $user->image) : asset('user-default.svg') }}"
                                 class="rounded-circle user-avatar-card" width="50" height="50" alt="{{ $user->name }}">
                            <div>
                                <h5 class="fw-bold text-dark-primary mb-0">{{ $user->name }}</h5>
                                <span class="small text-secondary-light">{{ $user->email }}</span>
                            </div>
                        </div>

                        {{-- 💡 اطلاعات سازمانی --}}
                        <div class="mb-3 d-flex flex-column gap-1 small text-dark-primary border-bottom pb-3">
                            <span class="badge bg-soft-info text-info fw-normal">
                                <i class="ti ti-building me-1"></i> {{ $user->department->company->name ?? 'بدون شرکت' }}
                            </span>
                            <span class="small text-secondary-light ms-2">
                                 {{ $user->department->name ?? 'بدون دپارتمان' }}
                            </span>
                        </div>

                        {{-- 🛑 لیست سمت‌های ثبت شده --}}
                        <div class="positions-list mt-3">
                            <p class="small fw-semibold text-dark-primary mb-2">سمت‌های فعال ({{ $user->positions->count() }}):</p>
                            @foreach($user->positions as $position)
                                <div class="d-flex justify-content-between align-items-center mb-2 position-item p-2 rounded-2xl bg-gray-light">
                                    <span class="badge bg-soft-primary text-action-primary fw-bold px-3 py-1">
                                        {{ $position->position }}
                                    </span>
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('admin.edit.position', $position->id) }}" class="btn btn-sm btn-outline-primary p-1" title="ویرایش">
                                            <i class="ti ti-pencil fs-5"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger p-1"
                                                wire:click="deletePosition({{ $position->id }})"
                                                wire:confirm="آیا از حذف سمت «{{ $position->position }}» مطمئن هستید؟"
                                                title="حذف">
                                            <i class="ti ti-trash fs-5"></i>
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                    </div>
                </div>
            @empty
                <div class="col-12">
                    <div class="text-center py-5 empty-state-box">
                        <i class="ti ti-mood-sad fs-2 d-block mb-2 text-secondary-light"></i>
                        <p class="text-dark-primary">هیچ کاربر فعالی با سمت یافت نشد!</p>
                    </div>
                </div>
            @endforelse
        </div>
        <div class="d-flex justify-content-center mt-5">{{ $usersWithPositions->links() }}</div>

    @else
        {{-- 🛑 حالت نمایش جدول فشرده (Aggregated Table View) --}}
        <div class="card shadow-xl border-0 rounded-4 overflow-hidden">
            <div class="table-responsive">
                <table class="table align-middle mb-0 table-hover-row">
                    <thead class="bg-dark-primary-table text-white">
                    <tr>
                        <th class="py-3 px-4" style="width: 30%" wire:click="sortBy('name')">نام کاربر / ایمیل</th>
                        <th class="py-3" style="width: 25%">ساختار سازمانی</th>
                        <th class="py-3" style="width: 25%">سمت سازمانی</th>
                        <th class="py-3">تاریخ ثبت</th>
                        <th class="text-center" style="width: 10%">عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($usersWithPositions as $user)
                        @foreach($user->positions as $position)
                            <tr class="table-row-hover" wire:key="pos-{{ $position->id }}">
                                <td>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="avatar-sm">{{ $user->name[0] ?? '—' }}</span>
                                        <div>
                                            <span class="fw-semibold text-dark-primary">{{ $user->name ?? '—' }}</span>
                                            <div class="small text-secondary-light">{{ $user->email }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="small text-secondary-light">
                                        <span class="fw-medium">{{ $user->department->company->name ?? '—' }}</span> /
                                        {{ $user->department->name ?? '—' }}
                                    </div>

                                </td>
                                <td>
                                    <span class="badge bg-soft-primary text-action-primary fw-bold">
                                        {{ $position->position }}
                                    </span>
                                </td>
                                <td>
                                    <span class="text-secondary-light small">
                                        {{ jdate($position->created_at)->format('Y/m/d') }}
                                    </span>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('admin.edit.position', $position->id) }}" class="btn btn-outline-primary shadow-sm p-1" title="ویرایش">
                                            <i class="ti ti-pencil"></i>
                                        </a>
                                        <button type="button" class="btn btn-outline-danger shadow-sm p-1"
                                                wire:click="deletePosition({{ $position->id }})"
                                                wire:confirm="آیا از حذف سمت «{{ $position->position }}» مطمئن هستید؟">
                                            <i class="ti ti-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @empty
                        <tr><td colspan="5" class="text-center py-5"><i class="ti ti-mood-sad fs-3 d-block mb-2 text-secondary-light"></i><p class="text-dark-primary">هیچ سمتی یافت نشد!</p></td></tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
            <div class="card-footer bg-white border-top d-flex justify-content-center p-3">{{ $usersWithPositions->links() }}</div>
        </div>
    @endif

    <style>
        /* 🛑 استایل‌های نهایی و مدرن */
        :root {
            --primary-dark: #1A2538;
            --action-color: #4361EE;
            --action-dark-hover: #3A4FCD;
            --text-primary-dark: #1F2937;
            --border-color: #E5E7EB;
            --gray-light: #F1F5F9;
            --secondary-light: #6B7280;
            --primary-light: #EEF4FF;
            --info-color: #3498DB;
            --danger-color: #EF4444;
            --success-color: #10B981;
            --dark-primary-table: #34495E;
        }

        .modern-position-list { background-color: var(--body-bg, #F8FAFC); }
        .text-dark-primary { color: var(--text-primary-dark) !important; }
        .text-action-primary { color: var(--action-color) !important; }
        .shadow-lg-md { box-shadow: 0 6px 15px rgba(0,0,0,0.08) !important; }
        .shadow-xl { box-shadow: 0 10px 25px rgba(0,0,0,0.15) !important; }
        .shadow-input { box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .animate-hover:hover { transform: translateY(-1px); }

        /* --- Header & Controls --- */
        .bg-dark-primary-table { background-color: var(--dark-primary-table) !important; }
        .btn-action-primary { background-color: var(--action-color) !important; border-color: var(--action-color) !important; color: white !important; }
        .btn-action-primary:hover { background-color: var(--action-dark-hover) !important; }

        .form-select-lg { height: 3.5rem; border-radius: 50rem !important; }

        /* --- User Card View --- */
        .card { border: 1px solid var(--border-color) !important; border-radius: 1rem !important; }
        .user-avatar-card { border: 3px solid var(--primary-light); object-fit: cover; }
        .user-card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(67, 97, 238, 0.15) !important;
            border-color: var(--action-color) !important;
        }
        .avatar-sm {
            width: 32px; height: 32px; border-radius: 50%;
            display: inline-flex; align-items: center; justify-content: center;
            background-color: var(--primary-light); color: var(--action-color); font-weight: bold;
        }

        /* --- Table/List Styles --- */
        .table-hover-row:hover { background-color: var(--primary-light) !important; }
        .table-hover-row { border-bottom: 1px solid var(--border-color); }
        .positions-list .position-item { background-color: var(--gray-light); border: 1px solid var(--border-color); }

        /* --- Badges --- */
        .badge { font-weight: 600 !important; padding: 0.5em 0.8em; border-radius: 9999px; }
        .bg-soft-info { background-color: #EBF5FB !important; color: var(--info-color) !important; }
        .bg-soft-primary { background-color: var(--primary-light) !important; color: var(--action-color) !important; }
        .bg-soft-secondary { background-color: var(--gray-light) !important; color: var(--secondary-light) !important; }

        /* --- Action Buttons --- */
        .btn-group-sm .btn { padding: 0.4rem; border-radius: 50% !important; }
        .btn-outline-primary { color: var(--action-color); border-color: var(--action-color); }
        .btn-outline-primary:hover { background-color: var(--action-color); color: white; }
        .btn-outline-danger { color: var(--danger-color); border-color: var(--danger-color); }
        .btn-outline-danger:hover { background-color: var(--danger-color); color: white; }

        /* --- Alerts --- */
        .success-alert-custom { border-left: 5px solid var(--success-color); }
        .danger-alert-custom { border-left: 5px solid var(--danger-color); }
    </style>
</div>
