<div class="container-fluid px-4 py-4">

    {{-- پیام‌ها --}}
    @if(session()->has('success'))
        <div class="alert alert-success alert-dismissible fade show d-flex align-items-center" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            <strong>انجام شد!</strong> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Header --}}
    <div class="card border-0 shadow-sm rounded-4 mb-4">
        <div class="card-body p-4 d-flex align-items-center gap-3 flex-wrap">
            @if($user->image)
                <img src="{{ Storage::disk('users')->url($user->image) }}" class="rounded-circle border" width="78" height="78" style="object-fit:cover;">
            @else
                <span class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center"
                      style="width:78px;height:78px;font-size:1.2rem;">
                    {{ strtoupper(mb_substr($user->name,0,1)) }}
                </span>
            @endif

            <div class="me-auto">
                <div class="fw-bold fs-4">{{ $user->name }}</div>
                <div class="text-muted small">{{ $user->email }} · {{ $user->mobile }}</div>
                <div class="mt-2 d-flex gap-2">
                    <span class="badge text-bg-{{ $user->status==='active'?'success':'secondary' }}">{{ $user->status==='active'?'فعال':'غیرفعال' }}</span>
                    <span class="badge text-bg-secondary">{{ $user->role ?? 'user' }}</span>
                    @if($user->gender)
                        <span class="badge text-bg-light text-dark">{{ $user->gender==='male'?'مرد':'زن' }}</span>
                    @endif
                </div>
            </div>

            <div class="d-flex gap-2">
{{--                <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary">--}}
{{--                    <i class="fas fa-arrow-right"></i> بازگشت--}}
{{--                </a>--}}
{{--                <a href="{{ route('admin.users.index') }}#edit-{{ $user->id }}" class="btn btn-outline-primary">--}}
{{--                    <i class="fas fa-edit"></i> ویرایش در لیست--}}
{{--                </a>--}}
                <button class="btn btn-outline-info" wire:click="openPasswordModal">
                    <i class="fas fa-key"></i> تغییر رمز
                </button>
            </div>
        </div>
    </div>

    {{-- Tabs --}}
    <div class="card border-0 shadow-sm rounded-4">
        <div class="card-header bg-white p-0 border-bottom">
            <ul class="nav nav-tabs nav-fill border-0" role="tablist">
                <li class="nav-item"><a class="nav-link active py-3" data-bs-toggle="tab" href="#overview" role="tab">نمای کلی</a></li>
                <li class="nav-item"><a class="nav-link py-3" data-bs-toggle="tab" href="#work" role="tab">سازمانی</a></li>
                <li class="nav-item"><a class="nav-link py-3" data-bs-toggle="tab" href="#security" role="tab">امنیت</a></li>
                <li class="nav-item"><a class="nav-link py-3" data-bs-toggle="tab" href="#activity" role="tab">فعالیت</a></li>
            </ul>
        </div>

        <div class="card-body p-4">
            <div class="tab-content">

                {{-- Overview --}}
                <div class="tab-pane fade show active" id="overview" role="tabpanel">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="border rounded-3 p-3 h-100">
                                <div class="fw-semibold mb-2">اطلاعات تماس</div>
                                <div class="small text-muted">ایمیل: <span class="text-dark">{{ $user->email }}</span></div>
                                <div class="small text-muted">موبایل: <span class="text-dark">{{ $user->mobile }}</span></div>
                                <div class="small text-muted">کد ملی: <span class="text-dark">{{ $user->ncode ?? '—' }}</span></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="border rounded-3 p-3 h-100">
                                <div class="fw-semibold mb-2">وضعیت و نقش</div>
                                <div class="small text-muted">وضعیت: <span class="text-dark">{{ $user->status==='active'?'فعال':'غیرفعال' }}</span></div>
                                <div class="small text-muted">نقش: <span class="text-dark">{{ $user->role ?? 'user' }}</span></div>
                                <div class="small text-muted">مدرک: <span class="text-dark">{{ $user->degree ?? '—' }}</span></div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Org / Work --}}
                <div class="tab-pane fade" id="work" role="tabpanel">
                    <div class="border rounded-3 p-3">
                        <div class="row g-3 small">
                            @php
                                $dept = $user->department;
                                $companyName = $user->company->name ?? optional($dept?->company)->name ?? '—';
                            @endphp
                            <div class="col-md-4">شرکت: <span class="text-dark">{{ $companyName }}</span></div>
                            <div class="col-md-4">دپارتمان: <span class="text-dark">{{ $dept->name ?? '—' }}</span></div>
                            <div class="col-md-4">تاریخ عضویت: <span class="text-dark">{{ $user->created_at->format('Y/m/d') }}</span></div>
                        </div>
                    </div>
                </div>

                {{-- Security --}}
                <div class="tab-pane fade" id="security" role="tabpanel">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="border rounded-3 p-3 h-100">
                                <div class="fw-semibold mb-2">ورود و نشست</div>
                                <div class="small text-muted">آخرین ورود: <span class="text-dark">{{ $user->last_login_at ? $user->last_login_at->diffForHumans() : 'هرگز' }}</span></div>
                                <div class="small text-muted">به‌روزرسانی: <span class="text-dark">{{ $user->updated_at->diffForHumans() }}</span></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="border rounded-3 p-3 h-100">
                                <div class="fw-semibold mb-2">احراز هویت</div>
                                <div class="small text-muted">2FA: <span class="text-dark">{{ isset($user->two_factor_confirmed_at) && $user->two_factor_confirmed_at ? 'فعال' : 'غیرفعال' }}</span></div>
                                <div class="small text-muted">وضعیت حساب: <span class="text-dark">{{ $user->status==='active'?'Active':'Inactive' }}</span></div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Activity --}}
                <div class="tab-pane fade" id="activity" role="tabpanel">
                    <div class="border rounded-3 p-3 small">
                        <div class="mb-2">تایم‌لاین</div>
                        <ul class="list-unstyled m-0">
                            <li class="mb-1">ایجاد حساب: <span class="text-dark">{{ $user->created_at->format('Y/m/d H:i') }}</span></li>
                            <li class="mb-1">آخرین بروزرسانی: <span class="text-dark">{{ $user->updated_at->format('Y/m/d H:i') }}</span></li>
                            <li class="mb-1">آخرین ورود: <span class="text-dark">{{ $user->last_login_at ? $user->last_login_at->format('Y/m/d H:i') : '—' }}</span></li>
                        </ul>
                        {{-- اگر لاگ فعالیت دارید، اینجا لیست کنید --}}
                    </div>
                </div>

            </div>
        </div>
    </div>

    {{-- تغییر رمز داخل صفحه پروفایل --}}
    @if($showPasswordModal)
        <div class="modal fade show d-block"
             tabindex="-1" role="dialog" aria-modal="true"
             wire:click.self="closePasswordModal"
             wire:keydown.escape.window="closePasswordModal"
             style="display:block;">
            <div class="modal-dialog">
                <div class="modal-content border-0 rounded-4 shadow-lg">
                    <div class="modal-header bg-primary text-white rounded-top-4">
                        <h5 class="modal-title">تغییر رمز کاربر</h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closePasswordModal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">رمز عبور جدید</label>
                            <input type="password" class="form-control @error('newPassword') is-invalid @enderror" wire:model.defer="newPassword">
                            @error('newPassword') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label class="form-label">تکرار رمز عبور</label>
                            <input type="password" class="form-control @error('newPasswordConfirmation') is-invalid @enderror" wire:model.defer="newPasswordConfirmation">
                            @error('newPasswordConfirmation') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <div class="modal-footer border-0 pt-0">
                        <button type="button" class="btn btn-secondary px-4" wire:click="closePasswordModal">انصراف</button>
                        <button type="button" class="btn btn-primary px-4" wire:click="updatePassword" wire:loading.attr="disabled">
                            <span wire:loading.remove><i class="fas fa-save"></i> ذخیره رمز</span>
                            <span wire:loading><i class="fas fa-spinner fa-spin"></i> در حال ذخیره...</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif
</div>
