<div>
    <div class="p-6">
        <h1 class="text-3xl font-bold mb-6">👋 داشبورد خوش آمدید، {{ $user->name }}</h1>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <div class="bg-blue-600 text-white p-4 rounded-lg shadow-lg flex flex-col items-center justify-center">
                <span id="current-time" class="text-4xl font-extrabold"></span>
                <span id="current-date" class="text-lg"></span>
            </div>

            <div class="bg-white p-4 rounded-lg shadow-lg border border-gray-200 col-span-2">
                <h3 class="text-lg font-semibold mb-2">وضعیت کلی</h3>
                <p>نقش شما: **{{ __('user.role_' . $user->role) }}**</p>
                <p>آخرین ورود: {{ optional($user->last_login_at)->diffForHumans() ?? 'اولین ورود' }}</p>
            </div>
        </div>

        <h2 class="text-2xl font-semibold mb-4 border-b pb-2">🎯 آمار و وظایف من</h2>
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 mb-8">

            <a href="{{ route('tasks.my-active') }}" class="bg-red-100 hover:bg-red-200 transition p-4 rounded-lg shadow-md text-center">
                <div class="text-3xl font-bold text-red-700">{{ $data['activeTasksCount'] }}</div>
                <p class="text-sm mt-1 text-red-600">تسک فعال</p>
            </a>

            <a href="{{ route('tasks.my-active') }}" class="bg-yellow-100 hover:bg-yellow-200 transition p-4 rounded-lg shadow-md text-center">
                <div class="text-3xl font-bold text-yellow-700">{{ $data['newLettersCount'] }}</div>
                <p class="text-sm mt-1 text-yellow-600">نامه جدید</p>
            </a>

            <a href="{{ route('tasks.my-active') }}" class="bg-indigo-100 hover:bg-indigo-200 transition p-4 rounded-lg shadow-md text-center">
                <div class="text-3xl font-bold text-indigo-700">{{ $data['newAnnouncementsCount'] }}</div>
                <p class="text-sm mt-1 text-indigo-600">اطلاع‌رسانی جدید</p>
            </a>

            @if($data['managedProjectsCount'] > 0)
                <a href="{{ route('tasks.my-active') }}" class="bg-green-100 hover:bg-green-200 transition p-4 rounded-lg shadow-md text-center">
                    <div class="text-3xl font-bold text-green-700">{{ $data['managedProjectsCount'] }}</div>
                    <p class="text-sm mt-1 text-green-600">پروژه مدیریت</p>
                </a>
            @endif

            @if(isset($data['totalProjects']))
                <a href="{{ route('tasks.my-active') }}" class="bg-gray-100 hover:bg-gray-200 transition p-4 rounded-lg shadow-md text-center">
                    <div class="text-3xl font-bold text-gray-700">{{ $data['totalProjects'] }}</div>
                    <p class="text-sm mt-1 text-gray-600">کل پروژه‌ها</p>
                </a>
            @endif

        </div>

        ---

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

            <div>
                <h2 class="text-2xl font-semibold mb-4 flex justify-between items-center">
                    📰 آخرین اخبار شرکت
                    <a href="{{ route('tasks.my-active') }}" class="text-sm text-blue-600 hover:underline">مشاهده همه</a>
                </h2>
                <div class="space-y-4">
                    @forelse ($data['tasks.my-active'] as $post)
                        <div class="bg-white p-4 rounded-lg shadow-sm border-l-4 border-green-500">
                            <a href="{{ route('tasks.my-active', $post) }}" class="text-lg font-medium hover:text-blue-600">{{ $post->title }}</a>
                            <p class="text-gray-500 text-sm mt-1">{{ \Carbon\Carbon::parse($post->created_at)->diffForHumans() }}</p>
                        </div>
                    @empty
                        <p class="text-gray-500">در حال حاضر خبری منتشر نشده است.</p>
                    @endforelse
                </div>
            </div>

            <div>
                <h2 class="text-2xl font-semibold mb-4 flex justify-between items-center">
                    📢 اطلاع‌رسانی‌های داخلی اخیر
                    <a href="{{ route('tasks.my-active') }}" class="text-sm text-blue-600 hover:underline">مشاهده همه</a>
                </h2>
                <p class="text-gray-500 p-4 bg-white rounded-lg shadow-sm">
                    (این بخش می‌تواند با لیست کوتاهی از ۵ اطلاعیه اخیر تکمیل شود.)
                </p>
            </div>
        </div>
    </div>

    <script>
        function updateTime() {
            const now = new Date();

            // تنظیمات ساعت (ساده)
            const timeOptions = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
            document.getElementById('current-time').innerText = now.toLocaleTimeString('fa-IR', timeOptions);

            // تنظیمات تاریخ
            const dateOptions = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
            document.getElementById('current-date').innerText = now.toLocaleDateString('fa-IR', dateOptions);
        }

        // به‌روزرسانی در لحظه بارگذاری و سپس هر ثانیه
        updateTime();
        setInterval(updateTime, 1000);
    </script>
</div>
