<?php

use App\Livewire\Actions\Logout;
use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use App\Models\User; // 💡 برای دسترسی به ثابت‌های نقش

new class extends Component
{
    /**
     * Log the current user out of the application.
     */
    public function logout(Logout $logout): void
    {
        $logout();

        $this->redirect('/', navigate: true);
    }

    public function with(): array
    {
        // ارسال اطلاعات کاربر به ویو
        return [
            'user' => Auth::user(),
        ];
    }
}; ?>

{{-- 💡 این کامپوننت محتوای Dropdown را ارائه می‌دهد --}}
<div>
    {{-- 💡 تعریف استایل‌های داخلی برای این کامپوننت --}}
    <style>
        /* 💡 استایل‌های داخلی برای هماهنگی نهایی و افکت هاور */
        .hover-bg-light:hover { background-color: #f8f9fa !important; }
        .bg-light-primary { background-color: #e6f0ff !important; }
        .bg-light-info { background-color: #e8f9fb !important; }
        .bg-light-warning { background-color: #fffde7 !important; }
        .rounded-1 { border-radius: 6px !important; }
        .shadow-sm { box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important; }
        .text-primary { color: #4a7cff !important; }
        .text-info { color: #17a2b8 !important; }
        .text-warning { color: #ffc107 !important; }
        .text-muted { color: #6c757d !important; }
        .text-dark { color: #212529 !important; }
    </style>

    <div class="profile-dropdown position-relative" data-simplebar>
        <div class="py-4 px-7 border-bottom">
            <h5 class="mb-0 fs-5 fw-semibold text-primary">پروفایل کاربر</h5>
            <span class="text-muted small">تنظیمات و دسترسی‌ها</span>
        </div>

        {{-- User Info Block --}}
        <div class="d-flex align-items-center py-5 mx-7 border-bottom">
            <img src="{{ $user->image ? asset('storage/' . $user->image) : asset('panel/dist/images/profile/user-1.jpg') }}"
                 class="rounded-circle shadow-sm"
                 width="48"
                 height="48"
                 alt="{{ $user->name }}"
                 onerror="this.src='{{ asset('panel/dist/images/profile/user-1.jpg') }}'">
            <div class="ms-3 text-right">
                <h6 class="mb-1 fs-4 fw-bold text-dark">{{ Str::limit($user->name, 25) ?? 'کاربر' }}</h6>

                {{-- نمایش نقش با استایل Badge --}}
                @php
                    $role = $user->role ?? 'نقش نامشخص';
                    $badgeClass = ($role === User::ROLE_ADMIN || $role === User::ROLE_MANAGER) ? 'text-bg-warning' : 'text-bg-info';
                @endphp
                <span class="mb-1 d-block badge {{ $badgeClass }} text-dark fw-semibold">{{ $role }}</span>

                <p class="mb-0 d-flex text-muted align-items-center gap-2 small mt-1">
                    <i class="ti ti-mail fs-5 me-1"></i> {{ Str::limit($user->email, 25) ?? 'N/A' }}
                </p>
            </div>
        </div>

        {{-- Menu Items --}}
        <div class="message-body">
            <a href="{{ route('user.profile.edit') }}" class="py-3 px-7 d-flex align-items-center hover-bg-light">
                <span class="d-flex align-items-center justify-content-center bg-light-primary rounded-1 p-2 me-3">
                    <i class="ti ti-user-circle fs-6 text-primary"></i>
                </span>
                <div class="w-75">
                    <h6 class="mb-0 fw-semibold">پروفایل من</h6>
                    <span class="d-block text-muted small">مشاهده و ویرایش</span>
                </div>
            </a>

            <a href="{{ route('user.inbox') }}" class="py-3 px-7 d-flex align-items-center hover-bg-light">
                <span class="d-flex align-items-center justify-content-center bg-light-info rounded-1 p-2 me-3">
                    <i class="ti ti-inbox fs-6 text-info"></i>
                </span>
                <div class="w-75">
                    <h6 class="mb-0 fw-semibold">صندوق ورودی</h6>
                    <span class="d-block text-muted small">پیام‌ها و اعلان‌ها</span>
                </div>
            </a>

            {{-- 💡 آیتم هوشمند: اگر مدیر یا مدیر پروژه است، لینک مدیریت را بده --}}
            @if ($user->role === User::ROLE_ADMIN || $user->role === User::ROLE_MANAGER)
                <a href="{{ route('admin.users') }}" class="py-3 px-7 d-flex align-items-center hover-bg-light">
                    <span class="d-flex align-items-center justify-content-center bg-light-warning rounded-1 p-2 me-3">
                        <i class="ti ti-user-shield fs-6 text-warning"></i>
                    </span>
                    <div class="w-75">
                        <h6 class="mb-0 fw-semibold">پنل مدیریت</h6>
                        <span class="d-block text-muted small">مدیریت کاربران و دسترسی‌ها</span>
                    </div>
                </a>
            @endif
        </div>

        {{-- Logout Button --}}
        <div class="d-grid py-4 px-7 border-top">
            <button wire:click="logout" class="btn btn-outline-danger w-100">
                <i class="ti ti-power me-2"></i> خروج از سیستم
            </button>
        </div>
    </div>
</div>
