<div>
    <div class="notifications-container">
        <!-- Flash Messages با طراحی مدرن -->
        @if(session()->has('success'))
            <div class="notification-alert success">
                <div class="alert-icon">
                    <i class="ti ti-circle-check"></i>
                </div>
                <div class="alert-content">
                    <h4>موفقیت آمیز</h4>
                    <p>{{ session('success') }}</p>
                </div>
                <button type="button" class="alert-close" data-bs-dismiss="alert">
                    <i class="ti ti-x"></i>
                </button>
            </div>
        @endif

        @if(session()->has('error'))
            <div class="notification-alert error">
                <div class="alert-icon">
                    <i class="ti ti-alert-triangle"></i>
                </div>
                <div class="alert-content">
                    <h4>خطا</h4>
                    <p>{{ session('error') }}</p>
                </div>
                <button type="button" class="alert-close" data-bs-dismiss="alert">
                    <i class="ti ti-x"></i>
                </button>
            </div>
        @endif

        <!-- هدر اصلی -->
        <div class="notifications-header">
            <div class="header-content">
                <div class="header-title">
                    <div class="title-icon">
                        <i class="ti ti-inbox"></i>
                    </div>
                    <div class="title-text">
                        <h1>صندوق ورودی اطلاعیه‌ها</h1>
                        <p>همه اطلاعیه‌های ارسال شده به شما</p>
                    </div>
                </div>

                <div class="header-stats">
                    <div class="stat-item total">
                        <div class="stat-icon">
                            <i class="ti ti-message"></i>
                        </div>
                        <div class="stat-info">
                            <span class="stat-number">{{ $stats['total'] }}</span>
                            <span class="stat-label">همه اطلاعیه‌ها</span>
                        </div>
                    </div>

                    <div class="stat-item unread">
                        <div class="stat-icon">
                            <i class="ti ti-mail"></i>
                        </div>
                        <div class="stat-info">
                            <span class="stat-number">{{ $stats['unread'] }}</span>
                            <span class="stat-label">نخوانده</span>
                        </div>
                    </div>

                    <div class="stat-item read">
                        <div class="stat-icon">
                            <i class="ti ti-mail-opened"></i>
                        </div>
                        <div class="stat-info">
                            <span class="stat-number">{{ $stats['read'] }}</span>
                            <span class="stat-label">خوانده شده</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- کارت اصلی -->
        <div class="notifications-card">
            <!-- نوار ابزار -->
            <div class="toolbar-section">
                <div class="toolbar-grid">
                    <div class="search-box">
                        <i class="ti ti-search"></i>
                        <input type="text"
                               placeholder="جستجو در عنوان و متن اطلاعیه..."
                               wire:model.debounce.400ms="search">
                    </div>

                    <div class="filter-controls">
                        <select class="filter-select" wire:model="only">
                            <option value="all">همه اطلاعیه‌ها</option>
                            <option value="unread">نخوانده‌ها</option>
                            <option value="read">خوانده‌ها</option>
                        </select>

                        <select class="filter-select" wire:model="sort">
                            <option value="newest">جدیدترین اول</option>
                            <option value="oldest">قدیمی‌ترین اول</option>
                            <option value="unread_first">نخوانده‌ها اول</option>
                        </select>

                        <select class="filter-select" wire:model="perPage">
                            <option value="5">۵ در صفحه</option>
                            <option value="10">۱۰ در صفحه</option>
                            <option value="15">۱۵ در صفحه</option>
                            <option value="20">۲۰ در صفحه</option>
                            <option value="50">۵۰ در صفحه</option>
                        </select>

                        <button class="clear-filters-btn" wire:click="clearFilters" title="پاک‌کردن فیلترها">
                            <i class="ti ti-refresh"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- اقدامات گروهی -->
            <div class="bulk-actions-section">
                <div class="bulk-actions-content">
                    <div class="selection-controls">
                        <label class="checkbox-container">
                            <input type="checkbox" id="selectPage" wire:model="selectPage">
                            <span class="checkmark"></span>
                            <span class="checkbox-label">انتخاب همه در این صفحه</span>
                        </label>

                        <button class="action-btn primary" wire:click="markAllAsRead">
                            <i class="ti ti-mail-opened"></i>
                            <span>علامت‌گذاری همه به عنوان خوانده</span>
                        </button>
                    </div>

                    @if(!empty($selected))
                        <div class="selected-actions">
                            <div class="selected-count">
                                <span>{{ count($selected) }} مورد انتخاب شده</span>
                            </div>

                            <div class="action-buttons">
                                <button class="action-btn success" wire:click="markSelectedAsRead">
                                    <i class="ti ti-checks"></i>
                                    <span>خوانده کردن انتخاب‌ها</span>
                                </button>

                                <button class="action-btn warning" wire:click="markSelectedAsUnread">
                                    <i class="ti ti-mail"></i>
                                    <span>برگرداندن به نخوانده</span>
                                </button>

                                <button class="action-btn danger" wire:click="clearSelection">
                                    <i class="ti ti-x"></i>
                                    <span>پاک‌کردن انتخاب</span>
                                </button>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- اسکلت بارگذاری -->
            <div wire:loading.flex class="loading-skeleton">
                @for($i=0; $i<3; $i++)
                    <div class="skeleton-item">
                        <div class="skeleton-checkbox"></div>
                        <div class="skeleton-content">
                            <div class="skeleton-title"></div>
                            <div class="skeleton-meta"></div>
                            <div class="skeleton-text"></div>
                            <div class="skeleton-text short"></div>
                        </div>
                        <div class="skeleton-action"></div>
                    </div>
                @endfor
            </div>

            <!-- لیست اطلاعیه‌ها -->
            <div wire:loading.remove class="announcements-list">
                @forelse($announcements as $a)
                    @php
                        $isUnread = is_null($a->pivot_read_at);
                        $hasAttachments = ($a->attachments && $a->attachments->count() > 0);
                    @endphp

                    <div class="announcement-item {{ $isUnread ? 'unread' : 'read' }}"
                         wire:key="a-{{ $a->id }}-{{ $tick }}">

                        <div class="announcement-content">
                            <div class="announcement-checkbox">
                                <input type="checkbox" wire:model="selected" value="{{ $a->id }}">
                            </div>

                            <div class="announcement-main">
                                <div class="announcement-header">
                                    <div class="announcement-title-section">
                                        <h3 class="announcement-title">{{ $a->title }}</h3>
                                        <div class="announcement-status">
                                            @if($isUnread)
                                                <span class="status-badge new">
                                                <i class="ti ti-bell"></i>
                                                جدید
                                            </span>
                                            @else
                                                <span class="status-badge read">
                                                <i class="ti ti-check"></i>
                                                خوانده شده
                                            </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="announcement-actions">
                                        <button class="status-toggle-btn {{ $isUnread ? 'mark-read' : 'mark-unread' }}"
                                                wire:click="toggleRead({{ $a->id }})"
                                                wire:loading.attr="disabled">
                                            <i class="ti {{ $isUnread ? 'ti-mail-opened' : 'ti-mail' }}"></i>
                                            <span>{{ $isUnread ? 'خوانده شد' : 'نخوانده' }}</span>
                                        </button>
                                    </div>
                                </div>

                                <div class="announcement-meta">
                                    <div class="meta-item">
                                        <i class="ti ti-user-circle"></i>
                                        <span>{{ $a->sender->name ?? 'نامشخص' }}</span>
                                    </div>
                                    <div class="meta-item">
                                        <i class="ti ti-calendar"></i>
                                        <span>{{ $a->created_at->diffForHumans() }}</span>
                                    </div>
                                    @if($a->created_at->isToday())
                                        <div class="meta-badge today">
                                            امروز
                                        </div>
                                    @endif
                                </div>

                                <div class="announcement-body">
                                    <p class="announcement-text">{{ $a->content }}</p>
                                </div>

                                @if($hasAttachments || $a->file)
                                    <div class="attachments-section">
                                        <div class="attachments-header">
                                            <div class="attachments-title">
                                                <i class="ti ti-paperclip"></i>
                                                <span>فایل‌های پیوست</span>
                                            </div>
                                            @if($hasAttachments || $a->file)
                                                <livewire:admin.announcement.attachment-zip-button
                                                    :announcement-id="$a->id"
                                                    :key="'zipbtn-'.$a->id" />
                                            @endif
                                        </div>

                                        <div class="attachments-list">
                                            @if($hasAttachments)
                                                <div class="attachments-grid">
                                                    @foreach($a->attachments as $att)
                                                        <div class="attachment-item">
                                                            <div class="attachment-icon">
                                                                <i class="ti ti-file"></i>
                                                            </div>
                                                            <div class="attachment-info">
                                                                <div class="attachment-name">{{ $att->original_name }}</div>
                                                                <div class="attachment-type">فایل پیوست</div>
                                                            </div>
                                                            <a class="attachment-download" href="{{ asset('storage/'.$att->path) }}" download>
                                                                <i class="ti ti-download"></i>
                                                            </a>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            @elseif($a->file)
                                                <div class="attachment-item">
                                                    <div class="attachment-icon">
                                                        <i class="ti ti-file"></i>
                                                    </div>
                                                    <div class="attachment-info">
                                                        <div class="attachment-name">فایل اصلی اطلاعیه</div>
                                                        <div class="attachment-type">یک فایل پیوست شده است</div>
                                                    </div>
                                                    <a class="attachment-download" href="{{ asset('storage/'.$a->file) }}" download>
                                                        <i class="ti ti-download"></i>
                                                    </a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @empty
                    <!-- حالت خالی -->
                    <div class="empty-state">
                        <div class="empty-icon">
                            <i class="ti ti-inbox-off"></i>
                        </div>
                        <h3>پیامی برای نمایش وجود ندارد</h3>
                        <p>فیلترها را تغییر دهید یا عبارت جستجو را پاک کنید.</p>
                        <button class="empty-action-btn" wire:click="clearFilters">
                            <i class="ti ti-refresh"></i>
                            پاک‌کردن فیلترها
                        </button>
                    </div>
                @endforelse
            </div>

            <!-- صفحه‌بندی -->
            @if($announcements->hasPages())
                <div class="pagination-section">
                    <div class="pagination-wrapper">
                        {{ $announcements->onEachSide(1)->links() }}
                    </div>
                </div>
            @endif
        </div>
    </div>

    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #4895ef;
            --secondary: #6c757d;
            --success: #2ecc71;
            --warning: #f39c12;
            --danger: #e74c3c;
            --info: #3498db;
            --light: #f8f9fa;
            --dark: #343a40;
            --gray-100: #f8f9fa;
            --gray-200: #e9ecef;
            --gray-300: #dee2e6;
            --gray-400: #ced4da;
            --gray-500: #adb5bd;
            --gray-600: #6c757d;
            --gray-700: #495057;
            --gray-800: #343a40;
            --gray-900: #212529;
            --border-radius: 12px;
            --border-radius-sm: 8px;
            --border-radius-lg: 16px;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            --transition: all 0.3s ease;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Vazirmatn', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f7fb;
            color: var(--gray-800);
            line-height: 1.6;
        }

        .notifications-container {
            padding: 1.5rem;
            max-width: 1200px;
            margin: 0 auto;
        }

        /* استایل آلرت‌ها */
        .notification-alert {
            display: flex;
            align-items: flex-start;
            gap: 1rem;
            padding: 1.25rem 1.5rem;
            border-radius: var(--border-radius);
            margin-bottom: 2rem;
            box-shadow: var(--shadow);
            animation: slideIn 0.3s ease;
        }

        .notification-alert.success {
            background: linear-gradient(135deg, #10b981, #059669);
            color: white;
        }

        .notification-alert.error {
            background: linear-gradient(135deg, #ef4444, #dc2626);
            color: white;
        }

        .alert-icon {
            font-size: 1.5rem;
            margin-top: 0.125rem;
        }

        .alert-content h4 {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 0.25rem;
        }

        .alert-content p {
            margin: 0;
            opacity: 0.9;
        }

        .alert-close {
            background: none;
            border: none;
            color: white;
            cursor: pointer;
            font-size: 1.25rem;
            margin-left: auto;
            opacity: 0.8;
            transition: var(--transition);
        }

        .alert-close:hover {
            opacity: 1;
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* هدر اصلی */
        .notifications-header {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            margin-bottom: 2rem;
            overflow: hidden;
        }

        .header-content {
            padding: 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 2rem;
        }

        .header-title {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .title-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, var(--primary), var(--primary-light));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
        }

        .title-text h1 {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--gray-800);
            margin-bottom: 0.25rem;
        }

        .title-text p {
            color: var(--gray-600);
            margin: 0;
        }

        .header-stats {
            display: flex;
            gap: 1.5rem;
        }

        .stat-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1rem 1.5rem;
            border-radius: var(--border-radius);
            background: var(--gray-100);
            transition: var(--transition);
        }

        .stat-item:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }

        .stat-item.total {
            border-left: 4px solid var(--primary);
        }

        .stat-item.unread {
            border-left: 4px solid var(--warning);
        }

        .stat-item.read {
            border-left: 4px solid var(--success);
        }

        .stat-icon {
            width: 40px;
            height: 40px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
        }

        .stat-item.total .stat-icon {
            color: var(--primary);
        }

        .stat-item.unread .stat-icon {
            color: var(--warning);
        }

        .stat-item.read .stat-icon {
            color: var(--success);
        }

        .stat-info {
            display: flex;
            flex-direction: column;
        }

        .stat-number {
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
        }

        .stat-label {
            font-size: 0.85rem;
            color: var(--gray-600);
            margin-top: 0.25rem;
        }

        /* کارت اصلی */
        .notifications-card {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            overflow: hidden;
        }

        /* نوار ابزار */
        .toolbar-section {
            padding: 1.5rem;
            border-bottom: 1px solid var(--gray-200);
            background: var(--gray-50);
        }

        .toolbar-grid {
            display: grid;
            grid-template-columns: 1fr auto;
            gap: 1.5rem;
            align-items: center;
        }

        .search-box {
            position: relative;
            max-width: 400px;
        }

        .search-box i {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--gray-500);
        }

        .search-box input {
            width: 100%;
            padding: 0.875rem 1rem 0.875rem 3rem;
            border: 1px solid var(--gray-300);
            border-radius: var(--border-radius);
            font-size: 0.95rem;
            transition: var(--transition);
            background: white;
        }

        .search-box input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
        }

        .filter-controls {
            display: flex;
            gap: 1rem;
            align-items: center;
        }

        .filter-select {
            padding: 0.875rem 1rem;
            border: 1px solid var(--gray-300);
            border-radius: var(--border-radius);
            background: white;
            font-size: 0.95rem;
            cursor: pointer;
            transition: var(--transition);
            min-width: 160px;
        }

        .filter-select:focus {
            outline: none;
            border-color: var(--primary);
        }

        .clear-filters-btn {
            padding: 0.875rem;
            background: var(--gray-200);
            border: 1px solid var(--gray-300);
            border-radius: var(--border-radius);
            cursor: pointer;
            transition: var(--transition);
            color: var(--gray-700);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .clear-filters-btn:hover {
            background: var(--gray-300);
        }

        /* اقدامات گروهی */
        .bulk-actions-section {
            padding: 1.5rem;
            border-bottom: 1px solid var(--gray-200);
            background: var(--gray-50);
        }

        .bulk-actions-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1.5rem;
            flex-wrap: wrap;
        }

        .selection-controls {
            display: flex;
            align-items: center;
            gap: 1rem;
            flex-wrap: wrap;
        }

        .checkbox-container {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            cursor: pointer;
            font-weight: 500;
            color: var(--gray-700);
        }

        .checkbox-container input {
            display: none;
        }

        .checkmark {
            width: 20px;
            height: 20px;
            border: 2px solid var(--gray-400);
            border-radius: 4px;
            position: relative;
            transition: var(--transition);
        }

        .checkbox-container input:checked + .checkmark {
            background: var(--primary);
            border-color: var(--primary);
        }

        .checkbox-container input:checked + .checkmark::after {
            content: '';
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%) rotate(45deg);
            width: 4px;
            height: 8px;
            border: solid white;
            border-width: 0 2px 2px 0;
        }

        .action-btn {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.25rem;
            border: 1px solid;
            border-radius: var(--border-radius);
            font-weight: 500;
            cursor: pointer;
            transition: var(--transition);
            font-size: 0.9rem;
        }

        .action-btn.primary {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .action-btn.primary:hover {
            background: #3a56d4;
            border-color: #3a56d4;
        }

        .action-btn.success {
            background: var(--success);
            color: white;
            border-color: var(--success);
        }

        .action-btn.success:hover {
            background: #27ae60;
            border-color: #27ae60;
        }

        .action-btn.warning {
            background: var(--warning);
            color: white;
            border-color: var(--warning);
        }

        .action-btn.warning:hover {
            background: #e67e22;
            border-color: #e67e22;
        }

        .action-btn.danger {
            background: var(--danger);
            color: white;
            border-color: var(--danger);
        }

        .action-btn.danger:hover {
            background: #c0392b;
            border-color: #c0392b;
        }

        .selected-actions {
            display: flex;
            align-items: center;
            gap: 1.5rem;
        }

        .selected-count {
            background: var(--primary);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 50px;
            font-weight: 500;
            font-size: 0.9rem;
        }

        .action-buttons {
            display: flex;
            gap: 0.75rem;
        }

        /* اسکلت بارگذاری */
        .loading-skeleton {
            padding: 1.5rem;
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }

        .skeleton-item {
            display: flex;
            gap: 1rem;
            padding: 1.5rem;
            background: white;
            border-radius: var(--border-radius);
            border: 1px solid var(--gray-200);
        }

        .skeleton-checkbox {
            width: 20px;
            height: 20px;
            border-radius: 4px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite;
        }

        .skeleton-content {
            flex: 1;
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }

        .skeleton-title {
            height: 24px;
            border-radius: 4px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite;
            width: 60%;
        }

        .skeleton-meta {
            height: 16px;
            border-radius: 4px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite;
            width: 40%;
        }

        .skeleton-text {
            height: 16px;
            border-radius: 4px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite;
        }

        .skeleton-text.short {
            width: 80%;
        }

        .skeleton-action {
            width: 120px;
            height: 40px;
            border-radius: var(--border-radius);
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite;
        }

        @keyframes shimmer {
            0% {
                background-position: 200% 0;
            }
            100% {
                background-position: -200% 0;
            }
        }

        /* لیست اطلاعیه‌ها */
        .announcements-list {
            padding: 1.5rem;
        }

        .announcement-item {
            background: white;
            border-radius: var(--border-radius);
            border: 1px solid var(--gray-200);
            margin-bottom: 1rem;
            transition: var(--transition);
            overflow: hidden;
        }

        .announcement-item:hover {
            box-shadow: var(--shadow-lg);
            transform: translateY(-2px);
        }

        .announcement-item.unread {
            border-left: 4px solid var(--primary);
            background: linear-gradient(90deg, rgba(67, 97, 238, 0.03), white);
        }

        .announcement-content {
            padding: 1.5rem;
            display: flex;
            gap: 1rem;
        }

        .announcement-checkbox {
            display: flex;
            align-items: flex-start;
            padding-top: 0.25rem;
        }

        .announcement-checkbox input {
            width: 18px;
            height: 18px;
            cursor: pointer;
        }

        .announcement-main {
            flex: 1;
        }

        .announcement-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .announcement-title-section {
            display: flex;
            align-items: center;
            gap: 1rem;
            flex-wrap: wrap;
        }

        .announcement-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--gray-800);
            margin: 0;
        }

        .announcement-status {
            display: flex;
            align-items: center;
        }

        .status-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            border-radius: 50px;
            font-weight: 500;
            font-size: 0.85rem;
        }

        .status-badge.new {
            background: var(--primary);
            color: white;
        }

        .status-badge.read {
            background: var(--success);
            color: white;
        }

        .announcement-actions {
            display: flex;
            align-items: center;
        }

        .status-toggle-btn {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.25rem;
            border: 1px solid;
            border-radius: var(--border-radius);
            font-weight: 500;
            cursor: pointer;
            transition: var(--transition);
            font-size: 0.9rem;
        }

        .status-toggle-btn.mark-read {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .status-toggle-btn.mark-read:hover {
            background: #3a56d4;
            border-color: #3a56d4;
        }

        .status-toggle-btn.mark-unread {
            background: var(--gray-200);
            color: var(--gray-700);
            border-color: var(--gray-300);
        }

        .status-toggle-btn.mark-unread:hover {
            background: var(--gray-300);
        }

        .announcement-meta {
            display: flex;
            align-items: center;
            gap: 1.5rem;
            margin-bottom: 1rem;
            flex-wrap: wrap;
        }

        .meta-item {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--gray-600);
            font-size: 0.9rem;
        }

        .meta-badge.today {
            background: var(--info);
            color: white;
            padding: 0.25rem 0.75rem;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 500;
        }

        .announcement-body {
            margin-bottom: 1.5rem;
        }

        .announcement-text {
            color: var(--gray-700);
            line-height: 1.6;
            margin: 0;
        }

        /* بخش پیوست‌ها */
        .attachments-section {
            background: var(--gray-50);
            border-radius: var(--border-radius);
            padding: 1.5rem;
            border: 1px solid var(--gray-200);
        }

        .attachments-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }

        .attachments-title {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-weight: 600;
            color: var(--gray-800);
        }

        .attachments-list {
            margin-top: 1rem;
        }

        .attachments-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1rem;
        }

        .attachment-item {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem;
            background: white;
            border-radius: var(--border-radius);
            border: 1px solid var(--gray-200);
            transition: var(--transition);
        }

        .attachment-item:hover {
            box-shadow: var(--shadow);
            transform: translateY(-1px);
        }

        .attachment-icon {
            width: 48px;
            height: 48px;
            background: rgba(67, 97, 238, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
            font-size: 1.25rem;
        }

        .attachment-info {
            flex: 1;
        }

        .attachment-name {
            font-weight: 500;
            color: var(--gray-800);
            margin-bottom: 0.25rem;
        }

        .attachment-type {
            font-size: 0.85rem;
            color: var(--gray-600);
        }

        .attachment-download {
            width: 40px;
            height: 40px;
            background: var(--primary);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            transition: var(--transition);
        }

        .attachment-download:hover {
            background: #3a56d4;
            color: white;
            transform: scale(1.05);
        }

        /* حالت خالی */
        .empty-state {
            text-align: center;
            padding: 4rem 2rem;
        }

        .empty-icon {
            width: 80px;
            height: 80px;
            background: var(--gray-100);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            color: var(--gray-400);
            font-size: 2rem;
        }

        .empty-state h3 {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--gray-600);
            margin-bottom: 0.5rem;
        }

        .empty-state p {
            color: var(--gray-500);
            margin-bottom: 2rem;
        }

        .empty-action-btn {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.875rem 1.5rem;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: var(--border-radius);
            font-weight: 500;
            cursor: pointer;
            transition: var(--transition);
        }

        .empty-action-btn:hover {
            background: #3a56d4;
        }

        /* صفحه‌بندی */
        .pagination-section {
            padding: 1.5rem;
            border-top: 1px solid var(--gray-200);
            background: var(--gray-50);
        }

        .pagination-wrapper {
            display: flex;
            justify-content: center;
        }

        .pagination-wrapper .pagination {
            display: flex;
            gap: 0.5rem;
            list-style: none;
            margin: 0;
            padding: 0;
        }

        .pagination-wrapper .page-item .page-link {
            padding: 0.75rem 1rem;
            border: 1px solid var(--gray-300);
            border-radius: var(--border-radius);
            color: var(--gray-700);
            text-decoration: none;
            transition: var(--transition);
            background: white;
        }

        .pagination-wrapper .page-item .page-link:hover {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .pagination-wrapper .page-item.active .page-link {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .pagination-wrapper .page-item.disabled .page-link {
            background: var(--gray-200);
            color: var(--gray-500);
            cursor: not-allowed;
        }

        /* رسپانسیو */
        @media (max-width: 1024px) {
            .header-content {
                flex-direction: column;
                align-items: flex-start;
            }

            .header-stats {
                width: 100%;
                justify-content: space-between;
            }

            .toolbar-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .filter-controls {
                flex-wrap: wrap;
            }
        }

        @media (max-width: 768px) {
            .notifications-container {
                padding: 1rem;
            }

            .header-content {
                padding: 1.5rem;
            }

            .header-stats {
                flex-direction: column;
                gap: 1rem;
            }

            .stat-item {
                width: 100%;
            }

            .bulk-actions-content {
                flex-direction: column;
                align-items: flex-start;
            }

            .selected-actions {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }

            .action-buttons {
                flex-wrap: wrap;
            }

            .announcement-header {
                flex-direction: column;
                align-items: flex-start;
            }

            .announcement-title-section {
                flex-direction: column;
                align-items: flex-start;
            }

            .attachments-grid {
                grid-template-columns: 1fr;
            }

            .announcement-content {
                padding: 1rem;
            }

            .attachments-section {
                padding: 1rem;
            }
        }

        @media (max-width: 480px) {
            .filter-controls {
                flex-direction: column;
            }

            .filter-select {
                min-width: 100%;
            }

            .selection-controls {
                flex-direction: column;
                align-items: flex-start;
            }
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // مدیریت انیمیشن‌ها و تعاملات
            const announcementItems = document.querySelectorAll('.announcement-item');

            announcementItems.forEach(item => {
                item.addEventListener('click', function(e) {
                    // جلوگیری از فعال شدن کلیک روی دکمه‌ها و چک‌باکس
                    if (!e.target.closest('.announcement-checkbox') &&
                        !e.target.closest('.status-toggle-btn') &&
                        !e.target.closest('.attachment-download')) {
                        this.classList.toggle('expanded');
                    }
                });
            });

            // مدیریت اسکرول نرم
            const smoothScroll = (target) => {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            };

            // اضافه کردن افکت‌های تعاملی
            const interactiveElements = document.querySelectorAll('.action-btn, .status-toggle-btn, .attachment-download');

            interactiveElements.forEach(element => {
                element.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-1px)';
                });

                element.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });
        });
    </script>
</div>
