<div wire:poll.25000ms="loadAllData" class="fade-in-container">
    <div class="container-fluid">
        {{-- نمودار ApexCharts --}}
        <div class="card shadow-sm border-0 rounded-4 mb-4">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold text-gray-800">
                    <i class="ti ti-chart-bar me-2 text-primary"></i>
                    ورودهای 7 روز گذشته
                </h5>
                <span class="text-muted small">به‌روزرسانی خودکار هر 30 ثانیه</span>
            </div>
            <div class="card-body">
                <div id="loginChart" style="height: 250px;"></div>
            </div>
        </div>

        {{-- آمار بلادرنگ --}}
        <div class="row mb-4 g-3">
            <div class="col-md-4">
                <div class="card border-0 shadow-sm rounded-4 bg-gradient-to-r from-blue-500 to-indigo-600 text-white">
                    <div class="card-body text-center py-3">
                        <div class="text-2xl font-bold">{{ $stats['last_24h'] ?? 0 }}</div>
                        <small class="opacity-90">ورود در 24 ساعت گذشته</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card border-0 shadow-sm rounded-4 bg-gradient-to-r from-green-500 to-emerald-600 text-white">
                    <div class="card-body text-center py-3">
                        <div class="text-2xl font-bold">{{ $stats['unique_ips'] ?? 0 }}</div>
                        <small class="opacity-90">آی‌پی منحصربه‌فرد</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card border-0 shadow-sm rounded-4 bg-gradient-to-r from-cyan-500 to-sky-600 text-white">
                    <div class="card-body text-center py-3">
                        <div class="text-2xl font-bold">{{ $stats['unique_countries'] ?? 0 }}</div>
                        <small class="opacity-90">کشور فعال</small>
                    </div>
                </div>
            </div>
        </div>

        {{-- کنترل نمایش --}}
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="mb-0 fw-bold text-gray-800 d-flex align-items-center">
                <i class="ti ti-history me-2 text-primary"></i>
                تاریخچه ورودهای اخیر
            </h2>
            <div class="btn-group" role="group">
                <button
                    type="button"
                    class="btn {{ $viewMode === 'table' ? 'btn-primary' : 'btn-outline-primary' }} rounded-3"
                    wire:click="toggleViewMode('table')"
                >
                    <i class="ti ti-layout-grid me-1"></i> جدول
                </button>
                <button
                    type="button"
                    class="btn {{ $viewMode === 'cards' ? 'btn-primary' : 'btn-outline-primary' }} rounded-3"
                    wire:click="toggleViewMode('cards')"
                >
                    <i class="ti ti-layout-cards me-1"></i> کارت‌ها
                </button>
            </div>
        </div>

        {{-- نمای جدولی (پیش‌فرض) --}}
        @if($viewMode === 'table')
            @if($loginHistories && $loginHistories->count() > 0)
                <div class="card shadow-sm border-0 rounded-4 overflow-hidden">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="bg-gray-50">
                            <tr>
                                <th class="text-center">زمان</th>
                                <th>موقعیت</th>
                                <th class="text-center">IP</th>
                                <th class="d-none d-md-table-cell">دستگاه</th>
                                <th class="text-center">وضعیت</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($loginHistories as $history)
                                @php
                                    $location = $history->location;
                                    $device = $history->device;
                                    $isNewIp = !in_array($history->ip_address, $loginHistories->skip(1)->pluck('ip_address')->toArray());
                                    $isNewCountry = !in_array($location['country'], $loginHistories->skip(1)->pluck('location.country')->toArray());
                                    $isSuspicious = $isNewIp && $isNewCountry && $loop->first;
                                    $isUnusualHour = $history->login_at->hour < 5 || $history->login_at->hour > 23;

                                    $statusColor = 'success';
                                    $statusText = 'معمولی';
                                    if ($isSuspicious || $isUnusualHour) {
                                        $statusColor = 'danger';
                                        $statusText = 'مشکوک';
                                    } elseif ($isNewIp || $isNewCountry) {
                                        $statusColor = 'warning';
                                        $statusText = 'جدید';
                                    }
                                @endphp

                                <tr class="{{ $statusColor === 'danger' ? 'bg-danger-light' : ($statusColor === 'warning' ? 'bg-warning-light' : '') }}">
                                    <td class="text-center align-middle py-3">
                                        <div class="fw-bold text-primary">
                                            {{ \Morilog\Jalali\Jalalian::fromCarbon($history->login_at)->format('Y/m/d') }}
                                        </div>
                                        <small class="text-muted">{{ $history->login_at->diffForHumans() }}</small>
                                    </td>
                                    <td class="align-middle py-3">
                                        <div class="d-flex align-items-center">
                                            <span class="me-2">{!! country_flag($location['country_code']) !!}</span>
                                            <div>{{ $location['city'] }}, {{ $location['country'] }}</div>
                                        </div>
                                    </td>
                                    <td class="text-center align-middle py-3">
                                        <kbd class="bg-light text-dark px-2 py-1 rounded">{{ $history->ip_address }}</kbd>
                                    </td>
                                    <td class="align-middle py-3 d-none d-md-table-cell">
                                        <div>{{ $device['browser'] }} on {{ $device['platform'] }}</div>
                                        <small class="text-muted">{{ $device['device'] }}</small>
                                    </td>
                                    <td class="text-center align-middle py-3">
                                            <span class="badge rounded-pill bg-{{ $statusColor }}-subtle text-{{ $statusColor }} border border-{{ $statusColor }}-subtle px-3 py-2">
                                                <i class="ti ti-{{ $statusColor === 'danger' ? 'alert-triangle' : ($statusColor === 'warning' ? 'sparkles' : 'check') }} me-1"></i>
                                                {{ $statusText }}
                                            </span>
                                    </td>
                                    <td class="text-center align-middle py-3">
                                        <button
                                            wire:click="openDetails({{ $history->id }})"
                                            class="btn btn-sm btn-outline-secondary"
                                        >
                                            <i class="ti ti-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="ti ti-history-off text-muted" style="font-size: 3.5rem;"></i>
                    <h4 class="text-muted mt-3 fw-bold">تاریخچه ورودی وجود ندارد</h4>
                </div>
            @endif

            {{-- نمای کارتی --}}
        @elseif($viewMode === 'cards')
            @if($loginHistories && $loginHistories->count() > 0)
                <div class="row g-4">
                    @foreach($loginHistories as $history)
                        @php
                            $location = $history->location;
                            $device = $history->device;
                            $isNewIp = !in_array($history->ip_address, $loginHistories->skip(1)->pluck('ip_address')->toArray());
                            $isNewCountry = !in_array($location['country'], $loginHistories->skip(1)->pluck('location.country')->toArray());
                            $isSuspicious = $isNewIp && $isNewCountry && $loop->first;
                            $isUnusualHour = $history->login_at->hour < 5 || $history->login_at->hour > 23;

                            $statusColor = 'success';
                            $statusText = 'معمولی';
                            if ($isSuspicious || $isUnusualHour) {
                                $statusColor = 'danger';
                                $statusText = 'مشکوک';
                            } elseif ($isNewIp || $isNewCountry) {
                                $statusColor = 'warning';
                                $statusText = 'جدید';
                            }

                            if ($device['is_mobile']) {
                                $deviceIcon = '📱';
                            } elseif ($device['is_desktop']) {
                                $deviceIcon = '💻';
                            } else {
                                $deviceIcon = '🤖';
                            }
                        @endphp

                        <div class="col-12 col-md-6 col-lg-4">
                            <div class="card border-0 shadow-sm rounded-4 h-100 hover-card {{ $statusColor === 'danger' ? 'border-start border-4 border-danger' : ($statusColor === 'warning' ? 'border-start border-4 border-warning' : '') }}">
                                <div class="card-body p-4">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <span class="badge bg-{{ $statusColor }}-subtle text-{{ $statusColor }} rounded-pill px-3 py-2">
                                            <i class="ti ti-{{ $statusColor === 'danger' ? 'alert-triangle' : ($statusColor === 'warning' ? 'sparkles' : 'check') }} me-1"></i>
                                            {{ $statusText }}
                                        </span>
                                        <span class="text-muted small">{{ $history->login_at->diffForHumans() }}</span>
                                    </div>

                                    <div class="d-flex align-items-center mb-3">
                                        <span class="me-2">{!! country_flag($location['country_code']) !!}</span>
                                        <div>
                                            <div class="fw-bold">{{ $location['city'] }}</div>
                                            <div class="text-muted small">{{ $location['country'] }}</div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <div class="text-muted small mb-1">آدرس IP</div>
                                        <kbd class="bg-light text-dark px-2 py-1 rounded">{{ $history->ip_address }}</kbd>
                                    </div>

                                    <div class="d-flex align-items-center mb-4">
                                        <span class="fs-4 me-2">{{ $deviceIcon }}</span>
                                        <div>
                                            <div class="fw-medium">{{ $device['browser'] }}</div>
                                            <div class="text-muted small">{{ $device['platform'] }} • {{ $device['device'] }}</div>
                                        </div>
                                    </div>

                                    <button
                                        wire:click="openDetails({{ $history->id }})"
                                        class="btn btn-outline-primary btn-sm w-100"
                                    >
                                        <i class="ti ti-eye me-1"></i> جزئیات کامل
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-5">
                    <i class="ti ti-history-off text-muted" style="font-size: 3.5rem;"></i>
                    <h4 class="text-muted mt-3 fw-bold">تاریخچه ورودی وجود ندارد</h4>
                </div>
            @endif
        @endif
    </div>

    {{-- مودال جزئیات --}}
    @if($showModal)
        <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.5); z-index: 1050;">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content rounded-4 shadow-lg border-0">
                    <div class="modal-header border-0 pb-0">
                        <h5 class="modal-title fw-bold text-gray-800">جزئیات ورود</h5>
                        <button type="button" class="btn-close" wire:click="$set('showModal', false)"></button>
                    </div>
                    <div class="modal-body pt-0">
                        <div class="row mb-3">
                            <div class="col-6">
                                <small class="text-muted">تاریخ (شمسی)</small>
                                <div class="fw-bold">{{ $modalData['shamsi'] ?? '-' }}</div>
                            </div>
                            <div class="col-6">
                                <small class="text-muted">IP</small>
                                <div class="fw-bold">{{ $modalData['ip'] ?? '-' }}</div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <small class="text-muted">موقعیت</small>
                            <div class="fw-bold">
                                {!! country_flag($modalData['location']['country_code'] ?? 'xx') !!}
                                {{ ($modalData['location']['city'] ?? 'Unknown') . ', ' . ($modalData['location']['country'] ?? 'Unknown') }}
                            </div>
                        </div>
                        <div class="mb-3">
                            <small class="text-muted">User Agent</small>
                            <pre class="bg-gray-100 p-3 rounded mt-2" style="font-size:0.8rem; white-space: pre-wrap;">{{ $modalData['user_agent'] ?? '-' }}</pre>
                        </div>
                    </div>
                    <div class="modal-footer border-0 pt-0">
                        <button type="button" class="btn btn-secondary rounded-3" wire:click="$set('showModal', false)">بستن</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show" style="z-index: 1040;"></div>
    @endif

    @php
        function country_flag($code) {
            if ($code === 'local') return '🖥️';
            if (strlen($code) !== 2) return '🌐';
            return implode('', array_map(fn($c) => mb_chr(ord($c) - ord('A') + 0x1F1E6, 'UTF-8'), str_split(strtoupper($code))));
        }
    @endphp

    {{-- ApexCharts --}}
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        document.addEventListener('livewire:init', () => {
            function renderChart() {
                const data = @js($chartData);
                const options = {
                    chart: { type: 'area', height: 250, parentHeightOffset: 0, toolbar: { show: false } },
                    series: [{ name: 'ورودها', data: data.data }],
                    xaxis: { categories: data.labels, labels: { style: { colors: '#6b7280' } } },
                    yaxis: { labels: { style: { colors: '#6b7280' } } },
                    stroke: { curve: 'smooth', width: 2 },
                    fill: { type: 'gradient', gradient: { shade: 'light', type: 'vertical', shadeIntensity: 0.2, gradientToColors: undefined, inverseColors: true, opacityFrom: 0.8, opacityTo: 0.1, stops: [0, 100] } },
                    colors: ['#4f46e5'],
                    grid: { borderColor: '#e5e7eb', strokeDashArray: 4 },
                    tooltip: { theme: 'light' },
                    dataLabels: { enabled: false }
                };
                const chart = new ApexCharts(document.querySelector("#loginChart"), options);
                chart.render();

                // رفرش نمودار هر بار که Livewire آپدیت می‌شود
                Livewire.hook('element.updated', () => {
                    chart.destroy();
                    renderChart();
                });
            }
            renderChart();
        });
    </script>

    <style>
        .fade-in-container { animation: fadeIn 0.5s ease-out; }
        @keyframes fadeIn { from { opacity: 0.8; } to { opacity: 1; } }

        .hover-card:hover { transform: translateY(-4px); transition: transform 0.2s ease; box-shadow: 0 8px 20px rgba(0,0,0,0.12) !important; }

        .bg-gray-50 { background-color: #f9fafb; }
        .bg-gray-100 { background-color: #f3f4f6; }
        .text-gray-800 { color: #1f2937; }

        .bg-danger-light { background-color: rgba(239, 68, 68, 0.05); }
        .bg-warning-light { background-color: rgba(234, 179, 8, 0.05); }

        .bg-gradient-to-r { background-image: linear-gradient(to right, var(--tw-gradient-stops)); }
        .from-blue-500 { --tw-gradient-stops: #3b82f6, #3b82f6; }
        .to-indigo-600 { --tw-gradient-stops: #3b82f6, #4f46e5; }
        .from-green-500 { --tw-gradient-stops: #10b981, #10b981; }
        .to-emerald-600 { --tw-gradient-stops: #10b981, #059669; }
        .from-cyan-500 { --tw-gradient-stops: #06b6d4, #06b6d4; }
        .to-sky-600 { --tw-gradient-stops: #06b6d4, #0284c7; }

        kbd { font-size: 0.85rem; border-radius: 0.375rem; }
    </style>
</div>
