<div class="min-h-screen flex flex-col lg:flex-row items-center justify-center bg-gradient-to-br from-cyan-50 via-blue-50 to-indigo-100 px-4 py-12 relative overflow-hidden"
     dir="rtl">

    <div class="absolute inset-0 opacity-15 pointer-events-none">
        <div class="absolute top-1/4 left-1/4 w-64 h-64 bg-cyan-200 rounded-full animate-pulse-slow"></div>
        <div class="absolute bottom-1/3 right-1/3 w-80 h-80 bg-blue-200 rounded-full animate-pulse-slow animation-delay-2000"></div>
        <div class="absolute top-2/3 left-1/2 w-72 h-72 bg-teal-100 rounded-full animate-pulse-slow animation-delay-4000"></div>
    </div>

    <div class="absolute inset-0 opacity-4 pointer-events-none">
        <svg class="w-full h-full" viewBox="0 0 1440 800" xmlns="http://www.w3.org/2000/svg">
            <defs>
                <pattern id="grid" width="60" height="60" patternUnits="userSpaceOnUse">
                    <path d="M 60 0 L 0 0 0 60" fill="none" stroke="rgba(14, 165, 233, 0.08)" stroke-width="1"></path>
                </pattern>
            </defs>
            <rect width="100%" height="100%" fill="url(#grid)"></rect>
        </svg>
    </div>

    <div class="lg:w-1/2 lg:pr-12 flex-shrink-0 relative z-10 hidden lg:flex items-center justify-center">
        <div class="text-center max-w-2xl mx-auto space-y-6 animate-fade-in">
            <div class="flex justify-center mb-6">
                <div class="relative group">
                    <div class="absolute -inset-5 bg-gradient-to-r from-cyan-300 to-teal-200 rounded-full opacity-40 transition-all duration-700 group-hover:opacity-60 group-hover:scale-110"></div>

                    <div class="relative bg-gradient-to-br from-cyan-500 to-blue-600 p-5 rounded-3xl shadow-lg transition-transform duration-700 group-hover:rotate-6 group-active:rotate-0">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 850.39 866.3" class="w-28 h-28 lg:w-32 lg:h-32 text-white transition-transform duration-1000 ease-out group-hover:rotate-[360deg]">
                            <path fill="currentColor" d="m538.99,140.11c158.99,1.77,296,128.26,310.88,286.82,1.81,19.31-.37,36.9-18.12,48.4-26.16,16.95-60.13.25-63.53-32.51-4.61-44.38-18.34-84.89-43.97-121.48-61.46-87.76-174.07-123.45-266.88-84.16-29.57,12.52-54.58,30.91-71.72,58.71-21.12,34.27-14.36,61.85,20.63,80.99,22.18,12.13,44.64,23.92,67.64,34.38,107.55,48.86,99.27,161.14,43.66,223.74-79.12,89.07-178.41,109.59-289.18,78.16C101.3,677.08,14.16,568.77.38,436.29c-2.98-28.69,11.85-48.87,37.46-50.96,26.19-2.13,43.41,14.21,45.8,43.47,10.29,125.52,119.14,222.11,243.93,215.79,45.68-2.31,85.62-19.21,118.49-51.55,11.84-11.65,21.15-25.06,26.62-40.89,8.82-25.51-.39-49.31-24.4-61.67-27.07-13.94-54.22-27.77-81.63-41.03-84.96-41.11-87.26-132.1-54.57-187.74,36.65-62.39,92.2-98.09,161.34-114.81,21.57-5.21,43.46-6.92,65.56-6.78Z"/>
                            <path fill="#0d88" d="m432.95.02c26.42-.59,43.4,13.83,44.81,38.03,1.38,23.71-15.4,41.73-41.13,44.2-111.21,10.64-198.34,90.76-216.12,198.73-13.47,81.81,31.3,167.24,102.62,195.41,7.8,3.08,16.13,4.81,24.16,7.33,23.69,7.44,37.39,30.68,30.97,52.38-6.79,22.97-28.65,34.66-53.34,28.53-95.93-23.81-172.38-109.7-186.49-210.8C113.06,172.11,252.51,15.55,428.74.24c1.4-.12,2.81-.15,4.21-.22Z"/>
                            <path fill="#0d88" d="m715.62,557.39c.04,147.17-113.58,278.87-262.47,304.11-10.61,1.8-21.31,3.12-32,4.42-25.23,3.07-45.36-12.77-48.25-37.82-2.75-23.77,13.82-43.12,39.79-44.67,45.27-2.69,85.54-18.12,122.73-43.74,78.83-54.33,117.13-160.91,86.68-246.54-19.72-55.47-56.14-94.23-115.03-109.26-26.11-6.67-39.05-30.37-31.48-55.17,7.08-23.21,28.16-33.32,53.94-25.85,111.99,32.43,186.05,133.74,186.08,254.53Z"/>
                        </svg>
                    </div>
                </div>
            </div>

            <h2 class="text-5xl font-extrabold text-gray-800 leading-tight mt-4">
                به <span class="bg-gradient-to-r from-cyan-600 to-teal-600 text-transparent bg-clip-text animate-gradient">سامانه سرآمان</span> خوش آمدید
            </h2>

            <p class="text-gray-600 leading-relaxed text-lg max-w-md mx-auto">
                فرآیند ثبت‌نام ساده و سریع برای دسترسی به پلتفرم یکپارچه و هوشمند.
            </p>

            <div class="mt-8">
                <div class="text-center text-gray-500 text-sm mb-3">دسترسی سریع</div>
                <div class="flex justify-center space-x-3 space-x-reverse">
                    <div class="px-4 py-2 bg-cyan-50 text-cyan-700 rounded-xl text-sm font-medium shadow-sm hover:bg-cyan-100 transition-colors duration-300 cursor-pointer">
                        مستندات
                    </div>
                    <div class="px-4 py-2 bg-emerald-50 text-emerald-700 rounded-xl text-sm font-medium shadow-sm hover:bg-emerald-100 transition-colors duration-300 cursor-pointer">
                        راهنما
                    </div>
                    <div class="px-4 py-2 bg-violet-50 text-violet-700 rounded-xl text-sm font-medium shadow-sm hover:bg-violet-100 transition-colors duration-300 cursor-pointer">
                        پشتیبانی
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="w-full lg:w-1/2 lg:pl-12 relative z-20 flex justify-center items-center">
        <div class="w-full max-w-md mx-auto px-8 py-10 shadow-xl rounded-3xl border border-cyan-200 bg-white text-gray-800 transition-all duration-500 hover:shadow-2xl hover:shadow-cyan-200/30 hover:border-cyan-300 transform hover:-translate-y-1">

            <div class="text-center mb-8">
                <div class="flex justify-center mb-4">
                    <div class="relative group">
                        <div class="absolute -inset-3 bg-cyan-300 rounded-full opacity-50 transition-all duration-700 group-hover:opacity-70 group-hover:scale-110"></div>
                        <div class="relative bg-gradient-to-br from-cyan-500 to-blue-600 p-3.5 rounded-2xl shadow-lg transition-transform duration-700 group-hover:rotate-3 group-active:rotate-0">
                            <svg class="w-14 h-14 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                            </svg>
                        </div>
                    </div>
                </div>
                <h2 class="text-3xl font-bold text-gray-800 mb-2">
                    ایجاد حساب کارمند جدید
                </h2>
                <p class="text-gray-600 text-sm">فرایند سه مرحله‌ای - سریع و ایمن</p>
            </div>

            <div class="flex justify-center gap-2 mb-8 mt-2 select-none">
                @foreach([1,2,3] as $i)
                    <div class="flex items-center">
                        <div class="w-10 h-10 rounded-full flex items-center justify-center text-md font-bold shadow-lg border
                            {{ $step >= $i
                                ? 'bg-gradient-to-br from-cyan-500 to-teal-500 text-white border-cyan-400 scale-110'
                                : 'bg-gray-100 text-gray-500 border-gray-300' }}">
                            {{ $i }}
                        </div>
                        @if($i < 3)
                            <div class="w-11 h-0.5 mx-1 {{ $step > $i ? 'bg-gradient-to-r from-cyan-400 to-teal-300' : 'bg-gray-300' }}"></div>
                        @endif
                    </div>
                @endforeach
            </div>

            <form wire:submit.prevent="submitForm" enctype="multipart/form-data" class="space-y-6">

                {{-- Step 1: اطلاعات شخصی --}}
                @if($step == 1)
                    <div class="space-y-7 animate-fade-in">
                        <h2 class="text-lg font-bold text-gray-700 mb-2 flex items-center gap-2">
                            <svg class="w-5 h-5 text-cyan-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                            </svg>
                            اطلاعات شخصی
                        </h2>
                        <div class="relative">
                            <input type="text" wire:model.defer="name" placeholder="نام و نام خانوادگی"
                                   class="w-full px-4 py-3.5 rounded-xl border border-gray-300 bg-white text-gray-800 placeholder-gray-400 focus:border-cyan-500 focus:ring-2 focus:ring-cyan-200 outline-none transition shadow-sm text-sm"
                                   dir="rtl">
                            <label class="absolute right-5 -top-2.5 text-xs px-1 bg-white text-cyan-600 font-medium">نام و نام خانوادگی</label>
                            @error('name') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div class="relative">
                            <input type="email" wire:model.defer="email" placeholder="ایمیل شرکتی"
                                   class="w-full px-4 py-3.5 rounded-xl border border-gray-300 bg-white text-gray-800 placeholder-gray-400 focus:border-cyan-500 focus:ring-2 focus:ring-cyan-200 outline-none transition shadow-sm text-sm"
                                   dir="rtl">
                            <label class="absolute right-5 -top-2.5 text-xs px-1 bg-white text-cyan-600 font-medium">ایمیل شرکتی</label>
                            @error('email') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div class="relative">
                            <input type="tel" wire:model.defer="mobile" placeholder="شماره موبایل"
                                   class="w-full px-4 py-3.5 rounded-xl border border-gray-300 bg-white text-gray-800 placeholder-gray-400 focus:border-cyan-500 focus:ring-2 focus:ring-cyan-200 outline-none transition shadow-sm text-sm"
                                   dir="rtl">
                            <label class="absolute right-5 -top-2.5 text-xs px-1 bg-white text-cyan-600 font-medium">شماره موبایل</label>
                            @error('mobile') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div class="relative">
                            <input type="text" wire:model.defer="ncode" placeholder="کد ملی"
                                   class="w-full px-4 py-3.5 rounded-xl border border-gray-300 bg-white text-gray-800 placeholder-gray-400 focus:border-cyan-500 focus:ring-2 focus:ring-cyan-200 outline-none transition shadow-sm text-sm"
                                   dir="rtl">
                            <label class="absolute right-5 -top-2.5 text-xs px-1 bg-white text-cyan-600 font-medium">کد ملی</label>
                            @error('ncode') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div class="flex justify-end mt-8">
                            <button type="button" wire:click="nextStep"
                                    class="px-6 py-3 bg-gradient-to-r from-cyan-600 to-blue-600 hover:from-cyan-500 hover:to-blue-500 text-white text-sm font-bold rounded-xl shadow-md transition-all duration-300 transform hover:-translate-y-0.5 focus:outline-none">
                                ادامه →
                            </button>
                        </div>
                    </div>
                @endif

                {{-- Step 2: اطلاعات سازمانی --}}
                @if($step == 2)
                    <div class="space-y-7 animate-fade-in">
                        <h2 class="text-lg font-bold text-gray-700 mb-2 flex items-center gap-2">
                            <svg class="w-5 h-5 text-teal-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h6m-6 4h6m-6 4h6"/>
                            </svg>
                            اطلاعات سازمانی
                        </h2>
                        <div class="relative">
                            <select wire:model.defer="degree"
                                    class="w-full px-4 py-3.5 rounded-xl border border-gray-300 bg-white text-gray-800 focus:border-teal-500 focus:ring-2 focus:ring-teal-200 outline-none transition shadow-sm text-sm">
                                <option value="" disabled selected>انتخاب کنید...</option>
                                @foreach($degrees as $deg)
                                    <option value="{{ $deg }}">{{ $deg }}</option>
                                @endforeach
                            </select>
                            <label class="absolute right-5 -top-2.5 text-xs px-1 bg-white text-teal-600 font-medium">مدرک تحصیلی</label>
                            @error('degree') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div class="relative">
                            <select wire:model="company_id"
                                    class="w-full px-4 py-3.5 rounded-xl border border-gray-300 bg-white text-gray-800 focus:border-teal-500 focus:ring-2 focus:ring-teal-200 outline-none transition shadow-sm text-sm">
                                <option value="" disabled selected>انتخاب کنید...</option>
                                @foreach($companies as $company)
                                    <option value="{{ $company->id }}">{{ $company->name }}</option>
                                @endforeach
                            </select>
                            <label class="absolute right-5 -top-2.5 text-xs px-1 bg-white text-teal-600 font-medium">شرکت</label>
                            @error('company_id') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div class="relative">
                            <select wire:model="department_id" @if(!$company_id) disabled @endif
                            class="w-full px-4 py-3.5 rounded-xl border border-gray-300 bg-white text-gray-800 focus:border-teal-500 focus:ring-2 focus:ring-teal-200 outline-none transition shadow-sm text-sm disabled:bg-gray-50 disabled:text-gray-400">
                                <option value="" disabled selected>{{ $company_id ? 'انتخاب کنید...' : 'ابتدا شرکت را انتخاب کنید' }}</option>
                                @foreach($departments as $dep)
                                    <option value="{{ $dep->id }}">{{ $dep->name }}</option>
                                @endforeach
                            </select>
                            <label class="absolute right-5 -top-2.5 text-xs px-1 bg-white text-teal-600 font-medium">دپارتمان</label>
                            @error('department_id') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                            <div wire:loading.flex wire:target="company_id" class="absolute left-4 top-3 items-center">
                                <svg class="animate-spin w-5 h-5 text-cyan-500" fill="none" viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                </svg>
                            </div>
                        </div>
                        <div class="grid grid-cols-2 gap-4 mt-2">
                            <div>
                                <label class="block text-xs text-cyan-600 mb-1 font-medium">تصویر پروفایل</label>
                                <input type="file" wire:model="image" accept="image/*"
                                       class="w-full text-sm text-gray-700 file:mr-4 file:py-2 file:px-4 file:rounded-xl file:border-0 file:text-sm file:bg-cyan-100 file:text-cyan-700 hover:file:bg-cyan-200 bg-gray-50 border border-gray-300 rounded-xl file:transition">
                                @error('image') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                            </div>
                            <div>
                                <label class="block text-xs text-teal-600 mb-1 font-medium">امضا</label>
                                <input type="file" wire:model="sign" accept="image/*"
                                       class="w-full text-sm text-gray-700 file:mr-4 file:py-2 file:px-4 file:rounded-xl file:border-0 file:text-sm file:bg-teal-100 file:text-teal-700 hover:file:bg-teal-200 bg-gray-50 border border-gray-300 rounded-xl file:transition">
                                @error('sign') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="flex justify-between mt-8">
                            <button type="button" wire:click="previousStep" class="px-6 py-3 bg-gray-200 hover:bg-gray-300 text-gray-700 text-sm font-bold rounded-xl transition">← قبلی</button>
                            <button type="button" wire:click="nextStep" class="px-6 py-3 bg-gradient-to-r from-teal-500 to-cyan-500 hover:from-teal-600 hover:to-cyan-600 text-white text-sm font-bold rounded-xl shadow-md transition-all duration-300 transform hover:-translate-y-0.5 focus:outline-none">ادامه →</button>
                        </div>
                    </div>
                @endif

                {{-- Step 3: امنیت --}}
                @if($step == 3)
                    <div class="space-y-7 animate-fade-in">
                        <h2 class="text-lg font-bold text-gray-700 mb-2 flex items-center gap-2">
                            <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                      d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                            </svg>
                            تنظیمات امنیتی
                        </h2>
                        <div class="relative">
                            <input type="password" wire:model.defer="password" placeholder="رمز عبور"
                                   class="w-full px-4 py-3.5 rounded-xl border border-gray-300 bg-white text-gray-800 placeholder-gray-400 focus:border-green-500 focus:ring-2 focus:ring-green-200 outline-none transition shadow-sm text-sm"
                                   dir="rtl">
                            <label class="absolute right-5 -top-2.5 text-xs px-1 bg-white text-green-600 font-medium">رمز عبور</label>
                            @error('password') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div class="relative">
                            <input type="password" wire:model.defer="password_confirmation" placeholder="تکرار رمز عبور"
                                   class="w-full px-4 py-3.5 rounded-xl border border-gray-300 bg-white text-gray-800 placeholder-gray-400 focus:border-green-500 focus:ring-2 focus:ring-green-200 outline-none transition shadow-sm text-sm"
                                   dir="rtl">
                            <label class="absolute right-5 -top-2.5 text-xs px-1 bg-white text-green-600 font-medium">تکرار رمز عبور</label>
                            @error('password_confirmation') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div class="flex gap-8 mt-3">
                            <label class="inline-flex items-center text-sm cursor-pointer">
                                <input type="radio" wire:model.defer="gender" value="male" class="rounded text-cyan-600 focus:ring-cyan-500 border-gray-300 ml-2">
                                <span class="text-gray-700">مرد</span>
                            </label>
                            <label class="inline-flex items-center text-sm cursor-pointer">
                                <input type="radio" wire:model.defer="gender" value="female" class="rounded text-pink-500 focus:ring-pink-400 border-gray-300 ml-2">
                                <span class="text-gray-700">زن</span>
                            </label>
                        </div>
                        @error('gender') <span class="text-rose-600 text-xs mt-1 block">{{ $message }}</span> @enderror
                        <div class="flex justify-between pt-4">
                            <button type="button" wire:click="previousStep"
                                    class="px-6 py-3 bg-gray-200 hover:bg-gray-300 text-gray-700 text-sm font-bold rounded-xl transition">
                                ← قبلی
                            </button>
                            <button type="submit"
                                    wire:loading.attr="disabled"
                                    class="px-6 py-3 bg-gradient-to-r from-green-600 to-teal-600 hover:from-green-500 hover:to-teal-500 text-white text-sm font-bold rounded-xl shadow-md transition-all duration-300 transform hover:-translate-y-0.5 min-w-32"
                                    wire:loading.class="opacity-80 cursor-not-allowed">
                                <span wire:loading.remove>ثبت نهایی</span>
                                <span wire:loading>
                                    <svg class="animate-spin w-4 h-4 mx-auto" fill="none" viewBox="0 0 24 24">
                                        <circle class="opacity-20" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    </svg>
                                </span>
                            </button>
                        </div>
                    </div>
                @endif
            </form>

            {{-- پیام موفقیت/خطا - استایل روشن --}}
            @if(session()->has('success'))
                <div class="mt-6 p-4 bg-green-100 border-r-4 border-green-500 text-green-700 rounded-xl shadow font-medium text-sm animate-fade-in">
                    {{ session('success') }}
                </div>
            @endif
            @if(session()->has('error'))
                <div class="mt-6 p-4 bg-red-100 border-r-4 border-red-500 text-red-700 rounded-xl shadow font-medium text-sm animate-fade-in">
                    {{ session('error') }}
                </div>
            @endif

            <div class="mt-10 pt-6 border-t border-gray-200 text-center">
                <p class="text-gray-600 text-sm mb-3">قبلاً حساب کاربری ساخته‌اید؟</p>
                <a href="{{ route('login') }}" wire:navigate
                   class="inline-flex items-center px-5 py-2.5 border-2 border-cyan-500 text-cyan-600 hover:bg-cyan-50 rounded-xl text-sm font-semibold transition-colors group">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1.5 group-hover:scale-110 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1" />
                    </svg>
                    ورود به سیستم
                </a>
            </div>
        </div>
    </div>
    <style>
        @keyframes fade-in {
            from { opacity: 0; transform: translateY(12px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes pulse-slow {
            0%, 100% { opacity: 0.15; transform: scale(1); }
            50% { opacity: 0.3; transform: scale(1.03); }
        }

        @keyframes ping-slow {
            0% { transform: scale(0.8); opacity: 0.7; }
            75%, 100% { transform: scale(1.4); opacity: 0; }
        }

        @keyframes gradient {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        .animate-fade-in {
            animation: fade-in 0.6s ease-out;
        }

        .animate-pulse-slow {
            animation: pulse-slow 10s infinite;
        }

        .animate-ping-slow {
            animation: ping-slow 4s infinite;
        }

        .animation-delay-2000 {
            animation-delay: 2s;
        }

        .animation-delay-4000 {
            animation-delay: 4s;
        }

        .animate-gradient {
            background-size: 200% 200%;
            animation: gradient 5s ease infinite;
        }
    </style>
</div>
