@props(['status'])

@php
    $statusClasses = [
        'done' => ['bg-green-100', 'text-green-700', 'انجام شده'],
        'in_progress' => ['bg-yellow-100', 'text-yellow-700', 'درحال انجام'],
        'on_hold' => ['bg-red-100', 'text-red-700', 'متوقف'],
        'new' => ['bg-blue-100', 'text-blue-700', 'جدید'],
        'default' => ['bg-gray-100', 'text-gray-700', 'نامشخص'],
    ];
    $class = $statusClasses[$status] ?? $statusClasses['default'];

    // انتخاب آیکون بر اساس وضعیت
    $icon = match($status) {
        'done' => 'check-circle',
        'in_progress' => 'loader',
        'on_hold' => 'pause-circle',
        default => 'clock',
    };
@endphp
<div class="flex-shrink-0">
    <span class="px-3 py-1 text-xs font-semibold rounded-full {{ $class[0] }} {{ $class[1] }} flex items-center">
        <i data-feather="{{ $icon }}" class="w-4 h-4 ml-1"></i>
        {{ $class[2] }}
    </span>
</div>
