<div class="container-fluid py-5">
    <div class="row justify-content-center">
        <div class="col-12 col-xl-9">

            {{-- Flash Messages --}}
            @if(session()->has('success') || session()->has('error'))
                <div
                    class="alert alert-{{ session()->has('success') ? 'success' : 'danger' }} alert-dismissible fade show d-flex align-items-center mb-4 border-0 shadow-sm rounded-4 notification-alert"
                    role="alert"
                >
                    <i class="ti ti-{{ session()->has('success') ? 'check-circle' : 'alert-octagon' }} fs-4 me-3"></i>
                    <div class="flex-grow-1 fw-medium">
                        {{ session('success') ?? session('error') }}
                    </div>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- Header --}}
            <div class="post-header-card rounded-4 shadow-lg overflow-hidden mb-4 position-relative text-white">
                <div class="p-4 p-md-5 position-relative">

                    @if($post->category)
                        <span class="badge rounded-pill bg-white bg-opacity-20 px-3 py-2 mb-3 d-inline-flex align-items-center gap-1 small">
                            <i class="ti ti-tag"></i>
                            {{ $post->category->name }}
                        </span>
                    @endif

                    <h1 class="fw-bold display-6 mb-3">{{ $post->title }}</h1>

                    <div class="d-flex flex-wrap align-items-center gap-3 small opacity-90">
                        <div>
                            <i class="ti ti-user-circle me-1"></i>
                            {{ $post->author->name ?? 'بدون نویسنده' }}
                        </div>

                        <div>
                            <i class="ti ti-calendar-event me-1"></i>
                            {{ $post->created_at->translatedFormat('j F Y') }}
                        </div>

                        <div class="text-white-50">
                            • {{ $post->created_at->diffForHumans() }}
                        </div>
                    </div>

                    <div class="header-bg-icon">
                        <i class="ti ti-news"></i>
                    </div>
                </div>
            </div>

            {{-- محتوای پست --}}
            <div class="bg-white rounded-4 shadow-sm p-4 p-md-5 content-wrapper">

                {{-- تصویر شاخص --}}
                @if($post->image)
                    <div class="hero-image-wrapper rounded-4 overflow-hidden mb-4">
                        <img src="{{ asset('storage/' . $post->image) }}"
                             class="img-fluid hero-image"
                             alt="{{ $post->title }}">
                    </div>
                @endif

                {{-- نوار متریک‌ها (لایک / کامنت / پیوست / برگشت/ویرایش) --}}
                <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 mb-4">
                    <div class="d-flex flex-wrap align-items-center gap-2">

                        {{-- Like --}}
                        <button
                            type="button"
                            wire:click="toggleLike"
                            wire:loading.attr="disabled"
                            class="btn btn-sm rounded-pill like-pill d-inline-flex align-items-center gap-1"
                        >
                            <i class="ti ti-heart{{ $liked ? '' : '-plus' }} fs-5 {{ $liked ? 'text-danger' : '' }}"></i>
                            <span class="small">
                                {{ $likesCount }} لایک
                            </span>
                        </button>

                        {{-- Comments count --}}
                        <div class="badge rounded-pill bg-gray-100 text-secondary d-inline-flex align-items-center gap-1 small">
                            <i class="ti ti-message-circle fs-6"></i>
                            {{ $commentsCount }} دیدگاه
                        </div>

                        {{-- Attachment --}}
                        @if($post->media_file)
                            <a href="{{ asset('storage/' . $post->media_file) }}"
                               class="badge rounded-pill bg-primary-subtle text-primary d-inline-flex align-items-center gap-1 small text-decoration-none"
                               target="_blank">
                                <i class="ti ti-paperclip fs-6"></i>
                                فایل پیوست
                            </a>
                        @endif
                    </div>

                    <div class="d-flex flex-wrap align-items-center gap-2">
                        <a href="{{ route('user.posts') }}"
                           class="btn btn-sm btn-light rounded-pill px-3 d-inline-flex align-items-center gap-1 hover-scale shadow-sm">
                            <i class="ti ti-arrow-right fs-5"></i>
                            بازگشت
                        </a>

                        @if(auth()->check() && auth()->user()->isAdmin())
                            <a href="{{ route('admin.posts.edit', $post->id) }}"
                               class="btn btn-sm btn-primary rounded-pill px-3 d-inline-flex align-items-center gap-1 hover-scale shadow-md">
                                <i class="ti ti-edit fs-5"></i>
                                ویرایش
                            </a>
                        @endif
                    </div>
                </div>

                {{-- متن پست --}}
                <div class="post-content fs-6 lh-lg text-gray-700 mb-4">
                    {!! nl2br(e($post->content)) !!}
                </div>

                {{-- جداکننده --}}
                <hr class="my-4">

                {{-- سکشن دیدگاه‌ها --}}
                <div class="comments-section">

                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <div class="d-flex align-items-center gap-2">
                            <div class="comments-icon-pill">
                                <i class="ti ti-message-circle"></i>
                            </div>
                            <div>
                                <div class="fw-semibold">دیدگاه‌ها</div>
                                <div class="small text-muted">
                                    {{ $commentsCount }} دیدگاه ثبت شده
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- فرم ارسال دیدگاه --}}
                    <div class="comment-form-card mb-4 p-3 p-md-4 rounded-3 border bg-gray-50">
                        @if(auth()->check())
                            <form wire:submit.prevent="addComment" class="d-flex flex-column gap-3">

                                <div class="d-flex align-items-start gap-2 mb-1">
                                    <div class="comment-avatar">
                                        <span>
                                            {{ mb_substr(auth()->user()->name ?? 'شما', 0, 1) }}
                                        </span>
                                    </div>
                                    <div class="flex-grow-1">
                                        <label for="commentBody" class="form-label small text-muted mb-1">
                                            نظر خود را درباره این پست بنویسید
                                        </label>
                                        <textarea
                                            id="commentBody"
                                            rows="3"
                                            class="form-control rounded-3 @error('commentBody') is-invalid @enderror"
                                            placeholder="متن دیدگاه شما..."
                                            wire:model.defer="commentBody"
                                        ></textarea>
                                        @error('commentBody')
                                        <div class="invalid-feedback d-block small mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="d-flex justify-content-end">
                                    <button
                                        type="submit"
                                        class="btn btn-primary rounded-pill px-4 d-inline-flex align-items-center gap-2"
                                        wire:loading.attr="disabled"
                                        wire:target="addComment"
                                    >
                                        <span wire:loading.remove wire:target="addComment">
                                            <i class="ti ti-send fs-5"></i>
                                            ارسال دیدگاه
                                        </span>
                                        <span wire:loading wire:target="addComment">
                                            <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                            در حال ارسال...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        @else
                            <div class="d-flex align-items-center gap-2 small text-muted">
                                <i class="ti ti-lock fs-5"></i>
                                برای ارسال دیدگاه، ابتدا وارد حساب کاربری خود شوید.
                            </div>
                        @endif
                    </div>

                    {{-- لیست دیدگاه‌ها --}}
                    @if($comments->count() > 0)
                        <div class="comments-list d-flex flex-column gap-3">
                            @foreach($comments as $comment)
                                <div class="comment-item p-3 rounded-3 border bg-white shadow-sm-sm">
                                    <div class="d-flex align-items-start gap-2">
                                        <div class="comment-avatar small-avatar">
                                            <span>
                                                {{ mb_substr($comment->user->name ?? '؟', 0, 1) }}
                                            </span>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <div class="fw-semibold small">
                                                    {{ $comment->user->name ?? 'کاربر' }}
                                                </div>
                                                <div class="small text-muted">
                                                    {{ $comment->created_at->diffForHumans() }}
                                                </div>
                                            </div>
                                            <div class="text-gray-700 small lh-lg">
                                                {{ $comment->body }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        {{-- صفحه‌بندی کامنت‌ها --}}
                        @if($comments->hasPages())
                            <div class="mt-3">
                                {{ $comments->links('pagination.custom-modern') }}
                            </div>
                        @endif
                    @else
                        <div class="text-center text-muted small py-3">
                            هنوز دیدگاهی ثبت نشده است. اولین نفر باشید 🤍
                        </div>
                    @endif

                </div>

            </div>
        </div>
    </div>

    {{-- Styles --}}
    <style>
        :root {
            --primary: #0f766e;
            --primary-dark: #115e59;
            --gray-50: #f9fafb;
            --gray-100: #f3f4f6;
            --gray-700: #374151;
        }

        .notification-alert {
            background: linear-gradient(135deg, #10b981, #059669) !important;
            color: #fff !important;
        }
        .btn-close-white { filter: brightness(0) invert(1); }

        .post-header-card {
            background: radial-gradient(circle at top left, rgba(255,255,255,0.18), transparent 40%),
            linear-gradient(135deg, var(--primary-dark), var(--primary));
        }

        .header-bg-icon {
            position: absolute;
            left: -10px;
            top: -10px;
            font-size: 9rem;
            opacity: 0.07;
            transform: rotate(-15deg);
        }

        .content-wrapper {
            font-size: 1rem;
        }

        .hero-image-wrapper .hero-image {
            width: 100%;
            height: 350px;
            object-fit: cover;
            transition: all 0.25s ease-in-out;
        }
        .hero-image-wrapper:hover .hero-image {
            transform: scale(1.03);
        }

        .post-content {
            color: var(--gray-700);
        }
        .post-content p {
            margin-bottom: 1rem;
        }

        .hover-scale {
            transition: transform .15s ease, box-shadow .15s ease;
        }
        .hover-scale:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 12px rgba(0,0,0,0.12);
        }

        .bg-gray-50 { background-color: var(--gray-50); }
        .bg-gray-100 { background-color: var(--gray-100); }

        .like-pill {
            background-color: #fee2e2;
            color: #b91c1c;
            border: none;
        }
        .like-pill:hover {
            background-color: #fecaca;
        }

        .comments-icon-pill {
            width: 34px;
            height: 34px;
            border-radius: 999px;
            background: rgba(59, 130, 246, 0.12);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: #1d4ed8;
        }

        .comment-avatar {
            width: 38px;
            height: 38px;
            border-radius: 999px;
            background: #e5e7eb;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            color: #374151;
        }
        .comment-avatar.small-avatar {
            width: 32px;
            height: 32px;
            font-size: 0.8rem;
        }

        .shadow-sm-sm {
            box-shadow: 0 3px 10px rgba(15, 23, 42, 0.06);
        }
    </style>
</div>
