<div>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold">پست‌های من</h4>
        <button wire:click="create" class="btn btn-primary rounded-pill px-4">پست جدید</button>
    </div>

    <input type="text" class="form-control mb-3" placeholder="جستجو..." wire:model.debounce.500ms="search">

    @if (session()->has('success'))
        <div class="alert alert-success my-2">{{ session('success') }}</div>
    @endif
    @if (session()->has('error'))
        <div class="alert alert-danger my-2">{{ session('error') }}</div>
    @endif

    @if($this->posts->count())
        <div class="row g-3">
            @foreach($this->posts as $post)
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <h5 class="card-title text-truncate">{{ $post->title }}</h5>
                            <p class="card-text text-muted small mb-2">{{ \Illuminate\Support\Str::limit($post->content, 80) }}</p>
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-secondary">نویسنده: {{ $post->user->name }}</small>
                                <small class="text-secondary">{{ $post->created_at->diffForHumans() }}</small>
                            </div>
                            <div class="mt-2 d-flex gap-2">
                                <button wire:click="edit({{ $post->id }})" class="btn btn-sm btn-outline-info rounded-pill">ویرایش</button>
                                <button wire:click="delete({{ $post->id }})" class="btn btn-sm btn-outline-danger rounded-pill" onclick="return confirm('حذف شود؟')">حذف</button>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mt-4">
            {{ $this->posts->links() }}
        </div>
    @else
        <div class="alert alert-info mt-4">هیچ پستی یافت نشد.</div>
    @endif

    {{-- فرم ساخت/ویرایش --}}
    @if($showForm)
        <div class="modal fade show d-block" tabindex="-1" style="background:rgba(0,0,0,0.2)">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content border-0 rounded-4">
                    <div class="modal-header border-0">
                        <h5 class="modal-title">{{ $mode === 'edit' ? 'ویرایش پست' : 'پست جدید' }}</h5>
                        <button type="button" class="btn-close" wire:click="closeForm"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="save">
                            <div class="mb-3">
                                <label class="form-label">عنوان</label>
                                <input type="text" wire:model.defer="title" class="form-control rounded-3" required>
                                @error('title') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                            <div class="mb-3">
                                <label class="form-label">متن پست</label>
                                <textarea wire:model.defer="content" rows="5" class="form-control rounded-3" required></textarea>
                                @error('content') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                            <div class="d-flex gap-2">
                                <button class="btn btn-success rounded-pill px-4">{{ $mode === 'edit' ? 'ذخیره تغییرات' : 'ثبت پست' }}</button>
                                <button type="button" class="btn btn-secondary rounded-pill px-4" wire:click="closeForm">انصراف</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif
</div>
