@if ($paginator->hasPages())
    <nav class="pagination-modern-nav">
        <ul class="pagination mb-0">

            {{-- قبلی --}}
            @if ($paginator->onFirstPage())
                <li class="page-item disabled">
                    <span class="page-link page-arrow">&lsaquo;</span>
                </li>
            @else
                <li class="page-item">
                    <button
                        type="button"
                        class="page-link page-arrow"
                        wire:click="previousPage('{{ $paginator->getPageName() }}')"
                    >
                        &lsaquo;
                    </button>
                </li>
            @endif

            {{-- شماره صفحات --}}
            @foreach ($elements as $element)
                @if (is_string($element))
                    <li class="page-item disabled">
                        <span class="page-link">{{ $element }}</span>
                    </li>
                @endif

                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        @if ($page == $paginator->currentPage())
                            <li class="page-item active">
                                <span class="page-link">{{ $page }}</span>
                            </li>
                        @else
                            <li class="page-item">
                                <button
                                    type="button"
                                    class="page-link"
                                    wire:click="gotoPage({{ $page }}, '{{ $paginator->getPageName() }}')"
                                >
                                    {{ $page }}
                                </button>
                            </li>
                        @endif
                    @endforeach
                @endif
            @endforeach

            {{-- بعدی --}}
            @if ($paginator->hasMorePages())
                <li class="page-item">
                    <button
                        type="button"
                        class="page-link page-arrow"
                        wire:click="nextPage('{{ $paginator->getPageName() }}')"
                    >
                        &rsaquo;
                    </button>
                </li>
            @else
                <li class="page-item disabled">
                    <span class="page-link page-arrow">&rsaquo;</span>
                </li>
            @endif

        </ul>
    </nav>
@endif
