<!-- Sidebar -->
<aside class="left-sidebar" id="sidebar">
    <div class="sidebar-header">
        <a href="/" class="logo-img">
            <img src="{{ asset('logo.png') }}" alt="لوگو Mersa" width="140" class="pulse-animation">
        </a>
        <button id="sidebarCollapse" class="hamburger-btn d-lg-none" aria-label="باز و بسته کردن منو">
            <i class="fa fa-bars"></i>
        </button>
    </div>
    <nav class="sidebar-nav">
        <ul id="sidebarnav">
            <li class="sidebar-item">
                <a class="sidebar-link" href="{{ route('dashboard') }}">
                    <i class="ti ti-home"></i>
                    داشبورد
                </a>
            </li>
            <li class="sidebar-item">
                <a class="sidebar-link" href="{{ route('admin.projects') }}">
                    <i class="ti ti-briefcase"></i>
                    پروژه‌ها
                </a>
            </li>
            <li class="sidebar-item">
                <a class="sidebar-link" href="{{ route('user.letter') }}">
                    <i class="ti ti-mail"></i>
                    نامه‌ها
                </a>
            </li>
            <li class="sidebar-item">
                <a class="sidebar-link" href="{{ route('purchase.my-requests') }}">
                    <i class="ti ti-shopping-cart"></i>
                    درخواست‌های خرید
                </a>
            </li>
            <li class="sidebar-item">
                <a class="sidebar-link" href="{{ route('profile.edit') }}">
                    <i class="ti ti-user"></i>
                    پروفایل
                </a>
            </li>
        </ul>
    </nav>
    <div class="sidebar-footer">
        <form action="/logout" method="POST" class="mt-3">
            @csrf
            <button type="submit" class="w-100 btn btn-danger">خروج</button>
        </form>
    </div>
</aside>

<!-- CSS for Sidebar -->
<style>
    /* Basic Sidebar styles */
    .left-sidebar {
        background: #2d3e50; /* Darker background for modern look */
        color: #fff;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.15);
        position: fixed;
        top: 0;
        left: 0;
        width: 270px;
        height: 100%;
        z-index: 1050;
        display: flex;
        flex-direction: column;
        transition: transform 0.3s ease-in-out;
    }

    .sidebar-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 20px;
        background-color: #34495e;
        border-bottom: 1px solid #445360;
    }

    .sidebar-nav {
        flex-grow: 1;
        padding-top: 20px;
    }

    .sidebar-item {
        list-style: none;
        padding: 12px 20px;
        transition: background-color 0.3s ease;
    }

    .sidebar-item a {
        display: flex;
        align-items: center;
        color: #c2c6d0; /* Softer color for text */
        text-decoration: none;
        font-size: 16px;
        padding: 12px;
        border-radius: 8px;
        transition: background-color 0.3s ease, color 0.3s ease;
    }

    .sidebar-item a:hover {
        background-color: #1abc9c; /* Accent color for hover effect */
        color: #fff;
    }

    .sidebar-item i {
        margin-right: 12px;
        font-size: 1.25rem;
    }

    .sidebar-footer {
        padding: 20px;
        background-color: #34495e;
        border-top: 1px solid #445360;
    }

    /* Sidebar Toggle for Mobile */
    .hamburger-btn {
        background: none;
        border: none;
        font-size: 1.5rem;
        color: #fff;
        cursor: pointer;
    }

    /* Mobile View */
    @media (max-width: 992px) {
        .left-sidebar {
            transform: translateX(-100%); /* Sidebar hidden */
        }

        .left-sidebar.active {
            transform: translateX(0); /* Sidebar visible */
        }

        .hamburger-btn {
            display: inline-block;
        }

        /* Adjust content margin when sidebar is active */
        .body-wrapper {
            margin-left: 0;
        }
    }

    /* Styling for Sidebar items when active */
    .sidebar-item.active {
        background-color: #1abc9c;
        color: #fff;
    }
</style>
