<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="utf-8">
    <style>
        /* استفاده از فونت‌های استاندارد اداری */
        @page { margin: 0.8cm; }
        body {
            /*font-family: 'B Nazanin', 'Tahoma', sans-serif;*/
            direction: rtl;
            color: #000;
            font-size: 12pt;
            margin: 0;
            padding: 0;
            background: #fff;
        }

        .document-wrapper { border: 1px solid #000; padding: 20px; min-height: 26cm; position: relative; }

        /* هدر اداری */
        .header-box { width: 100%; border-bottom: 2px solid #000; margin-bottom: 20px; padding-bottom: 10px; }
        .logo-space { text-align: right; }
        .doc-title { text-align: center; font-size: 18pt; font-weight: bold; }
        .doc-meta { text-align: left; font-size: 10pt; line-height: 1.6; }

        /* جداول اطلاعاتی سنگین و اداری */
        .info-grid { width: 100%; border-collapse: collapse; margin-bottom: 15px; }
        .info-grid td { border: 1px solid #000; padding: 8px 10px; font-size: 11pt; }
        .label-bg { background: #eee; font-weight: bold; width: 20%; }
        .value-cell { width: 30%; }

        /* بخش مالی حساس */
        .financial-summary {
            border: 2px solid #000;
            margin: 20px 0;
            padding: 10px;
            background: #fdfdfd;
            text-align: center;
        }
        .amount-words { font-weight: bold; text-decoration: underline; font-size: 13pt; }

        /* متن درخواست */
        .body-text {
            border: 1px solid #000;
            padding: 15px;
            min-height: 120px;
            text-align: justify;
            line-height: 2;
            margin-bottom: 20px;
        }

        /* 🖋️ بخش امضاهای اداری (دقیقاً در یک ردیف) */
        .signature-table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
            table-layout: fixed; /* اجبار به تقسیم مساوی فضا */
        }
        .signature-table td {
            border: 1px solid #000;
            text-align: center;
            padding: 10px;
            vertical-align: top;
            height: 150px;
        }
        .role-title { font-weight: bold; font-size: 10pt; margin-bottom: 10px; display: block; border-bottom: 1px solid #ddd; }
        .signer-name { font-weight: bold; font-size: 11pt; margin-bottom: 5px; }
        .sig-img { max-width: 120px; max-height: 70px; margin-top: 5px; }
        .sig-date { font-size: 9pt; display: block; margin-top: 5px; }

        .footer-note { position: absolute; bottom: 10px; width: 100%; text-align: center; font-size: 9pt; }
    </style>
</head>
<body>

<div class="document-wrapper">
    <table class="header-box">
        <tr>
            <td width="25%" class="logo-space">
                @if($companyLogo)
                    <img src="{{ $companyLogo }}" style="max-height: 65px;">
                @endif
            </td>
            <td width="50%" class="doc-title">فرم درخواست پرداخت وجه</td>
            <td width="25%" class="doc-meta">
                شماره: {{ $request->id }}<br>
                تاریخ: {{ $request->created_at_shamsi }}<br>
                پیوست: دارد
            </td>
        </tr>
    </table>

    <table class="info-grid">
        <tr>
            <td class="label-bg">ذینفع تسویه:</td>
            <td class="value-cell">{{ $request->payee->name ?? $request->recipient_name }}</td>
            <td class="label-bg">شناسه ملی:</td>
            <td class="value-cell">{{ $request->payee->national_id ?? '---' }}</td>
        </tr>
        <tr>
            <td class="label-bg">بانک مقصد:</td>
            <td class="value-cell">{{ $banks[$request->payee->bank_name ?? ''] ?? '---' }}</td>
            <td class="label-bg">مرکز هزینه:</td>
            <td class="value-cell">{{ $request->project->name ?? '---' }}</td>
        </tr>
        <tr>
            <td class="label-bg">شماره شبا:</td>
            <td colspan="3" style="text-align: left; font-family: 'Tahoma'; letter-spacing: 1px;">
                IR{{ $request->payee->sheba ?? '------------------------' }}
            </td>
        </tr>
    </table>

    <div class="financial-summary">
        مبلغ قابل پرداخت: <span class="amount-words">{{ number_format($request->amount) }} ریال</span>
        <br>
        <small style="font-size: 10pt;">( معادل ناخالص {{ number_format($request->amount_gross) }} ریال پس از کسر کسورات قانونی )</small>
    </div>

    <div style="font-weight: bold; margin-bottom: 5px;">بابت / شرح ضرورت:</div>
    <div class="body-text">
        {{ $request->purpose }}
    </div>

    <table class="signature-table">
        <tr>
            <td>
                <span class="role-title">تنظیم و تایید واحد متقاضی</span>
                <div class="signer-name">{{ $request->user->name }}</div>
                @if($request->user->sign)
                    <img src="data:image/png;base64,{{ base64_encode(file_get_contents(storage_path('app/public/'.$request->user->sign))) }}" class="sig-img">
                @endif
                <span class="sig-date">{{ $request->created_at_shamsi }}</span>
            </td>

            @foreach($approvals as $approval)
                <td>
                    <span class="role-title">{{ $approval['role'] }}</span>
                    <div class="signer-name">{{ $approval['name'] }}</div>
                    @if($approval['is_approved'] === 1 && $approval['signature'])
                        <img src="{{ $approval['signature'] }}" class="sig-img">
                    @elseif($approval['is_approved'] === 0)
                        <div style="color:red; font-weight:bold; padding-top:20px;">مردود شد</div>
                    @endif
                    <span class="sig-date">{{ $approval['date'] ?? '---' }}</span>
                </td>
            @endforeach

            <td style="border: 2px dashed #999;">
                <span class="role-title">محل مهر و تایید نهایی مدیریت</span>
            </td>
        </tr>
    </table>

    <div class="footer-note">
        صادر شده توسط سامانه یکپارچه مالی | اصالت این سند با کد {{ md5($request->id) }} قابل پیگیری است.
    </div>
</div>

</body>
</html>
