<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <title>Mersa - داشبورد شخصی</title>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="description" content="داشبورد مدیریتی Mersa برای مدیریت پروژه‌ها، نامه‌ها و درخواست‌های خرید">
    <link rel="icon" href="{{ asset('favicon.ico') }}" type="image/x-icon">
{{--    <link rel="preconnect" href="https://cdn.fontcdn.ir">--}}
{{--    <link rel="preconnect" href="https://cdn.jsdelivr.net">--}}
{{--    <link href="https://cdn.fontcdn.ir/Font/Persian/Vazir/Vazir.css" rel="stylesheet">--}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="{{url('panel/dist/libs/owl.carousel/dist/assets/owl.carousel.min.css')}}">
    <link rel="stylesheet" href="{{url('panel/dist/css/style.min.css')}}">
    <style>
        :root {
            --primary-color: #5d3ebc;
            --primary-dark: #4b2997;
            --primary-light: #a88cc7;
            --text-dark: #1e3a8a;
            --text-gray: #6b7280;
            --bg-light: #f9fafb;
            --card-radius: 16px;
            --transition-speed: 0.3s;
        }
        body {
            background: linear-gradient(135deg, var(--bg-light) 0%, #eaeaea 100%);
            font-family: 'Vazir', Tahoma, sans-serif;
            line-height: 1.6;
            color: #333;
            min-height: 100vh;
            margin: 0;
        }
        .page-wrapper {
            display: flex;
            min-height: 100vh;
        }
        .left-sidebar {
            background: #f8f9fa;
            box-shadow: 0 0 12px rgba(0,0,0,0.05);
            border-left: 1px solid rgba(0,0,0,0.05);
            position: fixed;
            right: 0;
            top: 0;
            width: 260px;
            height: 100%;
            z-index: 1050;
            transition: right 0.3s;
            display: flex;
            flex-direction: column;
        }
        .left-sidebar .brand-logo {
            border-bottom: 1px solid #eee;
        }
        .body-wrapper {
            flex: 1;
            margin-right: 260px;
            transition: margin-right 0.3s;
        }
        @media (max-width: 992px) {
            .left-sidebar {
                right: -260px;
            }
            .left-sidebar.active {
                right: 0;
            }
            .body-wrapper {
                margin-right: 0;
            }
            .hamburger-btn {
                display: inline-block !important;
            }
        }
        .hamburger-btn {
            display: none;
            background: none;
            border: none;
            font-size: 1.5rem;
            color: var(--primary-dark);
            margin-left: 10px;
            cursor: pointer;
        }
        .main-container {
            max-width: 1200px;
            margin: 40px auto 0 auto;
            padding: 24px 16px 40px 16px;
            background: rgba(255,255,255,0.98);
            border-radius: 24px;
            box-shadow: 0 12px 48px rgba(93,62,188,0.08), 0 1.5px 12px rgba(0,0,0,0.04);
            animation: fadeIn 0.8s;
        }
        @media (max-width: 768px) {
            .main-container {
                padding: 12px 4px 20px 4px;
                border-radius: 12px;
            }
        }
        .dashboard-card {
            background: rgba(255,255,255,0.98);
            border-radius: var(--card-radius);
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
            padding: 24px;
            transition: all var(--transition-speed) ease;
            height: 100%;
            display: flex;
            flex-direction: column;
            border: 1px solid rgba(0,0,0,0.05);
        }
        .dashboard-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 24px rgba(0,0,0,0.12);
        }
        .card-header {
            display: flex;
            align-items: center;
            margin-bottom: 1.5rem;
        }
        .icon-large {
            font-size: 2.5rem;
            color: var(--primary-color);
            margin-left: 1rem;
            flex-shrink: 0;
            animation: pulse 1.2s infinite alternate;
        }
        @keyframes pulse {
            to { transform: scale(1.1); }
        }
        .card-title {
            font-size: 1.25rem;
            font-weight: 700;
            margin-bottom: 0;
            color: var(--text-dark);
        }
        .card-value {
            font-size: 1.8rem;
            font-weight: 800;
            color: var(--primary-dark);
            margin: 0.5rem 0;
        }
        .card-text {
            color: var(--text-gray);
            margin-bottom: 1.5rem;
            flex-grow: 1;
        }
        .btn {
            border-radius: 12px;
            padding: 10px 20px;
            font-weight: 500;
            transition: all var(--transition-speed) ease;
        }
        .btn-primary {
            background: linear-gradient(90deg, var(--primary-color), var(--primary-dark));
            border: none;
            color: #fff;
        }
        .btn-primary:hover {
            background: linear-gradient(90deg, var(--primary-dark), #431897);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(93, 62, 188, 0.3);
        }
        .btn-outline-primary {
            border: 1px solid var(--primary-color);
            color: var(--primary-color);
        }
        .btn-outline-primary:hover {
            background: var(--primary-color);
            color: white;
        }
        .status-badge {
            display: inline-block;
            padding: 0.25rem 0.5rem;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        .status-active {
            background: #dcfce7;
            color: #166534;
        }
        .status-pending {
            background: #fef9c3;
            color: #854d0e;
        }
        .smart-suggestions {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
            gap: 1rem;
        }
        .suggestion-item {
            background: rgba(93, 62, 188, 0.05);
            border-radius: var(--card-radius);
            padding: 1rem;
            display: flex;
            align-items: center;
            transition: all var(--transition-speed) ease;
        }
        .suggestion-item:hover {
            background: rgba(93, 62, 188, 0.1);
        }
        .activity-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .activity-item {
            padding: 1rem 0;
            border-bottom: 1px solid rgba(0,0,0,0.05);
            display: flex;
            align-items: center;
        }
        .activity-item:last-child {
            border-bottom: none;
        }
        .activity-icon {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--primary-light);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-left: 1rem;
            flex-shrink: 0;
        }
        .progress {
            background: #f1f1f1;
            border-radius: 8px;
            overflow: hidden;
        }
        .progress-bar {
            height: 8px;
        }
        @media (max-width: 768px) {
            .smart-suggestions {
                grid-template-columns: 1fr;
            }
            .dashboard-card {
                padding: 1rem;
            }
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        h1 {
            font-size: 2rem;
            color: var(--text-dark);
            margin-bottom: 0.5rem;
            font-weight: 800;
        }
        .page-description {
            color: var(--text-gray);
            font-size: 1.1rem;
            margin-bottom: 2rem;
        }
        /* Theme Switcher */
        .theme-switcher {
            border: 1px solid #ccc;
            border-radius: 10px;
            overflow: hidden;
            display: flex;
            font-size: 0.8rem;
        }
        .theme-switcher select {
            border: none;
            padding: 5px 10px;
            appearance: none;
            background: transparent;
        }
        /* Notification Bell */
        .notification-bell {
            position: relative;
            cursor: pointer;
        }
        .notification-bell .badge {
            position: absolute;
            top: -8px;
            left: -8px;
            background: red;
            color: white;
            border-radius: 50%;
            padding: 4px 8px;
            font-size: 0.7rem;
        }
        /* Dark mode */
        .dark-mode {
            --text-dark: #e1e7ff;
            --text-gray: #a1a1aa;
            --bg-light: #1a1a1a;
        }
        .dark-mode body {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: #e5e7eb;
        }
        .dark-mode .dashboard-card {
            background: rgba(30, 30, 30, 0.98);
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
            border-color: rgba(255,255,255,0.05);
        }
        .dark-mode .left-sidebar {
            background: #1f1f1f;
            border-color: rgba(255,255,255,0.05);
        }
        .dark-mode .activity-item {
            border-color: rgba(255,255,255,0.05);
        }
    </style>
</head>
<body>
<div class="page-wrapper">
    <!-- Sidebar -->
    <aside class="left-sidebar" id="sidebar">
        <div>
            <div class="brand-logo d-flex align-items-center justify-content-between p-3">
                <a href="/" class="logo-img">
                    <img src="{{ asset('logo.png') }}" alt="لوگو Mersa" width="140" class="pulse-animation">
                </a>
                <div class="d-flex align-items-center">
                    <button id="sidebarCollapse" class="hamburger-btn d-lg-none" aria-label="باز و بسته کردن منو">
                        <i class="fa fa-bars"></i>
                    </button>
                    <button class="btn btn-sm btn-outline-secondary theme-switcher me-2" aria-label="انتخاب تم">
                        <select id="themeSwitcher">
                            <option value="default">پیش‌فرض</option>
                            <option value="purple">بنفش</option>
                            <option value="green">سبز</option>
                            <option value="orange">نارنجی</option>
                        </select>
                    </button>
                    <button class="btn btn-sm btn-outline-secondary dark-mode-toggle ms-2" id="darkModeToggle" aria-label="تغییر حالت تاریک">
                        <i class="ti ti-moon"></i>
                    </button>
                    <div class="notification-bell ms-2">
                        <i class="ti ti-bell fs-5"></i>
                        <span class="badge">3</span>
                    </div>
                </div>
            </div>
            <nav class="sidebar-nav scroll-sidebar" data-simplebar>
                <ul id="sidebarnav">
                    <li class="nav-small-cap">
                        <i class="ti ti-dots nav-small-cap-icon fs-4"></i>
                        <span class="hide-menu">منو اصلی</span>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link" href="{{route('dashboard')}}" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-home"></i></span>
                            <span class="hide-menu">داشبورد</span>
                        </a>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link" href="{{route('admin.projects')}}" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-briefcase"></i></span>
                            <span class="hide-menu">پروژه‌ها</span>
                        </a>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link" href="{{route('user.letter')}}" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-mail"></i></span>
                            <span class="hide-menu">نامه‌ها</span>
                        </a>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link" href="{{route('purchase.my-requests')}}" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-shopping-cart"></i></span>
                            <span class="hide-menu">درخواست‌های خرید</span>
                        </a>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link" href="{{route('profile.edit')}}" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-user"></i></span>
                            <span class="hide-menu">پروفایل</span>
                        </a>
                    </li>
                </ul>
            </nav>
            <div class="fixed-profile p-3 bg-light-secondary rounded sidebar-ad mt-3 mx-3">
                <div class="hstack gap-3">
                    <div class="john-img">
                        <img src="{{ auth()->user()->image ?? asset('default-avatar.jpg') }}" class="rounded-circle" width="60" height="60" alt="پروفایل {{ auth()->user()->name }}">
                    </div>
                    <div class="john-title">
                        <h6 class="mb-0 fs-4 fw-semibold">{{ auth()->user()->name }}</h6>
                        <span class="fs-2 text-dark">{{ auth()->user()->role ?? 'کاربر' }}</span>
                    </div>
                </div>
                <form action="/logout" method="POST" class="mt-3">
                    @csrf
                    <button type="submit" class="w-100 btn btn-danger">خروج</button>
                </form>
            </div>
        </div>
    </aside>
    <!-- Main Content -->
    <div class="body-wrapper">
        <div class="main-container">
            <!-- Alert -->
            <div class="alert alert-warning mb-4 animate-fade-in">
                ⚠️ ۲ پروژه نزدیک به مهلت تحویل هستند!
            </div>
            <!-- Welcome & Search -->
            <div class="d-flex flex-wrap justify-content-between align-items-center mb-4 gap-2">
                <div>
                    <h1>خوش آمدید، {{ auth()->user()->name }}</h1>
                    <p class="page-description">داشبورد شخصی شما برای مدیریت پروژه‌ها، نامه‌ها و درخواست‌ها</p>
                </div>
                <div style="min-width:220px;max-width:300px;width:100%;">
                    <div class="input-group w-100">
                        <input type="text" class="form-control" placeholder="جستجوی سریع..." aria-label="جستجوی سریع">
                        <button class="btn btn-outline-secondary" type="button">
                            <i class="ti ti-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <!-- Main Cards Row -->
            <div class="row g-4 mb-4">
                <div class="col-12 col-md-4">
                    <div class="dashboard-card">
                        <div class="card-header">
                            <i class="ti ti-briefcase icon-large"></i>
                            <h5 class="card-title">پروژه‌های من</h5>
                        </div>
                        <div class="card-value">{{ $activeProjects ?? 5 }}</div>
                        <p class="card-text">پروژه‌های فعال در حال حاضر</p>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="status-badge status-active">فعال: {{ $activeProjects ?? 5 }}</span>
                            <span class="status-badge status-pending">در انتظار: {{ $pendingProjects ?? 2 }}</span>
                        </div>
                        <a href="{{route('admin.projects')}}" class="btn btn-primary w-100 mt-auto">مشاهده پروژه‌ها</a>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="dashboard-card">
                        <div class="card-header">
                            <i class="ti ti-mail icon-large"></i>
                            <h5 class="card-title">نامه‌های دریافتی</h5>
                        </div>
                        <div class="card-value">{{ $totalLetters ?? 12 }}</div>
                        <p class="card-text">تعداد کل نامه‌های دریافتی</p>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="status-badge status-active">خوانده شده: {{ $readLetters ?? 9 }}</span>
                            <span class="status-badge status-pending">جدید: {{ $newLetters ?? 3 }}</span>
                        </div>
                        <a href="{{route('letters.received')}}" class="btn btn-primary w-100 mt-auto">مشاهده نامه‌ها</a>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="dashboard-card">
                        <div class="card-header">
                            <i class="ti ti-shopping-cart icon-large"></i>
                            <h5 class="card-title">درخواست‌های خرید</h5>
                        </div>
                        <div class="card-value">{{ $totalRequests ?? 8 }}</div>
                        <p class="card-text">تعداد کل درخواست‌های خرید</p>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="status-badge status-active">تایید شده: {{ $approvedRequests ?? 5 }}</span>
                            <span class="status-badge status-pending">در حال بررسی: {{ $pendingRequests ?? 3 }}</span>
                        </div>
                        <a href="{{route('purchase.my-requests')}}" class="btn btn-primary w-100 mt-auto">مشاهده درخواست‌ها</a>
                    </div>
                </div>
            </div>
            <!-- Smart Suggestions Row -->
            <div class="dashboard-card mb-4">
                <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-2">
                    <h5 class="fw-bold mb-0">پیشنهادات هوشمند</h5>
                    <button class="btn btn-sm btn-outline-primary">بروزرسانی</button>
                </div>
                <div class="smart-suggestions">
                    <div class="suggestion-item">
                        <i class="ti ti-alert-circle text-warning me-2"></i>
                        <span>۲ پروژه نزدیک به مهلت تحویل</span>
                    </div>
                    <div class="suggestion-item">
                        <i class="ti ti-mail text-info me-2"></i>
                        <span>۵ نامه خوانده نشده دارید</span>
                    </div>
                    <div class="suggestion-item">
                        <i class="ti ti-shopping-cart text-danger me-2"></i>
                        <span>۱ درخواست خرید نیاز به تایید دارد</span>
                    </div>
                    <div class="suggestion-item">
                        <i class="ti ti-calendar text-success me-2"></i>
                        <span>۳ جلسه در هفته جاری دارید</span>
                    </div>
                </div>
            </div>
            <!-- Recent Activity & System Status -->
            <div class="row">
                <div class="col-12 col-md-8 mb-4 mb-md-0">
                    <div class="dashboard-card">
                        <h5 class="fw-bold mb-4">فعالیت‌های اخیر</h5>
                        <ul class="activity-list">
                            @forelse ($recentActivities ?? [] as $activity)
                                <li class="activity-item">
                                    <div class="activity-icon">
                                        <i class="ti ti-{{ $activity['icon'] ?? 'circle' }}"></i>
                                    </div>
                                    <div>
                                        <div>{{ $activity['title'] }}</div>
                                        <small class="text-muted">{{ $activity['time'] }}</small>
                                    </div>
                                </li>
                            @empty
                                <li class="activity-item">
                                    <div class="activity-icon">
                                        <i class="ti ti-info-circle"></i>
                                    </div>
                                    <div>هیچ فعالیتی یافت نشد.</div>
                                </li>
                            @endforelse
                        </ul>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="dashboard-card">
                        <h5 class="fw-bold mb-4">وضعیت سیستم</h5>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between mb-1">
                                <span>فضای ذخیره‌سازی</span>
                                <span>65% استفاده شده</span>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-primary" role="progressbar" style="width: 65%;"></div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between mb-1">
                                <span>پهنای باند</span>
                                <span>42% استفاده شده</span>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-info" role="progressbar" style="width: 42%;"></div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between mb-1">
                                <span>کارایی سیستم</span>
                                <span>87% بهینه</span>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-success" role="progressbar" style="width: 87%;"></div>
                            </div>
                        </div>
                        <div class="alert alert-info mt-4">
                            <i class="ti ti-info-circle me-2"></i>
                            آخرین بروزرسانی: ۲ روز پیش
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- end body-wrapper -->
</div><!-- end page-wrapper -->

<!-- JavaScript -->
<script>
    // Dark Mode Toggle
    const darkModeToggle = document.getElementById('darkModeToggle');
    const htmlElement = document.documentElement;
    if (localStorage.getItem('darkMode') === 'true') {
        htmlElement.classList.add('dark-mode');
        darkModeToggle.innerHTML = '<i class="ti ti-sun"></i>';
    }
    darkModeToggle.addEventListener('click', () => {
        htmlElement.classList.toggle('dark-mode');
        const isDarkMode = htmlElement.classList.contains('dark-mode');
        localStorage.setItem('darkMode', isDarkMode);
        darkModeToggle.innerHTML = isDarkMode ? '<i class="ti ti-sun"></i>' : '<i class="ti ti-moon"></i>';
    });

    // Theme Switcher
    const themeSwitcher = document.getElementById('themeSwitcher');
    const root = document.documentElement;
    themeSwitcher.addEventListener('change', function () {
        const selectedTheme = this.value;
        switch (selectedTheme) {
            case 'purple':
                root.style.setProperty('--primary-color', '#5d3ebc');
                root.style.setProperty('--primary-dark', '#4b2997');
                root.style.setProperty('--primary-light', '#a88cc7');
                break;
            case 'green':
                root.style.setProperty('--primary-color', '#10b981');
                root.style.setProperty('--primary-dark', '#047857');
                root.style.setProperty('--primary-light', '#6ee7b7');
                break;
            case 'orange':
                root.style.setProperty('--primary-color', '#f97316');
                root.style.setProperty('--primary-dark', '#ea580c');
                root.style.setProperty('--primary-light', '#fb923c');
                break;
            default:
                root.style.setProperty('--primary-color', '#3b82f6');
                root.style.setProperty('--primary-dark', '#2563eb');
                root.style.setProperty('--primary-light', '#93c5fd');
        }
    });

    // Sidebar toggle for mobile
    const sidebarCollapse = document.getElementById('sidebarCollapse');
    const sidebar = document.getElementById('sidebar');
    if (sidebarCollapse) {
        sidebarCollapse.addEventListener('click', function() {
            sidebar.classList.toggle('active');
        });
    }
</script>
@stack('scripts')
@livewireScripts
</body>
</html>
