<?php

use App\Http\Controllers\AnnouncementAttachmentZipController;
use App\Http\Controllers\AttachmentController;
use App\Livewire\Actions\Logout;
use App\Http\Controllers\GalleryController;
use App\Livewire\Admin\PettyCash\ManageApprovalRules;
use App\Livewire\ClearJustLoggedIn;
use App\Models\Transmittal;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Route;
use App\Http\Middleware\DefaultUsersMiddleware;
use App\Livewire\Admin\Projects\ProjectSection;
use App\Http\Controllers\TransmittalController;
use Mpdf\Mpdf;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;



//Route::middleware([DefaultUsersMiddleware::class . ':1'])->group(function () {


Route::middleware(['auth'])
    ->group(function () {
        Route::get('/account-inactive', function () {
            return view('account-inactive');
        })->name('account.inactive');
    });





Route::group(['middleware' => 'guest'], function () {
    Route::get('/multiregister', App\Livewire\User\MultiStepRegister::class)->name('multi.register');
});


require __DIR__.'/auth.php';
Route::group(['middleware' => 'auth'], function () {

    Route::get('/profile/edit', App\Livewire\User\ProfileForm::class)
        ->name('user.profile.edit');

    Route::get('/user/login-history', App\Livewire\User\LoginHistory::class)->name('user.login.history');


Route::get('/admin',App\Livewire\Panel\Index::class)->name('admin.dashboard');
Route::get('/admin/users/add',App\Livewire\Admin\Users\AddUser::class)->name('admin.users.add');
Route::get('/admin/users/list',App\Livewire\Admin\Users\ListUsers::class)->name('admin.users.list');
Route::get('/admin/users',App\Livewire\Admin\Users\Users::class)->name('admin.users');
Route::get('/users/{user}', App\Livewire\Admin\Users\UserProfile::class)->name('users.profile');
Route::get('/admin/users/RoleMangement',App\Livewire\Admin\Users\UserRoleManagement::class)->name('admin.users.RoleManagement');


Route::get('/admin/create_companies',App\Livewire\Admin\Company\CreateCompany::class)->name('admin.create.company');
Route::get('/admin/companies',App\Livewire\Admin\Company\Companies::class)->name('admin.companies');
Route::get('/admin/company/List',App\Livewire\Admin\Company\CompanyList::class)->name('admin.list.company');

Route::get('/admin/projects',App\Livewire\Admin\Projects\Projects::class)->name('admin.projects');
Route::get('/admin/projects/Create',App\Livewire\Admin\Projects\CreateProject::class)->name('admin.create.project');
Route::get('/admin/projects/list',App\Livewire\Admin\Projects\ListProjects::class)->name('admin.list.projects');
Route::get('/admin/projects/cardview',App\Livewire\Admin\Projects\CardView::class)->name('admin.projects.cardview');
// Route::get('/admin/projects/{projectId}',App\Livewire\Admin\Projects\ShowSections::class)->name('admin.projects.sections');
Route::get('/project/{projectId}/roles', App\Livewire\Admin\Projects\ProjectRoleManager::class)->name('project.roles');


Route::get('/admin/project/{project}/section',App\Livewire\Admin\Projects\ProjectSection::class)->name('projects.section');



    Route::get('/admin/sections/{section}/file', App\Livewire\Admin\Sections\SectionFiles::class)
        ->name('projects.sections.files');

Route::get('/admin/projects/sections/{sectionId}',App\Livewire\Admin\ProjectFiles\ShowSectionFiles::class)->name('admin.projects.sections.files');

Route::get('/project-file-upload', App\Livewire\Admin\ProjectFiles\ProjectFileUpload::class)->name('project-file-upload');
//Route::get('/section-file-upload',App\Livewire\Admin\Sections\SectionFileUpload::class)->name('section-file-upload');
    Route::get('/admin/sections/{section}/files', App\Livewire\Admin\Sections\SectionFileUpload::class)
        ->name('admin.sections.files');

Route::get('/admin/projects/section/create',App\Livewire\Admin\Section\CreateSection::class)->name('admin.create.section');
Route::get('admin/section/sections',App\Livewire\Admin\Section\Sections::class)->name('admin.sections');
Route::get('admin/sections/list',App\Livewire\Admin\Section\SectionList::class)->name('admin.list.sections');

Route::get('/admin/projectfiles/create',App\Livewire\Admin\ProjectFiles\CreateFile::class)->name('admin.create.file');
Route::get('/admin/projectfiles/list',App\Livewire\Admin\ProjectFiles\ListFiles::class)->name('admin.projectfiles.list');
Route::get('/admin/projectfiles/files',App\Livewire\Admin\ProjectFiles\ProjectFiles::class)->name('admin.projectfiles');

//Route::get('/admin/projects/projectdetail/create/{projectId}',App\Livewire\Admin\Projects\ProjectDetailCreate::class)->name('admin.create.project.detail');
Route::get('/projects/{projectId}/details', App\Livewire\Admin\Projects\ProjectDetailCreate::class)->name('projects.details');
Route::get('/projects/{projectId}', App\Livewire\Admin\Projects\ProjectCreateOrRename::class)->name('projects.createOrRename');
Route::get('/projects/{projectId}/view-details', App\Livewire\Admin\Projects\ProjectViewComponent::class)->name('projects.viewDetails');


Route::get('/projects/{project}/mdr',App\Livewire\Admin\MDR\ProjectMdrList::class)->name('mdr.list');

Route::get('/admin/mdr/{projectId}/poi-settings', App\Livewire\Admin\MDR\ProjectPoiSettings::class)->name('admin.mdr.poi-settings');

//Route::get('/transmittals/show/{id}', ShowTransmittal::class)->name('mdr.transmittals.show');
//Route::get('/admin/transmittal/create',App\Livewire\Admin\Transmittal\CreateTransmittal::class)->name('transmittal.create');
//Route::get('/admin/transmittals/create', App\Livewire\Admin\Transmittal\CreateTransmittal::class)->name('transmittals.create');
// روت‌های ترنسمیتال
    Route::get('/admin/transmittals/create/{project_id?}', App\Livewire\Admin\Transmittal\CreateTransmittal::class)
        ->name('transmittal.create')
        ->where('project_id', '[0-9]+'); // project_id فقط عدد

Route::get('/admin/transmittal/',App\Livewire\Admin\Transmittal\TransmittalList::class)->name('transmittals.index');
Route::get('/admin/transmittal/{id}',App\Livewire\Admin\Transmittal\ShowTransmittal::class)->name('transmittals.show');


    Route::get('/transmittal/{id}/attachments/zip', [TransmittalController::class, 'downloadAttachmentsZip'])
        ->name('transmittal.attachments.zip');


// مدیریت قالب ترنسمیتال
   Route::get('/admin/transmittal/template/create', App\Livewire\Admin\Transmittal\CreateTransmittalTemplate::class)->name('admin.transmittal.template.create');
   Route::get('/admin/transmittal/templates', App\Livewire\Admin\Transmittal\TransmittalTemplateList::class)->name('admin.transmittal.templates.list');



    // مشاهده ترنسمیتال
    Route::get('/transmittals/show/{id}', \App\Livewire\Admin\Transmittal\ShowTransmittal::class)->name('transmittal.show');



    Route::get('/transmittals/download/{id}/pdf', function ($id) {
        // بارگیری ترنسمیتال
        $trans = \App\Models\Transmittal::with(['project', 'sender', 'receiver', 'documents'])->findOrFail($id);

        // render Blade
        $html = view('livewire.admin.transmittal.transmittal-pdf', ['trans' => $trans])->render();

        // تنظیمات MPDF
        $mpdf = new Mpdf([
            'mode' => 'utf-8',
            'format' => 'A4',
            'default_font' => 'vazir',
            'autoScriptToLang' => true,
            'autoLangToFont' => true,
            'useSubstitutions' => true,
            'fontDir' => [base_path('public/panel/dist/fonts/vazir/')],
            'fontdata' => [
                'vazir' => [
                    'R' => 'Vazir.ttf',
                    'B' => 'Vazir.ttf',
                    'useOTL' => 0xFF,
                    'useKashida' => 75,
                ]
            ],
        ]);

        // اضافه کردن HTML و خروجی
        $mpdf->WriteHTML($html);
        return response($mpdf->Output(), 200)
            ->header('Content-Type', 'application/pdf')
            ->header('Content-Disposition', 'inline; filename="'.$trans->transmittal_number.'.pdf"');
    })->name('transmittal.download');





//Route::get('/admin/transmittal/',App\Livewire\Admin\Transmittal\CreateTransmittal::class)->name('transmittal.create');

Route::get('/admin/project/{projectId}/insurance/create',App\Livewire\Admin\Projects\Insurance\InsuranceDetailCreate::class)->name('admin.create.insurance.detail');

Route::get('/admin/project/schedule/create/{projectId}',App\Livewire\Admin\Projects\Schedule\ProjectScheduleCreate::class)->name('admin.create.project.schedule');
Route::get('/admin/project/financial/create/{projectId}',App\Livewire\Admin\Projects\Financial\FinancialDetailCreate::class)->name('admin.create.project.financial');

    Route::get('/projects/{projectId}/contract', App\Livewire\Admin\Projects\Financial\ProjectContractManager::class)->name('projects.contract');

Route::get('/admin/projects/{project}/members', App\Livewire\Admin\Projects\EditProjectMembers::class)->name('admin.project.members');
Route::get('/admin/project/dashboard', App\Livewire\Admin\Projects\ProjectDashboard::class)->name('admin.project.dashboard');

    Route::get('/admin/projects/{project}/letters/list', App\Livewire\Admin\Projects\ProjectLettersIndex::class)
        ->name('admin.projects.letters.list');


Route::get('/projects/{project}/wall', App\Livewire\Admin\Projects\ProjectWall::class)
        ->name('projects.wall');


// 🛑 روت مدیریت نقش‌های قراردادی (کارفرما، پیمانکار، مشاور)
    Route::get('/projects/{project}/contract-roles', App\Livewire\Admin\Projects\ProjectContractRoles::class)
        ->name('admin.projects.contract-roles');


Route::get('/{project}/dashboard', App\Livewire\Admin\Projects\ProjectDashboardSingle::class)->name('single.project.dashboard');


    Route::get('/admin/project/type/create',App\Livewire\Admin\Projects\Type\ProjectTypeCreate::class)->name('admin.create.project.type');
Route::get('/admin/project/types',App\Livewire\Admin\Projects\Type\ProjectType::class)->name('admin.project.types');
Route::get('/admin/project/typelist',App\Livewire\Admin\Projects\Type\ProjectTypeList::class)->name('admin.list.project.type');

Route::get('/admin/Letter/Classification/create',App\Livewire\Admin\Letter\Classification\AddClassification::class)->name('admin.create.letter.classification');
Route::get('/admin/Letter/Classifications',App\Livewire\Admin\Letter\Classification\Classifications::class)->name('admin.letter.classifications');
Route::get('/admin/Letter/Classification/list',App\Livewire\Admin\Letter\Classification\ClassificationList::class)->name('admin.letter.classifications.list');

Route::get('/admin/user/user_position/create',App\Livewire\Admin\Users\Positions\AddPosition::class)->name('admin.user.position.create');
Route::get('/admin/user/user_position/list',App\Livewire\Admin\Users\Positions\PositionList::class)->name('admin.user.position.list');

Route::get('/admin/user/user_positions',App\Livewire\Admin\Users\Positions\Positions::class)->name('admin.user.position');
Route::get('/admin/user/user_position/{id}',App\Livewire\Admin\Users\Positions\EditPosition::class)->name('admin.edit.position');

Route::get('/admin/letter/create/{templateId?}',App\Livewire\Admin\Letter\CreateLetter::class)->name('admin.create.letter');
Route::get('/admin/letter/createLetter',App\Livewire\Admin\Letter\Create\CreateLetter::class)->name('admin.create2.letter');

Route::get('/letters/{letter}/edit', App\Livewire\Admin\Letter\CreateEditLetter::class)->name('admin.edit.letter');

Route::get('/admin/letter/Referral',App\Livewire\Admin\Letter\ReferralManagement::class)->name('admin.letter.Referral');
Route::get('/letters', App\Livewire\Admin\Letter\Letters::class)->name('letters.index');
Route::get('/referrals', App\Livewire\Admin\Letter\ReferralManagement::class)->name('referrals.index');
Route::get('/archive', App\Livewire\Admin\Letter\ArchiveLetter::class)->name('archive.index');
Route::get('/user-Letter',App\Livewire\Admin\Letter\UserLetters::class)->name('user.letter');
Route::get('/letters/{letterId}', App\Livewire\Admin\Letter\ShowLetters::class)->name('letters.show');
Route::get('/{letter}/edit', App\Livewire\Admin\Letter\LetterEdit::class)->name('letters.edit');


Route::get('/LetterFormLists', App\Livewire\Admin\Letter\Form\LetterFormList::class)->name('LetterFormList');
Route::get('/letters/create/{formId}', App\Livewire\Admin\Letter\Create\CreateLetterForm::class)->name('CreateLetterForm');


Route::get('/letter/{letter}', App\Livewire\Admin\Letter\LetterShow::class)->name('letter.show');
Route::get('/admin/Letter/Reminder',App\Livewire\Admin\Letter\LetterReminder::class)->name('admin.letter.reminder');
Route::get('/admin/letter/reports',App\Livewire\Admin\Letter\LetterReport::class)->name('admin.letter.report');
Route::get('/admin/letter/Forms',App\Livewire\Admin\Letter\Form\LetterFormCreate::class)->name('admin.letter.form.create');
Route::get('/admin/Letters/FormManagement',App\Livewire\Admin\Letter\Form\LetterFormManagement::class)->name('admin.letter.form');
Route::get('/template',App\Livewire\Admin\Letter\Template\LetterTemplateManager::class)->name('template.index');
Route::get('/admin/templates', App\Livewire\Admin\Letter\Template\TemplateManager::class)->name('admin.letter.templates.index');
Route::get('/admin/template/create',App\Livewire\Admin\Letter\Form\CreateTemplate::class)->name('admin.template.create');
Route::get('/received-letters', \App\Livewire\Admin\Letter\ReceivedLetters::class)->name('letters.received');

Route::get('/admin/letters/incoming/create', App\Livewire\Admin\Letter\RegisterIncomingLetter::class)
        ->name('admin.register.incoming');

    // روت برای آپلود تصاویر توسط TinyMCE
    Route::post('/upload/tinymce/image', [AttachmentController::class, 'uploadTinymceImage'])
        ->name('upload.tinymce.image');

    // روت برای نمایش فرم ثبت نامه وارده
    Route::get('/admin/letters/incoming', App\Livewire\Admin\Letter\IncomingLettersList::class)
        ->name('admin.incoming.list');

    Route::get('/admin/letter/mycorrespondence',App\Livewire\Admin\Letter\MyCorrespondenceHub::class)->name('admin.mycorrespondence.hub');

Route::get('/admin/roles',App\Livewire\Admin\Roles\Roles::class)->name('admin.roles');
Route::get('/admin/roles/create',App\Livewire\Admin\Roles\AddRoles::class)->name('admin.create.role');
Route::get('/admin/roles/list',App\Livewire\Admin\Roles\RolesList::class)->name('admin.list.roles');




//// 1. ثبت درخواست جدید تنخواه (برای کارمندان)
//    Route::get('/petty-cash/request', App\Livewire\Admin\PettyCash\PettyCashRequest::class)
//        ->name('pettycash.request');
//
//    // 2. داشبورد وظایف تأیید تنخواه (برای مدیران/مالی)
//    Route::get('/petty-cash/approval-hub', App\Livewire\Admin\PettyCash\PettyCashApprovalDashboard::class)
//        ->name('pettycash.approval.hub');
//
//    // 3. مدیریت قوانین تأیید (برای ادمین مالی)
//    Route::get('/petty-cash/rules', App\Livewire\Admin\PettyCash\PettyCashRuleManager::class)
//        ->name('pettycash.rules.manage');
//

    Route::get('/petty-cash', App\Livewire\Admin\PettyCash\ListRequests::class)->name('admin.petty-cash.index');
    Route::get('/petty-cash/create', App\Livewire\Admin\PettyCash\CreateRequest::class)->name('admin.petty-cash.create');
    Route::get('/petty-cash/{id}', App\Livewire\Admin\PettyCash\ShowRequest::class)->name('petty-cash.show');
    Route::get('/admin/petty-cash/rules', App\Livewire\Admin\PettyCash\ManageApprovalRules::class)->name('admin.petty-cash.rules');

    Route::get('/admin/projects/{projectId}/petty-cash', \App\Livewire\Admin\PettyCash\ProjectPettyCashList::class)
        ->name('admin.petty-cash.project');

//    Route::get('/admin/petty-cash/{id}/pdf', function ($id) {
//
//        // 1. بارگذاری داده‌ها
//        $request = \App\Models\PettyCash::with(['user', 'approvals.approver', 'projects'])->findOrFail($id);
//        $html = view('livewire.admin.petty-cash.pdf', ['request' => $request])->render();
//
//        // 2. 🎯 تنظیمات mPDF: اعمال حالت Landscape
//        $mpdf = new Mpdf([
//            'mode' => 'utf-8',
//            'format' => 'A4', // 💡 تغییر فرمت به A4-L (A4 Landscape)
//
//            // تنظیمات فونت Vazir
//            'default_font_size' => 10,
//            'default_font' => 'vazir',
//            'autoScriptToLang' => true,
//            'autoLangToFont' => true,
//            'useSubstitutions' => true,
//            'fontDir' => [base_path('public/panel/dist/fonts/vazir/')],
//            'fontdata' => [
//                'vazir' => [
//                    'R' => 'Vazir.ttf',
//                    'B' => 'Vazir-Bold.ttf',
//                    'useOTL' => 0xFF,
//                    'useKashida' => 75,
//                ]
//            ],
//            'allow_charset_conversion' => true,
//            'charset_in' => 'utf-8',
//            'tempDir' => storage_path('framework/cache'),
//            // **تنظیم حاشیه‌های استاندارد برای چاپ (mm)**
//            'margin_left' => 5,
//            'margin_right' => 5,
//            'margin_top' => 5,
//            'margin_bottom' => 5,
//        ]);
//
//        // 3. اعمال چیدمان
//        $mpdf->WriteHTML($html);
//
//        // 4. خروجی PDF
//        return response($mpdf->Output('PC_' . $request->id . '.pdf', 'S'), 200)
//            ->header('Content-Type', 'application/pdf');
//
//    })->name('admin.petty-cash.pdf');

    Route::get('/admin/petty-cash/{id}/pdf', function ($id) {

        // ----------------------------------------------------
        // ⚠️ گام ۱: تعریف تابع toJalali (باید در پروژه شما پیاده‌سازی شده باشد)
        // اگر از پکیج "morilog/jalali" استفاده می‌کنید:
        // use Morilog\Jalali\Jalali; // یا JDate

        if (!function_exists('toJalali')) {
            function toJalali($timestamp, $format = 'Y/m/d') {
                // **اینجا باید منطق تبدیل میلادی به شمسی با پکیج شما قرار گیرد.**
                // مثال با فرض استفاده از پکیج Morilog/Jalali:
                // return Morilog\Jalali\Jalali::fromDateTime($timestamp)->format($format);

                // به عنوان یک راه حل موقت (اگر پکیج نصب ندارید) فقط میلادی را برمی‌گرداند.
                return $timestamp instanceof \Carbon\Carbon ? $timestamp->format($format) : date($format, strtotime($timestamp));
            }
        }

        // 1. بارگذاری داده‌ها
        $request = \App\Models\PettyCash::with(['user', 'approvals.approver', 'projects'])->findOrFail($id);

        // 2. ارسال تابع به Blade
        $html = view('livewire.admin.petty-cash.pdf', [
            'request' => $request,
            'toJalali' => 'toJalali' // ارسال نام تابع به Blade
        ])->render();

        // 3. تنظیمات mPDF
        $mpdf = new Mpdf([
            'mode' => 'utf-8',
            'format' => 'A4',
            'default_font' => 'vazir',
            'autoScriptToLang' => true,
            'autoLangToFont' => true,
            'fontDir' => [base_path('public/panel/dist/fonts/vazir/')],
            'fontdata' => [
                'vazir' => [
                    'R' => 'Vazir.ttf',
                    'B' => 'Vazir-Bold.ttf',
                    'useOTL' => 0xFF,
                    'useKashida' => 75,
                ]
            ],
            'margin_left' => 5,
            'margin_right' => 5,
            'margin_top' => 5,
            'margin_bottom' => 5,
        ]);

        $mpdf->WriteHTML($html);

        // 4. خروجی PDF
        return response($mpdf->Output('PC_' . $request->id . '.pdf', 'S'), 200)
            ->header('Content-Type', 'application/pdf');

    })->name('admin.petty-cash.pdf');

//    // 💡 فرض می‌کنیم Facade یا کلاس PDF شما اکنون به mPDF اشاره می‌کند
//    Route::get('/admin/petty-cash/{id}/pdf', function ($id) {
//        // 1. بارگذاری داده‌ها
//        $request = \App\Models\PettyCash::with(['user', 'approvals.approver', 'projects'])->findOrFail($id);
//
//        // 2. 🎯 فراخوانی mPDF: تنظیمات RTL و فارسی
//        $pdf = \PDF::loadView('livewire.admin.petty-cash.pdf', compact('request'));
//
//        // 3. اعمال تنظیمات اختصاصی mPDF (برای تضمین RTL و فونت)
//        // 💡 توجه: این تنظیمات باید در فایل کانفیگ mpdf یا مستقیماً در کد اعمال شوند.
//        // اگر از پکیج استفاده نمی‌کنید، باید یک متد helper برای ایجاد آبجکت mPDF داشته باشید.
//
//        // اگر از پکیج barryvdh/laravel-dompdf (که قبلا استفاده می‌کردید) به mPDF تغییر داده شده،
//        // این تنظیمات باید در فایل کانفیگ (config/pdf.php) پکیج شما انجام شده باشد.
//
//        // 4. ارسال به صورت دانلود جریانی
//        return $pdf->download("درخواست_هزینه_{$id}.pdf");
//
//    })->name('admin.petty-cash.pdf');
//

//    Route::get('/admin/petty-cash/{id}/pdf', function ($id) {
//        $request = \App\Models\PettyCash::with(['user', 'approvals.approver'])->findOrFail($id);
//        $pdf = \PDF::loadView('livewire.admin.petty-cash.pdf', compact('request'))
//            ->setPaper('A4');
//        return response()->streamDownload(fn() => print($pdf->output()), "درخواست_هزینه_{$id}.pdf");
//    })->name('admin.petty-cash.pdf');


//task

    Route::get('/admin/project/{project}/task/create', App\Livewire\Admin\Task\CreateTask::class)
        ->name('admin.project.task.create');

// نمایش جزئیات هر تسک
    Route::get('/admin/project/{project}/task/{task}', App\Livewire\Admin\Task\TaskShow::class)
        ->name('admin.project.task.show');
    Route::get('/admin/project/{project}/tasklist',App\Livewire\Admin\Task\ListTasks::class)->name('admin.project.task.list');

// ویرایش تسک
    Route::get('/admin/project/{project}/task/{task}/edit', App\Livewire\Admin\Task\TaskEdit::class)
        ->name('admin.project.task.edit');


    Route::get('/my-tasks/active', App\Livewire\User\MyActiveTasks::class)->name('tasks.my-active');

    Route::get('/admin/permissions',App\Livewire\Admin\Permission\Permissions::class)->name('admin.permissions');
Route::get('/admin/permissions/create',App\Livewire\Admin\Permission\AddPermission::class)->name('admin.create.permissions');
Route::get('/admin/permissions/list',App\Livewire\Admin\Permission\Permissions::class)->name('admin.list.permissions');
    Route::get('/admin/roles/permissions', App\Livewire\Admin\Roles\RolePermissionManager::class)->name('admin.roles.permissions.manage');


    Route::get('/admin/projects/assign-roles', App\Livewire\Admin\Project\ProjectRoleAssignment::class)
        ->name('admin.projects.assign.roles');




Route::get('/admin/ContractStatus/create',App\Livewire\Admin\Contract\ContractStatusCreate::class)->name('admin.create.contract.status');
Route::get('/admin/ContractStatus/List',App\Livewire\Admin\Contract\ContractStatusList::class)->name('admin.list.contract.status');
Route::get('/admin/ContractStatus',App\Livewire\Admin\Contract\ContractStatus::class)->name('admin.contract.status');
Route::get('/admin/purchase/dashboard', App\Livewire\Admin\Purchase\PurchaseDashboard::class)->name('purchase.dashboard');

Route::get('/admin/item_management',App\Livewire\Admin\Item\ItemManagement::class)->name('admin.item_management');
Route::get('/admin/itemlist',App\Livewire\Admin\Item\ItemList::class)->name('admin.itemlist');
Route::get('/admin/purchase_request',App\Livewire\Admin\Purchase\PurchaseRequestManagement::class)->name('admin.purchase_request');
Route::get('/admin/all_purchase/',App\Livewire\Admin\Purchase\AllPurchaseRequests::class)->name('admin.all_purchase');

Route::get('/admin/purchase/approval', App\Livewire\Admin\Purchase\ApprovePurchaseRequests::class)->name('admin.purchase.approval');

Route::get('/admin/purchase-requests/approval', App\Livewire\Admin\Purchase\PurchaseRequestApproval::class)->name('admin.purchase-requests.approval');

// مدیریت تأییدکنندگان
    Route::get('/admin/approvers', App\Livewire\Admin\Approval\ApprovalManagement::class)->name('admin.approvers');




    Route::get('/purchase/my-requests', App\Livewire\Admin\Purchase\MyPurchaseRequests::class)
        ->name('purchase.my-requests');

    Route::get('/purchase/budget', App\Livewire\Admin\Purchase\ProjectBudgetManagement::class)
        ->name('purchase.budget');




// ---------------------------------------------
// 👇 مدیریت درخواست وجه (Payment Requests) - مسیرهای تصحیح شده
// ---------------------------------------------

// 1. ایجاد درخواست وجه جدید
    Route::get('/admin/payment_request/create', App\Livewire\Admin\Payment\CreatePaymentRequest::class)
        ->name('admin.payment.create');

// 2. ایجاد درخواست وجه از روی مرجع خرید
//    Route::get('/admin/payment_request/create-from-purchase/{purchaseRequest}', App\Livewire\Admin\Payment\CreatePaymentRequest::class)
//        ->name('admin.payment.create-from-purchase');

// 3. لیست درخواست‌های وجه من
    Route::get('/admin/payment_requests/mine', App\Livewire\Admin\Payment\MyPaymentRequests::class)
        ->name('admin.payment.mine');

// 4. لیست تمام درخواست‌های وجه
    Route::get('/admin/payment_requests/list', App\Livewire\Admin\Payment\PaymentRequestList::class)
        ->name('admin.payment.list');

// 5. مشاهده جزئیات یک درخواست وجه خاص
    Route::get('/admin/payment_request/{paymentRequest}', App\Livewire\Admin\Payment\ShowPaymentRequest::class)
        ->name('admin.payment.show');

// 6. صندوق ورودی تأیید درخواست‌های وجه
    Route::get('/admin/payment_approvals/inbox', App\Livewire\Admin\Payment\PaymentApprovalInbox::class)
        ->name('admin.payment.approval.inbox');
// 👇 مدیریت قوانین تأیید وجه (Payment Approval Rules)

    Route::get('/admin/payment/rule-management', App\Livewire\Admin\Payment\PaymentApprovalManagement::class)
        ->name('admin.payment.rule.management');



    Route::get('/projects/sales-invoice/create/{project_id?}', App\Livewire\Admin\Payment\CreateSalesInvoice::class)
        ->name('admin.sales.invoice.create');


    Route::get('/admin/sales/list', App\Livewire\Admin\Sales\SalesInvoiceList::class)
        ->name('admin.sales.list');


    Route::get('/admin/sales/show/{invoice}', App\Livewire\Admin\Sales\ShowSalesInvoice::class)
        ->name('admin.sales.show');


    Route::get('/admin/departments', App\Livewire\Admin\Departments\Management::class)
        ->name('admin.departments');
    Route::get('/departments/{department}/members', App\Livewire\Admin\Departments\ManageMembers::class)->name('departments.members');


    Route::get('/admin/projects/{projectId}/purchase-requests', App\Livewire\Admin\Purchase\ProjectPurchaseRequests::class)
        ->name('admin.projects.purchase-requests');

    Route::get('/admin/purchase-request/{id}/edit', App\Livewire\Admin\Purchase\EditPurchaseRequest::class)
        ->name('admin.purchase_request.edit');


    Route::get('/purchase/download/{id}/pdf', function ($id) {
        // 💡 اطمینان از Eager Loading تمام روابط لازم
        $request = \App\Models\PurchaseRequest::with(['project', 'user', 'items.item', 'approvals.user', 'approvals.role', 'costCenter'])->findOrFail($id);

        // رندر کردن ویو Blade به HTML
        $html = view('livewire.admin.purchase.purchase-request-pdf', ['request' => $request])->render();

        // 💡 تنظیمات کامل Mpdf برای پشتیبانی از فارسی (Vazir)
        $mpdf = new Mpdf([
            'mode' => 'utf-8',
            'format' => 'A4',
            // تنظیمات فونت Vazir
            'default_font_size' => 10,
            'default_font' => 'vazir',
            'autoScriptToLang' => true,
            'autoLangToFont' => true,
            'useSubstitutions' => true,
            'fontDir' => [base_path('public/panel/dist/fonts/vazir/')],
            'fontdata' => [
                'vazir' => [
                    'R' => 'Vazir.ttf',
                    'B' => 'Vazir.ttf',
                    'useOTL' => 0xFF,
                    'useKashida' => 75,
                ]
            ],
            // این خطوط تنظیمات باید داخل [ ] و با کاما جدا شده باشند
        ]);

        // اضافه کردن HTML و خروجی
        $mpdf->WriteHTML($html);

        // خروجی PDF
        return response($mpdf->Output('PR_' . $request->id . '.pdf', 'S'), 200)
            ->header('Content-Type', 'application/pdf');

    })->name('purchase.download');
    Route::get('/sign_settings',App\Livewire\Admin\Sign\SignSettingsManagement::class)->name('admin.sign_settings');


    Route::get('/admin/contact/contact-book', App\Livewire\Admin\Contact\ContactBookComponent::class)->name('contact.contact_book');
    Route::get('/admin/contact/call-reminders', App\Livewire\Admin\Contact\CallReminderComponent::class)->name('contact.call_reminders');



    Route::get('chats',App\Livewire\Admin\Chat\ChatManagement::class)->name('admin.chat');
Route::get('/chat/{userId}', App\Livewire\Admin\Chat\ChatWithUser::class)->name('chat');


Route::post('upload_ckeditor_image', [GalleryController::class, 'ckeditor_image'])->name('ckeditor.upload');
Route::post('upload_ckeditor_Letter', [GalleryController::class, 'ckeditor_image'])->name('ckeditor.letter.upload');






//Route::view('/', 'das');
Route::get('/',App\Livewire\User\Dashboard::class)->name('dashboard');

//Route::get('/dashboard',App\Livewire\Dashboard::class)->name('dashboard');

Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');



    // روت مدرن و مینیمال برای پست‌های کاربر
    Route::get('/user/posts', function () {
        return view('livewire.user.posts');
    })->name('user.posts');


    Route::get('/user/chats', function () {
        return view('livewire.user.chats');
    })->name('user.chats');


    Route::get('/admin/purchase-approvals/inbox', App\Livewire\Admin\Purchase\ApprovalInbox::class)
        ->name('purchase-approvals.inbox');

// 👇 مدیریت ذینفعان (Payee Management)
    Route::get('/admin/payee-management', App\Livewire\Admin\Purchase\PayeeManagement::class)
        ->name('admin.payee.management');

    // 💡 لیست ذینفعان (Payee List) با قابلیت مشاهده سوابق مالی
    Route::get('/admin/payees/list', App\Livewire\Admin\Purchase\PayeeList::class)
        ->name('admin.payees.list');





    Route::get('/admin/projects/{project}/letters/create', App\Livewire\Admin\ProjectLetter\CreateLetter::class)
        ->name('admin.projects.letters.create');


    Route::post('/upload/tinymce/image', function (\Illuminate\Http\Request $request) {
        $request->validate([
            'image' => 'required|image|max:2048',
        ]);

        try {
            $path = $request->file('image')->store('tinymce', 'public');
            return response()->json([
                'location' => Storage::url($path),
                'message' => 'آپلود با موفقیت انجام شد.'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => [
                    'message' => 'خطا در آپلود تصویر: ' . $e->getMessage()
                ]
            ], 500);
        }
    })->name('upload.tinymce.image')->middleware('auth');






        Route::get('/admin/attendence/requests', App\Livewire\Admin\Attendence\Requests\Index::class)->name('admin.attendence.requests.index');
        Route::get('/admin/attendence/requests/create', App\Livewire\Admin\Attendence\Requests\Create::class)->name('admin.attendence.requests.create');
        Route::get('/admin/attendence/requests/{requestId}', App\Livewire\Admin\Attendence\Requests\Show::class)->name('admin.attendence.requests.show');
        Route::get('/admin/attendence/approvals/inbox', App\Livewire\Admin\Attendence\Requests\ApproverInbox::class)->name('admin.attendence.approvals.inbox');
        Route::get('/admin/attendence/managerule',App\Livewire\Admin\Attendence\ManageApprovalRules::class)->name('admin.attendence.managerule');

    Route::get('/admin/announcements/create', App\Livewire\Admin\Announcement\CreateAnnouncement::class)->name('admin.announcements.create');
    Route::get('/user/posts', App\Livewire\User\Posts::class)->name('user.posts');
    Route::get('/user/inbox', App\Livewire\User\Inbox::class)->name('user.inbox');
    Route::get('/admin/posts/create', App\Livewire\Admin\Post\CreatePost::class)->name('admin.create.post');
    Route::get('/post/{post}', App\Livewire\User\PostShow::class)->name('post.show');

    Route::get('/my-posts', App\Livewire\Admin\Post\MyPosts::class)->name('admin.my-posts');
    Route::get('/posts/{post}/edit', App\Livewire\Admin\Post\EditPost::class)->name('admin.posts.edit');
    Route::get('/categories', App\Livewire\Admin\Category\Index::class)->name('admin.categories.index');
    Route::get('/categories/{category}/edit', App\Livewire\Admin\Category\Upsert::class)->name('admin.categories.edit');

    // اطلاعیه‌های ارسالی من
    Route::get('/sent-announcements', App\Livewire\User\SentAnnouncements::class)->name('user.sent-announcements');

    Route::get(
        '/announcements/{announcement}/attachments.zip',
        AnnouncementAttachmentZipController::class
    )->name('announcements.attachments.zip');



//    Route::post('/logout', function () {
//        auth()->logout();
//        request()->session()->invalidate();
//        request()->session()->regenerateToken();
//        return redirect('/'); // یا هر صفحه‌ای که می‌خواهید کاربر به آن هدایت شود
//    })->name('logout');


//    Route::post('/logout', App\Livewire\Actions\Logout::class)
//        ->name('logout');


    Route::post('/logout', function (Logout $logout) {
        $logout();
        return redirect(route('login')); // یا فقط redirect('/login') اگر route به این صورت تعریف شده
    })->name('logout');




    Route::get('/clear-just-logged-in', ClearJustLoggedIn::class)->name('clear.just.logged.in')->middleware('auth');


});

