<div>
    
    <div class="container-fluid py-4">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card rounded-4 shadow-sm border-0">
                    <div class="card-header bg-gradient-primary text-white rounded-top-4 p-4">
                        <h4 class="mb-0 d-flex align-items-center">
                            <i class="fas fa-chart-line me-2"></i>
                            تنظیم درصد پیشرفت بر اساس نوع POI
                        </h4>
                        <p class="mb-0 mt-2 text-white-75 small">
                            هر مدرک بر اساس آخرین POI خود، درصد پیشرفت دریافت می‌کند.
                        </p>
                    </div>
                    <div class="card-body p-4">
                        <form wire:submit.prevent="save">
                            <div class="row g-4">
                                <?php $__currentLoopData = \App\Models\DocumentRevision::POI_TYPES; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6 col-lg-4">
                                        <div class="form-floating">
                                            <input
                                                type="number"
                                                step="0.01"
                                                min="0"
                                                max="100"
                                                wire:model="weights.<?php echo e($key); ?>"
                                                class="form-control rounded-3 shadow-sm"
                                                id="poi-<?php echo e($key); ?>"
                                                placeholder="0.00"
                                            >
                                            <label for="poi-<?php echo e($key); ?>">
                                                <?php echo e($label); ?> <span class="text-muted">(<?php echo e($key); ?>)</span>
                                            </label>
                                        </div>
                                        <div class="mt-2 text-end">
                                            <span class="badge bg-info text-dark"><?php echo e($weights[$key] ?? 0); ?>%</span>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <div class="mt-5 pt-4 border-top d-flex justify-content-between align-items-center">
                                <a href="<?php echo e(url()->previous()); ?>" class="btn btn-outline-secondary btn-modern">
                                    <i class="fas fa-arrow-right me-1"></i> بازگشت
                                </a>
                                <button type="submit" class="btn btn-success btn-modern px-4">
                                    <i class="fas fa-save me-2"></i> ذخیره تنظیمات
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- هشدار: جمع درصدها لزوماً 100 نیست -->
                <div class="alert alert-light mt-4 rounded-3 border border-info">
                    <i class="fas fa-info-circle text-info me-2"></i>
                    <strong>نکته:</strong> این درصد‌ها سطح پیشرفت هر POI را نشان می‌دهند (مثلاً IFA = 30%، AFC = 100%) و نیازی نیست جمع آن‌ها 100 شود.
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-control:focus {
            border-color: #6366f1;
            box-shadow: 0 0 0 0.25rem rgba(99, 102, 241, 0.25);
        }
        .btn-modern {
            border-radius: 8px;
            padding: 0.5rem 1rem;
            font-weight: 600;
            transition: all 0.2s ease;
        }
        .btn-modern:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\m-d-r\project-poi-settings.blade.php ENDPATH**/ ?>