<div>
    <div class="container-fluid">

        <?php if(session()->has('message')): ?>
            <div class="alert alert-success alert-dismissible fade show mt-2 shadow-sm rounded-3">
                <i class="ti ti-check me-2"></i>
                <?php echo e(session('message')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <div class="card shadow-lg rounded-3 border-0">
            <div class="card-body">
                <h5 class="mb-4 text-primary-dark d-flex align-items-center gap-2 border-bottom pb-2">
                    <i class="ti ti-chart-line fs-4"></i> مدیریت بودجه پروژه‌ها (وضعیت مالی)
                </h5>
                <div class="table-responsive">
                    <table class="table table-hover align-middle table-striped table-bordered budget-table">
                        <thead class="bg-primary-darker text-white sticky-top">
                        <tr>
                            <th style="width: 20%;">پروژه</th>
                            <th style="width: 15%;">بودجه کل (ریال)</th>
                            <th style="width: 15%;">مصرف‌شده (ریال)</th>
                            <th style="width: 15%;">باقی‌مانده (ریال)</th>
                            <th style="width: 20%;">درصد مصرف</th>
                            <th style="width: 15%;">عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $projectData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="<?php echo e($project->status_class); ?>">
                                <td class="fw-bold text-primary-dark"><?php echo e($project->name); ?></td>
                                <td class="text-info fw-bold"><?php echo e(number_format($project->budget)); ?></td>
                                <td class="text-danger-dark fw-bold"><?php echo e(number_format($project->spent)); ?></td>
                                <td class="fw-bold" style="color: <?php echo e($project->remaining < 0 ? '#dc3545' : '#198754'); ?>;">
                                    <?php echo e(number_format($project->remaining)); ?>

                                </td>
                                <td>
                                    <div class="progress progress-budget shadow-sm" style="height: 15px;">
                                        <div class="progress-bar
                                         <?php if($project->percent >= 100): ?> bg-danger
                                         <?php elseif($project->percent >= 80): ?> bg-warning
                                         <?php else: ?> bg-success <?php endif; ?>"
                                             style="width: <?php echo e($project->percent); ?>%">
                                            <?php echo e($project->percent); ?>%
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary-darker rounded-pill px-3"
                                            wire:click="editBudget(<?php echo e($project->id); ?>, <?php echo e($project->budget); ?>)">
                                        <i class="ti ti-edit me-1"></i> ویرایش
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted py-4">پروژه‌ای برای مدیریت بودجه یافت نشد.</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="modal fade" id="budgetModal" tabindex="-1" aria-labelledby="budgetModalLabel" aria-hidden="true" wire:ignore.self>
            <div class="modal-dialog">
                <div class="modal-content rounded-4 shadow-lg">
                    <div class="modal-header bg-primary-darker text-white rounded-top-4">
                        <h5 class="modal-title" id="budgetModalLabel">ویرایش بودجه پروژه</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form wire:submit.prevent="saveBudget">
                        <div class="modal-body p-4">
                            <div class="alert alert-info small fw-bold">
                                پروژه انتخابی: **<?php echo e($editProjectId); ?>**
                            </div>
                            <div class="mb-3">
                                <label for="newBudgetAmount" class="form-label fw-semibold">مبلغ بودجه جدید (ریال)</label>
                                <input type="number" min="0" class="form-control <?php $__errorArgs = ['newBudgetAmount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="newBudgetAmount" wire:model.defer="newBudgetAmount" placeholder="مبلغ بودجه جدید را وارد کنید">
                                <?php $__errorArgs = ['newBudgetAmount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-secondary rounded-pill px-4" data-bs-dismiss="modal">انصراف</button>
                            <button type="submit" class="btn btn-success rounded-pill px-4">
                                <i class="ti ti-device-floppy me-1"></i> ذخیره
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('livewire:initialized', () => {
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').on('open-budget-modal', () => {
                const modal = new bootstrap.Modal(document.getElementById('budgetModal'));
                modal.show();
            });
        });
    </script>

    <style>
        /* 💡 کلاس‌های سفارشی برای رنگ‌بندی تیره‌تر */
        :root {
            --bs-primary-darker: #004d99;
        }
        .text-primary-dark { color: var(--bs-primary-darker) !important; }
        .bg-primary-darker { background-color: var(--bs-primary-darker) !important; }
        .text-danger-dark { color: #dc3545 !important; }
        .table-darker-head th { background-color: #343a40 !important; color: white; }

        /* 💡 بهبود ظاهر */
        .shadow-lg { box-shadow: 0 5px 15px rgba(0, 0, 0, 0.15) !important; }
        .progress-bar { font-size: 0.7rem; }
        .progress-budget { height: 1.2rem !important; font-weight: bold; }
        .btn.rounded-pill { border-radius: 50px !important; }
        .btn-close-white { filter: brightness(0) invert(1); }
        .rounded-4 { border-radius: 1rem !important; }

        /* 💡 کلاس‌های وضعیت بودجه */
        .budget-exceeded { background-color: #fbeaea !important; border-left: 5px solid #dc3545; }
        .budget-warning { background-color: #fffbe6 !important; }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\purchase\project-budget-management.blade.php ENDPATH**/ ?>