<?php use Illuminate\Support\Str; ?>

<div class="container py-3" dir="rtl">
    <style>
        :root {
            --brand: #4f46e5;
            --brand2: #0ea5e9;
            --soft: #f8fafc;
            --card-radius: 16px;
            --field-radius: 12px;
            --bg: #ffffff;
            --text: #111827;
            --card: #f9fafb;
            --border: #e5e7eb;
        }
        .dark {
            --bg: #111827;
            --text: #f9fafb;
            --card: #1f2937;
            --border: #374151;
        }
        body {
            background-color: var(--bg);
            color: var(--text);
            transition: background-color 0.3s;
        }
        .bg-grad { background: linear-gradient(90deg, var(--brand) 0%, var(--brand2) 100%); }
        .mobile-topbar {
            display: none; position: sticky; top: 0; z-index: 30; padding: .6rem .9rem;
            background: linear-gradient(90deg, rgba(79,70,229,.95), rgba(14,165,233,.95));
            color: #fff; backdrop-filter: blur(6px);
        }
        .mobile-topbar h5 { font-size: 1rem; margin: 0; display: flex; align-items: center; gap: .5rem }
        .stepper { display: flex; gap: .5rem; flex-wrap: wrap }
        .step { display: flex; align-items: center; gap: .5rem; padding: .3rem .7rem; border-radius: 999px; background: #eef2ff; color: #374151 }
        .step.active { background: #dbeafe; color: #111827; font-weight: 600 }
        .chip { background: #eef2ff; border-radius: 999px; padding: .3rem .75rem; display: inline-flex; gap: .4rem; align-items: center; cursor: pointer; transition: .15s }
        .chip:hover { background: #e0e7ff }
        .chip.is-active { background: var(--brand); color: #fff }
        .muted { color: #6b7280 }
        .table thead th.sticky { position: sticky; top: 0; background: var(--card); z-index: 2; }
        .doc-card { border: 1px solid var(--border); border-radius: 14px; padding: .7rem; background: var(--card); }
        .doc-card .title { font-weight: 600 }
        .img-thumb { max-width: 80px; max-height: 60px; object-fit: cover; border-radius: .6rem; border: 1px solid var(--border); }
        .action-bar {
            position: sticky; bottom: .25rem; z-index: 25; background: var(--bg);
            padding: .6rem .75rem calc(env(safe-area-inset-bottom,0) + .6rem);
            box-shadow: 0 -8px 24px rgba(15,23,42,.06);
            border-radius: 12px;
        }
        .dropzone {
            border: 2px dashed #cbd5e1; border-radius: 14px; padding: 1rem; background: var(--soft);
            text-align: center; transition: .2s
        }
        .dropzone.dragover { background: #eef2ff; border-color: #93c5fd }
        .skeleton { position: relative; overflow: hidden; background: var(--border); border-radius: .35rem }
        .skeleton::after { content: ""; position: absolute; inset: 0; transform: translateX(-100%);
            background: linear-gradient(90deg, transparent, rgba(255,255,255,.3), transparent); animation: sh 1.2s infinite }
        @keyframes sh { to { transform: translateX(100%) } }

        .card { border-radius: var(--card-radius); overflow: hidden; background: var(--card); }
        .card-header { border-radius: var(--card-radius) var(--card-radius) 0 0; }
        .form-control, .form-select { border-radius: var(--field-radius); background: var(--bg); color: var(--text); }
        .btn { border-radius: 12px; }
        .form-label { font-size: .95rem; color: var(--text); }

        .form-check-input { width: 1.2rem; height: 1.2rem; }

        @media (max-width: 767.98px) {
            .mobile-topbar { display: flex; align-items: center; justify-content: space-between }
            .card-header { display: none }
            .container { padding-left: .6rem; padding-right: .6rem }
            .doc-card { padding: .6rem }
            .form-label { font-size: .9rem }
            .form-check-input { width: 1.35rem; height: 1.35rem }
        }
    </style>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css"/>

    <div class="mobile-topbar">
        <h5><i class="fas fa-paper-plane"></i> ثبت ترنسمیتال</h5>
        <?php if($step === 'form'): ?>
            <span class="small">انتخاب‌ها: <strong><?php echo e(count($selected_documents)); ?></strong></span>
        <?php else: ?>
            <button class="btn btn-sm btn-light" wire:click="previousStep">ویرایش</button>
        <?php endif; ?>
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-grad d-flex justify-content-between align-items-center">
            <h4 class="mb-0 text-white"><i class="fas fa-paper-plane"></i> ثبت ترنسمیتال</h4>
            <?php if($step === 'preview'): ?>
                <button wire:click="previousStep" class="btn btn-light btn-sm">بازگشت به فرم</button>
            <?php endif; ?>
        </div>

        <div class="card-body">
            <div class="stepper mb-3" aria-label="مراحل">
                <div class="step <?php echo e($step==='form' ? 'active' : ''); ?>"><span>۱</span><span>اطلاعات</span></div>
                <div class="step <?php echo e($step==='preview' ? 'active' : ''); ?>"><span>۲</span><span>پیش‌نمایش و ارسال</span></div>
            </div>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <strong>خطاهای فرم:</strong>
                    <ul class="mb-0"><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <li><?php echo e($error); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            <?php if(session()->has('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            <?php if(session()->has('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if($step === 'form'): ?>
                <form wire:submit.prevent="nextStep">
                    <?php if(!$isProjectSelected): ?>
                        <div class="mb-3">
                            <label class="form-label"><i class="far fa-folder-open ms-1"></i> انتخاب پروژه</label>
                            <div class="d-flex gap-2">
                                <select wire:model.live="project_id" class="form-select" aria-label="انتخاب پروژه">
                                    <option value="">پروژه را انتخاب کنید</option>
                                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($p->id); ?>"><?php echo e($p->name); ?> (<?php echo e($p->code ?? 'بدون کد'); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($project_id): ?>
                                    <button type="button" class="btn btn-outline-secondary" wire:click="clearProject">
                                        <i class="fas fa-rotate"></i>
                                    </button>
                                <?php endif; ?>
                            </div>
                            <?php $__errorArgs = ['project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php else: ?>
                        <div class="mb-3 d-flex align-items-center justify-content-between gap-2">
                            <div>
                                <label class="form-label mb-1">پروژه انتخاب‌شده</label>
                                <div class="chip is-active"><?php echo e($project_name); ?></div>
                            </div>
                            <button class="btn btn-sm btn-outline-secondary" type="button" wire:click="clearProject">تغییر</button>
                            <input type="hidden" wire:model="project_id">
                        </div>
                    <?php endif; ?>

                    <div class="mb-3">
                        <label class="form-label"><i class="far fa-file ms-1"></i> قالب ترنسمیتال</label>
                        <select wire:model.live="template_id" class="form-select">
                            <option value="">بدون قالب</option>
                            <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($t->id); ?>"><?php echo e($t->title); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="row g-3 mb-3 align-items-end">
                        <div class="col-12 col-md-3">
                            <label class="form-label">شماره (پیش‌نمایش)</label>
                            <input type="text" class="form-control" value="<?php echo e($transmittal_number_preview); ?>" readonly>
                        </div>
                        <div class="col-12 col-md-3" wire:ignore>
                            <label class="form-label">تاریخ (شمسی)</label>
                            <input id="pdp-trans-date" type="text" class="form-control" placeholder="YYYY/MM/DD"
                                   value="<?php echo e($transmittal_date_jalali); ?>">
                            <?php $__errorArgs = ['transmittal_date_jalali'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger d-block"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-6 col-md-3">
                            <label class="form-label">فرستنده</label>
                            <select wire:model="sender_id" class="form-select">
                                <option value="">انتخاب کنید</option>
                                <?php $__currentLoopData = $senders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-6 col-md-3">
                            <label class="form-label">گیرنده اصلی</label>
                            <select wire:model="receiver_id" class="form-select">
                                <option value="">انتخاب کنید</option>
                                <?php $__currentLoopData = $recipients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($r->id); ?>"><?php echo e($r->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['receiver_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row g-3 mb-3 align-items-end">
                        <div class="col-12 col-md-3">
                            <label class="form-label">هدف ارسال</label>
                            <select wire:model="purpose" class="form-select">
                                <option value="">انتخاب کنید</option>
                                <?php $__currentLoopData = $purposeOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($opt); ?>"><?php echo e($opt); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['purpose'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <div class="mt-2 d-flex flex-wrap gap-1">
                                <?php $__currentLoopData = $purposeOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="chip <?php echo e($purpose===$opt ? 'is-active' : ''); ?>" wire:click="$set('purpose','<?php echo e($opt); ?>')"><?php echo e($opt); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <div class="col-12 col-md-6">
                            <label class="form-label">توضیحات</label>
                            <input type="text" wire:model="description" class="form-control" placeholder="توضیحات (اختیاری)">
                        </div>

                        <div class="col-12 col-md-3">
                            <label class="form-label">پیوست‌ها</label>
                            <div
                                id="drop-area"
                                class="dropzone"
                                ondragover="event.preventDefault(); this.classList.add('dragover')"
                                ondragleave="this.classList.remove('dragover')"
                                ondrop="event.preventDefault(); this.classList.remove('dragover'); document.getElementById('attachments-input').files = event.dataTransfer.files; document.getElementById('attachments-input').dispatchEvent(new Event('change'));"
                            >
                                <div class="mb-1">فایل‌ها را بکشید و رها کنید</div>
                                <label for="attachments-input" class="btn btn-sm btn-outline-primary">انتخاب فایل</label>
                                <input id="attachments-input" type="file" wire:model="attachments" multiple class="d-none">
                                <div class="small muted mt-2">pdf, تصاویر، doc/x، xls/x | حداکثر ۵ فایل</div>
                            </div>
                            <?php $__errorArgs = ['attachments.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger d-block mt-1"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="mt-2" wire:loading wire:target="attachments">
                                <div class="progress"><div class="progress-bar progress-bar-striped progress-bar-animated" style="width:100%">در حال آپلود…</div></div>
                            </div>

                            <?php if($attachments): ?>
                                <div class="mt-2 d-flex flex-column gap-2">
                                    <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $att): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="d-flex align-items-center justify-content-between doc-card">
                                            <div class="d-flex align-items-center gap-2">
                                                <?php if(str_starts_with($att->getMimeType(),'image/')): ?>
                                                    <img class="img-thumb" src="<?php echo e($att->temporaryUrl()); ?>" alt="">
                                                <?php else: ?>
                                                    <i class="far fa-file fa-lg text-secondary"></i>
                                                <?php endif; ?>
                                                <div>
                                                    <div class="fw-semibold"><?php echo e($att->getClientOriginalName()); ?></div>
                                                    <div class="muted small"><?php echo e(number_format($att->getSize()/1024,1)); ?> KB</div>
                                                </div>
                                            </div>
                                            <button type="button" class="btn btn-sm btn-outline-danger" wire:click="removeAttachment(<?php echo e($idx); ?>)" aria-label="حذف پیوست">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">گیرنده‌های CC (اختیاری)</label>
                        <select wire:model="cc_recipients" class="form-select" multiple aria-label="گیرندگان CC">
                            <?php $__currentLoopData = $recipients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($r->id); ?>"><?php echo e($r->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <?php if($isProjectSelected): ?>
                        <div class="d-flex flex-wrap align-items-end justify-content-between gap-2 mb-2">
                            <div class="flex-grow-1">
                                <label class="form-label">جستجوی مدرک</label>
                                <div class="input-group">
                                    <input type="text" wire:model.debounce.500ms="searchTerm" class="form-control" placeholder="شماره سند یا عنوان">
                                    <?php if($searchTerm): ?>
                                        <button class="btn btn-outline-secondary" type="button" wire:click="$set('searchTerm','')">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="text-end">
                                <div class="small muted mb-1">
                                    انتخاب‌ها: <span class="fw-bold"><?php echo e(count($selected_documents)); ?></span>
                                    <span class="mx-2">|</span>
                                    نتایج صفحه: <span class="fw-bold"><?php echo e($documents->count()); ?></span>
                                </div>

                                <button type="button" class="btn btn-sm btn-outline-primary"
                                        wire:click="selectAllMatching"
                                    <?php if(!$documents->total()): echo 'disabled'; endif; ?>>
                                    انتخاب همه نتایج
                                </button>

                                <button type="button" class="btn btn-sm btn-outline-secondary"
                                        wire:click="clearSelection"
                                    <?php if(!count($selected_documents)): echo 'disabled'; endif; ?>>
                                    پاک‌سازی
                                </button>
                            </div>
                        </div>

                        <!-- موبایل: کارت‌ها -->
                        <div class="d-md-none">
                            <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $isChecked = in_array($doc->id, $selected_documents ?? []);
                                    $latestRevision = $doc->revisions->first();
                                ?>
                                <label class="doc-card mb-2 w-100" wire:key="doc-card-<?php echo e($doc->id); ?>">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="title"><?php echo e($doc->document_number); ?> — <?php echo e(Str::limit($doc->title, 50)); ?></div>
                                        <input class="form-check-input mt-1" type="checkbox" wire:model="selected_documents" value="<?php echo e($doc->id); ?>">
                                    </div>
                                    <div class="muted small mt-1">نسخه فعلی: <?php echo e($latestRevision?->revision ?? '—'); ?></div>

                                    <?php if($doc->revisions->count() && $isChecked): ?>
                                        <div class="mt-2">
                                            <select class="form-select form-select-sm" wire:model="selected_revisions.<?php echo e($doc->id); ?>">
                                                <option value="">انتخاب نسخه</option>
                                                <?php $__currentLoopData = $doc->revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($rev->id); ?>"><?php echo e($rev->revision); ?> — <?php echo e(jdate($rev->created_at)->format('Y/m/d')); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    <?php elseif(!$doc->revisions->count() && $isChecked): ?>
                                        <span class="badge bg-secondary mt-2">بدون رویژن</span>
                                    <?php endif; ?>
                                </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="text-muted text-center py-3">مدرکی برای این پروژه وجود ندارد.</div>
                            <?php endif; ?>
                            <div class="mt-2"><?php echo e($documents->links()); ?></div>
                        </div>

                        <!-- دسکتاپ: جدول -->
                        <div class="table-responsive d-none d-md-block">
                            <?php
                                $pageIds = $documents->pluck('id')->all();
                                $pageAllSelected = $documents->count() && count(array_intersect($pageIds, $selected_documents)) === $documents->count();
                                $dirIcon = fn($f)=> $docSortField===$f ? ($docSortDir==='asc'?'↑':'↓') : '↕';
                            ?>
                            <table class="table table-sm table-hover align-middle text-center">
                                <thead class="table-light">
                                <tr>
                                    <th class="sticky" style="width:60px;">
                                        <input type="checkbox" <?php if($pageAllSelected): echo 'checked'; endif; ?> wire:click="toggleSelectPage(<?php echo e($pageAllSelected ? 0 : 1); ?>)" aria-label="انتخاب همه صفحه">
                                    </th>
                                    <th class="sticky" style="width:160px;cursor:pointer" wire:click="sortDocsBy('document_number')">شماره سند <span class="small"><?php echo e($dirIcon('document_number')); ?></span></th>
                                    <th class="sticky" style="cursor:pointer" wire:click="sortDocsBy('title')">عنوان <span class="small"><?php echo e($dirIcon('title')); ?></span></th>
                                    <th class="sticky" style="width:180px;">شماره رویژن</th>
                                    <th class="sticky">توضیح</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $latestRevision = $doc->revisions->first();
                                    ?>
                                    <tr wire:key="doc-row-<?php echo e($doc->id); ?>">
                                        <td><input type="checkbox" wire:model="selected_documents" value="<?php echo e($doc->id); ?>"></td>
                                        <td class="text-monospace"><?php echo e($doc->document_number); ?></td>
                                        <td class="text-start" title="<?php echo e($doc->title); ?>"><?php echo e(Str::limit($doc->title, 60)); ?></td>
                                        <td>
                                            <?php if($doc->revisions->count()): ?>
                                                <select wire:model="selected_revisions.<?php echo e($doc->id); ?>" class="form-select form-select-sm">
                                                    <option value="">انتخاب نسخه</option>
                                                    <?php $__currentLoopData = $doc->revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($rev->id); ?>"><?php echo e($rev->revision); ?> — <?php echo e(jdate($rev->created_at)->format('Y/m/d')); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">بدون رویژن</span>
                                                <input type="hidden" wire:model="selected_revisions.<?php echo e($doc->id); ?>" value="">
                                            <?php endif; ?>
                                        </td>
                                        <td title="<?php echo e($doc->description); ?>"><?php echo e(Str::limit($doc->description, 60)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr><td colspan="5">
                                            <div class="skeleton" style="height:12px;margin:8px 0"></div>
                                            <div class="skeleton" style="height:12px;margin:8px 0"></div>
                                            <div class="skeleton" style="height:12px;margin:8px 0"></div>
                                        </td></tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                            <?php echo e($documents->links()); ?>

                        </div>
                    <?php endif; ?>

                    <div class="action-bar mt-3 d-flex justify-content-between align-items-center">
                        <div class="small muted">
                            <?php if(count($selected_documents)): ?>
                                <i class="fas fa-check-circle text-success"></i>
                                <?php echo e(count($selected_documents)); ?> مدرک انتخاب‌شده
                                <?php if($allMatchingSelected): ?>
                                    <span class="chip">همه نتایج انتخاب شده</span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <button type="submit" class="btn btn-primary btn-lg px-4"
                                wire:loading.attr="disabled" wire:target="nextStep,attachments">
                            <i class="fas fa-eye"></i> مرحله بعد
                        </button>
                    </div>
                </form>
            <?php endif; ?>

            <?php if($step === 'preview'): ?>
                <div class="p-3 bg-light rounded mb-3">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h5 class="mb-0">پیش‌نمایش</h5>
                        <button class="btn btn-sm btn-outline-secondary" wire:click="previousStep">ویرایش</button>
                    </div>
                    <div class="row g-2">
                        <div class="col-12 col-md-3"><div><strong>شماره:</strong> <?php echo e($transmittal_number_preview); ?></div></div>
                        <div class="col-12 col-md-3"><div><strong>پروژه:</strong> <?php echo e($project_name); ?></div></div>
                        <div class="col-12 col-md-3"><div><strong>فرستنده:</strong> <?php echo e($sender_name); ?></div></div>
                        <div class="col-12 col-md-3"><div><strong>گیرنده:</strong> <?php echo e($receiver_name); ?></div></div>
                        <div class="col-12 col-md-3"><div><strong>تاریخ (شمسی):</strong> <?php echo e($transmittal_date_jalali ?? '—'); ?></div></div>
                        <div class="col-12 col-md-3"><div><strong>هدف:</strong> <?php echo e($purpose ?: '—'); ?></div></div>
                        <div class="col-12 col-md-6"><div><strong>توضیحات:</strong> <?php echo e($description ?: '—'); ?></div></div>
                        <div class="col-12"><strong>گیرندگان CC:</strong>
                            <?php if($cc_names && count($cc_names)): ?>
                                <?php $__currentLoopData = $cc_names; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <span class="chip is-active"><?php echo e($n); ?></span> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?> <span class="muted">ندارد</span> <?php endif; ?>
                        </div>
                    </div>
                    <hr>
                    <div class="mb-2"><strong>مدارک انتخابی:</strong></div>
                    <?php if(count($previewDocs)): ?>
                        <ul class="mb-2">
                            <?php $__currentLoopData = $previewDocs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($pd['number']); ?> — <?php echo e($pd['title']); ?> (<?php echo e($pd['revision_label']); ?>)</li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php else: ?>
                        <div class="muted">مدرکی انتخاب نشده است.</div>
                    <?php endif; ?>

                    <div class="mb-2"><strong>پیوست‌ها:</strong></div>
                    <?php if($attachments && count($attachments)): ?>
                        <ul class="mb-0"><?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $att): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <li><?php echo e($att->getClientOriginalName()); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul>
                    <?php else: ?>
                        <div class="muted">فاقد پیوست</div>
                    <?php endif; ?>
                </div>

                <form wire:submit.prevent="saveTransmittal" onsubmit="return confirm('آیا از ارسال ترنسمیتال مطمئن هستید؟')">
                    <div class="text-end">
                        <button class="btn btn-success btn-lg px-5" wire:loading.attr="disabled" wire:target="saveTransmittal">
                            <i class="fas fa-save"></i> ذخیره و ارسال
                        </button>
                    </div>
                </form>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });

        document.addEventListener('livewire:initialized', () => {
            initPD();
            Livewire.hook('message.processed', () => initPD());

            function initPD(){
                if (!window.$ || !$.fn.pDatepicker) return;
                const $input = $('#pdp-trans-date');
                if (!$input.length) return;

                if ($input.data('hasPicker')){
                    $input.val(window.Livewire.find('<?php echo e($_instance->getId()); ?>').get('transmittal_date_jalali') || '');
                    return;
                }

                $input.pDatepicker({
                    initialValue: !!window.Livewire.find('<?php echo e($_instance->getId()); ?>').get('transmittal_date_jalali'),
                    format: 'YYYY/MM/DD',
                    autoClose: true,
                    calendarType: 'persian',
                    onSelect: function (unix) {
                        try{
                            const p = new persianDate(unix).format('YYYY/MM/DD');
                            $input.val(p);
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('transmittal_date_jalali', p);
                        }catch(e){}
                    }
                });

                $input.val(window.Livewire.find('<?php echo e($_instance->getId()); ?>').get('transmittal_date_jalali') || '');
                $input.data('hasPicker', true);
            }
        });
    </script>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\transmittal\create-transmittal.blade.php ENDPATH**/ ?>