<div class="container-fluid py-5" dir="rtl" style="font-family: 'Vazirmatn', sans-serif; background: #fcfdfe; min-height: 100vh;">
    <style>
        :root {
            --p-emerald: #059669;
            --p-teal: #0d9488;
            --p-dark: #064e3b;
            --p-border: #f1f5f9;
        }

        .reveal-up { animation: fadeInUp 0.8s cubic-bezier(0.16, 1, 0.3, 1) both; }
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }

        /* 🏔️ هدر پانوراما با گرادینت زمردی */
        .emerald-panorama {
            background: linear-gradient(135deg, var(--p-emerald) 0%, var(--p-dark) 100%);
            border-radius: 35px; padding: 60px; color: white;
            position: relative; overflow: hidden;
            box-shadow: 0 25px 50px -12px rgba(5, 150, 105, 0.25);
            margin-bottom: 50px;
        }
        /* افکت ذرات نوری در هدر */
        .emerald-panorama::after {
            content: ''; position: absolute; top: -10%; right: -5%; width: 350px; height: 350px;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
            border-radius: 50%;
        }

        /* ✨ ردیف‌های شناور مینیمال (Bento Rows) */
        .lux-row {
            background: #fff; border: 1px solid var(--p-border);
            border-radius: 26px; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            margin-bottom: 16px; padding: 22px 35px;
            display: flex; align-items: center; justify-content: space-between;
        }
        .lux-row:hover {
            transform: translateY(-5px) scale(1.005);
            border-color: var(--p-emerald);
            box-shadow: 0 15px 35px -10px rgba(0,0,0,0.06);
        }

        /* 🔍 اینپوت مدرن شیشه‌ای */
        .glass-input-wrapper {
            background: rgba(255, 255, 255, 0.12); border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 22px; padding: 14px 25px; color: white;
            backdrop-filter: blur(12px); transition: 0.3s; width: 100%;
            display: flex; align-items: center; gap: 12px;
        }
        .glass-input-wrapper:focus-within {
            background: rgba(255, 255, 255, 0.2); border-color: white;
            transform: translateY(-2px);
        }
        .glass-input-wrapper input {
            background: transparent; border: none; color: white; width: 100%; font-weight: 600;
        }
        .glass-input-wrapper input:focus { outline: none; }
        .glass-input-wrapper input::placeholder { color: rgba(255, 255, 255, 0.6); }

        /* 🔘 دکمه‌های اکشن نرم */
        .btn-soft-action {
            width: 48px; height: 48px; border-radius: 18px;
            display: flex; align-items: center; justify-content: center;
            background: #f8fafc; border: 1px solid #f1f5f9;
            color: #64748b; transition: 0.3s;
        }
        .btn-edit:hover { background: var(--p-emerald); color: white; border-color: var(--p-emerald); transform: rotate(-8deg); }
        .btn-delete:hover { background: #fee2e2; color: #ef4444; border-color: #fecaca; transform: rotate(8deg); }

        .code-tag {
            font-family: 'JetBrains Mono', monospace; font-size: 0.8rem;
            background: #ecfdf5; color: #065f46; padding: 6px 18px;
            border-radius: 12px; font-weight: 800; border: 1px solid #d1fae5;
        }
    </style>

    <div class="emerald-panorama reveal-up">
        <div class="row align-items-center g-4 position-relative z-index-2">
            <div class="col-lg-7">
                <div class="d-flex align-items-center gap-3 mb-4">
                    <span class="badge bg-white bg-opacity-20 rounded-pill px-3 py-2 fw-bold small">CORE ARCHITECTURE</span>
                    <span class="opacity-50 text-white">|</span>
                    <span class="small fw-bold text-white">DATABASE V2.0</span>
                </div>
                <h1 class="fw-black display-3 mb-3 text-white">لایه‌های اطلاعاتی</h1>
                <p class="opacity-80 fs-5 mb-0 lh-lg">ساختاردهی هوشمند انواع پروژه‌ها جهت خوشه‌بندی دقیق داده‌های عملیاتی سازمان.</p>
            </div>

            <div class="col-lg-5">
                <div class="glass-input-wrapper">
                    <i class="ti ti-search fs-4 opacity-70"></i>
                    <input type="text" wire:model.live.debounce.400ms="search" placeholder="جستجو در دایرکتوری...">
                </div>
                <div class="mt-3 d-flex gap-3 text-white opacity-60 small fw-bold px-2">
                    <span><i class="ti ti-check me-1"></i> فیلتر آنی</span>
                    <span><i class="ti ti-refresh me-1"></i> نوسازی خودکار</span>
                </div>
            </div>
        </div>
    </div>

    <div class="container px-4 reveal-up" style="animation-delay: 0.2s">
        <div class="row px-5 mb-4 text-muted small fw-black opacity-60 text-uppercase letter-spacing-1">
            <div class="col-md-5">Identifier & Status</div>
            <div class="col-md-3 text-center">System Slug</div>
            <div class="col-md-2 text-center">Registration</div>
            <div class="col-md-2 text-center pe-4">Actions</div>
        </div>

        <?php $__empty_1 = true; $__currentLoopData = $projectTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="lux-row" wire:key="type-<?php echo e($type->id); ?>">
                <div class="col-md-5 d-flex align-items-center gap-4">
                    <div class="icon-square bg-emerald rounded-4 d-flex align-items-center justify-content-center shadow-sm" style="width: 52px; height: 52px; background: linear-gradient(135deg, #34d399 0%, #059669 100%); color: white;">
                        <i class="ti ti-tag fs-4"></i>
                    </div>
                    <div>
                        <span class="fw-black text-dark fs-5 d-block mb-1"><?php echo e($type->name); ?></span>
                        <div class="d-flex align-items-center gap-2">
                            <span class="status-dot bg-success" style="width: 7px; height: 7px; border-radius: 50%;"></span>
                            <span class="text-muted small fw-bold">Active Module</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-3 text-center">
                    <span class="code-tag"><?php echo e($type->slug); ?></span>
                </div>

                <div class="col-md-2 text-center d-flex flex-column align-items-center border-start border-end border-light">
                    <span class="fw-black text-dark small"><?php echo e(jdate($type->created_at)->format('Y/m/d')); ?></span>
                    <small class="text-muted" style="font-size: 0.6rem;"><?php echo e(jdate($type->created_at)->ago()); ?></small>
                </div>

                <div class="col-md-2 d-flex justify-content-center gap-3">
                    <a href="#" class="btn-soft-action btn-edit shadow-xs" title="ویرایش"><i class="ti ti-edit-circle fs-4"></i></a>
                    <button wire:click="deleteType(<?php echo e($type->id); ?>)"
                            wire:confirm="آیا از پاکسازی این لایه اطمینان دارید؟"
                            class="btn-soft-action btn-delete shadow-xs" title="حذف">
                        <i class="ti ti-trash-x fs-4"></i>
                    </button>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center py-5 bg-white rounded-5 border border-dashed">
                <div class="opacity-20 py-5">
                    <i class="ti ti-database-off fs-1 d-block mb-3"></i>
                    <p class="fw-black fs-4">بانک اطلاعاتی خالی است.</p>
                </div>
            </div>
        <?php endif; ?>

        <div class="d-flex justify-content-between align-items-center mt-5 px-3">
            <div class="text-muted small fw-black">
                <span class="p-2 bg-light rounded-3">Total: <?php echo e($projectTypes->total()); ?> Records</span>
            </div>
            <div class="lux-pagination shadow-sm rounded-pill overflow-hidden border">
                <?php echo e($projectTypes->links('livewire::bootstrap')); ?>

            </div>
        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\type\project-type-list.blade.php ENDPATH**/ ?>