<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">

            <div class="d-flex align-items-center mb-4 animate__animated animate__fadeInDown">
                <div class="icon-box bg-primary-gradient shadow-primary me-3">
                    <i class="ti ti-folder-plus fs-7 text-white"></i>
                </div>
                <div>
                    <h3 class="fw-black color-navy mb-0"><?php echo e($projectId ? 'ویرایش پروژه فنی' : 'تعریف پروژه جدید'); ?></h3>
                    <p class="text-muted small mb-0">اطلاعات پایه پروژه را در این بخش وارد نمایید</p>
                </div>
            </div>

            <div class="card border-0 shadow-soft rounded-5 overflow-hidden animate__animated animate__fadeInUp">
                <div class="card-body p-4 p-md-5">
                    <form wire:submit.prevent="save">

                        <div class="mb-4 group">
                            <label for="name" class="form-label fw-bold color-navy">
                                <i class="ti ti-pencil me-1 text-primary"></i> نام پروژه
                            </label>
                            <div class="input-group-modern">
                                <input type="text" id="name" wire:model.defer="name"
                                       class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       placeholder="مثال: برج مسکونی آفتاب">
                                <div class="input-focus-line"></div>
                            </div>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="error-text animate__animated animate__headShake"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-5 group">
                            <label for="code" class="form-label fw-bold color-navy">
                                <i class="ti ti-barcode me-1 text-primary"></i> کد اختصاصی (انگلیسی)
                            </label>
                            <div class="input-group-modern">
                                <input type="text" id="code" wire:model.defer="code"
                                       class="form-control text-uppercase <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       placeholder="مثال: PRJ-2024-X" dir="ltr">
                                <div class="input-focus-line"></div>
                            </div>
                            <small class="text-muted mt-1 d-block smaller">این کد به عنوان شناسه در نامه‌نگاری‌ها استفاده می‌شود.</small>
                            <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="error-text animate__animated animate__headShake"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary-lux flex-grow-1 py-3 rounded-4 shadow-primary-sm" wire:loading.attr="disabled">
                                <span wire:loading.remove>
                                    <i class="ti ti-device-floppy me-1"></i> <?php echo e($projectId ? 'ذخیره تغییرات' : 'ثبت و ایجاد پروژه'); ?>

                                </span>
                                <span wire:loading>
                                    <span class="spinner-border spinner-border-sm me-2"></span> در حال ثبت...
                                </span>
                            </button>

                            <a href="<?php echo e(route('admin.projects')); ?>" wire:navigate class="btn btn-light-lux py-3 px-4 rounded-4">
                                انصراف
                            </a>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>

    <style>
        /* تم اختصاصی لوکس */
        .color-navy { color: #0f172a; }
        .fw-black { font-weight: 900 !important; }

        .bg-primary-gradient {
            background: linear-gradient(135deg, #6366f1 0%, #4338ca 100%);
        }

        .icon-box {
            width: 60px;
            height: 60px;
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .shadow-primary { box-shadow: 0 10px 20px -5px rgba(99, 102, 241, 0.5); }
        .shadow-soft { box-shadow: 0 20px 40px -10px rgba(0,0,0,0.05); }

        /* استایل فیلدهای ورودی مدرن */
        .input-group-modern {
            position: relative;
        }

        .input-group-modern .form-control {
            border: 2px solid #f1f5f9;
            background: #f8fafc;
            padding: 12px 15px;
            border-radius: 15px;
            transition: all 0.3s;
            font-weight: 600;
        }

        .input-group-modern .form-control:focus {
            background: #fff;
            border-color: #6366f1;
            box-shadow: 0 0 0 4px rgba(99, 102, 241, 0.1);
        }

        .error-text {
            color: #ef4444;
            font-size: 0.8rem;
            font-weight: 700;
            margin-top: 5px;
            display: block;
        }

        /* دکمه‌های پرمیوم */
        .btn-primary-lux {
            background: #0f172a;
            color: white;
            border: none;
            font-weight: 800;
            transition: 0.3s;
        }

        .btn-primary-lux:hover {
            background: #6366f1;
            transform: translateY(-3px);
            color: white;
        }

        .btn-light-lux {
            background: #f1f5f9;
            color: #64748b;
            border: none;
            font-weight: 700;
        }

        .btn-light-lux:hover {
            background: #e2e8f0;
            color: #0f172a;
        }

        .smaller { font-size: 0.75rem; }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\project-create-or-rename.blade.php ENDPATH**/ ?>