<div class="container-fluid py-4">

    <?php if(session()->has('success') || session()->has('error')): ?>
        <div class="alert alert-<?php echo e(session()->has('success') ? 'success' : 'danger'); ?> alert-dismissible fade show rounded-3 shadow-sm mb-4" role="alert">
            <i class="ti ti-<?php echo e(session()->has('success') ? 'check' : 'alert-triangle'); ?> me-2"></i>
            <span class="fw-semibold"><?php echo e(session('success') ?? session('error')); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row g-4">
        <!-- فرم اصلی -->
        <div class="col-lg-8">
            <div class="card shadow-lg border-0 rounded-4">
                <div class="card-header bg-gradient-deep-blue text-white py-4 rounded-top-4">
                    <h4 class="mb-0 fw-bold d-flex align-items-center">
                        <i class="ti ti-wallet me-2"></i>
                        اطلاعات مالی پروژه
                        <span class="text-action-primary ms-2">«<?php echo e($project->name); ?>»</span>
                    </h4>
                    <p class="mb-0 mt-1 text-white-75">مدیریت ارزش قرارداد، واحد پولی و نرخ تبدیل</p>
                </div>

                <div class="card-body p-5">
                    <form wire:submit.prevent="saveFinancialDetail">
                        <div class="row g-4">

                            <!-- ارزش قرارداد -->
                            <div class="col-12">
                                <label class="form-label fw-medium text-primary-dark d-flex align-items-center">
                                    <i class="ti ti-currency-dollar me-2 text-muted fs-5"></i>
                                    ارزش قرارداد
                                </label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text bg-white border-end-0 fw-bold text-primary">
                                        <?php echo e($this->currencyIcon); ?>

                                    </span>
                                    <input
                                        type="text"
                                        wire:model.live="display_contract_value"
                                        class="form-control form-control-lg border-start-0 text-end <?php $__errorArgs = ['contract_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="مثلاً: 5,000,000,000"
                                        inputmode="decimal"
                                    >
                                </div>
                                <?php $__errorArgs = ['contract_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- واحد پولی -->
                            <div class="col-12 col-md-6">
                                <label class="form-label fw-medium text-primary-dark">
                                    <i class="ti ti-world me-2 text-muted fs-5"></i>
                                    واحد پولی
                                </label>
                                <select
                                    wire:model.live="currency_unit"
                                    class="form-select form-select-lg"
                                >
                                    <option value="IRR">ریال ایران (IRR) — ﷼</option>
                                    <option value="USD">دلار آمریکا (USD) — $</option>
                                    <option value="EUR">یورو (EUR) — €</option>
                                    <option value="GBP">پوند استرلینگ (GBP) — £</option>
                                    <option value="AED">درهم امارات (AED) — د.إ</option>
                                    <option value="CAD">دلار کانادا (CAD) — C$</option>
                                    <option value="JPY">ین ژاپن (JPY) — ¥</option>
                                    <option value="TRY">لیر ترکیه (TRY) — ₺</option>
                                    <option value="CNY">یوان چین (CNY) — ¥</option>
                                </select>
                            </div>

                            <!-- نرخ تبدیل -->
                            <div class="col-12 col-md-6">
                                <label class="form-label fw-medium text-primary-dark d-flex align-items-center">
                                    <i class="ti ti-exchange me-2 text-muted fs-5"></i>
                                    نرخ تبدیل (به ریال)
                                    <?php if($currency_unit !== 'IRR'): ?>
                                        <span class="badge bg-info ms-2">پیشنهادی: <?php echo e(number_format($exchangeRates[$currency_unit] ?? 0)); ?></span>
                                    <?php endif; ?>
                                </label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text bg-white border-end-0">﷼</span>
                                    <input
                                        type="text"
                                        wire:model.live="display_exchange_rate"
                                        class="form-control form-control-lg border-start-0 text-end <?php $__errorArgs = ['exchange_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="<?php echo e($currency_unit !== 'IRR' ? 'مثلاً: 580,000' : '—'); ?>"
                                        <?php echo e($currency_unit === 'IRR' ? 'disabled' : ''); ?>

                                        inputmode="decimal"
                                    >
                                </div>
                                <?php $__errorArgs = ['exchange_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                        </div>

                        <div class="mt-5 d-flex justify-content-end">
                            <a href="<?php echo e(route('single.project.dashboard', $project->id)); ?>" class="btn btn-outline-secondary me-3 px-4 py-2">
                                <i class="ti ti-arrow-left me-2"></i> بازگشت
                            </a>
                            <button
                                type="submit"
                                class="btn btn-action-primary fw-bold px-5 py-2 d-flex align-items-center"
                                wire:loading.attr="disabled"
                            >
                                <span wire:loading.remove wire:target="saveFinancialDetail">
                                    <i class="ti ti-device-floppy me-2"></i> ذخیره اطلاعات مالی
                                </span>
                                <span wire:loading wire:target="saveFinancialDetail" class="d-flex align-items-center">
                                    <span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                                    در حال ذخیره...
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- کارت خلاصه مالی -->
        <div class="col-lg-4">
            <div class="card shadow-lg border-0 rounded-4 h-100">
                <div class="card-header bg-gradient-action-blue text-white py-3 rounded-top-4">
                    <h5 class="mb-0 fw-bold d-flex align-items-center">
                        <i class="ti ti-report-money me-2"></i> خلاصه مالی
                    </h5>
                </div>
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between mb-3">
                        <span class="text-muted">واحد پولی:</span>
                        <span class="fw-bold"><?php echo e($currency_unit); ?> <?php echo e($this->currencyIcon); ?></span>
                    </div>
                    <div class="d-flex justify-content-between mb-3">
                        <span class="text-muted">ارزش قرارداد:</span>
                        <span class="fw-bold"><?php echo e($display_contract_value ?: '—'); ?></span>
                    </div>
                    <?php if($currency_unit !== 'IRR' && $exchange_rate): ?>
                        <div class="d-flex justify-content-between mb-3">
                            <span class="text-muted">نرخ تبدیل:</span>
                            <span class="fw-bold"><?php echo e(number_format($exchange_rate)); ?> ریال</span>
                        </div>
                    <?php endif; ?>
                    <?php if($this->rialValue): ?>
                        <div class="d-flex justify-content-between pt-3 border-top">
                            <span class="text-muted">معادل ریال:</span>
                            <span class="fw-bold text-success">
            <?php echo e(number_format($this->rialValue)); ?> ریال
                            </span>
                        </div>
                    <?php endif; ?>

                    <?php if(!$contract_value): ?>
                        <div class="text-center mt-4 text-muted">
                            <i class="ti ti-info-circle fs-2 d-block mb-2"></i>
                            <p class="mb-0">اطلاعات مالی وارد نشده است.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- نکته راهنما -->
            <div class="card shadow-sm border-0 rounded-4 mt-4">
                <div class="card-body p-3">
                    <small class="text-muted d-flex align-items-start">
                        <i class="ti ti-lightbulb me-2 mt-1 text-warning"></i>
                        <span>اعداد به صورت خودکار سه‌رقمی جدا می‌شوند. برای ورود اعشار از نقطه (.) استفاده کنید.</span>
                    </small>
                </div>
            </div>
        </div>
    </div>

</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\financial\financial-detail-create.blade.php ENDPATH**/ ?>