<div class="container py-5 px-3">
    <div x-data="{ activeTab: 'personal' }" class="row justify-content-center">
        <div class="col-12 col-xl-10">

            <div class="profile-main-card mb-4 animate__animated animate__fadeIn">
                <div class="profile-cover"></div>
                <div class="profile-content p-4 d-flex flex-column flex-md-row align-items-center gap-4">
                    <div class="position-relative">
                        <div class="avatar-container">
                            <?php if($image_preview): ?>
                                <img src="<?php echo e($image_preview); ?>" class="profile-avatar-img" />
                            <?php else: ?>
                                <div class="profile-avatar-placeholder">
                                    <i class="ti ti-user fs-1"></i>
                                </div>
                            <?php endif; ?>
                            <div class="online-status <?php echo e($is_active ? 'active' : 'inactive'); ?>"
                                 title="<?php echo e($is_active ? 'حساب فعال' : 'حساب غیرفعال'); ?>"></div>
                        </div>
                    </div>
                    <div class="profile-info text-center text-md-end flex-grow-1">
                        <h2 class="user-name mb-1"><?php echo e($name ?: 'کاربر جدید'); ?></h2>
                        <div class="user-badges d-flex flex-wrap justify-content-center justify-content-md-start gap-2 mt-2">
                            <span class="badge-modern badge-role">
                                <i class="ti ti-shield-check me-1"></i> <?php echo e($roles[$role] ?? 'بدون نقش'); ?>

                            </span>
                            <span class="badge-modern badge-email">
                                <i class="ti ti-mail me-1"></i> <?php echo e($email); ?>

                            </span>
                        </div>
                    </div>
                    <div class="action-zone">
                        <button wire:click="save" wire:loading.attr="disabled" class="btn-modern-save">
                            <span wire:loading.remove wire:target="save">
                                <i class="ti ti-device-floppy fs-4"></i> بروزرسانی
                            </span>
                            <span wire:loading wire:target="save" class="spinner-border spinner-border-sm"></span>
                        </button>
                    </div>
                </div>
            </div>

            <div class="segmented-control mb-4 animate__animated animate__fadeInUp animate__delay-1s">
                <button @click="activeTab = 'personal'" :class="{ 'selected': activeTab === 'personal' }">
                    <i class="ti ti-user-edit"></i> <span>اطلاعات فردی</span>
                </button>
                <button @click="activeTab = 'media'" :class="{ 'selected': activeTab === 'media' }">
                    <i class="ti ti-photo-circle"></i> <span>رسانه و امضا</span>
                </button>
                <button @click="activeTab = 'security'" :class="{ 'selected': activeTab === 'security' }">
                    <i class="ti ti-lock-square"></i> <span>امنیت</span>
                </button>
            </div>

            <div class="content-glass-card animate__animated animate__fadeInUp animate__delay-1s">
                <div class="card-body p-4 p-md-5">

                    <div x-show="activeTab === 'personal'" x-transition:enter="fade-in-up">
                        <div class="row g-4">
                            <div class="col-md-6 field-group">
                                <label class="field-label">نام و نام خانوادگی</label>
                                <div class="smart-input-group">
                                    <i class="ti ti-user-check"></i>
                                    <input type="text" wire:model.defer="name" placeholder="مثلا: علی علوی" />
                                </div>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="error-text"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 field-group">
                                <label class="field-label">کد ملی</label>
                                <div class="smart-input-group">
                                    <i class="ti ti-id"></i>
                                    <input type="text" wire:model.defer="ncode" maxlength="10" />
                                </div>
                                <?php $__errorArgs = ['ncode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="error-text"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 field-group">
                                <label class="field-label">شماره موبایل</label>
                                <div class="smart-input-group">
                                    <i class="ti ti-device-mobile"></i>
                                    <input type="tel" wire:model.defer="mobile" dir="ltr" />
                                </div>
                            </div>
                            <div class="col-md-6 field-group">
                                <label class="field-label">شماره داخلی</label>
                                <div class="smart-input-group">
                                    <i class="ti ti-phone-incoming"></i>
                                    <input type="text" wire:model.defer="internal_number" />
                                </div>
                            </div>
                            <div class="col-md-6 field-group">
                                <label class="field-label">سازمان / شرکت</label>
                                <div class="smart-input-group">
                                    <i class="ti ti-building-skyscraper"></i>
                                    <select wire:model.live="company_id">
                                        <option value="">انتخاب کنید...</option>
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 field-group">
                                <label class="field-label">واحد سازمانی</label>
                                <div class="smart-input-group">
                                    <i class="ti ti-hierarchy-2"></i>
                                    <select wire:model.defer="department_id" <?php if(!$company_id): echo 'disabled'; endif; ?>>
                                        <option value="">انتخاب کنید...</option>
                                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($dep->id); ?>"><?php echo e($dep->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div x-show="activeTab === 'media'" x-transition:enter="fade-in-up">
                        <div class="row g-5 justify-content-center">
                            <div class="col-md-5 text-center">
                                <div class="upload-art-card">
                                    <div class="art-title">تصویر پروفایل</div>
                                    <div class="avatar-upload-circle position-relative mx-auto my-4">
                                        <?php if($image_preview): ?>
                                            <img src="<?php echo e($image_preview); ?>" />
                                        <?php endif; ?>
                                        <label for="img-up" class="btn-plus-icon"><i class="ti ti-camera-plus"></i></label>
                                    </div>
                                    <input type="file" id="img-up" wire:model="image" class="d-none" />
                                    <span class="upload-hint">حداکثر ۲ مگابایت (JPG/PNG)</span>
                                </div>
                            </div>
                            <div class="col-md-5 text-center">
                                <div class="upload-art-card">
                                    <div class="art-title">امضای دیجیتال</div>
                                    <div class="sign-upload-box position-relative mx-auto my-4">
                                        <?php if($sign_preview): ?>
                                            <img src="<?php echo e($sign_preview); ?>" />
                                        <?php endif; ?>
                                        <label for="sign-up" class="btn-plus-icon"><i class="ti ti-signature"></i></label>
                                    </div>
                                    <input type="file" id="sign-up" wire:model="sign" class="d-none" />
                                    <span class="upload-hint">تصویر با پس‌زمینه شفاف (حداکثر ۱ مگابایت)</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div x-show="activeTab === 'security'" x-transition:enter="fade-in-up">
                        <div class="security-wrapper mx-auto">
                            <div class="alert-modern-info mb-4">
                                <i class="ti ti-alert-circle"></i> جهت امنیت بیشتر، رمز عبوری ترکیبی انتخاب کنید.
                            </div>
                            <form wire:submit.prevent="changePassword" class="row g-4">
                                <div class="col-12 field-group">
                                    <label class="field-label">رمز عبور فعلی</label>
                                    <div class="smart-input-group">
                                        <i class="ti ti-lock-access"></i>
                                        <input type="password" wire:model.defer="current_password" placeholder="••••••••" />
                                    </div>
                                    <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="error-text"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-12 field-group">
                                    <label class="field-label">رمز عبور جدید</label>
                                    <div class="smart-input-group">
                                        <i class="ti ti-key-plus"></i>
                                        <input type="password" wire:model.defer="new_password" placeholder="••••••••" />
                                    </div>
                                    <?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="error-text"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-12 field-group">
                                    <label class="field-label">تکرار رمز عبور جدید</label>
                                    <div class="smart-input-group">
                                        <i class="ti ti-circle-check"></i>
                                        <input type="password" wire:model.defer="new_password_confirmation" placeholder="••••••••" />
                                    </div>
                                </div>
                                <div class="col-12 mt-5">
                                    <button type="submit" class="btn-modern-primary w-100">بروزرسانی امنیت حساب</button>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <style>
        :root {
            --accent: #6366f1;
            --accent-light: #eef2ff;
            --glass-bg: rgba(255, 255, 255, 0.85);
            --input-border: #e2e8f0;
            --text-main: #1e293b;
        }

        /* Profile Header Arched Style */
        .profile-main-card {
            background: #fff;
            border-radius: 24px;
            overflow: hidden;
            box-shadow: 0 10px 40px rgba(0,0,0,0.04);
            position: relative;
        }

        .profile-cover {
            height: 100px;
            background: linear-gradient(135deg, #6366f1, #a855f7);
            opacity: 0.15;
        }

        .avatar-container {
            width: 130px;
            height: 130px;
            margin-top: -65px;
            position: relative;
        }

        .profile-avatar-img, .profile-avatar-placeholder {
            width: 100%;
            height: 100%;
            border-radius: 35px;
            object-fit: cover;
            border: 6px solid #fff;
            box-shadow: 0 15px 35px rgba(99, 102, 241, 0.2);
        }

        .profile-avatar-placeholder {
            background: linear-gradient(135deg, #6366f1, #a855f7);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .online-status {
            position: absolute;
            bottom: 8px;
            right: 8px;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            border: 4px solid #fff;
        }
        .online-status.active { background: #10b981; }
        .online-status.inactive { background: #f43f5e; }

        .user-name { font-weight: 800; color: var(--text-main); font-size: 1.8rem; }

        .badge-modern {
            padding: 6px 14px;
            border-radius: 12px;
            font-size: 0.85rem;
            font-weight: 600;
        }
        .badge-role { background: var(--accent-light); color: var(--accent); }
        .badge-email { background: #f1f5f9; color: #64748b; }

        /* Segmented Control (iOS Style) */
        .segmented-control {
            display: flex;
            background: #e2e8f0;
            padding: 4px;
            border-radius: 16px;
            gap: 4px;
        }

        .segmented-control button {
            flex: 1;
            padding: 10px;
            border: none;
            border-radius: 12px;
            background: transparent;
            color: #64748b;
            font-weight: 600;
            transition: 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .segmented-control button.selected {
            background: white;
            color: var(--accent);
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        }

        /* Smart Inputs */
        .smart-input-group {
            position: relative;
            display: flex;
            align-items: center;
        }

        .smart-input-group i {
            position: absolute;
            right: 16px;
            color: #94a3b8;
            font-size: 1.2rem;
            transition: 0.3s;
        }

        .smart-input-group input, .smart-input-group select {
            width: 100%;
            padding: 14px 48px 14px 16px;
            border-radius: 16px;
            border: 2px solid #f1f5f9;
            background: #f8fafc;
            transition: 0.3s;
            color: var(--text-main);
            font-weight: 500;
        }

        .smart-input-group input:focus {
            outline: none;
            border-color: var(--accent);
            background: #fff;
            box-shadow: 0 0 0 4px rgba(99, 102, 241, 0.1);
        }

        .smart-input-group:focus-within i { color: var(--accent); }

        .field-label {
            font-weight: 700;
            margin-bottom: 8px;
            color: #475569;
            font-size: 0.9rem;
            display: block;
        }

        /* Buttons */
        .btn-modern-save, .btn-modern-primary {
            background: linear-gradient(135deg, #6366f1, #8b5cf6);
            color: white;
            padding: 14px 28px;
            border-radius: 16px;
            border: none;
            font-weight: 700;
            transition: 0.3s;
            box-shadow: 0 10px 20px rgba(99, 102, 241, 0.2);
        }

        .btn-modern-save:hover { transform: translateY(-3px); box-shadow: 0 15px 30px rgba(99, 102, 241, 0.3); }

        /* Media Upload Art */
        .upload-art-card {
            background: white;
            border-radius: 24px;
            padding: 24px;
            border: 2px dashed #e2e8f0;
            transition: 0.3s;
        }
        .upload-art-card:hover { border-color: var(--accent); background: var(--accent-light); }

        .avatar-upload-circle { width: 140px; height: 140px; }
        .avatar-upload-circle img { width: 100%; height: 100%; border-radius: 50%; object-fit: cover; }

        .sign-upload-box { width: 220px; height: 110px; background: #fff; border-radius: 16px; }
        .sign-upload-box img { width: 100%; height: 100%; object-contain; }

        .btn-plus-icon {
            position: absolute;
            bottom: 0;
            left: 0;
            background: var(--accent);
            color: white;
            width: 40px;
            height: 40px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }

        .art-title { font-weight: 700; color: #334155; margin-bottom: 4px; }
        .upload-hint { font-size: 0.75rem; color: #94a3b8; }

        .error-text { color: #f43f5e; font-size: 0.8rem; margin-top: 6px; display: block; font-weight: 600; }

        .fade-in-up { animation: fadeInUp 0.4s ease forwards; }
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }

        .content-glass-card { background: var(--glass-bg); border-radius: 24px; border: 1px solid #fff; box-shadow: 0 10px 40px rgba(0,0,0,0.04); }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\user\profile-form.blade.php ENDPATH**/ ?>