<div class="container-fluid py-4 rtl" style="font-family: 'Vazirmatn', 'Segoe UI', sans-serif;">
    <style>
        .hover-shadow:hover {
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1) !important;
            transform: translateY(-2px);
            transition: all 0.3s ease;
        }

        .form-control:focus, .form-control:focus~.invalid-feedback {
            box-shadow: 0 0 0 0.2rem rgba(139, 92, 246, 0.25);
            border-color: #8b5cf6;
        }

        .btn-primary {
            background: linear-gradient(90deg, #8b5cf6, #6366f1);
            border: none;
            transition: all 0.3s ease;
        }
    </style>

    <div class="row justify-content-center">
        <div class="col-12 col-lg-8">
            <?php if(session()->has('message')): ?>
                <div class="alert alert-success alert-dismissible fade show d-flex align-items-center mb-4 border-0 shadow-sm" role="alert" style="background: linear-gradient(90deg, #10b981, #059669); color: white;">
                    <i class="ti ti-check-circle fs-4 me-3"></i>
                    <div class="flex-grow-1 fw-medium"><?php echo e(session('message')); ?></div>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="card border-0 shadow-lg rounded-4 overflow-hidden">
                <div class="card-header bg-gradient-to-r from-violet-600 to-indigo-600 text-white py-4 text-center"
                     style="background: linear-gradient(90deg, #8b5cf6, #6366f1);">
                    <h3 class="mb-0 fw-bold d-flex align-items-center justify-content-center gap-2">
                        <i class="ti ti-building-plus fs-3"></i>
                        ثبت شرکت جدید
                    </h3>
                    <p class="mb-0 opacity-90 mt-2">اطلاعات شرکت را به دقت وارد کنید</p>
                </div>
                <div class="card-body p-4 p-md-5">
                    
                    <form wire:submit.prevent="saveCompany" enctype="multipart/form-data">
                        <div class="row g-4">
                            <div class="col-12 col-md-6">
                                <div class="bg-white rounded-3 p-3 border shadow-sm hover-shadow">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="ti ti-building fs-5 text-primary"></i>
                                        <label class="mb-0 fw-medium text-dark">نام شرکت</label>
                                    </div>
                                    <input type="text"
                                           class="form-control form-control-lg rounded-2 <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           wire:model.defer="name"
                                           placeholder="مثلاً شرکت فناوری اطلاعات مرسا"
                                           required>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback d-block mt-2"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-12 col-md-6">
                                <div class="bg-white rounded-3 p-3 border shadow-sm hover-shadow">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="ti ti-phone fs-5 text-primary"></i>
                                        <label class="mb-0 fw-medium text-dark">تلفن</label>
                                    </div>
                                    <input type="tel"
                                           class="form-control form-control-lg rounded-2 <?php $__errorArgs = ['tel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           wire:model.defer="tel"
                                           placeholder="مثلاً 021-12345678">
                                    <?php $__errorArgs = ['tel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback d-block mt-2"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-12 col-md-6">
                                <div class="bg-white rounded-3 p-3 border shadow-sm hover-shadow">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="ti ti-fax fs-5 text-primary"></i>
                                        <label class="mb-0 fw-medium text-dark">فکس</label>
                                    </div>
                                    <input type="text"
                                           class="form-control form-control-lg rounded-2 <?php $__errorArgs = ['fax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           wire:model.defer="fax"
                                           placeholder="مثلاً 021-87654321">
                                    <?php $__errorArgs = ['fax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback d-block mt-2"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-12 col-md-6">
                                <div class="bg-white rounded-3 p-3 border shadow-sm hover-shadow h-100">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <i class="ti ti-map fs-5 text-primary"></i>
                                        <label class="mb-0 fw-medium text-dark">آدرس شرکت</label>
                                    </div>
                                    <textarea
                                        class="form-control form-control-lg rounded-2 <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        wire:model.defer="address"
                                        placeholder="آدرس کامل پستی شرکت"
                                        rows="2"></textarea>
                                    <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback d-block mt-2"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="bg-white rounded-3 p-3 border shadow-sm hover-shadow">
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <i class="ti ti-photo fs-5 text-primary"></i>
                                        <label class="mb-0 fw-medium text-dark">لوگوی شرکت</label>
                                    </div>
                                    <input type="file"
                                           class="form-control form-control-lg rounded-2 <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           wire:model="image"
                                           accept="image/*">
                                    <div wire:loading wire:target="image" class="small text-primary mt-2 d-flex align-items-center gap-1">
                                        <i class="ti ti-loader fs-5 animate-spin"></i>
                                        در حال بارگذاری...
                                    </div>
                                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback d-block mt-2"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="bg-white rounded-3 p-3 border shadow-sm hover-shadow">
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <i class="ti ti-eye fs-5 text-primary"></i>
                                        <label class="mb-0 fw-medium text-dark">پیش‌نمایش لوگو</label>
                                    </div>
                                    <div class="text-center">
                                        <?php if($image): ?>
                                            <img src="<?php echo e($image->temporaryUrl()); ?>" class="rounded-circle border border-3 border-primary shadow-sm" width="120" height="120" style="object-fit: cover; transition: all 0.3s ease;" onmouseover="this.style.transform='scale(1.05)'" onmouseout="this.style.transform='scale(1)'">
                                        <?php else: ?>
                                            <div class="bg-gradient-to-br from-violet-100 to-indigo-100 rounded-circle d-flex align-items-center justify-content-center" style="width: 120px; height: 120px; transition: all 0.3s ease; background: #eef2ff;">
                                                <i class="ti ti-building fs-1 text-primary"></i>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-text text-muted small mt-2 text-center">فرمت‌های JPG, PNG - حداکثر 2MB</div>
                                </div>
                            </div>

                            <div class="col-12 mt-4">
                                <button type="submit"
                                        class="btn btn-lg w-100 py-3 d-flex align-items-center justify-content-center gap-2 rounded-4 fw-bold text-white"
                                        wire:loading.attr="disabled"
                                        style="background: linear-gradient(90deg, #8b5cf6, #6366f1); transition: all 0.3s ease; box-shadow: 0 4px 15px rgba(139, 92, 246, 0.3);">
                                    <span wire:loading.remove>
                                        <i class="ti ti-device-floppy fs-4 me-2"></i>
                                        ثبت شرکت
                                    </span>
                                    <span wire:loading>
                                        <i class="ti ti-loader fs-4 me-2 animate-spin"></i>
                                        در حال ثبت...
                                    </span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\company\create-company.blade.php ENDPATH**/ ?>