<!doctype html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="utf-8">
    <style>
        /* DejaVu Sans برای پوشش حروف فارسی در DomPDF */
        @page { margin: 24px; }
        body{ font-family: DejaVu Sans, sans-serif; font-size:12px; }
        h3{ margin:0 0 10px; }
        .muted{ color:#777; }
        table{ width:100%; border-collapse: collapse; }
        th,td{ border:1px solid #ccc; padding:6px; text-align:center; }
        thead{ background:#f5f5f5; }
    </style>
</head>
<body>
<h3><?php echo e($title); ?></h3>
<div class="muted">تاریخ چاپ: <?php echo e($printed_at); ?></div>
<br>

<table>
    <thead>
    <tr>
        <th>#</th>
        <th>شماره</th>
        <th>پروژه</th>
        <th>فرستنده</th>
        <th>گیرنده</th>
        <th>تاریخ</th>
        <th>هدف</th>
        <th>مدارک</th>
        <th>وضعیت</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($i+1); ?></td>
            <td><?php echo e($r['number']); ?></td>
            <td><?php echo e($r['project']); ?></td>
            <td><?php echo e($r['sender']); ?></td>
            <td><?php echo e($r['receiver']); ?></td>
            <td><?php echo e($r['date']); ?></td>
            <td><?php echo e(\Illuminate\Support\Str::limit($r['purpose'], 60)); ?></td>
            <td><?php echo e($r['docs']); ?></td>
            <td><?php echo e($r['status']); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</body>
</html>
<?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\exports\transmittals-pdf.blade.php ENDPATH**/ ?>