<div>

    <style>
        :root {
            /* REFINED DEEP NAVY BLUE PALETTE (High Contrast) */
            --brand-dark: #21334c;
            --brand: #345373;
            --brand-50: #e8eff6;
            --brand-100: #bfd4ee;
            --brand-rgb: 52, 83, 115;
            --bg: #fcfcfc;
            --text: #2d3748;
            --card: #ffffff;
            --border: #e2e8f0;
            --shadow: 0 6px 20px rgba(0,0,0,0.08);
            --info: #3b82f6;
            --success: #10b981;
            --warning: #f59e0b;
            --danger: #ef4444;
            --indigo: #5A67D8; /* اضافه شد */
        }

        .dark {
            --brand-dark: #1f2a38;
            --brand: #2a4365;
            --brand-50: #1a2332;
            --brand-100: #2c3a4d;
            --brand-rgb: 42, 67, 101;
            --bg: #1f2a38;
            --text: #e2e8f0;
            --card: #2a3447;
            --border: #3b465a;
            --shadow: 0 4px 8px rgba(0,0,0,0.4);
        }

        body {
            background-color: var(--bg);
            color: var(--text);
            transition: background-color 0.3s, color 0.3s;
            font-family: 'Vazirmatn', sans-serif;
        }

        .card, .modal-content {
            background-color: var(--card);
            border-color: var(--border);
            box-shadow: var(--shadow);
            border-radius: 16px;
            border: 1px solid var(--border);
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.12);
        }

        .table {
            border-radius: 16px;
            overflow: hidden;
            table-layout: fixed;
            width: 100%;
        }

        .document-title-link {
            color: var(--brand);
            font-weight: 600;
            text-decoration: none;
            transition: color 0.2s;
        }

        .document-title-link:hover {
            color: var(--brand-dark);
            text-decoration: underline;
        }

        .transmittal-attachment-link {
            color: var(--success);
            font-size: .8rem;
            font-weight: 600;
            text-decoration: none;
        }

        .transmittal-attachment-link:hover {
            text-decoration: underline;
        }

        .table thead th.sticky {
            position: sticky;
            top: 0;
            background: var(--brand-50);
            z-index: 2;
            font-weight: 700;
            border-bottom: 2px solid var(--brand-100);
            color: var(--brand-dark);
        }

        .table-hover tbody tr:hover {
            background-color: var(--brand-50);
        }

        .text-truncate-2 {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .text-monospace {
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
            font-weight: 600;
        }

        .chip {
            background: var(--brand-100);
            color: var(--brand-dark);
            border-radius: 999px;
            padding: .3rem .8rem;
            font-size: .85rem;
            display: inline-flex;
            align-items: center;
            gap: 0.3rem;
        }

        .status-badge {
            padding: .3em .7em;
            border-radius: 999px;
            font-size: .8em;
            font-weight: 700;
            white-space: nowrap;
        }

        .btn-modern {
            border-radius: 10px;
            padding: 0.5rem 1rem;
            font-weight: 600;
            transition: all 0.2s ease;
        }

        .btn-icon {
            width: 32px;
            height: 32px;
            padding: 0;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            flex-shrink: 0;
        }

        .progress-percent-badge {
            background: linear-gradient(135deg, var(--brand), var(--brand-dark));
            color: white;
            padding: 0.4rem 0.9rem;
            border-radius: 25px;
            font-weight: 700;
            font-size: 1rem;
        }

        .header-bg {
            background: linear-gradient(135deg, var(--brand-dark), var(--brand));
            color: white;
            padding: 28px;
            border-radius: 20px;
            box-shadow: 0 12px 25px rgba(0,0,0,0.15);
        }

        .stat-card {
            border: none !important;
            border-left: 6px solid;
            padding: 1.2rem 1.8rem !important;
            border-radius: 16px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.05);
        }

        .modal-header.bg-gradient-primary {
            background: linear-gradient(135deg, var(--brand-dark), var(--brand)) !important;
            color: white;
            border-top-left-radius: 16px !important;
            border-top-right-radius: 16px !important;
        }

        /* استایل‌های آکاردئونی جدید */
        .accordion-item {
            border: 1px solid var(--border);
            border-radius: 16px;
            margin-bottom: 10px;
            overflow: hidden;
            transition: box-shadow 0.2s;
        }
        .accordion-item:hover {
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        }
        .accordion-header {
            border-bottom: none;
        }
        .accordion-button {
            background-color: var(--card);
            color: var(--brand-dark);
            font-weight: 700;
            padding: 1rem 1.5rem;
            transition: background-color 0.2s;
        }
        .accordion-button:not(.collapsed) {
            background-color: var(--brand-50);
            color: var(--brand-dark);
            box-shadow: none;
            border-bottom: 1px solid var(--brand-100);
        }
        .accordion-button:focus {
            box-shadow: none;
            border-color: var(--brand);
        }
        .accordion-button::after {
            margin-left: 0.5rem;
            margin-right: -1rem;
            transform: rotate(90deg);
        }
        .accordion-button.collapsed::after {
            transform: rotate(0deg);
        }
        .table-full-width {
            table-layout: auto; /* برای انعطاف بیشتر در ستون‌های آکاردئونی */
            width: 100%;
        }

        /* تنظیم عرض ستون‌های جدول داخل آکاردئون */
        .table-full-width thead th:nth-child(1) { width: 3%; } /* Checkbox */
        .table-full-width thead th:nth-child(2) { width: 3%; } /* # */
        .table-full-width thead th:nth-child(3) { width: 10%; } /* Document Number */
        .table-full-width thead th:nth-child(4) { width: 20%; } /* Title */
        .table-full-width thead th:nth-child(5) { width: 7%; } /* Category */
        .table-full-width thead th:nth-child(6) { width: 10%; } /* Document Type */
        .table-full-width thead th:nth-child(7) { width: 7%; } /* Revision */
        .table-full-width thead th:nth-child(8) { width: 7%; } /* Progress */
        .table-full-width thead th:nth-child(9) { width: 7%; } /* Weight */
        .table-full-width thead th:nth-child(10) { width: 7%; } /* Status */
        .table-full-width thead th:nth-child(11) { width: 12%; } /* Last Transmittal */
        .table-full-width thead th:nth-child(12) { width: 7%; } /* Actions */

        .table-full-width tbody td {
            vertical-align: middle;
            white-space: nowrap;
        }
        .table-full-width tbody td:nth-child(4) {
            white-space: normal;
            word-break: break-word;
            max-width: 1px;
        }
        /* پایان استایل‌های آکاردئونی جدید */

        .btn-clear {
            background: none;
            border: none;
            font-size: 1rem;
            margin-left: 0.4rem;
            color: inherit;
            cursor: pointer;
        }

        .btn-clear:hover {
            opacity: 0.7;
        }

        @media (max-width: 768px) {
            .mobile-card-row {
                display: flex;
                flex-wrap: wrap;
                gap: 0.5rem;
                margin-top: 0.75rem;
                padding-top: 0.75rem;
                border-top: 1px solid var(--border);
            }

            .mobile-card-item {
                flex: 1 1 calc(50% - 0.5rem);
                min-width: 120px;
            }

            /* حذف نمای جدول دسکتاپ در موبایل */
            .d-none.d-md-block { display: none !important; }
            .d-md-none { display: block !important; }
        }
    </style>

    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-4 header-bg">
        <div>
            <h2 class="mb-1 fw-bolder" style="font-size: 1.8rem;">
                <i class="fas fa-folder-open me-2"></i>
                <?php echo e(__('مدارک پروژه')); ?>

            </h2>
            <div class="mt-2 d-flex flex-wrap gap-3 align-items-center">
                <span class="chip bg-white text-indigo-700 fw-bold border-0">
                    <strong><?php echo e(__('پروژه')); ?>:</strong> <?php echo e($project->name); ?>

                </span>
                <?php if($project->code): ?>
                    <span class="chip bg-white text-dark border-0">
                        <?php echo e(__('کد')); ?>: <?php echo e($project->code); ?>

                    </span>
                <?php endif; ?>
            </div>
        </div>
        <div class="toolbar-actions d-flex flex-wrap align-items-center gap-2">
            <button class="btn btn-outline-light btn-modern" wire:click="exportExcel" title="<?php echo e(__('خروجی اکسل')); ?>">
                <i class="fas fa-file-excel me-1"></i> <span class="d-none d-sm-inline"><?php echo e(__('اکسل')); ?></span>
            </button>
            <button class="btn btn-outline-light btn-modern" wire:click="exportPdf" title="<?php echo e(__('خروجی PDF')); ?>">
                <i class="fas fa-file-pdf me-1"></i> <span class="d-none d-sm-inline"><?php echo e(__('PDF')); ?></span>
            </button>
            <button class="btn btn-outline-light btn-modern" wire:click="downloadSelected" title="<?php echo e(__('دانلود مدارک انتخاب شده')); ?>" <?php if(!$selectedDocs): ?> disabled <?php endif; ?>>
                <i class="fas fa-download me-1"></i> <span class="d-none d-sm-inline"><?php echo e(__('دانلود گروهی')); ?></span>
            </button>
            <a href="<?php echo e(route('admin.mdr.poi-settings', $project->id)); ?>" class="btn btn-outline-light btn-modern" title="<?php echo e(__('تنظیم درصد POI')); ?>">
                <i class="fas fa-cog me-1"></i> <span class="d-none d-sm-inline"><?php echo e(__('تنظیمات')); ?></span>
            </a>
            <button class="btn btn-modern fw-bold" style="background: white; color: var(--brand-dark); border: none;" wire:click="showAddForm">
                <i class="fas fa-plus me-1"></i> <span class="d-none d-sm-inline"><?php echo e(__('افزودن مدرک')); ?></span>
            </button>
        </div>
    </div>

    <div class="card p-3 mb-4 d-flex align-items-center gap-3" style="border-left: 4px solid var(--brand);">
        <div class="d-flex align-items-center w-100">
            <i class="fas fa-chart-line fa-2x me-3" style="color: var(--brand) !important;"></i>
            <div>
                <h6 class="mb-0 fw-bold text-muted"><?php echo e(__('پیشرفت کل پروژه')); ?></h6>
                <h4 class="mb-0 fw-bolder" style="color: var(--brand);"><?php echo e($project->total_progress_percent); ?>%</h4>
            </div>
            <div class="ms-auto">
                <span class="progress-percent-badge"><?php echo e($project->total_progress_percent); ?>%</span>
            </div>
        </div>
    </div>

    <?php
        $total = $this->stats['total'] ?? 0;
        $sent = $this->stats['sent'] ?? 0;
        $approved = $this->stats['approved'] ?? 0;
        $rejected = $this->stats['rejected'] ?? 0;
    ?>
    <div class="row g-3 mb-4">
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card stat-card shadow-sm" style="border-left-color: var(--text) !important;">
                <small class="text-muted fw-medium"><i class="fas fa-list-alt me-1"></i> <?php echo e(__('کل مدارک')); ?></small>
                <h3 class="mb-0 fw-bold mt-1"><?php echo e($total); ?></h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card stat-card shadow-sm" style="border-left-color: var(--warning) !important;">
                <small class="text-muted fw-medium"><i class="fas fa-paper-plane me-1"></i> <?php echo e(__('ارسال شده')); ?></small>
                <h3 class="mb-0 fw-bold mt-1" style="color: var(--warning);"><?php echo e($sent); ?></h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card stat-card shadow-sm" style="border-left-color: var(--success) !important;">
                <small class="text-muted fw-medium"><i class="fas fa-check-circle me-1"></i> <?php echo e(__('تایید شده')); ?></small>
                <h3 class="mb-0 fw-bold mt-1" style="color: var(--success);"><?php echo e($approved); ?></h3>
            </div>
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="card stat-card shadow-sm" style="border-left-color: var(--danger) !important;">
                <small class="text-muted fw-medium"><i class="fas fa-times-circle me-1"></i> <?php echo e(__('رد شده')); ?></small>
                <h3 class="mb-0 fw-bold mt-1" style="color: var(--danger);"><?php echo e($rejected); ?></h3>
            </div>
        </div>
    </div>

    <div x-data="{ open: false, message: '', type: '' }"
         x-on:alert.window="message = $event.detail.message; type = $event.detail.type; open = true; setTimeout(() => open = false, 5000);"
         x-show="open"
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0 transform translate-y-2"
         x-transition:enter-end="opacity-100 transform translate-y-0"
         x-transition:leave="transition ease-in duration-300"
         x-transition:leave-start="opacity-100 transform translate-y-0"
         x-transition:leave-end="opacity-0 transform translate-y-2"
         class="position-fixed top-0 end-0 p-3" style="z-index: 1070;">
        <div :class="{
            'alert-success': type === 'success',
            'alert-danger': type === 'error'
        }"
             class="alert alert-dismissible fade show rounded-3 mb-4" role="alert" style="min-width: 300px;">
            <span x-text="message"></span>
            <button type="button" class="btn-close" @click="open = false"></button>
        </div>
    </div>

    <div class="collapse d-md-block mb-4 card p-4" id="filtersCollapse">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="fw-bold" style="color: var(--brand-dark);"><i class="fas fa-sliders-h me-2"></i> <?php echo e(__('فیلتر و جستجو')); ?></h5>
            <button class="btn btn-link text-decoration-none text-muted p-0" wire:click="resetFilters">
                <i class="fas fa-rotate me-1"></i> <?php echo e(__('بازنشانی فیلترها')); ?>

            </button>
        </div>
        <div class="row g-3 align-items-end">
            <div class="col-12 col-md-3">
                <div class="form-floating">
                    <input type="text" class="form-control" id="searchInput" wire:model.debounce.500ms="search" placeholder="<?php echo e(__('جستجو (شماره یا عنوان)')); ?>">
                    <label for="searchInput"><?php echo e(__('جستجو (شماره یا عنوان)')); ?></label>
                </div>
            </div>
            <div class="col-6 col-md-2">
                <select class="form-select" wire:model.live="filter_status">
                    <option value=""><?php echo e(__('همه وضعیت‌ها')); ?></option>
                    <option value="در حال تهیه"><?php echo e(__('در حال تهیه')); ?></option>
                    <option value="ارسال شده"><?php echo e(__('ارسال شده')); ?></option>
                    <option value="تایید شده"><?php echo e(__('تایید شده')); ?></option>
                    <option value="رد شده"><?php echo e(__('رد شده')); ?></option>
                </select>
            </div>
            <div class="col-6 col-md-2">
                <select class="form-select" wire:model.live="filter_discipline_id">
                    <option value=""><?php echo e(__('همه دیسپلین‌ها')); ?></option>
                    <?php $__currentLoopData = $disciplines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($d->id); ?>"><?php echo e($d->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-6 col-md-2">
                <select class="form-select" wire:model.live="filter_transmittal_status">
                    <option value=""><?php echo e(__('همه ترنسمیتال‌ها')); ?></option>
                    <option value="ارسال شده"><?php echo e(__('ارسال شده')); ?></option>
                    <option value="دریافت شده"><?php echo e(__('دریافت شده')); ?></option>
                    <option value="در انتظار"><?php echo e(__('در انتظار')); ?></option>
                    <option value="رد شده"><?php echo e(__('رد شده')); ?></option>
                    <option value="بدون ارسال"><?php echo e(__('بدون ارسال')); ?></option>
                </select>
            </div>
            <div class="col-6 col-md-2">
                <select class="form-select" wire:model.live="perPage">
                    <option value="20">20 <?php echo e(__('رکورد در صفحه')); ?></option>
                    <option value="50">50 <?php echo e(__('رکورد در صفحه')); ?></option>
                    <option value="100">100 <?php echo e(__('رکورد در صفحه')); ?></option>
                </select>
            </div>
        </div>
        <div class="mt-3 d-flex flex-wrap gap-2">
            <?php if($search): ?>
                <span class="chip"><?php echo e(__('جستجو')); ?>: “<?php echo e($search); ?>”<button type="button" class="btn-clear" wire:click="$set('search','')">&times;</button></span>
            <?php endif; ?>
            <?php if($filter_status): ?>
                <span class="chip"><?php echo e(__('وضعیت')); ?>: <?php echo e($filter_status); ?><button type="button" class="btn-clear" wire:click="$set('filter_status','')">&times;</button></span>
            <?php endif; ?>
            <?php if($filter_discipline_id): ?>
                <span class="chip"><?php echo e(__('دیسپلین')); ?>: <?php echo e(optional($disciplines->firstWhere('id',$filter_discipline_id))->name); ?><button type="button" class="btn-clear" wire:click="$set('filter_discipline_id','')">&times;</button></span>
            <?php endif; ?>
            <?php if($filter_transmittal_status): ?>
                <span class="chip"><?php echo e(__('ترنسمیتال')); ?>: <?php echo e($filter_transmittal_status); ?><button type="button" class="btn-clear" wire:click="$set('filter_transmittal_status','')">&times;</button></span>
            <?php endif; ?>
        </div>
    </div>

    <div class="card p-0" wire:loading.class="opacity-50">
        <div class="accordion" id="mdrAccordion">
            <?php
                // 1. آماده‌سازی داده‌ها برای گروپ‌بندی آکاردئونی
                $documents = $this->masterDocuments;
                $groupedDocuments = $documents->groupBy('discipline_id');

                // مرتب‌سازی کلیدها بر اساس ترتیب دیسپلین‌های موجود
                $disciplineOrder = $disciplines->pluck('id')->toArray();

                // کلیدهای مرتب شده: ابتدا دیسپلین‌های تعریف شده، سپس دیسپلین‌های نامشخص/حذف شده (null)
                $sortedKeys = collect($disciplineOrder)->filter(fn($id) => $groupedDocuments->has($id))
                    ->push(null)
                    ->filter(fn($key) => $groupedDocuments->has($key));

                $dirIcon = fn($f)=> $sortField===$f ? ($sortDir==='asc'?'↑':'↓') : '';

                $columns = [
                    ['field'=>'document_number','label'=>__('شماره سند')],
                    ['field'=>'title','label'=>__('عنوان')],
                    ['field'=>'category','label'=>__('کلاس')], // قابل مرتب‌سازی در Livewire
                    ['field'=>'document_type','label'=>__('توضیحات')],
                    ['field'=>null,'label'=>__('نسخه')],
                    ['field'=>null,'label'=>__('پیشرفت')],
                    ['field'=>null,'label'=>__('وزن')],
                    ['field'=>null,'label'=>__('تاریخچه')], // ترکیب رویژن و پیش‌نمایش
                    ['field'=>null,'label'=>__('آخرین ترنسمیتال')],
                    ['field'=>null,'label'=>__('وضعیت')],
                    ['field'=>null,'label'=>__('عملیات')],
                ];
            ?>

            <?php $__empty_1 = true; $__currentLoopData = $sortedKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplineId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $docs = $groupedDocuments[$disciplineId];
                    $disciplineName = $disciplines->firstWhere('id', $disciplineId)?->name ?? 'نامشخص یا حذف‌شده';
                    $collapseId = 'collapse-' . ($disciplineId ?? 'und');
                    $disciplineClass = $disciplineId ? 'bg-primary' : 'bg-warning';
                    $disciplineIcon = $disciplineId ? 'fas fa-layer-group' : 'fas fa-exclamation-triangle';
                ?>

                <div class="accordion-item" wire:key="discipline-<?php echo e($disciplineId ?? 'und'); ?>">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#<?php echo e($collapseId); ?>" aria-expanded="false" aria-controls="<?php echo e($collapseId); ?>">
                            <span class="d-flex align-items-center gap-2">
                                <i class="<?php echo e($disciplineIcon); ?> me-2"></i>
                                **<?php echo e(__('دیسپلین')); ?>:** <?php echo e($disciplineName); ?>

                            </span>
                            <span class="badge <?php echo e($disciplineClass); ?> text-white ms-auto me-3 py-2">
                                <?php echo e($docs->count()); ?> <?php echo e(__('مدرک')); ?>

                            </span>
                        </button>
                    </h2>
                    <div id="<?php echo e($collapseId); ?>" class="accordion-collapse collapse <?php if(!$filter_discipline_id): ?> show <?php endif; ?>" data-bs-parent="#mdrAccordion">
                        <div class="accordion-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover align-middle text-center mb-0 table-full-width">
                                    <thead class="table-light d-none d-md-table-header-group">
                                    <tr>
                                        <th style="width: 3%;"><input type="checkbox" wire:model.live="selectAll" aria-label="<?php echo e(__('انتخاب همه')); ?>"></th>
                                        <th style="width: 3%;">#</th>
                                        <?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <th role="<?php echo e($c['field'] ? 'button' : 'columnheader'); ?>"
                                                <?php if($c['field']): ?>
                                                    wire:click="sortBy('<?php echo e($c['field'] === 'category' ? 'category' : $c['field']); ?>')"
                                                <?php endif; ?>
                                            >
                                                <?php echo e($c['label']); ?>

                                                <?php if($c['field']): ?>
                                                    <span class="text-muted small"><?php echo e($dirIcon($c['field'])); ?></span>
                                                <?php endif; ?>
                                            </th>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $row = $documents->firstItem(); ?>
                                    <?php $__currentLoopData = $docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $latestRevision = $doc->revisions->last();
                                            $latestFile = $latestRevision?->files->last();
                                            $lastTransmittalDoc = $doc->transmittalDocuments->last();
                                            $statusTxt = $doc->status ?: 'نامشخص';
                                            $cls = match($statusTxt) {
                                                'تایید شده' => 'bg-success text-white',
                                                'رد شده' => 'bg-danger text-white',
                                                'ارسال شده' => 'bg-warning text-dark',
                                                default => 'bg-secondary text-white'
                                            };
                                            $docNumber = $documents->search(fn($item) => $item->id === $doc->id) + $documents->firstItem();
                                        ?>
                                        <tr wire:key="doc-<?php echo e($doc->id); ?>">
                                            <td class="d-none d-md-table-cell"><input type="checkbox" wire:model="selectedDocs" value="<?php echo e($doc->id); ?>"></td>
                                            <td class="d-none d-md-table-cell"><?php echo e($docNumber); ?></td>
                                            <td class="text-monospace fw-bold d-none d-md-table-cell" style="color: var(--brand-dark);"><?php echo e($doc->document_number); ?></td>
                                            <td class="text-start d-none d-md-table-cell">
                                                <?php if($latestFile): ?>
                                                    <a href="<?php echo e(asset('storage/' . $latestFile->file_path)); ?>" target="_blank" class="document-title-link text-truncate-2">
                                                        <?php echo e($doc->title); ?>

                                                    </a>
                                                <?php else: ?>
                                                    <span class="text-muted text-truncate-2"><?php echo e($doc->title); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="d-none d-md-table-cell"><?php echo e($doc->category?->name ?? '-'); ?></td>
                                            <td class="d-none d-md-table-cell"><?php echo e($doc->document_type ?? '-'); ?></td>
                                            <td class="d-none d-md-table-cell"><span class="badge bg-indigo text-white"><?php echo e($latestRevision?->revision ?? '-'); ?></span></td>
                                            <td class="d-none d-md-table-cell">
                                                <span class="badge bg-info text-white"><?php echo e($doc->progress_percent ?? 0); ?>%</span>
                                            </td>
                                            <td class="d-none d-md-table-cell"><span class="fw-bold" style="color: var(--brand-dark);"><?php echo e($doc->weight); ?></span></td>

                                            <td class="d-none d-md-table-cell">
                                                <div class="d-flex flex-row gap-1 justify-content-center">
                                                    <button class="btn btn-icon btn-sm btn-outline-secondary" wire:click="showRevisions(<?php echo e($doc->id); ?>)" title="<?php echo e(__('تاریخچه رویژن')); ?>">
                                                        <i class="fas fa-history"></i>
                                                    </button>
                                                    <?php if($latestFile && in_array($latestFile->mime_type, ['application/pdf', 'image/jpeg', 'image/png'])): ?>
                                                        <button class="btn btn-icon btn-sm btn-outline-info" wire:click="preview(<?php echo e($doc->id); ?>)" title="<?php echo e(__('پیش‌نمایش')); ?>">
                                                            <i class="fas fa-eye"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                </div>
                                            </td>

                                            <td class="d-none d-md-table-cell">
                                                <div class="d-flex flex-column align-items-center gap-1">
                                                    <?php if($lastTransmittalDoc && $lastTransmittalDoc->transmittal): ?>
                                                        <a href="<?php echo e(route('transmittals.show', $lastTransmittalDoc->transmittal_id)); ?>" class="badge bg-indigo text-white fw-bold" target="_blank">
                                                            <?php echo e($lastTransmittalDoc->transmittal->transmittal_number); ?>

                                                        </a>
                                                        <small class="text-muted"><?php echo e($lastTransmittalDoc->transmittal->sent_at_formatted); ?></small>
                                                        <button class="btn btn-icon btn-sm btn-outline-info mt-1" wire:click="showTransmittalHistory(<?php echo e($doc->id); ?>)" title="<?php echo e(__('تاریخچه ترنسمیتال‌ها')); ?>">
                                                            <i class="fas fa-list"></i>
                                                        </button>
                                                    <?php else: ?>
                                                        <span class="text-muted">—</span>
                                                    <?php endif; ?>
                                                </div>
                                            </td>

                                            <td class="d-none d-md-table-cell"><span class="status-badge <?php echo e($cls); ?>"><?php echo e($statusTxt); ?></span></td>

                                            <td class="d-none d-md-table-cell">
                                                <div class="d-flex flex-row gap-1 justify-content-center">
                                                    <a href="<?php echo e(route('transmittal.create', ['project_id'=>$project->id,'doc_id'=>$doc->id])); ?>"
                                                       class="btn btn-icon btn-sm btn-outline-primary" title="<?php echo e(__('ارسال با ترنسمیتال جدید')); ?>">
                                                        <i class="fas fa-paper-plane"></i>
                                                    </a>
                                                    <button class="btn btn-icon btn-sm btn-outline-warning" wire:click="showEditForm(<?php echo e($doc->id); ?>)" title="<?php echo e(__('ویرایش مدرک')); ?>">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <button class="btn btn-icon btn-sm btn-outline-danger" wire:click="deleteDocument(<?php echo e($doc->id); ?>)" onclick="return confirm('<?php echo e(__('حذف شود؟')); ?>')" title="<?php echo e(__('حذف')); ?>">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center text-muted py-5 card">
                    <i class="fas fa-inbox fa-3x mb-3"></i>
                    <p class="mb-0"><?php echo e(__('هیچ مدرکی با فیلترهای اعمال شده پیدا نشد.')); ?></p>
                </div>
            <?php endif; ?>
        </div>

        <div class="card-footer bg-light border-top d-flex justify-content-center p-3">
            <?php echo e($documents->links()); ?>

        </div>
    </div>

    <div class="d-md-none" wire:loading.class="opacity-50">
        <?php $rowM = ($documents->currentPage() - 1) * $documents->perPage() + 1; ?>
        <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $latestRevision = $doc->revisions->last();
                $latestFile = $latestRevision?->files->last();
                $lastTrans = $doc->transmittalDocuments->last();
                $status = $doc->status ?: 'نامشخص';
                $cls = match($status) {
                    'تایید شده' => 'bg-success text-white',
                    'رد شده' => 'bg-danger text-white',
                    'ارسال شده' => 'bg-warning text-dark',
                    default => 'bg-secondary text-white'
                };
            ?>
            <div class="card mb-3 shadow-sm" wire:key="card-<?php echo e($doc->id); ?>">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <span class="badge bg-light text-dark">#<?php echo e($rowM++); ?></span>
                        <span class="form-check">
                            <input class="form-check-input" type="checkbox" wire:model="selectedDocs" value="<?php echo e($doc->id); ?>">
                        </span>
                    </div>
                    <div class="mb-1 text-monospace fw-bold" style="color: var(--brand-dark);"><?php echo e($doc->document_number); ?></div>
                    <h6 class="mb-2">
                        <?php if($latestFile): ?>
                            <a class="document-title-link" href="<?php echo e(asset('storage/' . $latestFile->file_path)); ?>" target="_blank">
                                <?php echo e($doc->title); ?>

                            </a>
                        <?php else: ?>
                            <?php echo e($doc->title); ?>

                        <?php endif; ?>
                    </h6>
                    <div class="mobile-card-row">
                        <div class="mobile-card-item"><small class="text-muted"><?php echo e(__('کلاس')); ?>:</small> <?php echo e($doc->category?->name ?? '-'); ?></div>
                        <div class="mobile-card-item"><small class="text-muted"><?php echo e(__('توضیحات')); ?>:</small> <?php echo e($doc->document_type ?: '-'); ?></div>
                        <div class="mobile-card-item"><small class="text-muted"><?php echo e(__('نسخه')); ?>:</small> <span class="badge bg-indigo text-white"><?php echo e($latestRevision?->revision ?: '-'); ?></span></div>
                        <div class="mobile-card-item"><small class="text-muted"><?php echo e(__('دیسپلین')); ?>:</small> <?php echo e($disciplines->firstWhere('id', $doc->discipline_id)?->name ?? '-'); ?></div>
                        <div class="mobile-card-item"><small class="text-muted"><?php echo e(__('پیشرفت')); ?>:</small>
                            <?php if($doc->progress_percent > 0): ?>
                                <span class="badge bg-info text-white"><?php echo e($doc->progress_percent); ?>%</span>
                            <?php else: ?>
                                <span class="text-muted">0%</span>
                            <?php endif; ?>
                        </div>
                        <div class="mobile-card-item"><small class="text-muted"><?php echo e(__('وزن')); ?>:</small> <span style="color: var(--brand-dark); font-weight: 700;"><?php echo e($doc->weight); ?></span></div>
                    </div>
                    <hr class="my-2">
                    <div class="d-flex flex-wrap align-items-center gap-2 mb-2">
                        <span class="status-badge <?php echo e($cls); ?> px-3 py-1"><?php echo e($status); ?></span>
                        <?php if($lastTrans && $lastTrans->transmittal): ?>
                            <a class="badge bg-indigo text-white px-3 py-1" target="_blank" href="<?php echo e(route('transmittals.show', $lastTrans->transmittal_id)); ?>">
                                <?php echo e($lastTrans->transmittal->transmittal_number); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                    <div class="mt-2 d-flex flex-wrap gap-1">
                        <button class="btn btn-icon btn-sm btn-outline-secondary" wire:click="showRevisions(<?php echo e($doc->id); ?>)" title="<?php echo e(__('رویژن‌ها')); ?>"><i class="fas fa-history"></i></button>
                        <?php if($latestFile && in_array($latestFile->mime_type, ['application/pdf', 'image/jpeg', 'image/png'])): ?>
                            <button class="btn btn-icon btn-sm btn-outline-info" wire:click="preview(<?php echo e($doc->id); ?>)" title="<?php echo e(__('پیش‌نمایش')); ?>"><i class="fas fa-eye"></i></button>
                        <?php endif; ?>
                        <a href="<?php echo e(route('transmittal.create', ['project_id'=>$project->id,'doc_id'=>$doc->id])); ?>" class="btn btn-icon btn-sm btn-primary" title="<?php echo e(__('ترنسمیتال جدید')); ?>"><i class="fas fa-paper-plane"></i></a>
                        <button class="btn btn-icon btn-sm btn-warning" wire:click="showEditForm(<?php echo e($doc->id); ?>)" title="<?php echo e(__('ویرایش')); ?>"><i class="fas fa-edit"></i></button>
                        <button class="btn btn-icon btn-sm btn-danger" wire:click="deleteDocument(<?php echo e($doc->id); ?>)" onclick="return confirm('<?php echo e(__('حذف شود؟')); ?>')" title="<?php echo e(__('حذف')); ?>"><i class="fas fa-trash"></i></button>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center text-muted py-5 card">
                <i class="fas fa-inbox fa-3x mb-3"></i>
                <p class="mb-0"><?php echo e(__('هیچ مدرکی پیدا نشد.')); ?></p>
            </div>
        <?php endif; ?>
        <div class="mt-3">
            <?php echo e($documents->links()); ?>

        </div>
    </div>

    <!-- مودال فرم با wire:ignore.self برای جلوگیری از ریلود Livewire -->
    <div wire:ignore.self class="modal fade" id="formModal" tabindex="-1" aria-labelledby="formModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <form wire:submit.prevent="saveDocument" class="modal-content rounded-3">
                <div class="modal-header bg-gradient-primary text-white">
                    <h5 class="modal-title" id="formModalLabel">
                        <i class="fas fa-file-alt me-2"></i> <?php echo e($editId ? 'ویرایش مدرک' : 'افزودن مدرک جدید'); ?>

                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" wire:click="closeForm"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <div class="form-floating">
                                <input type="text" wire:model.lazy="document_number" class="form-control" id="docNumber" placeholder="P-ENG-DRW-0001">
                                <label for="docNumber"><?php echo e(__('شماره سند*')); ?></label>
                            </div>
                            <?php $__errorArgs = ['document_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-8">
                            <div class="form-floating">
                                <input type="text" wire:model.lazy="title" class="form-control" id="docTitle" placeholder="Document title">
                                <label for="docTitle"><?php echo e(__('عنوان*')); ?></label>
                            </div>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label mb-1 small text-muted"><?php echo e(__('کلاس')); ?></label>
                            <div class="input-group">
                                <select wire:model="category_id" class="form-select">
                                    <option value=""><?php echo e(__('انتخاب کنید')); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <input type="text" wire:model.defer="new_category" class="form-control" placeholder="<?php echo e(__('جدید')); ?>">
                                <button class="btn btn-outline-primary" wire:click.prevent="addCategory" title="<?php echo e(__('افزودن کلاس جدید')); ?>">+</button>
                            </div>
                            <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <?php $__errorArgs = ['new_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label mb-1 small text-muted"><?php echo e(__('دیسپلین')); ?></label>
                            <div class="input-group">
                                <select wire:model="discipline_id" class="form-select">
                                    <option value=""><?php echo e(__('انتخاب کنید')); ?></option>
                                    <?php $__currentLoopData = $disciplines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($d->id); ?>"><?php echo e($d->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <input type="text" wire:model.defer="new_discipline" class="form-control" placeholder="<?php echo e(__('جدید')); ?>">
                                <button class="btn btn-outline-primary" wire:click.prevent="addDiscipline" title="<?php echo e(__('افزودن دیسپلین جدید')); ?>">+</button>
                            </div>
                            <?php $__errorArgs = ['discipline_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <?php $__errorArgs = ['new_discipline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <select wire:model="status" class="form-select" id="docStatus" aria-label="<?php echo e(__('وضعیت')); ?>">
                                    <option value=""><?php echo e(__('انتخاب کنید')); ?></option>
                                    <option value="در حال تهیه"><?php echo e(__('در حال تهیه')); ?></option>
                                    <option value="ارسال شده"><?php echo e(__('ارسال شده')); ?></option>
                                    <option value="تایید شده"><?php echo e(__('تایید شده')); ?></option>
                                    <option value="رد شده"><?php echo e(__('رد شده')); ?></option>
                                </select>
                                <label for="docStatus"><?php echo e(__('وضعیت')); ?></label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="number" step="0.01" min="0.01" max="1000"
                                       wire:model="weight"
                                       class="form-control"
                                       id="docWeight"
                                       placeholder="1.00">
                                <label for="docWeight"><?php echo e(__('ارزش وزنی')); ?></label>
                            </div>
                            <small class="text-muted ps-1"><?php echo e(__('پیش‌فرض: 1')); ?></small>
                        </div>
                        <div class="col-12" x-data="{ isUploading: false, progress: 0 }"
                             x-on:livewire-upload-start="isUploading = true"
                             x-on:livewire-upload-finish="isUploading = false; progress = 0"
                             x-on:livewire-upload-error="isUploading = false"
                             x-on:livewire-upload-progress="progress = $event.detail.progress">

                            <label class="form-label text-muted fw-bold small"><?php echo e(__('پیوست‌های سند')); ?></label>
                            <div class="upload-zone p-4 mb-2 text-center border-dashed rounded-4"
                                 style="border: 2px dashed var(--brand-100); background: #f8fafc; position: relative;">

                                <i class="fas fa-cloud-upload-alt fa-2x mb-2 text-primary"></i>
                                <p class="mb-0 small text-muted">فایل‌ها را اینجا رها کنید یا کلیک کنید</p>

                                <input type="file" wire:model="files" class="position-absolute opacity-0 w-100 h-100"
                                       style="top:0; left:0; cursor:pointer;" multiple>

                                <div x-show="isUploading" class="mt-3">
                                    <div class="progress" style="height: 20px; border-radius: 10px;">
                                        <div class="progress-bar progress-bar-striped progress-bar-animated bg-success"
                                             role="progressbar"
                                             :style="`width: ${progress}%`"
                                             x-text="progress + '%'"></div>
                                    </div>
                                    <span class="small text-primary mt-2 d-block">در حال انتقال به سرور... لطفا صفحه را نبندید.</span>
                                </div>
                            </div>

                            <?php if($files && count($files) > 0): ?>
                                <div class="mt-3 p-3 bg-white border rounded-4 shadow-sm">
                                    <h6 class="fw-bold mb-2 small text-success">
                                        <i class="fas fa-check-circle me-1"></i> فایل‌های آماده ثبت:
                                    </h6>
                                    <div class="d-flex flex-wrap gap-2">
                                        <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="badge bg-light text-dark border p-2 rounded-3 d-flex align-items-center">
                                                <i class="fas fa-file-archive me-2 text-warning"></i>
                                                <span class="me-2"><?php echo e($file->getClientOriginalName()); ?></span>
                                                <button type="button" wire:click="$set('files.<?php echo e($index); ?>', null)" class="btn-close" style="font-size: 0.6rem;"></button>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php $__errorArgs = ['files.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger d-block mt-1"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success btn-modern shadow-sm"
                            type="submit"
                            wire:loading.attr="disabled"
                            wire:target="files, saveDocument">
                        <span wire:loading.remove wire:target="saveDocument">
                            <i class="fas fa-save me-1"></i> <?php echo e(__('ذخیره نهایی')); ?>

                        </span>
                        <span wire:loading wire:target="saveDocument">
                            <span class="spinner-border spinner-border-sm me-1"></span> در حال پردازش و ثبت...
                        </span>
                    </button>
                    <button type="button" class="btn btn-light btn-modern" data-bs-dismiss="modal" wire:click="closeForm"><?php echo e(__('انصراف')); ?></button>
                </div>
            </form>
        </div>
    </div>

    <!-- مودال رویژن با wire:ignore.self -->
    <?php if($showRevisionModal): ?>
        <div wire:ignore.self class="modal fade show" id="revisionModal" style="display:block;background:rgba(0,0,0,.5); z-index:1055" tabindex="-1">
            <div class="modal-dialog modal-xl">
                <div class="modal-content rounded-3">
                    <div class="modal-header bg-gradient-primary text-white">
                        <h5 class="modal-title">
                            <i class="fas fa-history me-2"></i><?php echo e(__('تاریخچه رویژن‌ها')); ?>

                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closeRevisionModal"></button>
                    </div>
                    <div class="modal-body p-4">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h5 class="fw-bold d-flex align-items-center gap-2 text-dark">
                                <i class="fas fa-history me-2"></i>
                                <?php echo e(__('تاریخچه رویژن‌ها')); ?>

                            </h5>
                            <span class="badge bg-light text-muted"><?php echo e($revisions->count()); ?> <?php echo e(__('رویژن')); ?></span>
                        </div>
                        <div class="revision-list mb-4">
                            <?php $__empty_1 = true; $__currentLoopData = $revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="card mb-3 shadow-sm border rounded-4">
                                    <div class="card-body p-3">
                                        <div class="d-flex flex-wrap gap-3 align-items-start">
                                            <span class="badge bg-indigo text-white px-3 py-2 fw-bold fs-6 rounded-pill">
                                                <?php echo e($rev->revision); ?>

                                            </span>
                                            <div class="d-flex align-items-center gap-2 text-muted small">
                                                <i class="fas fa-calendar-alt me-1"></i>
                                                <span><?php echo e(jdate($rev->date)->format('Y/m/d')); ?></span>
                                            </div>
                                            <div class="flex-grow-1">
                                                <small class="text-muted d-block"><?php echo e(__('توضیح:')); ?></small>
                                                <p class="mb-0 mt-1 fw-normal text-truncate-2" style="max-width: 200px;">
                                                    <?php echo e($rev->remark ?: '—'); ?>

                                                </p>
                                            </div>
                                            <?php if($rev->poi_type): ?>
                                                <span class="badge px-3 py-2 fw-bold rounded-pill
                                                    <?php echo e(match($rev->poi_type) {
                                                        'IFC' => 'bg-success',
                                                        'IFA' => 'bg-warning',
                                                        'AFC' => 'bg-primary',
                                                        default => 'bg-info'
                                                    }); ?>"
                                                      title="<?php echo e(\App\Models\DocumentRevision::POI_TYPES[$rev->poi_type] ?? ''); ?>">
                                                    <?php echo e($rev->poi_type); ?>

                                                </span>
                                            <?php endif; ?>
                                            <div class="d-flex flex-wrap gap-2">
                                                <?php if($rev->files->isNotEmpty()): ?>
                                                    <?php $__currentLoopData = $rev->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $extension = strtoupper(pathinfo($file->file_name, PATHINFO_EXTENSION));
                                                            $fileIcon = match($extension) {
                                                                'PDF' => 'fa-file-pdf text-danger',
                                                                'XLSX' => 'fa-file-excel text-success',
                                                                'DOCX' => 'fa-file-word text-primary',
                                                                default => 'fa-file-alt text-muted',
                                                            };
                                                        ?>
                                                        <div class="d-flex align-items-center gap-2 bg-white rounded-3 px-2 py-1 border border-1"
                                                             style="box-shadow: 0 1px 3px rgba(0,0,0,0.05);">
                                                            <i class="fas <?php echo e($fileIcon); ?> fa-xs"></i>
                                                            <span class="small text-truncate" style="max-width: 120px;">
                                                                <?php echo e(Str::limit($file->file_name, 12, '...')); ?>

                                                            </span>
                                                            <a href="<?php echo e(asset('storage/' . $file->file_path)); ?>" target="_blank"
                                                               class="btn btn-icon btn-xs btn-outline-primary rounded-circle ms-1"
                                                               title="<?php echo e(__('دانلود')); ?>">
                                                                <i class="fas fa-download fa-xs"></i>
                                                            </a>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <span class="text-muted small">—</span>
                                                <?php endif; ?>
                                            </div>
                                            <div>
                                                <button class="btn btn-icon btn-xs btn-outline-danger rounded-circle shadow-sm"
                                                        wire:click="deleteRevision(<?php echo e($rev->id); ?>)"
                                                        onclick="return confirm('<?php echo e(__('آیا مطمئن هستید؟ این عمل غیرقابل بازگشت است.')); ?>')"
                                                        title="<?php echo e(__('حذف رویژن')); ?>"
                                                        wire:loading.attr="disabled">
                                                    <i class="fas fa-trash fa-xs"></i>
                                                </button>
                                                <button class="btn btn-icon btn-xs btn-outline-success rounded-circle shadow-sm ms-1"
                                                        wire:click="$set('addFileToRevisionId', <?php echo e($rev->id); ?>)"
                                                        title="<?php echo e(__('افزودن فایل')); ?>">
                                                    <i class="fas fa-plus fa-xs"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="text-center py-5 text-muted">
                                    <i class="fas fa-folder-open fa-3x mb-3"></i>
                                    <p class="mb-0"><?php echo e(__('هیچ رویژنی وجود ندارد.')); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="card border-dashed border-2 rounded-4 p-4" style="border-color: var(--brand-100);">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="mb-0 fw-bold d-flex align-items-center gap-2" style="color: var(--brand-dark);">
                                    <i class="fas fa-plus-circle"></i>
                                    <?php echo e(__('افزودن رویژن جدید')); ?>

                                </h6>
                            </div>
                            <form wire:submit.prevent="addRevision">
                                <div class="row g-3">
                                    <div class="col-md-2">
                                        <label class="form-label"><?php echo e(__('شماره رویژن')); ?> <span class="text-danger">*</span></label>
                                        <input type="text" wire:model="new_revision_number" class="form-control form-control-sm rounded-3" placeholder="Rev.02" required>
                                        <?php $__errorArgs = ['new_revision_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label"><?php echo e(__('توضیح')); ?></label>
                                        <input type="text" wire:model="new_revision_remark" class="form-control form-control-sm rounded-3" placeholder="<?php echo e(__('توضیح اختیاری')); ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label"><?php echo e(__('نوع POI')); ?></label>
                                        <select wire:model="new_revision_poi_type" class="form-select form-select-sm rounded-3">
                                            <option value=""><?php echo e(__('انتخاب کنید')); ?></option>
                                            <?php $__currentLoopData = \App\Models\DocumentRevision::POI_TYPES; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($key); ?> — <?php echo e($label); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['new_revision_poi_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label"><?php echo e(__('فایل‌ها')); ?></label>
                                        <div class="border-dashed border-2 rounded-3 p-3 text-center"
                                             style="border-color: var(--brand-100) !important; background: #fafafa;">
                                            <input type="file" wire:model="new_revision_files" class="form-control form-control-sm rounded-3" multiple>
                                            <div class="text-muted small mt-2">
                                                <?php echo e(__('فایل‌های خود را اینجا بکشید یا کلیک کنید')); ?>

                                            </div>
                                            <?php $__errorArgs = ['new_revision_files.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-1 d-grid">
                                        <button type="submit" class="btn btn-success btn-sm rounded-3 d-flex align-items-center justify-content-center"
                                                wire:loading.attr="disabled">
                                            <i class="fas fa-plus fa-sm"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>

                        <?php if($addFileToRevisionId): ?>
                            <div class="mt-4 p-4 border rounded-4 bg-white shadow-sm" wire:key="add-file-<?php echo e($addFileToRevisionId); ?>">
                                <h6 class="mb-3 fw-bold d-flex align-items-center gap-2" style="color: var(--brand-dark);">
                                    <i class="fas fa-plus-circle me-2"></i>
                                    <?php echo e(__('افزودن فایل به رویژن')); ?> **<?php echo e($revisions->firstWhere('id', $addFileToRevisionId)?->revision); ?>**
                                </h6>
                                <form wire:submit.prevent="addFilesToRevision(<?php echo e($addFileToRevisionId); ?>)">
                                    <div class="mb-3">
                                        <label class="form-label small text-muted"><?php echo e(__('فایل‌های جدید')); ?></label>
                                        <div class="border-dashed border-2 rounded-3 p-3 text-center"
                                             style="border-color: var(--brand-100) !important; background: #fafafa;">
                                            <input type="file" wire:model="new_files_for_revision" class="form-control form-control-sm rounded-3" multiple>
                                            <div class="text-muted small mt-2">
                                                <?php echo e(__('فایل‌های خود را اینجا بکشید یا کلیک کنید')); ?>

                                            </div>
                                            <?php $__errorArgs = ['new_files_for_revision.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-end gap-2">
                                        <button type="submit" class="btn btn-success btn-sm rounded-3 d-flex align-items-center gap-1"
                                                wire:loading.attr="disabled">
                                            <i class="fas fa-upload"></i> <?php echo e(__('آپلود')); ?>

                                        </button>
                                        <button type="button" class="btn btn-outline-secondary btn-sm rounded-3"
                                                wire:click="$set('addFileToRevisionId', null)">
                                            <?php echo e(__('لغو')); ?>

                                        </button>
                                    </div>
                                </form>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary btn-modern" wire:click="closeRevisionModal"><?php echo e(__('بستن')); ?></button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- مودال ترنسمیتال با wire:ignore.self -->
    <div wire:ignore.self class="modal fade" id="transmittalModal" tabindex="-1" aria-labelledby="transmittalModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content rounded-3">
                <div class="modal-header bg-gradient-primary text-white">
                    <h5 class="modal-title" id="transmittalModalLabel"><i class="fas fa-exchange-alt me-2"></i><?php echo e(__('تاریخچه ترنسمیتال‌های')); ?> <?php echo e($selectedDocNumber); ?></h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" wire:click="closeTransmittalModal"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead><tr>
                                <th><?php echo e(__('شماره ترنسمیتال')); ?></th>
                                <th><?php echo e(__('موضوع')); ?></th>
                                <th><?php echo e(__('فرستنده')); ?></th>
                                <th><?php echo e(__('گیرنده')); ?></th>
                                <th><?php echo e(__('هدف')); ?></th>
                                <th><?php echo e(__('وضعیت')); ?></th>
                                <th><?php echo e(__('تاریخ ارسال')); ?></th>
                                <th><?php echo e(__('پیوست')); ?></th>
                            </tr></thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $selectedTransmittals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tdoc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><a href="<?php echo e(route('transmittals.show', $tdoc->transmittal_id)); ?>" target="_blank" class="fw-bold text-primary"><?php echo e($tdoc->transmittal->transmittal_number); ?></a></td>
                                    <td class="text-truncate-2" style="max-width: 200px;"><?php echo e($tdoc->transmittal->subject ?? '-'); ?></td>
                                    <td><?php echo e($tdoc->transmittal->sender?->name ?? '-'); ?></td>
                                    <td><?php echo e($tdoc->transmittal->receiver?->name ?? '-'); ?></td>
                                    <td><span class="badge bg-secondary"><?php echo e($tdoc->transmittal->purpose ?? '-'); ?></span></td>
                                    <td><?php echo $tdoc->transmittal->status_badge; ?></td>
                                    <td><?php echo e($tdoc->transmittal->sent_at_formatted); ?></td>
                                    <td>
                                        <?php if($tdoc->transmittal->attachment_url): ?>
                                            <a href="<?php echo e($tdoc->transmittal->attachment_url); ?>" target="_blank" class="transmittal-attachment-link">
                                                <i class="fas fa-paperclip"></i>
                                            </a>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="8" class="text-muted text-center py-4"><?php echo e(__('رکوردی موجود نیست.')); ?></td></tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary btn-modern" data-bs-dismiss="modal" wire:click="closeTransmittalModal"><?php echo e(__('بستن')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <!-- مودال پیش‌نمایش با wire:ignore.self -->
    <?php if($previewFileUrl): ?>
        <div wire:ignore.self class="modal fade show preview-modal" style="display:block;background:rgba(0,0,0,0.7);z-index:1060" tabindex="-1">
            <div class="modal-dialog modal-xl">
                <div class="modal-content rounded-3">
                    <div class="modal-header bg-light">
                        <h5><?php echo e(__('پیش‌نمایش فایل')); ?></h5>
                        <button type="button" class="btn-close" wire:click="closePreviewModal"></button>
                    </div>
                    <div class="modal-body text-center p-3">
                        <?php if(str_ends_with($previewFileUrl, '.pdf')): ?>
                            <iframe src="<?php echo e($previewFileUrl); ?>" width="100%" height="700px" class="rounded-3"></iframe>
                        <?php else: ?>
                            <img src="<?php echo e($previewFileUrl); ?>" class="img-fluid rounded-3" alt="Preview">
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <script>
        document.addEventListener('livewire:initialized', () => {
            // مطمئن شوید که بوت استرپ بارگذاری شده است
            if (typeof bootstrap === 'undefined') {
                console.error('Bootstrap is not loaded.');
                return;
            }

            // مدیریت مودال فرم
            const formModalEl = document.getElementById('formModal');
            let formModalInstance = null;
            if (formModalEl) {
                formModalInstance = new bootstrap.Modal(formModalEl, { keyboard: false, backdrop: 'static' });
            }
            Livewire.on('open-form-modal', () => { if (formModalInstance) formModalInstance.show(); });
            Livewire.on('close-form-modal', () => { if (formModalInstance) formModalInstance.hide(); });

            // مدیریت مودال رویژن
            const revisionModalEl = document.getElementById('revisionModal');
            let revisionModalInstance = null;
            if (revisionModalEl) {
                revisionModalInstance = new bootstrap.Modal(revisionModalEl, { keyboard: false, backdrop: 'static' });
            }
            Livewire.on('open-revision-modal', () => { if (revisionModalInstance) revisionModalInstance.show(); });
            Livewire.on('close-revision-modal', () => { if (revisionModalInstance) revisionModalInstance.hide(); });

            // مدیریت مودال ترنسمیتال
            const transmittalModalEl = document.getElementById('transmittalModal');
            let transmittalModalInstance = null;
            if (transmittalModalEl) {
                transmittalModalInstance = new bootstrap.Modal(transmittalModalEl, { keyboard: false, backdrop: 'static' });
            }
            Livewire.on('open-transmittal-modal', () => { if (transmittalModalInstance) transmittalModalInstance.show(); });
            Livewire.on('close-transmittal-modal', () => { if (transmittalModalInstance) transmittalModalInstance.hide(); });

            // مدیریت مودال پیش‌نمایش
            const previewModalEl = document.querySelector('.preview-modal');
            let previewModalInstance = null;
            if (previewModalEl) {
                previewModalInstance = new bootstrap.Modal(previewModalEl, { keyboard: false, backdrop: 'static' });
            }
            Livewire.on('open-preview-modal', () => { if (previewModalInstance) previewModalInstance.show(); });
            Livewire.on('close-preview-modal', () => { if (previewModalInstance) previewModalInstance.hide(); });

            // بستن خودکار مودال‌ها در صورت حذف شدن element توسط Livewire
            Livewire.hook('element.removed', (el) => {
                const modals = {
                    'formModal': formModalInstance,
                    'revisionModal': revisionModalInstance,
                    'transmittalModal': transmittalModalInstance,
                    'preview-modal': previewModalInstance
                };
                if (modals[el.id]) {
                    modals[el.id].dispose();
                }
            });
        });
    </script>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\m-d-r\project-mdr-list.blade.php ENDPATH**/ ?>