<div class="saraman-luxury-v11 pb-5 overflow-visible">
    <style>
        /* 💎 Master Visual Language v11 - Ultimate Platinum Edition */
        .saraman-luxury-v11 {
            --p-indigo: #6366f1; --p-purple: #8b5cf6; --p-emerald: #10b981; --p-amber: #f59e0b;
            --p-gradient-main: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
            --navy-obsidian: #0f172a; --glass-core: rgba(255, 255, 255, 0.9);
            --border-lux: rgba(255, 255, 255, 0.8);
            --shadow-base: 0 20px 50px -12px rgba(99, 102, 241, 0.15);
            --shadow-deep: 0 40px 80px -20px rgba(15, 23, 42, 0.2);

            background: radial-gradient(circle at 10% 10%, #f8fafc 0%, #f1f5f9 50%, #e2e8f0 100%);
            min-height: 100vh; direction: rtl; font-family: 'Vazirmatn', sans-serif; color: var(--navy-obsidian);
        }

        /* ✨ انیمیشن ورود آرام */
        .reveal-node { opacity: 0; animation: revealUp 1s cubic-bezier(0.19, 1, 0.22, 1) forwards; }
        @keyframes revealUp { from { opacity: 0; transform: translateY(50px); } to { opacity: 1; transform: translateY(0); } }

        /* 🏔️ Hero Module - Floating Glass */
        .hero-banner-lux {
            background: var(--glass-core); backdrop-filter: blur(40px);
            border-radius: 50px; border: 2px solid var(--border-lux);
            padding: 3.5rem; box-shadow: var(--shadow-base); display: flex;
            justify-content: space-between; align-items: center; position: relative;
            z-index: 10; margin-top: 2rem;
        }

        .budget-card-lux {
            background: var(--navy-obsidian); color: white; border-radius: 35px;
            padding: 25px 40px; display: flex; align-items: center; gap: 30px;
            box-shadow: 0 25px 50px -12px rgba(0,0,0,0.3); position: relative; overflow: hidden;
        }
        .budget-card-lux::after {
            content: ''; position: absolute; top: 0; right: 0; width: 5px; height: 100%; background: var(--p-emerald);
        }

        /* 📦 Bento Grid Precision */
        .bento-node {
            background: white; border-radius: 40px; padding: 2.2rem;
            border: 1px solid #edf2f7; box-shadow: var(--shadow-base);
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .bento-node:hover { transform: translateY(-15px) scale(1.02); box-shadow: var(--shadow-deep); border-color: var(--p-indigo); }

        /* 🛠️ Action Console Grid */
        .console-box-lux {
            background: var(--glass-core); backdrop-filter: blur(50px);
            border-radius: 60px; border: 1px solid white;
            padding: 4rem; box-shadow: var(--shadow-deep);
        }

        .category-header {
            font-size: 0.7rem; font-weight: 900; color: white;
            background: var(--navy-obsidian); padding: 6px 18px;
            border-radius: 50px; margin-bottom: 2.5rem; display: inline-flex; align-items: center; gap: 8px;
        }

        .smart-link-lux {
            display: flex; align-items: center; justify-content: space-between;
            padding: 16px 22px; border-radius: 22px; background: white;
            color: var(--navy-obsidian); font-weight: 700; transition: 0.4s;
            text-decoration: none !important; margin-bottom: 14px;
            border: 1px solid #f1f5f9; box-shadow: 0 4px 6px rgba(0,0,0,0.02);
        }
        .smart-link-lux:hover {
            background: var(--navy-obsidian); color: white !important;
            transform: translateX(-15px); box-shadow: 0 20px 40px rgba(0,0,0,0.15);
        }
        .smart-link-lux i { font-size: 1.4rem; transition: 0.3s; }
        .smart-link-lux:hover i { transform: scale(1.2); color: var(--p-indigo); }

        /* 📋 Activity Obsidian Feed */
        .obsidian-feed {
            background: #0f172a; border-radius: 50px;
            color: white; padding: 2.5rem; box-shadow: var(--shadow-deep);
        }

        /* 👤 Team Avatars */
        .avatar-sq {
            width: 58px; height: 58px; border-radius: 18px; object-fit: cover;
            border: 2px solid white; transition: 0.4s ease;
        }
        .avatar-sq:hover { transform: scale(1.25) rotate(-5deg); z-index: 10; box-shadow: 0 10px 20px rgba(99, 102, 241, 0.3); }

        /* 🛳️ Navigation Dock */
        .lux-dock-v11 {
            position: fixed; bottom: 35px; left: 50%; transform: translateX(-50%);
            background: rgba(15, 23, 42, 0.95); backdrop-filter: blur(40px);
            padding: 12px 35px; border-radius: 100px; display: flex; gap: 30px;
            border: 1px solid rgba(255,255,255,0.1); box-shadow: 0 30px 60px rgba(0,0,0,0.5);
            z-index: 10000;
        }
        .dock-item {
            color: rgba(255,255,255,0.6); font-size: 1.8rem; transition: 0.4s;
            display: flex; align-items: center; justify-content: center;
        }
        .dock-item:hover { transform: scale(1.5) translateY(-15px); color: white; text-shadow: 0 0 15px var(--p-indigo); }

        .lux-badge { font-size: 0.65rem; font-weight: 900; padding: 4px 12px; border-radius: 50px; text-transform: uppercase; }

        /* Custom Scrollbar */
        .scrollbar-lux::-webkit-scrollbar { width: 4px; }
        .scrollbar-lux::-webkit-scrollbar-thumb { background: rgba(255,255,255,0.1); border-radius: 10px; }
    </style>

    <div class="container-fluid px-lg-5">

        
        <div class="hero-banner-lux mb-5 reveal-node" style="animation-delay: 0.1s">
            <div class="d-flex align-items-center gap-5">
                <div class="position-relative" style="width: 110px; height: 110px;">
                    <svg width="110" height="110" viewBox="0 0 100 100">
                        <circle cx="50" cy="50" r="44" fill="none" stroke="#f1f5f9" stroke-width="8"></circle>
                        <circle cx="50" cy="50" r="44" fill="none" stroke="url(#luxGradient)" stroke-width="10"
                                stroke-dasharray="276.4" stroke-dashoffset="<?php echo e(276.4 - (276.4 * $progressPercent) / 100); ?>"
                                stroke-linecap="round"></circle>
                    </svg>
                    <div class="position-absolute top-50 start-50 translate-middle text-center">
                        <span class="fw-black d-block fs-3"><?php echo e($progressPercent); ?>%</span>
                    </div>
                </div>
                <div>
                    <h1 class="fw-black mb-1 display-5 letter-spacing-n1"><?php echo e($project->name); ?></h1>
                    <div class="d-flex align-items-center gap-3 mt-2">
                        <span class="lux-badge bg-indigo-subtle text-indigo border border-indigo border-opacity-20">کد پروژه: <?php echo e($project->code); ?></span>
                        <div class="vr opacity-20"></div>
                        <span class="text-success fw-black small d-flex align-items-center gap-1">
                            <span class="status-dot-pulse bg-success" style="width: 8px; height: 8px; border-radius: 50%; display: inline-block;"></span>
                            وضعیت پایداری عملیات: فعال
                        </span>
                    </div>
                </div>
            </div>

            <div class="budget-card-lux">
                <div class="text-start">
                    <small class="text-white-50 fw-bold d-block mb-1">REMAINING LIQUIDITY</small>
                    <div class="fw-black fs-3 text-emerald"><?php echo e(number_format($financialMetrics['remainingBudget'] / 1000000, 1)); ?> <small class="fs-6 opacity-40">M.R</small></div>
                </div>
                <div class="vr opacity-10"></div>
                <div class="p-3 bg-white bg-opacity-5 rounded-4"><i class="ti ti-chart-arrows-vertical fs-2 text-indigo"></i></div>
            </div>
        </div>

        
        <div class="row g-4 mb-5 reveal-node" style="animation-delay: 0.2s">
            <?php $__currentLoopData = $mainStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-6 col-xl-3">
                    <div class="bento-node h-100">
                        <div class="d-flex justify-content-between align-items-start mb-4">
                            <div class="p-3 rounded-4 bg-<?php echo e($s['color']); ?> bg-opacity-10 text-<?php echo e($s['color']); ?>">
                                <i class="<?php echo e($s['icon']); ?> fs-3"></i>
                            </div>
                            <span class="lux-badge bg-light text-muted">LIVE DATA</span>
                        </div>
                        <h3 class="fw-black mb-1"><?php echo e($s['value']); ?></h3>
                        <div class="fw-bold text-muted small"><?php echo e($s['label']); ?></div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="row g-5">
            
            <div class="col-xl-9">
                <div class="console-box-lux reveal-node" style="animation-delay: 0.3s">
                    <div class="d-flex justify-content-between align-items-center mb-5 border-bottom pb-4">
                        <h3 class="fw-black mb-0">Project Console <span class="text-muted fw-light opacity-50">/ میز عملیات فنی</span></h3>
                        <div class="d-flex gap-2">
                            <div class="bg-indigo p-2 rounded-3 text-white shadow-sm"><i class="ti ti-cpu"></i></div>
                            <div class="bg-emerald p-2 rounded-3 text-white shadow-sm"><i class="ti ti-cash-banknote"></i></div>
                        </div>
                    </div>

                    <div class="row g-5 text-start">
                        <div class="col-md-4 border-start border-light-subtle">
                            <span class="category-header"><i class="ti ti-apps"></i> CORE MANAGEMENT</span>
                            <a href="<?php echo e(route('admin.projects.contract-roles', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>طرفین قرارداد</span> <i class="ti ti-users-group text-primary"></i></a>
                            <a href="<?php echo e(route('admin.projects.letters.create', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>ایجاد نامه جدید</span> <i class="ti ti-file-pencil text-primary"></i></a>
                            <a href="<?php echo e(route('admin.projects.letters.list', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>آرشیو مکاتبات</span> <i class="ti ti-mail-forward text-primary"></i></a>
                            <a href="<?php echo e(route('projects.section', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>مدیریت بخش‌ها</span> <i class="ti ti-hierarchy-2 text-primary"></i></a>
                            <a href="<?php echo e(route('projects.createOrRename', ['projectId' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>ویرایش شناسنامه</span> <i class="ti ti-edit text-primary"></i></a>
                            <a href="<?php echo e(route('projects.wall', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>دیوار وضعیت</span> <i class="ti ti-timeline text-primary"></i></a>
                            <a href="#" data-bs-toggle="modal" data-bs-target="#addSectionModal" wire:click="openAddSectionModal(<?php echo e($project->id); ?>, '<?php echo e($project->name); ?>')" class="smart-link-lux text-emerald border-dashed"><span>افزودن بخش جدید</span> <i class="ti ti-circle-plus"></i></a>
                        </div>

                        <div class="col-md-4 border-start border-light-subtle">
                            <span class="category-header" style="background: var(--p-emerald);"><i class="ti ti-receipt-2"></i> FINANCIAL FLOW</span>
                            <a href="<?php echo e(route('admin.purchase_request', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>درخواست خرید</span> <i class="ti ti-shopping-cart text-success"></i></a>
                            <a href="<?php echo e(route('admin.projects.purchase-requests', ['projectId' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>لیست خریدها</span> <i class="ti ti-list-check text-success"></i></a>
                            <a href="<?php echo e(route('admin.payment.create', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>درخواست وجه</span> <i class="ti ti-coin text-success"></i></a>
                            <a href="<?php echo e(route('admin.payment.create', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>لیست پرداخت‌ها</span> <i class="ti ti-credit-card text-success"></i></a>
                            <a href="<?php echo e(route('admin.petty-cash.create', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>درخواست تنخواه</span> <i class="ti ti-wallet text-success"></i></a>
                            <a href="<?php echo e(route('admin.petty-cash.project', ['projectId' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>آرشیو تنخواه</span> <i class="ti ti-history text-success"></i></a>
                            <a href="<?php echo e(route('admin.create.insurance.detail', ['projectId' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>بیمه و ضمانت‌نامه</span> <i class="ti ti-shield-check text-success"></i></a>
                        </div>

                        <div class="col-md-4">
                            <span class="category-header" style="background: var(--p-amber);"><i class="ti ti-vector-bezier-2"></i> ENGINEERING</span>
                            <a href="<?php echo e(route('mdr.list', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>اسناد MDR</span> <i class="ti ti-folder-check text-warning"></i></a>
                            <a href="<?php echo e(route('transmittal.create', ['project_id' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>صدور ترنسمیتال</span> <i class="ti ti-send text-warning"></i></a>
                            <a href="<?php echo e(route('admin.project.members', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>مدیریت تیم</span> <i class="ti ti-users-group text-warning"></i></a>
                            <a href="<?php echo e(route('admin.project.task.list', ['project' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>لیست وظایف</span> <i class="ti ti-checklist text-warning"></i></a>
                            <a href="<?php echo e(route('projects.details', ['projectId' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>قرارداد فنی</span> <i class="ti ti-certificate text-warning"></i></a>
                            <a href="<?php echo e(route('admin.create.project.schedule', ['projectId' => $project->id])); ?>" wire:navigate class="smart-link-lux"><span>زمانبندی گانت</span> <i class="ti ti-calendar-time text-warning"></i></a>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-xl-3">
                <div class="obsidian-feed mb-4 reveal-node" style="animation-delay: 0.4s">
                    <div class="d-flex align-items-center gap-3 mb-5 border-bottom border-white border-opacity-10 pb-3">
                        <i class="ti ti-activity-heartbeat text-warning fs-3 animate-pulse"></i>
                        <h5 class="fw-black mb-0 text-white">نبض سیستم</h5>
                    </div>
                    <div class="scrollbar-lux" style="max-height: 480px; overflow-y: auto;">
                        <?php $__currentLoopData = $recentActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $act): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex gap-3 mb-4">
                                <div class="mt-1">
                                    <div class="bg-<?php echo e($act['color']); ?> rounded-circle shadow-glow" style="width: 10px; height: 10px;"></div>
                                </div>
                                <div class="flex-grow-1 border-bottom border-white border-opacity-5 pb-3">
                                    <div class="small fw-bold text-white-50 leading-snug"><?php echo e($act['title']); ?></div>
                                    <div class="d-flex justify-content-between mt-2">
                                        <small class="opacity-40 fs-xs fw-bold"><?php echo e(jdate($act['created_at'])->ago()); ?></small>
                                        <span class="badge bg-white bg-opacity-5 smaller-8"><?php echo e($act['type']); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <div class="bento-node p-4 reveal-node shadow-sm" style="animation-delay: 0.5s">
                    <h6 class="fw-black mb-4">کارگروه پروژه</h6>
                    <div class="row g-3">
                        <?php $__currentLoopData = $teamMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-4 text-center">
                                <div class="position-relative d-inline-block mb-1">
                                    <img src="<?php echo e($this->getUserProfilePhotoUrl($m)); ?>" class="avatar-sq shadow-sm" title="<?php echo e($m->name); ?>">
                                    <div class="position-absolute bottom-0 start-0 bg-success border border-white rounded-circle shadow-sm" style="width: 12px; height: 12px; border-width: 2px !important;"></div>
                                </div>
                                <div class="smaller-8 fw-black text-muted text-truncate"><?php echo e(Str::before($m->name, ' ')); ?></div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="row g-4 mt-5 reveal-node" style="animation-delay: 0.6s">
            <div class="col-md-6">
                <div class="bento-node h-100">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h6 class="fw-black mb-0"><i class="ti ti-file-invoice me-2 text-indigo"></i>اسناد مهندسی (MDR)</h6>
                        <a href="<?php echo e(route('mdr.list', $project->id)); ?>" class="btn btn-sm btn-indigo rounded-pill px-3">مشاهده لیست</a>
                    </div>
                    <?php $__currentLoopData = \App\Models\MasterDocument::where('project_id', $project->id)->latest()->take(3)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex justify-content-between align-items-center p-3 rounded-4 mb-2" style="background: #f8fafc;">
                            <span class="small fw-bold text-dark text-truncate px-2"><?php echo e($doc->title); ?></span>
                            <span class="lux-badge bg-white shadow-sm"><?php echo e($doc->status); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="bento-node h-100">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h6 class="fw-black mb-0"><i class="ti ti-mail-share me-2 text-purple"></i>ترنسمیتال‌های ارسالی</h6>
                    </div>
                    <?php $__currentLoopData = \App\Models\Transmittal::where('project_id', $project->id)->latest()->take(3)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex justify-content-between align-items-center p-3 rounded-4 mb-2" style="background: #f8fafc;">
                            <span class="small fw-bold text-dark"><?php echo e($tr->transmittal_number); ?></span>
                            <div class="d-flex align-items-center gap-1 text-success fw-black fs-xs"><i class="ti ti-circle-check-filled"></i> SENT</div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>

    
    <nav class="lux-dock-v11">
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="dock-item" title="خانه"><i class="ti ti-layout-2"></i></a>
        <a href="<?php echo e(route('mdr.list', $project->id)); ?>" class="dock-item" title="مدارک"><i class="ti ti-folder-open"></i></a>
        <a href="<?php echo e(route('admin.purchase_request', ['project' => $project->id])); ?>" class="dock-item" title="لجستیک"><i class="ti ti-shopping-cart-bolt"></i></a>
        <a href="<?php echo e(route('admin.project.members', $project->id)); ?>" class="dock-item" title="تیم"><i class="ti ti-users"></i></a>
        <div class="vr bg-white opacity-20 my-2"></div>
        <button class="dock-item border-0 bg-transparent" onclick="window.scrollTo({top:0, behavior:'smooth'})"><i class="ti ti-arrow-bar-to-up"></i></button>
    </nav>

    <svg width="0" height="0">
        <defs>
            <linearGradient id="luxGradient" x1="0%" y1="0%" x2="100%" y2="100%">
                <stop offset="0%" stop-color="#6366f1" />
                <stop offset="100%" stop-color="#a855f7" />
            </linearGradient>
            <filter id="shadow-glow">
                <feGaussianBlur in="SourceAlpha" stdDeviation="3" />
                <feOffset dx="0" dy="4" result="offsetblur" />
                <feFlood flood-color="rgba(99, 102, 241, 0.4)" />
                <feComposite in2="offsetblur" operator="in" />
                <feMerge><feMergeNode /><feMergeNode in="SourceGraphic" /></feMerge>
            </filter>
        </defs>
    </svg>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\project-dashboard-single.blade.php ENDPATH**/ ?>