<div class="container-fluid" x-data="{}">
    <style>
        /* 💡 استایل‌های پایه CSS */
        :root {
            --primary-main: #4f46e5;
            --primary-darker: #004d99; /* آبی تیره */
            --light-subtle: #f0f3f8; /* خاکستری روشن */
            --secondary-darker: #4a5563;
            --border-color-subtle: #e5e7eb;
            --radius-lg: 0.75rem;
        }
        .text-primary-dark { color: var(--primary-darker) !important; }
        .bg-primary-darker { background-color: var(--bs-primary-darker) !important; }
        .bg-primary-subtle { background-color: var(--light-subtle) !important; }
        .card-shadow-wide { box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1) !important; }
        .rounded-3 { border-radius: var(--radius-lg) !important; }
        .form-control, .form-select { border-radius: 0.5rem; transition: all 0.2s; }

        /* Table/Row Enhancements */
        .table-row-item td { padding: 12px 1rem; border-color: var(--border-color-subtle) !important; }
        .amount-range-box {
            background: #fff;
            border-radius: 0.5rem;
            padding: 0.4rem 0.8rem;
            font-weight: 600;
            font-size: 0.9rem;
            border: 1px solid var(--border-color-subtle);
        }
        .approver-sub-row { background-color: #fafafa; }
        .approver-tag-item { background: #fff; border: 1px solid #ddd; padding: 0.5rem 0.8rem; border-radius: 1rem; }

        /* Header Specific */
        .section-header-modern {
            background: linear-gradient(135deg, #004d99 0%, #3b82f6 100%);
            color: white;
            padding: 2.5rem 2rem;
            margin-bottom: 2rem;
            border-radius: var(--radius-lg);
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.15);
        }
        .header-metric { background: rgba(255, 255, 255, 0.15); border-radius: 0.5rem; padding: 1rem; }
    </style>

    
    <div id="toast-container" class="position-fixed bottom-0 end-0 p-3" style="z-index: 1050;">
        <div id="liveToast" class="toast hide" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header bg-success text-white">
                <i class="ti ti-check me-2"></i>
                <strong class="me-auto">سیستم تأیید</strong>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body"></div>
        </div>
    </div>

    <div class="section-header-modern">
        <div class="row align-items-center">
            <div class="col-md-5">
                <h1 class="text-white fw-bold mb-1">مدیریت قوانین تأیید خرید</h1>
                <p class="text-white opacity-75">تنظیم و نظارت بر قوانین خرید و پرداخت در پروژه‌ها.</p>
            </div>
            <div class="col-md-7">
                <div class="row g-3">
                    <div class="col-4">
                        <div class="header-metric">
                            <i class="ti ti-check-circle fs-3 mb-1"></i>
                            <div class="small">قوانین فعال</div>
                            <div class="value"><?php echo e($rules->where('is_active', 1)->count()); ?></div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="header-metric">
                            <i class="ti ti-star fs-3 mb-1"></i>
                            <div class="small">قانون پیش‌فرض</div>
                            <div class="value"><?php echo e($rules->where('is_default', 1)->count()); ?></div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="header-metric">
                            <i class="ti ti-users fs-3 mb-1"></i>
                            <div class="small">کل تأییدکنندگان</div>
                            <div class="value"><?php echo e($rules->sum(fn($r) => $r->approvers->count())); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-lg border-0 mb-4 rounded-3 card-shadow-wide">
        <div class="card-body">
            <h5 class="mb-4 text-primary-dark border-bottom pb-2">
                <i class="ti ti-settings me-2"></i>
                <?php echo e($editRuleId ? 'ویرایش قانون: ' . $name : 'افزودن قانون جدید'); ?>

            </h5>
            <form wire:submit.prevent="<?php echo e($editRuleId ? 'updateRule' : 'saveRule'); ?>">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label small">نام قانون</label>
                        <input type="text" class="form-control" wire:model="name" required placeholder="مثلاً: تأیید امور مالی">
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label small">پروژه</label>
                        <select class="form-select" wire:model="projectId">
                            <option value="">(اعمال به همه پروژه‌ها)</option>
                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['projectId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label small">
                            اولویت اجرا
                            <i class="ti ti-info-circle tooltip-icon" data-bs-toggle="tooltip" title="قوانین با عدد کمتر، زودتر بررسی و اعمال می‌شوند."></i>
                        </label>
                        <input type="number" class="form-control" wire:model="priority" min="1" required placeholder="عدد کمتر = اولویت بالاتر">
                        <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label small">حداقل مبلغ (ریال)</label>
                        <input type="number" class="form-control" wire:model="amountMin" min="0" placeholder="۰">
                        <?php $__errorArgs = ['amountMin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label small">حداکثر مبلغ (ریال)</label>
                        <input type="number" class="form-control" wire:model="amountMax" min="0" placeholder="نامحدود">
                        <?php $__errorArgs = ['amountMax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6 d-flex align-items-center pt-3 gap-5">
                        <div class="form-check form-switch mt-3">
                            <input class="form-check-input" type="checkbox" wire:model="isDefault" id="isDefault">
                            <label class="form-check-label fw-bold small" for="isDefault">قانون پیش‌فرض</label>
                            <i class="ti ti-info-circle tooltip-icon" data-bs-toggle="tooltip" title="قانون پیش‌فرض برای درخواست‌هایی اعمال می‌شود که هیچ قانون دیگری بر آن‌ها منطبق نباشد."></i>
                        </div>
                        <div class="form-check form-switch mt-3">
                            <input class="form-check-input" type="checkbox" wire:model="isActive" id="isActive" value="1">
                            <label class="form-check-label fw-bold small" for="isActive">فعال</label>
                        </div>
                        <?php $__errorArgs = ['isActive'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-12 card-action-bar text-end pt-4">
                        <button type="submit" class="btn btn-primary-darker rounded-pill px-4">
                            <i class="ti ti-check"></i> <?php echo e($editRuleId ? 'ذخیره تغییرات' : 'ثبت قانون'); ?>

                        </button>
                        <?php if($editRuleId): ?>
                            <button type="button" class="btn btn-secondary rounded-pill px-4" wire:click="resetForm">
                                <i class="ti ti-x"></i> انصراف
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow-lg border-0 mb-4 rounded-3 card-shadow-wide">
        <div class="card-body">
            <h5 class="mb-4 text-primary-dark border-bottom pb-2">
                <i class="ti ti-user-plus me-2"></i>
                افزودن تأییدکننده به قانون
            </h5>
            <form wire:submit.prevent="saveApprover">
                <div class="row g-3 align-items-end">
                    <div class="col-md-3">
                        <label class="form-label small">انتخاب قانون</label>
                        <select class="form-select" wire:model.live="ruleId" required>
                            <option value="">انتخاب قانون</option>
                            <?php $__currentLoopData = $rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($rule->id); ?>"><?php echo e($rule->name); ?> (<?php echo e($rule->project->name ?? 'عمومی'); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['ruleId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label small">کاربر تأییدکننده</label>
                        <select class="form-select" wire:model="userId" required>
                            <option value="">انتخاب کاربر</option>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>">
                                    <?php echo e($user->name); ?> (<?php echo e($user->email); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['userId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label small">نقش مورد نیاز</label>
                        <select class="form-select" wire:model="roleId" required>
                            <option value="">انتخاب نقش</option>
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role->id); ?>"><?php echo e($role->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['roleId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">اولویت تأیید</label>
                        <input type="number" class="form-control" wire:model="approverPriority" min="1" required placeholder="پیشنهاد: <?php echo e($approverPriority); ?>">
                        <?php $__errorArgs = ['approverPriority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-1">
                        <label class="form-label small">&nbsp;</label>
                        <button type="submit" class="btn btn-success rounded-pill w-100">
                            <i class="ti ti-plus"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <ul class="nav nav-pills nav-tabs mb-3 p-2 bg-light-subtle rounded-3 shadow-sm d-flex justify-content-between align-items-center sticky-top-filters">
        <div class="d-flex overflow-auto">
            <li class="nav-item">
                <button class="nav-link <?php if(is_null($activeProject)): ?> active <?php endif; ?>" wire:click="$set('activeProject', null)">
                    همه قوانین
                </button>
            </li>
            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="nav-item">
                    <button class="nav-link <?php if($activeProject == $project->id): ?> active <?php endif; ?>" wire:click="$set('activeProject', <?php echo e($project->id); ?>)">
                        <?php echo e($project->name); ?>

                        <span class="badge bg-secondary ms-1">
                            <?php echo e($rules->where('project_id', $project->id)->count()); ?>

                        </span>
                    </button>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="d-flex gap-2">
            <button class="btn btn-sm btn-outline-secondary rounded-pill" wire:click="$set('viewMode', 'table')" :class="{'active': viewMode === 'table'}">
                <i class="ti ti-table"></i>
            </button>
            <button class="btn btn-sm btn-outline-secondary rounded-pill" wire:click="$set('viewMode', 'grid')" :class="{'active': viewMode === 'grid'}">
                <i class="ti ti-layout-grid"></i>
            </button>
        </div>
    </ul>

    <div class="row g-3 mb-3">
        <div class="col-md-6">
            <input type="text" class="form-control" wire:model.live.debounce.300ms="searchRule" placeholder="جستجوی نام قانون یا پروژه...">
        </div>
        <div class="col-md-3">
            <select class="form-select" wire:model.live="statusFilter">
                <option value="">همه وضعیت‌ها</option>
                <option value="1">فعال</option>
                <option value="0">غیرفعال</option>
            </select>
        </div>
        <div class="col-md-3">
            <select class="form-select" wire:model.live="isDefaultFilter">
                <option value="">همه</option>
                <option value="1">پیش‌فرض</option>
            </select>
        </div>
    </div>

    <?php if($viewMode == 'table'): ?>
        <div class="table-responsive">
            <table class="table table-hover table-borderless align-middle rounded-3 overflow-hidden shadow-sm">
                <thead class="bg-primary-darker text-white">
                <tr>
                    <th class="py-3">قانون / اولویت</th>
                    <th class="py-3">پروژه / دامنه مبلغ</th>
                    <th class="py-3">تأییدکنندگان</th>
                    <th class="py-3">وضعیت / پیش‌فرض</th>
                    <th class="py-3">عملیات</th>
                </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr wire:key="rule-<?php echo e($rule->id); ?>" class="border-bottom border-light-subtle table-row-item">
                        <td class="fw-bold text-primary-dark">
                            <?php echo e($rule->name); ?>

                            <div class="small text-muted">اولویت: <?php echo e($rule->priority); ?></div>
                        </td>
                        <td>
                            <div class="small text-dark"><?php echo e($rule->project->name ?? 'عمومی'); ?></div>
                            <div class="amount-range-box small text-secondary-darker mt-1">
                                <span class="fw-bold"><?php echo e($rule->amount_min ? number_format($rule->amount_min) : '۰'); ?></span> تا
                                <span class="fw-bold"><?php echo e($rule->amount_max ? number_format($rule->amount_max) : '∞'); ?></span> ریال
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-info-subtle text-info badge-approver">
                                <i class="ti ti-users me-1"></i> <?php echo e($rule->approvers->count()); ?> نفر
                            </span>
                        </td>
                        <td>
                            <div class="d-flex flex-column gap-1">
                                <span class="badge <?php if($rule->is_active): ?> bg-success <?php else: ?> bg-danger <?php endif; ?>">
                                    <?php if($rule->is_active): ?> فعال <?php else: ?> غیرفعال <?php endif; ?>
                                </span>
                                <?php if($rule->is_default): ?>
                                    <span class="badge bg-primary-darker mt-1">پیش‌فرض</span>
                                <?php else: ?>
                                    <button class="btn btn-sm btn-outline-secondary rounded-pill mt-1 btn-action-small" wire:click="setDefaultRule(<?php echo e($rule->id); ?>)">
                                        تنظیم پیش‌فرض
                                    </button>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td>
                            <button class="btn btn-sm btn-outline-primary-darker me-2 rounded-pill" wire:click="editRule(<?php echo e($rule->id); ?>)">
                                <i class="ti ti-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-danger rounded-pill" wire:click="deleteRule(<?php echo e($rule->id); ?>)" onclick="return confirm('آیا از حذف این قانون مطمئن هستید؟')">
                                <i class="ti ti-trash"></i>
                            </button>
                        </td>
                    </tr>
                    <?php if($rule->approvers->count()): ?>
                        <tr>
                            <td colspan="7" class="bg-light-subtle pt-2 pb-2 approver-sub-row">
                                <p class="small text-secondary-darker fw-bold mb-1 ps-3">تأییدکنندگان (اولویت/نقش)</p>
                                <div class="d-flex flex-wrap gap-3 ps-3">
                                    <?php $__currentLoopData = $rule->approvers->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="border rounded-pill px-3 py-1 d-flex align-items-center gap-2 bg-white shadow-sm badge-approver approver-tag-item">
                                            <span class="text-secondary"><i class="ti ti-user me-1"></i> <?php echo e($approver->user->name ?? 'N/A'); ?></span>
                                            <span class="badge bg-primary-subtle text-primary-dark"><?php echo e($approver->role->name ?? 'N/A'); ?></span>
                                            <span class="badge bg-secondary-subtle text-dark">اول: <?php echo e($approver->priority); ?></span>
                                            <button class="btn btn-xs btn-link text-danger" wire:click="deleteApprover(<?php echo e($approver->id); ?>)" title="حذف">
                                                <i class="ti ti-x"></i>
                                            </button>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center py-4 text-muted">
                            <i class="ti ti-info-circle fs-2"></i>
                            <br>
                            قانونی برای نمایش وجود ندارد.
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

    <?php if($viewMode == 'grid'): ?>
        <div class="row g-4 mb-4">
            <?php $__empty_1 = true; $__currentLoopData = $rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $statusColor = $rule->is_active ? 'success' : 'danger';
                ?>
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="card h-100 shadow-sm border-<?php echo e($statusColor); ?> border-3 border-top rounded-3 card-rule-compact">
                        <div class="card-body d-flex flex-column">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="mb-0 fw-bold text-primary-dark"><?php echo e($rule->name); ?></h6>
                                <span class="badge bg-<?php echo e($statusColor); ?> text-white rounded-pill"><?php echo e($rule->is_active ? 'فعال' : 'غیرفعال'); ?></span>
                            </div>

                            <p class="small text-muted mb-1">پروژه: <span class="fw-bold text-dark"><?php echo e($rule->project->name ?? 'عمومی'); ?></span></p>
                            <p class="small text-muted mb-2">اولویت اجرا: <span class="fw-bold text-primary"><?php echo e($rule->priority); ?></span></p>

                            <p class="small mb-3 p-2 bg-light-subtle rounded-pill text-center">
                                دامنه:
                                <span class="fw-bold"><?php echo e($rule->amount_min ? number_format($rule->amount_min) : '۰'); ?></span> تا
                                <span class="fw-bold"><?php echo e($rule->amount_max ? number_format($rule->amount_max) : 'نامحدود'); ?></span> ریال
                            </p>

                            <div class="mt-auto">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="text-info fw-bold">تأییدکنندگان (<?php echo e($rule->approvers->count()); ?>)</span>
                                    <?php if($rule->is_default): ?>
                                        <span class="badge bg-primary-darker">پیش‌فرض</span>
                                    <?php endif; ?>
                                </div>
                                <div class="d-flex gap-2 justify-content-end mt-3">
                                    <button class="btn btn-sm btn-outline-primary-darker" wire:click="editRule(<?php echo e($rule->id); ?>)">
                                        <i class="ti ti-edit"></i> ویرایش
                                    </button>
                                    <?php if(!$rule->is_default): ?>
                                        <button class="btn btn-sm btn-outline-secondary" wire:click="setDefaultRule(<?php echo e($rule->id); ?>)">
                                            <i class="ti ti-star"></i> پیش‌فرض
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12">
                    <div class="alert alert-info text-center py-4 rounded-3 shadow-sm">
                        <i class="ti ti-info-circle fs-2"></i>
                        <br>
                        قانونی برای نمایش وجود ندارد.
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <div class="mt-3">
        <?php echo e($rules->links()); ?>

    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            document.addEventListener('livewire:initialized', () => {
                // 💡 اسکریپت Toast Notification
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').on('show-toast', (event) => {
                    const data = event.detail[0];
                    const toastContainer = document.getElementById('toast-container');
                    if (!toastContainer) return;

                    const toast = document.createElement('div');
                    toast.className = `toast align-items-center text-white bg-${data.type === 'error' ? 'danger' : 'success'} border-0`;
                    toast.setAttribute('role', 'alert');
                    toast.setAttribute('aria-live', 'assertive');
                    toast.setAttribute('aria-atomic', 'true');
                    toast.innerHTML = `
                        <div class="d-flex">
                            <div class="toast-body">
                                ${data.message}
                            </div>
                            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                        </div>
                    `;
                    toastContainer.appendChild(toast);
                    const bsToast = new bootstrap.Toast(toast, { delay: 4000 });
                    bsToast.show();

                    toast.addEventListener('hidden.bs.toast', function () {
                        toast.remove();
                    })
                });
            });
            // 💡 فعال‌سازی Tooltips (با فرض وجود کتابخانه Bootstrap)
            document.addEventListener("DOMContentLoaded", function () {
                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                tooltipTriggerList.map(function (tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl);
                });
            });
        </script>
    <?php $__env->stopPush(); ?>

</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\approval\approval-management.blade.php ENDPATH**/ ?>