<?php if($showEditContactModal): ?>
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);" x-data>
        <div class="modal-dialog modal-lg modal-dialog-centered"> 
            <div class="modal-content rounded-3 border-0 shadow-lg">

                
                <div class="modal-header bg-primary text-white border-bottom-0 rounded-top-3 p-4">
                    <h5 class="modal-title fw-bolder d-flex align-items-center">
                        <i class="ti ti-edit me-2 fs-4"></i>
                        ویرایش مخاطب (ID: <?php echo e($editContactId); ?>)
                    </h5>
                    
                    <button type="button" class="btn-close btn-close-white opacity-100" aria-label="بستن"
                            wire:click="closeEditContactModal"></button>
                </div>

                <form wire:submit.prevent="updateContact">
                    <div class="modal-body p-4">
                        <div class="row g-3"> 

                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">نام کامل</label>
                                    <input type="text" wire:model.defer="editContactName" class="form-control rounded-3">
                                    <?php $__errorArgs = ['editContactName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold d-flex justify-content-between align-items-center">
                                        شماره تلفن <i class="ti ti-phone text-success me-1"></i>
                                    </label>
                                    <input type="text" wire:model.live.debounce.300ms="editContactPhone" class="form-control rounded-3">
                                    <?php $__errorArgs = ['editContactPhone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">نوع تماس</label>
                                    
                                    <select wire:model.defer="editContactPhoneType" class="form-select rounded-3">
                                        <option value="mobile">تلفن همراه</option>
                                        <option value="work">کاری</option>
                                        <option value="home">منزل</option>
                                        <option value="internal">داخلی</option>
                                        <option value="fax">فکس</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">گروه</label>
                                    <select wire:model.defer="editContactGroup" class="form-select rounded-3">
                                        <option value="">— بدون گروه —</option>
                                        <?php $__currentLoopData = $contactGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($group->id); ?>"><?php echo e($group->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">ایمیل (اختیاری)</label>
                                    <input type="email" wire:model.defer="editContactEmail" class="form-control rounded-3" placeholder="example@domain.com">
                                    <?php $__errorArgs = ['editContactEmail'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">فکس (اختیاری)</label>
                                    <input type="text" wire:model.defer="editContactFax" class="form-control rounded-3">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">آدرس (اختیاری)</label>
                                    <textarea wire:model.defer="editContactAddress" class="form-control rounded-3" rows="3"></textarea>
                                </div>

                                <?php if($hasTagsColumn): ?>
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">برچسب‌ها (با کاما جدا کنید)</label>
                                        <input type="text" wire:model.defer="editContactTags" class="form-control rounded-3" placeholder="مثلاً: مدیر، تامین‌کننده">
                                    </div>
                                <?php endif; ?>

                                <div class="mb-3 form-check form-switch pt-2">
                                    <input type="checkbox" wire:model.defer="editContactIsPublic" id="editIsPublic" class="form-check-input bg-primary border-primary">
                                    <label class="form-check-label fw-bold text-muted" for="editIsPublic">
                                        قابل مشاهده برای همه باشد؟
                                    </label>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="modal-footer justify-content-between">
                        
                        <button type="button" class="btn btn-secondary rounded-pill px-4" wire:click="closeEditContactModal">انصراف</button>
                        <button type="submit" class="btn btn-primary rounded-pill px-4 fw-bold" wire:loading.attr="disabled">
                            <span wire:loading.remove>ذخیره تغییرات</span>
                            <span wire:loading>... در حال ذخیره</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\contact\modals\edit-contact.blade.php ENDPATH**/ ?>