<div>
    <div class="letters-container rtl" dir="rtl"
         x-data="{
             toastStore: {
                 toasts: [],
                 add(type, msg, isGlobal = false) {
                     const id = Date.now();
                     const toastType = isGlobal ? 'global' : type;
                     this.toasts.push({id, type: toastType, message: msg, visible: true});
                     setTimeout(() => {
                         const t = this.toasts.find(t => t.id === id);
                         if (t) t.visible = false;
                         setTimeout(() => this.toasts = this.toasts.filter(t => t.id !== id), isGlobal ? 6500 : 3800);
                     }, isGlobal ? 6500 : 3800);
                 }
             },
             init() {
                 Livewire.on('show-toast', (e) => {
                     const data = Array.isArray(e) ? e[0] : e;
                     this.toastStore.add(data.type || 'info', data.message || 'پیام نامشخص');
                 });

                 // ✨ مدیریت تأیید با SweetAlert/Confirmation Dialog
                 Livewire.on('show-confirmation', (e) => {
                     const data = Array.isArray(e) ? e[0] : e;
                     if (typeof Swal !== 'undefined') {
                         Swal.fire({
                             title: data.title || 'آیا مطمئن هستید؟',
                             text: data.text || 'این عملیات قابل بازگشت نیست.',
                             icon: data.icon || 'warning',
                             showCancelButton: true,
                             confirmButtonColor: '#3085d6',
                             cancelButtonColor: '#d33',
                             confirmButtonText: data.confirmButtonText || 'بله، انجام بده!',
                             cancelButtonText: 'انصراف'
                         }).then((result) => {
                             if (result.isConfirmed) {
                                 // فراخوانی متد Livewire پس از تأیید
                                 window.Livewire.find('<?php echo e($_instance->getId()); ?>').dispatch('confirmed', {
                                     method: data.method,
                                     params: data.params || []
                                 });
                             }
                         });
                     }
                 });

                 if (window.Echo) {
                     window.Echo.private('App.Models.User.<?php echo e(Auth::id()); ?>')
                         .notification((notification) => {
                             if (notification.type === 'referral') {
                                 this.toastStore.add('global', notification.message, true);
                                 // ✨ Refresh component if a new referral arrives
                                 window.Livewire.find('<?php echo e($_instance->getId()); ?>').dispatch('refreshReceivedLetters');
                                 if (Notification.permission === 'granted') {
                                     new Notification('ارجاع جدید', {
                                         body: notification.message,
                                         icon: '/favicon.png'
                                     });
                                 }
                             }
                         });
                 }
             }
         }"
         x-init="$nextTick(() => { $el.querySelectorAll('[data-bs-toggle=tooltip]').forEach(el => new bootstrap.Tooltip(el)) })"
         style="font-family: 'Vazirmatn', 'Segoe UI', sans-serif;"
    >
        <style>
            /* CSS Variables - Remain unchanged */
            :root {
                --primary: hsl(217, 91%, 55%);
                --primary-50: hsl(217, 91%, 95%);
                --primary-100: hsl(217, 91%, 90%);
                --primary-600: hsl(217, 91%, 35%);
                --secondary: hsl(200, 15%, 55%);
                --accent: hsl(170, 100%, 45%);
                --bg: #f3f4f6;
                --card: #ffffff;
                --text: #1f2937;
                --text-muted: #6b7280;
                --border: #e5e7eb;
                --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.06);
                --shadow-lg: 0 10px 25px -3px rgba(15, 23, 42, 0.55), 0 4px 6px -4px rgba(15, 23, 42, 0.4);
                --transition: all 0.25s cubic-bezier(0.16, 1, 0.3, 1);

                --primary-dark: #3730A3;
                --primary-light: #EDE9FE;
                --gray-50: #F9FAFB;
                --gray-100: #F3F4F6;
                --gray-200: #E5E7EB;
                --gray-600: #4B5563;
                --gray-900: #111827;
            }

            .letters-container {
                max-width: 1600px;
                margin: 0 auto;
                padding: 24px 16px;
            }

            /* ✨ ENHANCED HEADER (Minimal Gradient) */
            .page-header {
                position: relative;
                padding: 24px 32px;
                border-radius: 24px;
                overflow: hidden;
                margin-bottom: 20px;
                box-shadow: var(--shadow-lg);
                background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 45%, #5B21B6 100%);
                color: white;
            }

            /* Light Particles */
            .page-header::before {
                content: '';
                position: absolute;
                top: 0; left: 0; width: 100%; height: 100%;
                background:
                    radial-gradient(circle at 20% 30%, rgba(255,255,255,0.07) 0%, transparent 40%),
                    radial-gradient(circle at 80% 70%, rgba(255,255,255,0.05) 0%, transparent 50%),
                    radial-gradient(circle at 50% 10%, rgba(255,255,255,0.04) 0%, transparent 60%);
                z-index: 0;
            }

            .header-content {
                position: relative;
                z-index: 2;
            }

            .header-title {
                font-size: 2.1rem;
                font-weight: 900;
                margin-bottom: 6px;
                letter-spacing: -0.5px;
                text-shadow: 0 2px 6px rgba(0,0,0,0.2);
                background: linear-gradient(to right, #ffffff, #e2e8f0);
                -webkit-background-clip: text;
                background-clip: text;
                color: transparent;
            }

            .header-subtitle {
                opacity: 0.85;
                font-size: 0.95rem;
                max-width: 600px;
                line-height: 1.4;
                margin-bottom: 0;
            }

            /* Floating Stat Cards */
            .stats-grid {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
                gap: 12px;
                margin-top: 24px;
            }

            .stat-card {
                background: rgba(255, 255, 255, 0.08);
                backdrop-filter: blur(16px);
                -webkit-backdrop-filter: blur(16px);
                border: 1px solid rgba(255, 255, 255, 0.18);
                border-radius: 22px;
                padding: 18px 20px;
                transition: var(--transition);
                cursor: pointer;
                position: relative;
                overflow: hidden;
                box-shadow: 0 8px 20px -8px rgba(0, 0, 0, 0.3);
            }

            .stat-card::before {
                content: '';
                position: absolute;
                top: 0; left: 0; right: 0; height: 4px;
                background: linear-gradient(90deg, #4F46E5, #10B981, #3B82F6);
                opacity: 0.7;
                transform: scaleX(0);
                transform-origin: left;
                transition: transform 0.4s ease;
            }

            .stat-card:hover {
                transform: translateY(-4px);
                background: rgba(255, 255, 255, 0.12);
                box-shadow: 0 10px 25px -6px rgba(0, 0, 0, 0.35);
            }

            .stat-card:hover::before, .stat-card.active::before {
                transform: scaleX(1);
            }

            .stat-card.active {
                background: rgba(255, 255, 255, 0.2);
                box-shadow: 0 10px 25px -6px rgba(0, 0, 0, 0.35);
                transform: translateY(-2px);
            }

            .stat-value {
                font-size: 1.8rem;
                font-weight: 800;
                margin: 4px 0 4px;
                background: linear-gradient(to right, #ffffff, #cbd5e1);
                -webkit-background-clip: text;
                background-clip: text;
                color: transparent;
            }

            .stat-label {
                font-size: 0.95rem;
                opacity: 0.85;
                font-weight: 500;
            }

            /* Filters — Modern Glass */
            .filter-section {
                background: rgba(255, 255, 255, 0.07);
                backdrop-filter: blur(14px);
                -webkit-backdrop-filter: blur(14px);
                border-radius: 22px;
                padding: 20px;
                margin-top: 20px;
                border: 1px solid rgba(255, 255, 255, 0.15);
            }

            .filter-row {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); /* ✨ متراکم‌تر */
                gap: 15px; /* ✨ کاهش گپ */
                align-items: end;
            }

            .form-label {
                font-size: 0.875rem;
                font-weight: 600;
                margin-bottom: 8px;
                color: rgba(255, 255, 255, 0.95);
            }

            .form-control, .form-select {
                background: rgba(255, 255, 255, 0.12);
                border: 1px solid rgba(255, 255, 255, 0.3);
                color: white;
                border-radius: 12px; /* ✨ گردتر */
                padding: 10px 14px; /* ✨ متراکم‌تر */
                font-size: 0.9rem;
                transition: var(--transition);
            }

            .form-control::placeholder {
                color: rgba(255, 255, 255, 0.6);
            }

            .form-control:focus, .form-select:focus {
                outline: none;
                border-color: rgba(255, 255, 255, 0.8);
                box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.25);
                background: rgba(255, 255, 255, 0.2);
            }

            .form-select option {
                background-color: #3b82f6; /* ✨ رنگ پس زمینه تیره برای آپشن‌ها */
                color: white;
            }

            .btn-outline-light {
                background: transparent;
                border: 2px solid rgba(255, 255, 255, 0.5);
                color: white;
                border-radius: 12px; /* ✨ گردتر */
                padding: 8px 18px; /* ✨ متراکم‌تر */
                font-weight: 600;
                transition: var(--transition);
                display: inline-flex;
                align-items: center;
                gap: 8px;
            }

            .btn-outline-light:hover {
                background: rgba(255, 255, 255, 0.15);
                border-color: white;
                transform: translateY(-2px);
            }

            .btn-outline-light:active {
                transform: translateY(0);
            }

            /* Smart Referrer Badges */
            .top-referrers {
                margin-top: 24px;
                display: flex;
                flex-wrap: wrap;
                gap: 8px; /* ✨ متراکم‌تر */
            }

            .top-referrer-badge {
                display: inline-flex;
                align-items: center;
                gap: 8px; /* ✨ متراکم‌تر */
                background: rgba(255, 255, 255, 0.1);
                border: 1px solid rgba(255, 255, 255, 0.3);
                border-radius: 12px; /* ✨ گردتر */
                padding: 6px 12px; /* ✨ متراکم‌تر */
                font-size: 0.85rem;
                cursor: pointer;
                transition: var(--transition);
            }

            .top-referrer-avatar {
                width: 28px; /* ✨ متراکم‌تر */
                height: 28px; /* ✨ متراکم‌تر */
                border-radius: 50%;
                flex-shrink: 0;
                border: 2px solid rgba(255, 255, 255, 0.3);
            }

            /* Table */
            .main-content-card {
                background: white;
                border-radius: 18px; /* ✨ کمی کوچکتر */
                box-shadow: var(--shadow-lg);
                overflow: hidden;
            }

            /* 💡 وضعیت Loading برای جدول */
            .table-loading {
                position: relative;
            }
            .table-loading::after {
                content: '';
                position: absolute;
                top: 0; left: 0; right: 0; bottom: 0;
                background: rgba(255, 255, 255, 0.8);
                backdrop-filter: blur(2px);
                z-index: 50;
            }
            .loading-spinner {
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                z-index: 60;
                color: var(--primary);
                font-size: 2rem;
            }


            .table-responsive {
                overflow-x: auto;
                scrollbar-width: thin;
                scrollbar-color: #E5E7EB transparent;
            }

            .table {
                min-width: 900px; /* ✨ حداقل عرض متعادل */
                margin-bottom: 0;
            }

            .table thead th {
                color: var(--gray-900);
                background: var(--gray-50);
                font-weight: 700;
                font-size: 0.85rem; /* ✨ متراکم‌سازی */
                padding: 12px 14px; /* ✨ متراکم‌سازی */
                border-bottom: 3px solid var(--primary);
            }

            .table tbody tr {
                transition: var(--transition);
            }

            .table tbody tr:hover {
                background-color: #F9FAFB;
            }

            .table tbody td {
                padding: 10px 14px; /* ✨ متراکم‌سازی شدید */
                vertical-align: middle;
                font-size: 0.9rem; /* ✨ متراکم‌سازی */
                border-color: var(--gray-200);
            }

            /* Avatar */
            .avatar {
                width: 36px; /* ✨ متراکم‌سازی */
                height: 36px; /* ✨ متراکم‌سازی */
                min-width: 36px;
                border-radius: 50%;
                overflow: hidden;
                background: #E5E7EB;
                display: flex;
                align-items: center;
                justify-content: center;
                flex-shrink: 0;
                box-shadow: 0 3px 6px rgba(0,0,0,0.08);
            }

            /* Title */
            .letter-title {
                font-weight: 600; /* ✨ متراکم‌سازی */
                color: var(--primary);
                cursor: pointer;
                transition: var(--transition);
                display: inline-block;
                max-width: 280px; /* ✨ متراکم‌سازی */
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
                font-size: 0.95rem;
            }

            .letter-title:hover {
                color: #2563EB;
                text-decoration: underline;
                text-decoration-thickness: 1.5px;
                text-underline-offset: 3px;
            }

            /* Status Badge */
            .status-badge {
                display: inline-flex;
                align-items: center;
                gap: 6px; /* ✨ متراکم‌تر */
                padding: 6px 14px; /* ✨ متراکم‌تر */
                border-radius: 100px;
                font-size: 0.8rem; /* ✨ متراکم‌تر */
                font-weight: 600;
                white-space: nowrap;
                box-shadow: 0 1px 3px rgba(0,0,0,0.05);
            }

            .status-badge.pending {
                background-color: #fef9c3;
                color: #854d0e;
                border: 1px solid #fde68a;
            }
            .status-badge.viewed {
                background-color: #dbeafe;
                color: #1e40af;
                border: 1px solid #bfdbfe;
            }
            .status-badge.completed {
                background-color: #d1fae5;
                color: #065f46;
                border: 1px solid #a7f3d0;
            }
            .status-badge.canceled, .status-badge.rejected {
                background-color: #fee2e2;
                color: #b91c1c;
                border: 1px solid #fecaca;
            }

            /* Quick Action Buttons */
            .quick-action {
                width: 32px; /* ✨ متراکم‌تر */
                height: 32px; /* ✨ متراکم‌تر */
                border-radius: 10px; /* ✨ متراکم‌تر */
                display: flex;
                align-items: center;
                justify-content: center;
                transition: var(--transition);
                border: 1px solid var(--gray-200);
                box-shadow: 0 1px 3px rgba(0,0,0,0.05);
                font-size: 0.85rem;
            }

            .quick-action.read {
                background: #dbeafe;
                color: #1e40af;
            }
            .quick-action.read:hover {
                background: #bfdbfe;
                transform: scale(1.05) translateY(-1px);
            }

            .quick-action.complete {
                background: #d1fae5;
                color: #065f46;
            }
            .quick-action.complete:hover {
                background: #a7f3d0;
                transform: scale(1.05) translateY(-1px);
            }

            .quick-action.correction {
                background: #fef3c7;
                color: #92400e;
            }
            .quick-action.correction:hover {
                background: #fde68a;
                transform: scale(1.05) translateY(-1px);
            }

            .quick-action.neutral {
                background: #f3f4f6;
                color: #4b5563;
            }
            .quick-action.neutral:hover {
                background: #e5e7eb;
                transform: scale(1.05) translateY(-1px);
            }

            /* Unread Pulse */
            .unread-pulse {
                position: relative;
            }
            .unread-pulse::after {
                content: '';
                position: absolute;
                top: -3px; /* ✨ متراکم‌تر */
                right: -3px; /* ✨ متراکم‌تر */
                width: 8px; /* ✨ متراکم‌تر */
                height: 8px; /* ✨ متراکم‌تر */
                background: #ef4444;
                border-radius: 50%;
                animation: pulse 2s infinite;
                box-shadow: 0 0 0 0 rgba(239, 68, 68, 0.7);
                z-index: 10;
            }
            @keyframes pulse {
                0% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0.7); }
                70% { box-shadow: 0 0 0 8px rgba(239, 68, 68, 0); } /* ✨ متراکم‌تر */
                100% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0); }
            }

            /* Empty State */
            .empty-state {
                padding: 80px 24px; /* ✨ متراکم‌تر */
                text-align: center;
            }
            .empty-icon {
                width: 100px; /* ✨ متراکم‌تر */
                height: 100px; /* ✨ متراکم‌تر */
                margin: 0 auto 30px; /* ✨ متراکم‌تر */
                background: #f3f4f6;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                color: #9ca3af;
                font-size: 2.5rem; /* ✨ متراکم‌تر */
            }
            .empty-title {
                font-size: 1.5rem; /* ✨ متراکم‌تر */
                font-weight: 800;
                margin-bottom: 12px; /* ✨ متراکم‌تر */
                color: #374151;
            }
            .empty-desc {
                color: #6b7280;
                max-width: 500px;
                margin: 0 auto 30px; /* ✨ متراکم‌تر */
                line-height: 1.6;
                font-size: 1rem; /* ✨ متراکم‌تر */
            }

            /* Toasts - Remain unchanged */
            .notification-container { z-index: 1200; }
            .toast { border-radius: 16px !important; overflow: hidden; box-shadow: 0 10px 25px -5px rgba(0,0,0,0.15); }
            .toast-header { padding: 14px 18px !important; font-weight: 600; }
            .toast-body { padding: 16px 18px !important; font-size: 0.95rem; }

        </style>

        <?php $__env->startPush('scripts'); ?>
            <script>
                if (window.Notification && Notification.permission !== 'granted') {
                    Notification.requestPermission();
                }
            </script>
            <?php if(file_exists(public_path('assets/js/sweetalert2.min.js'))): ?>
                <script src="<?php echo e(asset('assets/js/sweetalert2.min.js')); ?>"></script>
            <?php endif; ?>
        <?php $__env->stopPush(); ?>

        <div class="notification-container position-fixed top-0 end-0 p-4">
            <template x-for="t in toastStore.toasts" :key="t.id">
                <div x-show="t.visible"
                     x-transition:enter="transition ease-out duration-400"
                     x-transition:enter-start="opacity-0 translate-x-full scale-95"
                     x-transition:enter-end="opacity-100 translate-x-0 scale-100"
                     x-transition:leave="transition ease-in duration-300"
                     x-transition:leave-start="opacity-100 translate-x-0 scale-100"
                     x-transition:leave-end="opacity-0 translate-x-full scale-95"
                     class="toast show mb-3"
                     role="alert">
                    <div class="toast-header"
                         :class="{
                             'bg-success text-white': t.type === 'success',
                             'bg-danger text-white': t.type === 'error',
                             'bg-info text-white': t.type === 'info',
                             'bg-primary-dark text-white': t.type === 'global',
                             'bg-warning text-white': t.type === 'warning'
                         }">
                        <i class="me-2"
                           :class="{
                               'fas fa-check-circle': t.type === 'success',
                               'fas fa-exclamation-triangle': t.type === 'error',
                               'fas fa-info-circle': t.type === 'info',
                               'fas fa-bell': t.type === 'global',
                               'fas fa-undo-alt': t.type === 'warning'
                           }"></i>
                        <strong class="me-auto" x-text="t.type === 'success' ? 'موفقیت' : (t.type === 'error' ? 'خطا' : (t.type === 'global' ? 'اطلاعیه جدید' : 'اطلاعات'))"></strong>
                        <button type="button" class="btn-close btn-close-white" @click="t.visible = false"></button>
                    </div>
                    <div class="toast-body bg-white text-gray-800" x-text="t.message"></div>
                </div>
            </template>
        </div>

        <div class="page-header">
            <div class="header-content">
                <div class="d-flex flex-column flex-md-row justify-content-between align-items-start gap-3 mb-3">
                    <div class="d-flex align-items-center gap-3">
                        <div class="d-flex align-items-center justify-content-center flex-shrink-0"
                             style="width: 56px; height: 56px; background: rgba(255,255,255,0.15); border-radius: 16px; box-shadow: 0 4px 10px rgba(0,0,0,0.2);">
                            <i class="fas fa-inbox text-white" style="font-size: 1.8rem;"></i>
                        </div>
                        <div>
                            <h1 class="header-title">صندوق نامه‌های دریافتی</h1>
                            <p class="header-subtitle">
                                ارجاعات و نامه‌های ارسالی به شما برای اقدام — با پیگیری هوشمند و نوتیفیکیشن Realtime
                            </p>
                        </div>
                    </div>
                </div>

                <div class="stats-grid">
                    <div class="stat-card"
                         wire:click="$set('filterReferralStatus', 'pending')"
                         :class="{ 'active': $wire.filterReferralStatus === 'pending' }">
                        <div class="stat-label">در انتظار</div>
                        <div class="stat-value text-warning"><?php echo e($statusCounts['pending'] ?? 0); ?></div>
                        <div class="text-xs opacity-80 mt-1">نیاز به اقدام فوری</div>
                    </div>
                    <div class="stat-card"
                         wire:click="$set('filterReferralStatus', 'viewed')"
                         :class="{ 'active': $wire.filterReferralStatus === 'viewed' }">
                        <div class="stat-label">دیده شده</div>
                        <div class="stat-value text-info"><?php echo e($statusCounts['viewed'] ?? 0); ?></div>
                        <div class="text-xs opacity-80 mt-1">مشاهده شده، تکمیل نشده</div>
                    </div>
                    <div class="stat-card"
                         wire:click="$set('filterReferralStatus', 'completed')"
                         :class="{ 'active': $wire.filterReferralStatus === 'completed' }">
                        <div class="stat-label">تکمیل شده</div>
                        <div class="stat-value text-success"><?php echo e($statusCounts['completed'] ?? 0); ?></div>
                        <div class="text-xs opacity-80 mt-1">اقدامات موفق</div>
                    </div>
                    <div class="stat-card"
                         wire:click="$set('filterReferralStatus', 'canceled')"
                         :class="{ 'active': $wire.filterReferralStatus === 'canceled' }">
                        <div class="stat-label">لغو / رد شده</div>
                        <div class="stat-value text-danger"><?php echo e($statusCounts['canceled'] ?? 0); ?></div>
                        <div class="text-xs opacity-80 mt-1">برگشت برای تصحیح</div>
                    </div>

                    <div class="stat-card"
                         wire:click="$set('filterReferralStatus', '')"
                         :class="{ 'active': $wire.filterReferralStatus === '' }">
                        <div class="stat-label">مجموع ارجاعات</div>
                        <div class="stat-value"><?php echo e($statusCounts['total'] ?? 0); ?></div>
                        <div class="text-xs opacity-80 mt-1">همه رکوردهای دریافتی</div>
                    </div>
                </div>
            </div>

            <div class="filter-section">
                <div class="filter-row">
                    <div>
                        <label class="form-label">جستجو (عنوان، کد، محتوا)</label>
                        <input type="text" wire:model.live.debounce.400ms="searchText"
                               class="form-control"
                               placeholder="عنوان، کد یا محتوا...">
                    </div>
                    <div>
                        <label class="form-label">وضعیت ارجاع</label>
                        <select class="form-select" wire:model.live="filterReferralStatus">
                            <option value="">همه وضعیت‌ها (<?php echo e($statusCounts['total'] ?? 0); ?>)</option>
                            <option value="pending">در انتظار (<?php echo e($statusCounts['pending'] ?? 0); ?>)</option>
                            <option value="viewed">دیده شده (<?php echo e($statusCounts['viewed'] ?? 0); ?>)</option>
                            <option value="completed">تکمیل شده (<?php echo e($statusCounts['completed'] ?? 0); ?>)</option>
                            <option value="canceled">لغو شده (<?php echo e($statusCounts['canceled'] ?? 0); ?>)</option>
                        </select>
                    </div>
                    <div>
                        <label class="form-label">ارجاع‌دهنده</label>
                        <select class="form-select" wire:model.live="filterReferrerId">
                            <option value="">همه ارجاع‌دهندگان</option>
                            <?php $__currentLoopData = $topReferrers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referrer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($referrer->id); ?>">
                                    <?php echo e($referrer->name); ?> (<?php echo e($referrer->count); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="d-flex gap-3">
                        <div style="flex: 1;">
                            <label class="form-label">از تاریخ (Y-m-d)</label>
                            <input type="date" wire:model.live="filterFromDate" class="form-control" placeholder="YYYY-MM-DD">
                        </div>
                        <div style="flex: 1;">
                            <label class="form-label">تا تاریخ (Y-m-d)</label>
                            <input type="date" wire:model.live="filterToDate" class="form-control" placeholder="YYYY-MM-DD">
                        </div>
                    </div>
                </div>

                <?php if($topReferrers->isNotEmpty()): ?>
                    <div class="top-referrers">
                        <span class="text-white-80 small me-2">ارجاع‌دهندگان پرکار:</span>
                        <?php $__currentLoopData = $topReferrers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referrer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="top-referrer-badge"
                                 :class="{ 'active': $wire.filterReferrerId == '<?php echo e($referrer->id); ?>' }"
                                 wire:click="$set('filterReferrerId', '<?php echo e($referrer->id); ?>')">
                                <img src="<?php echo e($referrer->photo_url); ?>" class="top-referrer-avatar" alt="<?php echo e($referrer->name); ?>">
                                <?php echo e($referrer->name); ?> <span class="text-xs opacity-70">(<?php echo e($referrer->count); ?>)</span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

                <div class="mt-4 d-flex justify-content-end">
                    <button wire:click="resetFilters" class="btn btn-outline-light">
                        <i class="fas fa-filter-slash"></i> ریست فیلترها
                    </button>
                </div>
            </div>
        </div>

        <div class="main-content-card mt-4">
            <div wire:loading.delay.class="opacity-50 table-loading"
                 wire:target="searchText, filterReferralStatus, filterReferrerId, filterFromDate, filterToDate, perPage, markAsRead, resetFilters">

                <i class="fas fa-sync-alt fa-spin loading-spinner"
                   wire:loading.delay
                   wire:target="searchText, filterReferralStatus, filterReferrerId, filterFromDate, filterToDate, perPage, markAsRead, resetFilters"></i>

                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                        <tr>
                            <th class="ps-4">عنوان نامه</th>
                            <th class="text-center">فرستنده</th>
                            <th class="text-center d-none d-lg-table-cell">ارجاع‌دهنده</th>
                            <th class="text-center">تاریخ ارجاع</th>
                            <th class="text-center">نوع</th>
                            <th class="text-center">وضعیت</th>
                            <th class="pe-4 text-end">اقدام</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $letter = $referral->letter;
                                $sender = $letter->sender;
                                $creator = $referral->creator;
                                $isUnread = $referral->status === \App\Models\Referral::STATUS_PENDING;
                            ?>
                            <tr wire:key="ref-<?php echo e($referral->id); ?>">
                                <td class="ps-4">
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="avatar <?php if($isUnread): ?> unread-pulse <?php endif; ?>">
                                            <img src="<?php echo e($this->getUserProfilePhotoUrl($sender)); ?>" alt="<?php echo e($sender->name ?? '—'); ?>">
                                        </div>
                                        <div>
                                            <a wire:click="showPreview(<?php echo e($letter->id); ?>)" class="letter-title">
                                                <?php echo e(Str::limit($letter->title, 50)); ?>

                                            </a>
                                            <div class="text-muted small mt-1">
                                                <i class="fas fa-code me-1"></i>
                                                <?php echo e(Str::limit($letter->code ?? 'LTR-' . $letter->id, 12)); ?>

                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center fw-medium">
                                    <?php echo e($sender->name ?? '—'); ?>

                                </td>
                                <td class="text-center d-none d-lg-table-cell">
                                    <div class="d-flex align-items-center justify-content-center gap-2">
                                        <div class="avatar" style="width: 30px; height: 30px;">
                                            <img src="<?php echo e($this->getUserProfilePhotoUrl($creator)); ?>" alt="<?php echo e($creator->name ?? '—'); ?>">
                                        </div>
                                        <span class="fw-medium" style="font-size: 0.9rem;"><?php echo e($creator->name ?? 'سیستم'); ?></span>
                                    </div>
                                </td>
                                <td class="text-center text-muted">
                                    <div><?php echo e($this->formatShamsiDate($referral->created_at, 'Y/m/d')); ?></div>
                                    <small style="font-size: 0.75rem;"><?php echo e($this->formatShamsiDate($referral->created_at, 'H:i')); ?></small>
                                </td>
                                <td class="text-center">
                                        <span class="badge bg-primary-subtle text-primary rounded-pill px-3 py-1 fw-medium" style="font-size: 0.75rem;">
                                            <?php echo e($referral->typeLabel()); ?>

                                        </span>
                                </td>
                                <td class="text-center">
                                        <span class="status-badge <?php echo e($referral->status); ?>">
                                            <?php switch($referral->status):
                                                case (\App\Models\Referral::STATUS_PENDING): ?> <i class="fas fa-clock"></i> در انتظار <?php break; ?>
                                                <?php case (\App\Models\Referral::STATUS_VIEWED): ?> <i class="fas fa-eye"></i> دیده شده <?php break; ?>
                                                <?php case (\App\Models\Referral::STATUS_COMPLETED): ?> <i class="fas fa-check"></i> تکمیل شده <?php break; ?>
                                                <?php case (\App\Models\Referral::STATUS_CANCELED): ?> <i class="fas fa-undo"></i> لغو شده <?php break; ?>
                                                <?php default: ?> —
                                            <?php endswitch; ?>
                                        </span>
                                </td>
                                <td class="pe-4 text-end">
                                    <div class="d-flex align-items-center gap-2 justify-content-end">
                                        <?php if($referral->status === \App\Models\Referral::STATUS_PENDING): ?>
                                            <button wire:click="markAsRead(<?php echo e($referral->id); ?>)"
                                                    class="quick-action read"
                                                    wire:loading.attr="disabled"
                                                    data-bs-toggle="tooltip" title="علامت‌گذاری به عنوان دیده‌شده">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                        <?php endif; ?>
                                        <?php if(in_array($referral->status, [\App\Models\Referral::STATUS_PENDING, \App\Models\Referral::STATUS_VIEWED])): ?>
                                            <button wire:click="openActionModal(<?php echo e($referral->id); ?>, 'completed')"
                                                    class="quick-action complete"
                                                    data-bs-toggle="tooltip" title="تکمیل اقدام">
                                                <i class="fas fa-check"></i>
                                            </button>
                                            <button wire:click="openActionModal(<?php echo e($referral->id); ?>, 'correction')"
                                                    class="quick-action correction"
                                                    data-bs-toggle="tooltip" title="بازگشت برای تصحیح">
                                                <i class="fas fa-undo"></i>
                                            </button>
                                        <?php endif; ?>

                                        <button wire:click="showPreview(<?php echo e($letter->id); ?>)"
                                                class="quick-action neutral"
                                                data-bs-toggle="tooltip" title="پیش‌نمایش">
                                            <i class="fas fa-search"></i>
                                        </button>

                                        <button wire:click="openReferralTreeModal(<?php echo e($letter->id); ?>)"
                                                class="quick-action neutral"
                                                data-bs-toggle="tooltip" title="تاریخچه">
                                            <i class="fas fa-history"></i>
                                        </button>

                                        <button wire:click="cloneLetterContent(<?php echo e($letter->id); ?>)"
                                                class="quick-action neutral"
                                                data-bs-toggle="tooltip" title="استفاده مجدد از محتوا">
                                            <i class="fas fa-copy"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="empty-state">
                                    <div class="empty-icon">
                                        <i class="fas fa-inbox"></i>
                                    </div>
                                    <h2 class="empty-title">صندوق ورودی شما خالی است</h2>
                                    <p class="empty-desc">
                                        هنوز ارجاعی برای شما ارسال نشده است. تمام ارجاعات و وظایف شما در اینجا ظاهر می‌شوند.
                                    </p>
                                    <div class="d-flex justify-content-center gap-3">
                                        <button wire:click="resetFilters" class="btn btn-outline-secondary rounded-pill px-5 py-2">
                                            <i class="fas fa-filter-slash me-1"></i> پاک کردن فیلترها
                                        </button>
                                        <button wire:click="$refresh" class="btn btn-primary rounded-pill px-5 py-2">
                                            <i class="fas fa-sync me-1"></i> تازه‌سازی
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <?php if($referrals->hasPages()): ?>
                <div class="p-4 d-flex flex-column flex-md-row justify-content-between align-items-center gap-3 border-top">
                    <div class="text-muted small">
                        نمایش <b><?php echo e($referrals->firstItem()); ?></b> تا <b><?php echo e($referrals->lastItem()); ?></b> از <b><?php echo e($referrals->total()); ?></b> مورد
                    </div>
                    <?php echo e($referrals->links('pagination::bootstrap-5')); ?>

                </div>
            <?php endif; ?>
        </div>

        <?php if($showPreviewModal && $previewLetter): ?>
            <div class="modal fade show d-block" style="background: rgba(15, 23, 42, 0.7);">
                <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content border-0 rounded-4 shadow-xl">
                        <div class="modal-header" style="background: var(--primary); color: white; padding: 24px;">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-sm bg-white bg-opacity-20 text-white rounded-circle me-3" style="width: 44px; height: 44px;">
                                    <i class="fas fa-file-alt"></i>
                                </div>
                                <h5 class="modal-title fw-bold">پیش‌نمایش نامه</h5>
                            </div>
                            <button type="button" class="btn-close btn-close-white" wire:click="closePreviewModal"></button>
                        </div>
                        <div class="modal-body p-0">
                            <div class="border-bottom p-5 bg-light">
                                <div class="d-flex justify-content-between flex-wrap gap-3">
                                    <div>
                                        <span class="badge bg-primary me-2 px-3 py-2">کد: <?php echo e($previewLetter->letter->code ?? 'LTR-'.$previewLetter->letter->id); ?></span>
                                        <span class="badge bg-secondary px-3 py-2">تاریخ: <?php echo e($this->formatShamsiDate($previewLetter->letter->created_at, 'Y/m/d')); ?></span>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar avatar-sm me-2">
                                            <img src="<?php echo e($this->getUserProfilePhotoUrl($previewLetter->letter->sender)); ?>">
                                        </div>
                                        <span class="text-muted small">
                                            از: <?php echo e($previewLetter->letter->sender->name ?? '—'); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="p-5" style="min-height: 400px; max-height: 600px; overflow-y: auto;">
                                <div class="bg-white rounded-3 p-5 shadow-sm border">
                                    <?php echo $previewLetter->letter->content; ?>

                                </div>
                            </div>
                        </div>
                        <div class="modal-footer bg-light p-4">


                            <a href="<?php echo e(route('letter.show', $previewLetter->letter->id)); ?>"
                               class="btn btn-primary px-4 rounded-3" style="background: var(--primary-600); border-color: var(--primary-600);">
                                <i class="fas fa-expand me-1"></i> مشاهده کامل
                            </a>

                            <button class="btn btn-outline-secondary rounded-3 px-4" wire:click="closePreviewModal">
                                بستن
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if($showActionModal && $currentReferral): ?>
            <div class="modal fade show d-block" style="background: rgba(15, 23, 42, 0.7);">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content border-0 rounded-4 shadow-xl">
                        <div class="modal-header"
                             :class="{
                                 'bg-success text-white': actionType === 'completed',
                                 'bg-warning text-white': actionType === 'correction'
                             }"
                             style="padding: 24px;">
                            <h5 class="modal-title fw-bold">
                                <?php if($actionType === 'completed'): ?>
                                    <i class="fas fa-check-circle me-2"></i> تکمیل اقدام
                                <?php else: ?>
                                    <i class="fas fa-undo-alt me-2"></i> بازگشت برای تصحیح
                                <?php endif; ?>
                            </h5>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeActionModal"></button>
                        </div>
                        <form wire:submit.prevent="submitAction">
                            <div class="modal-body p-5">
                                <p class="mb-4 small">
                                    <strong class="text-gray-800">نامه:</strong> <?php echo e($currentReferral->letter->title); ?><br>
                                    <strong class="text-gray-800">ارجاع‌دهنده:</strong> <?php echo e($currentReferral->creator->name ?? 'سیستم'); ?>

                                </p>
                                <?php if($actionType === 'correction'): ?>
                                    <div class="mb-3">
                                        <label class="form-label fw-medium">علت بازگشت (اجباری)</label>
                                        <textarea wire:model="correctionMessage"
                                                  class="form-control"
                                                  rows="3"
                                                  placeholder="لطفاً علت نیاز به تصحیح را شرح دهید..."></textarea>
                                        <?php $__errorArgs = ['correctionMessage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="modal-footer bg-light p-4">
                                <button type="button" class="btn btn-outline-secondary rounded-3 px-4" wire:click="closeActionModal">
                                    انصراف
                                </button>
                                <button type="submit" class="btn rounded-3 px-4 py-2"
                                        :class="{
                                            'btn-success': actionType === 'completed',
                                            'btn-warning': actionType === 'correction'
                                        }"
                                        wire:loading.attr="disabled">
                                    <span wire:loading.remove>
                                        <?php if($actionType === 'completed'): ?> <i class="fas fa-check me-2"></i> تأیید تکمیل <?php else: ?> <i class="fas fa-undo me-2"></i> بازگشت <?php endif; ?>
                                    </span>
                                    <span wire:loading>
                                        <span class="spinner-border spinner-border-sm me-2"></span> در حال ثبت...
                                    </span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if($showReferralTreeModal): ?>
            <div class="modal fade show d-block" style="background: rgba(15, 23, 42, 0.7);">
                <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content border-0 rounded-4 shadow-xl">
                        <div class="modal-header" style="background: var(--secondary); color: white; padding: 24px;">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-sm bg-white bg-opacity-20 text-white rounded-circle me-3" style="width: 44px; height: 44px;">
                                    <i class="fas fa-history"></i>
                                </div>
                                <h5 class="modal-title fw-bold">تاریخچه و مسیر ارجاعات</h5>
                            </div>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeReferralTreeModal"></button>
                        </div>
                        <div class="modal-body p-0">
                            <div class="row g-0">
                                <div class="col-md-6 border-end" style="border-color: #E5E7EB;">
                                    <div class="p-5">
                                        <h5 class="fw-bold text-primary-dark mb-4">
                                            <i class="fas fa-sitemap me-2"></i> درخت ارجاعات
                                        </h5>
                                        <?php if(count($referralTree)): ?>
                                            <div class="ps-3">
                                                <?php $__currentLoopData = $referralTree; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $node): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo $__env->make('livewire.admin.letter.partials.referral-node', ['node' => $node], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-center py-5 bg-gray-50 rounded-3">
                                                <i class="fas fa-info-circle text-muted fs-1 mb-3"></i>
                                                <p class="text-muted">هیچ ارجاعی ثبت نشده است.</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="p-5">
                                        <h5 class="fw-bold text-gray-700 mb-4">
                                            <i class="fas fa-list-ul me-2"></i> خط زمانی رویدادها
                                        </h5>
                                        <?php if($historyTimeline->isNotEmpty()): ?>
                                            <div class="timeline">
                                                <?php $__currentLoopData = $historyTimeline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="d-flex mb-4">
                                                        <div class="avatar avatar-sm me-3 mt-1">
                                                            <img src="<?php echo e($this->getUserProfilePhotoUrl($event->user)); ?>">
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <div class="fw-bold text-gray-800 small mb-1"><?php echo e($event->user->name ?? '—'); ?></div>
                                                            <div class="text-muted small">
                                                                <i class="far fa-clock me-1"></i>
                                                                <?php echo e($this->formatShamsiDate($event->date, 'Y/m/d H:i')); ?>

                                                                <span class="badge bg-light text-dark ms-2 px-2 py-1"><?php echo e($event->type); ?></span>
                                                            </div>
                                                            <?php if($event->description): ?>
                                                                <div class="mt-3 bg-gray-50 p-3 rounded-2 small border">
                                                                    <?php echo e($event->description); ?>

                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-center py-5 bg-gray-50 rounded-3">
                                                <i class="fas fa-clock text-muted fs-1 mb-3"></i>
                                                <p class="text-muted">هیچ رویدادی ثبت نشده است.</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer bg-light p-4">
                            <button type="button" class="btn btn-outline-secondary rounded-3 px-4"
                                    wire:click="closeReferralTreeModal">
                                بستن
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\received-letters.blade.php ENDPATH**/ ?>