<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>

        <style>
        @font-face {
            font-family: 'Vazir';
            src: url('<?php echo e(public_path('assets/fonts/Vazir.ttf')); ?>') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: 'Vazir', Tahoma, sans-serif;
            direction: rtl;
            text-align: right;
            font-size: 11px;
        }

        /* این بخش برای نمایش درست اعداد و متون در جداول حیاتی است */
        table {
            width: 100%;
            border-collapse: collapse;
            direction: rtl;
        }

        th, td {
            border: 1px solid #000;
            padding: 5px;
            text-align: center;
        }



        .header-table { width: 100%; border-bottom: 2px solid #000; padding-bottom: 10px; margin-bottom: 20px; }
        .content-table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .content-table th, .content-table td { border: 1px solid #ddd; padding: 8px; text-align: center; }
        .content-table th { background-color: #f2f2f2; }
        .signature-section { width: 100%; margin-top: 50px; }
        .sig-box { width: 33%; float: right; text-align: center; min-height: 150px; position: relative; }
        .stamp-img { position: absolute; width: 80px; opacity: 0.5; top: 20px; left: 20px; }
        .sig-img { max-width: 120px; max-height: 70px; filter: contrast(1.5) blue; }
        .footer { position: fixed; bottom: 0; width: 100%; text-align: center; font-size: 10px; color: #777; }
    </style>
</head>
<body>
<table class="header-table">
    <tr>
        <td style="width: 30%;"><img src="https://your-domain.com/logo.png" width="80"></td>
        <td style="width: 40%; text-align: center;"><h2>فرم رسمی درخواست خرید کالا/خدمات</h2></td>
        <td style="width: 30%; text-align: left;">
            تاریخ: <?php echo e(jdate($request->created_at)->format('Y/m/d')); ?><br>
            شماره: PR-<?php echo e($request->id); ?>

        </td>
    </tr>
</table>

<p><strong>پروژه:</strong> <?php echo e($request->project->name); ?> | <strong>متقاضی:</strong> <?php echo e($request->user->name); ?></p>
<p><strong>شرح درخواست:</strong> <?php echo e($request->description); ?></p>

<table class="content-table">
    <thead>
    <tr>
        <th>ردیف</th>
        <th>شرح کالا / خدمات</th>
        <th>تعداد</th>
        <th>قیمت واحد (ریال)</th>
        <th>جمع کل (ریال)</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $request->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($index + 1); ?></td>
            <td><?php echo e($item->displayName); ?></td>
            <td><?php echo e($item->quantity); ?></td>
            <td><?php echo e(number_format($item->price)); ?></td>
            <td><?php echo e(number_format($item->subtotal)); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
    <tfoot>
    <tr style="background-color: #eee; font-weight: bold;">
        <td colspan="4">جمع کل نهایی</td>
        <td><?php echo e(number_format($request->total_price)); ?></td>
    </tr>
    </tfoot>
</table>

<div class="signature-section">
    <h4 style="border-bottom: 1px solid #eee; padding-bottom: 5px;">تاییدیه مدیران و گردش کار:</h4>
    <?php $__currentLoopData = $request->approvals->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="sig-box">
            <p><strong><?php echo e($approval->role->name); ?></strong></p>
            <p><?php echo e($approval->user->name); ?></p>
            <div style="height: 80px;">
                <?php if($approval->is_approved): ?>
                    <img src="https://i.postimg.cc/mD7Q3rM2/approved-stamp.png" class="stamp-img">
                    <?php if($approval->user->sign): ?>
                        <img src="<?php echo e(public_path('storage/' . $approval->user->sign)); ?>" class="sig-img">
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <small><?php echo e($approval->approved_at ? jdate($approval->approved_at)->format('Y/m/d H:i') : ''); ?></small>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<div class="footer">این سند در سامانه سرآمان تولید شده و فاقد خدشه معتبر است.</div>
</body>
</html>
<?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\pdf\purchase-request.blade.php ENDPATH**/ ?>