<div class="container-fluid py-4">



    <div class="row g-4 mb-5 justify-content-center">

        <?php

            $statsConfig = [

            'pending' => ['icon' => 'fas fa-clock', 'color' => 'warning', 'label' => 'در انتظار', 'bg' => 'bg-warning-light'],

            'approved' => ['icon' => 'fas fa-check-circle', 'color' => 'primary', 'label' => 'تأیید شده', 'bg' => 'bg-primary-light'],

            'rejected' => ['icon' => 'fas fa-times-circle', 'color' => 'danger', 'label' => 'رد شده', 'bg' => 'bg-danger-light'],

            'paid' => ['icon' => 'fas fa-money-bill-wave', 'color' => 'success', 'label' => 'پرداخت شده', 'bg' => 'bg-success-light'],

            'total' => ['icon' => 'fas fa-file-invoice', 'color' => 'info', 'label' => 'کل درخواست‌ها', 'bg' => 'bg-info-light'],

            ];

            $statKeys = ['pending', 'approved', 'rejected', 'paid', 'total'];

        ?>



        <?php $__currentLoopData = $statKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <div class="col-6 col-md-4 col-lg-2 <?php echo e($loop->last ? 'col-xl-2' : 'col-xl-2-4'); ?>">

                <div class="card border-0 shadow-lg rounded-4 h-100 p-3 hover-lift <?php echo e($statsConfig[$key]['bg']); ?>">

                    <div class="card-body p-2 d-flex flex-column justify-content-between">

                        <div class="d-flex justify-content-between align-items-center">

                            <h6 class="mb-1 text-muted fw-bold small text-uppercase"><?php echo e($statsConfig[$key]['label']); ?></h6>

                            <div class="text-<?php echo e($statsConfig[$key]['color']); ?> opacity-50 icon-pulse" style="font-size: 2.2rem;">

                                <i class="<?php echo e($statsConfig[$key]['icon']); ?>"></i>

                            </div>

                        </div>

                        <h2 class="mb-0 fw-bolder text-dark display-6 mt-3"><?php echo e($stats[$key] ?? 0); ?></h2>

                    </div>

                    <div class="position-absolute bottom-0 start-0 w-100 bg-<?php echo e($statsConfig[$key]['color']); ?> opacity-25 rounded-bottom-4" style="height: 5px;"></div>

                </div>

            </div>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>



    <hr class="text-primary opacity-50 mb-4">



    <div class="d-flex flex-wrap justify-content-between align-items-center mb-5">

        <div>

            <h2 class="h3 fw-bolder text-dark mb-1">

                <i class="fas fa-hand-holding-usd text-success me-2"></i> مدیریت هزینه‌های جزء (Petty Cash)

            </h2>

            <p class="text-muted mb-0 small">نمایش و پیگیری کلیه درخواست‌های تنخواه و وضعیت تأیید آن‌ها</p>

        </div>

        <div class="d-flex gap-3 mt-3 mt-sm-0">

            <a href="<?php echo e(route('admin.petty-cash.create')); ?>" class="btn btn-success px-4 rounded-pill shadow-lg hover-lift">

                <i class="fas fa-plus me-2"></i>درخواست جدید

            </a>

            <a href="<?php echo e(route('admin.petty-cash.rules')); ?>" class="btn btn-outline-info px-4 rounded-pill hover-lift">

                <i class="fas fa-gavel me-2"></i>قوانین تأیید

            </a>

        </div>

    </div>



    <div class="card border-0 shadow-lg rounded-4 mb-4 filter-card">

        <div class="card-body p-4">

            <div class="row g-3 align-items-end">

                <div class="col-md-6 col-lg-4">

                    <label class="form-label fw-bold text-dark small">جستجو در درخواست‌ها</label>

                    <div class="input-group input-group-lg">

<span class="input-group-text bg-light border-end-0 rounded-start-pill border-0">

<i class="fas fa-search text-primary"></i>

</span>

                        <input type="text"

                               wire:model.live.debounce.300ms="search"

                               class="form-control border-start-0 rounded-end-pill shadow-none"

                               placeholder="دلیل، نام کاربر یا مبلغ...">

                    </div>

                </div>

                <div class="col-md-4 col-lg-3">

                    <label class="form-label fw-bold text-dark small">فیلتر بر اساس وضعیت</label>

                    <select wire:model.live="statusFilter" class="form-select form-select-lg rounded-pill shadow-none">

                        <option value="all">همه وضعیت‌ها</option>

                        <option value="pending">در انتظار (<?php echo e($stats['pending'] ?? 0); ?>)</option>

                        <option value="approved">تأیید شده (<?php echo e($stats['approved'] ?? 0); ?>)</option>

                        <option value="rejected">رد شده (<?php echo e($stats['rejected'] ?? 0); ?>)</option>

                        <option value="paid">پرداخت شده (<?php echo e($stats['paid'] ?? 0); ?>)</option>

                    </select>

                </div>

                <div class="col-md-2 col-lg-2">

                    <button wire:click="resetFilters" class="btn btn-outline-secondary px-4 rounded-pill w-100 hover-lift mt-auto" title="پاک کردن فیلترها">

                        <i class="fas fa-trash-restore-alt me-2"></i> ریست

                    </button>

                </div>

            </div>

        </div>

    </div>



    <div class="card border-0 shadow-2xl rounded-4 overflow-hidden">

        <div class="card-body p-0">

            <?php if($requests->isEmpty()): ?>

                <div class="text-center py-5 text-muted">

                    <div class="mb-3">

                        <i class="fas fa-box-open fa-4x text-warning opacity-50"></i>

                    </div>

                    <h5 class="mb-2 fw-semibold">هیچ درخواستی یافت نشد</h5>

                    <p class="mb-0 text-muted">فیلترها را تنظیم کنید یا درخواست جدیدی ثبت نمایید.</p>

                </div>

            <?php else: ?>

                <div class="table-responsive">

                    <table class="table table-striped table-hover mb-0 align-middle">

                        <thead class="bg-primary-subtle text-dark fw-bolder">

                        <tr>

                            <th class="text-center" style="width: 5%">#</th>

                            <th style="width: 15%">درخواست‌دهنده</th>

                            <th style="width: 10%">مبلغ</th>

                            <th>دلیل</th>

                            <th class="text-center" style="width: 10%">وضعیت</th>

                            <th style="width: 30%">سیر تأییدیه‌ها</th>

                            <th class="text-center" style="width: 10%">اقدامات</th>

                        </tr>

                        </thead>

                        <tbody>

                        <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php

                                $currentUserId = auth()->id();

                                $isApprover = $req->isApprover($currentUserId);

                                $hasFinalAction = $req->approvals

                                ->where('user_id', $currentUserId)

                                ->whereIn('status', [\App\Models\PettyCashApproval::STATUS_APPROVED, \App\Models\PettyCashApproval::STATUS_REJECTED])

                                ->isNotEmpty();



                                // تعیین هوشمند جهت Dropdown: اگر در 3 ردیف آخر صفحه بود، منو از بالا باز شود (dropup)

                                $isNearBottom = ($requests->count() - $loop->iteration) < 3;

                                $dropdownClass = $isNearBottom ? 'dropup' : 'dropstart';

                            ?>



                            <tr class="hover-row">

                                <td class="text-center text-muted fw-medium"><?php echo e($requests->firstItem() + $index); ?></td>

                                <td>

                                    <div class="d-flex align-items-center">

                                        <img src="<?php echo e($req->user->image ? asset('storage/' . $req->user->image) : 'https://ui-avatars.com/api/?name=' . urlencode($req->user->name) . '&background=random&color=fff'); ?>"

                                             class="rounded-circle me-3 border border-2 border-primary shadow-sm" width="36" height="36" alt="<?php echo e($req->user->name); ?>">

                                        <span class="fw-bold text-dark"><?php echo e(Str::limit($req->user->name, 15)); ?></span>

                                    </div>

                                </td>

                                <td class="fw-bolder text-success" dir="ltr"><?php echo e(number_format($req->amount)); ?> <span class="small text-muted">تومان</span></td>

                                <td>

                                    <button wire:click="viewDetails(<?php echo e($req->id); ?>)"

                                            class="btn btn-sm btn-link p-0 text-decoration-none text-dark fw-medium text-start text-truncate"

                                            title="مشاهده جزئیات کامل: <?php echo e($req->reason); ?>" style="max-width: 180px;">

                                        <?php echo e(Str::limit($req->reason, 40)); ?>


                                    </button>

                                </td>

                                <td class="text-center">

<span class="badge bg-<?php echo e($req->statusColor()); ?> rounded-pill px-3 py-2 fw-bold shadow-sm status-badge">

<?php echo e($req->statusLabel()); ?>


</span>

                                </td>

                                <td>

                                    <div class="d-flex flex-wrap gap-1 align-items-center">

                                        <?php $__empty_1 = true; $__currentLoopData = $req->approvals->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ap): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                                            <span class="d-flex align-items-center bg-white border border-<?php echo e($ap->statusColor()); ?> rounded-pill px-2 py-1 small text-dark shadow-sm-hover approver-pill"

                                                  data-bs-toggle="tooltip" title="<?php echo e($ap->approver->name . ' - ' . $ap->statusLabel() . ($ap->comments ? ' (با نظر)' : '')); ?>">

<i class="fas fa-<?php echo e($ap->status === \App\Models\PettyCashApproval::STATUS_APPROVED ? 'check text-success' : 'times text-danger'); ?> me-1" style="font-size: 10px;"></i>

<span class="text-truncate fw-medium" style="max-width: 60px;"><?php echo e(Str::limit($ap->approver->name, 7)); ?></span>

</span>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                            <span class="badge bg-light text-muted fw-normal border">در انتظار اقدام...</span>

                                        <?php endif; ?>

                                        <?php if($req->approvals->count() > 3): ?>

                                            <span class="badge bg-secondary rounded-pill px-2 py-1 small">+<?php echo e($req->approvals->count() - 3); ?></span>

                                        <?php endif; ?>

                                    </div>

                                    <small class="text-muted d-block mt-1 fw-bold">

                                        <i class="fas fa-chart-bar me-1 text-primary"></i>

                                        **<?php echo e($req->approved_count); ?>** / <?php echo e($req->getRequiredApprovalsCount()); ?> تأیید لازم

                                    </small>

                                </td>

                                <td class="text-center">

                                    <div class="dropdown <?php echo e($dropdownClass); ?>">

                                        <button class="btn btn-sm btn-outline-secondary rounded-circle p-2 hover-lift" type="button" data-bs-toggle="dropdown" aria-expanded="false" title="اقدامات">

                                            <i class="fas fa-ellipsis-v"></i>

                                        </button>

                                        <ul class="dropdown-menu text-end shadow-lg border-0 rounded-4" style="min-width: 180px;">

                                            <li><button wire:click="viewDetails(<?php echo e($req->id); ?>)" class="dropdown-item rounded fw-medium"><i class="fas fa-eye me-2 text-info"></i>مشاهده جزئیات</button></li>

                                            <li><a class="dropdown-item rounded" href="<?php echo e(route('petty-cash.show', $req->id)); ?>" wire:navigate><i class="fas fa-file-alt me-2 text-primary"></i>مشاهده کامل درخواست</a></li>



                                            <?php if($req->status === \App\Models\PettyCash::STATUS_APPROVED): ?>

                                                <li><hr class="dropdown-divider"></li>

                                                <li><a class="dropdown-item text-info rounded" href="<?php echo e(route('admin.petty-cash.pdf', $req->id)); ?>" target="_blank"><i class="fas fa-file-pdf me-2"></i>دانلود PDF</a></li>

                                            <?php endif; ?>



                                            <?php if($req->status === \App\Models\PettyCash::STATUS_PENDING && $isApprover && !$hasFinalAction): ?>

                                                <li><hr class="dropdown-divider"></li>

                                                <li><button wire:click="confirmAction(<?php echo e($req->id); ?>, 'approve')" class="dropdown-item text-success rounded fw-bold"><i class="fas fa-check-double me-2"></i>تأیید نهایی</button></li>

                                                <li><button wire:click="confirmAction(<?php echo e($req->id); ?>, 'reject')" class="dropdown-item text-danger rounded fw-bold"><i class="fas fa-times-circle me-2"></i>رد کردن</button></li>

                                            <?php endif; ?>



                                            <?php if($req->status === \App\Models\PettyCash::STATUS_APPROVED && auth()->user()->isAdmin()): ?>

                                                <li><hr class="dropdown-divider"></li>

                                                <li><button wire:click="markAsPaid(<?php echo e($req->id); ?>)" class="dropdown-item text-warning rounded fw-bold" onclick="return confirm('آیا مطمئنید درخواست شماره <?php echo e($req->id); ?> را به عنوان پرداخت شده ثبت می‌کنید؟')"><i class="fas fa-money-bill-wave me-2"></i>ثبت پرداخت شد</button></li>

                                            <?php endif; ?>

                                        </ul>

                                    </div>

                                </td>

                            </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>

                    </table>

                </div>



                <div class="card-footer bg-light-subtle border-top d-flex flex-wrap justify-content-between align-items-center py-3 px-4 rounded-bottom-4 shadow-sm">

                    <div class="text-muted small mb-2 mb-md-0 fw-medium">

                        نمایش **<?php echo e($requests->firstItem()); ?> تا <?php echo e($requests->lastItem()); ?>** از **<?php echo e($requests->total()); ?>** نتیجه

                    </div>

                    <div class="pagination-container">

                        <?php echo e($requests->links('pagination::bootstrap-5')); ?>


                    </div>

                </div>

            <?php endif; ?>

        </div>

    </div>



    <div wire:ignore.self class="modal fade" id="approvalModal" tabindex="-1">

        <div class="modal-dialog">

            <div class="modal-content border-0 shadow-2xl rounded-4">

                <div class="modal-header bg-<?php echo e($action === 'approve' ? 'success' : 'danger'); ?> text-white rounded-top-4 p-3">

                    <h5 class="modal-title fw-bolder">

                        <i class="fas fa-<?php echo e($action === 'approve' ? 'check-circle' : 'ban'); ?> me-2"></i>

                        <?php echo e($action === 'approve' ? 'تأیید نهایی درخواست' : 'رد کامل درخواست'); ?>


                    </h5>

                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>

                </div>

                <form wire:submit.prevent="submit">

                    <div class="modal-body p-4">

                        <p class="text-muted small mb-3">لطفاً برای ثبت اقدام خود، توضیحات لازم را (اختیاری) وارد نمایید.</p>

                        <div class="mb-3">

                            <label class="form-label fw-bold text-dark">توضیحات / علت تصمیم</label>

                            <textarea wire:model="comments" class="form-control rounded-3 shadow-sm" rows="4" placeholder="دلیل تأیید یا رد را بنویسید..."></textarea>

                            <?php $__errorArgs = ['comments'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2 small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                        </div>

                    </div>

                    <div class="modal-footer d-flex justify-content-between border-top p-3 bg-light-subtle">

                        <button type="button" class="btn btn-outline-secondary rounded-pill px-4 hover-lift" data-bs-dismiss="modal">لغو</button>

                        <button type="submit" class="btn btn-<?php echo e($action === 'approve' ? 'success' : 'danger'); ?> rounded-pill px-4 fw-bold shadow-lg hover-lift">

                            <i class="fas fa-save me-2"></i> <?php echo e($action === 'approve' ? 'ثبت تأیید' : 'ثبت رد'); ?>


                        </button>

                    </div>

                </form>

            </div>

        </div>

    </div>



    <?php if($detailRequest): ?>

        <div wire:ignore.self class="modal fade" id="detailsModal" tabindex="-1">

            <div class="modal-dialog modal-lg">

                <div class="modal-content border-0 shadow-2xl rounded-4">

                    <div class="modal-header bg-primary text-white rounded-top-4 p-3">

                        <h5 class="modal-title fw-bolder">جزئیات کامل درخواست #<?php echo e($detailRequest->id); ?></h5>

                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>

                    </div>

                    <div class="modal-body p-4">

                        <div class="row mb-4 bg-light p-4 rounded-3 border-end border-5 border-primary shadow-sm hover-lift">

                            <div class="col-md-6 border-md-end">

                                <p class="mb-2 small text-primary fw-bold">درخواست‌دهنده:</p>

                                <div class="d-flex align-items-center mb-3">

                                    <img src="<?php echo e($detailRequest->user->image ? asset('storage/' . $detailRequest->user->image) : 'https://ui-avatars.com/api/?name=' . urlencode($detailRequest->user->name) . '&background=random&color=fff'); ?>"

                                         class="rounded-circle me-3 border border-2 border-primary" width="45" height="45" alt="<?php echo e($detailRequest->user->name); ?>">

                                    <span class="fw-bolder text-dark h5 mb-0"><?php echo e($detailRequest->user->name); ?></span>

                                </div>

                                <p class="mb-0 small text-muted">تاریخ ثبت: <span class="fw-medium text-dark"><?php echo e($detailRequest->created_at ? $detailRequest->created_at->format('Y/m/d H:i') : 'نامشخص'); ?></span></p>



                                <?php if($detailRequest->projects->isNotEmpty()): ?>

                                    <p class="mb-0 mt-3 small text-muted">پروژه‌های مرتبط:</p>

                                    <?php $__currentLoopData = $detailRequest->projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <span class="badge bg-secondary rounded-pill me-1 fw-medium"><?php echo e($project->name ?? 'پروژه نامشخص'); ?></span>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php endif; ?>

                            </div>

                            <div class="col-md-6 text-md-end mt-4 mt-md-0">

                                <h1 class="mb-1 text-success fw-bolder display-6" dir="ltr"><?php echo e(number_format($detailRequest->amount)); ?></h1>

                                <p class="mb-3 text-muted">مبلغ کل (تومان)</p>

                                <p class="mb-1 small text-primary fw-bold">وضعیت فعلی:</p>

                                <span class="badge bg-<?php echo e($detailRequest->statusColor()); ?> px-3 py-2 fw-bold rounded-pill shadow-lg status-badge-lg">

<?php echo e($detailRequest->statusLabel()); ?>


</span>

                            </div>

                        </div>



                        <h6 class="mt-4 mb-3 fw-bold text-primary border-bottom pb-2"><i class="fas fa-clipboard-list me-2"></i> دلیل درخواست</h6>

                        <p class="alert alert-info rounded-3 text-dark fw-medium p-3"><?php echo e($detailRequest->reason); ?></p>



                        <?php if($detailRequest->details_json): ?>

                            <h6 class="mt-4 mb-3 fw-bold text-primary border-bottom pb-2"><i class="fas fa-boxes me-2"></i> اقلام درخواستی</h6>

                            <div class="table-responsive border rounded-3 shadow-sm">

                                <table class="table table-striped table-hover mb-0 small">

                                    <thead class="table-primary">

                                    <tr><th>آیتم</th><th>تعداد</th><th>قیمت واحد</th><th>جمع</th></tr>

                                    </thead>

                                    <tbody>

                                    <?php $__currentLoopData = $detailRequest->details_json; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr class="hover-row-sm">

                                            <td><?php echo e($item['item']); ?></td>

                                            <td><?php echo e($item['qty']); ?></td>

                                            <td dir="ltr"><?php echo e(number_format($item['price'])); ?> <span class="small text-muted">تومان</span></td>

                                            <td class="fw-bold" dir="ltr"><?php echo e(number_format($item['qty'] * $item['price'])); ?> <span class="small text-muted">تومان</span></td>

                                        </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>

                                </table>

                            </div>

                        <?php endif; ?>



                        <h6 class="mt-4 mb-3 fw-bold text-primary border-bottom pb-2"><i class="fas fa-stream me-2"></i> سیر تأیید درخواست</h6>

                        <div class="list-group list-group-flush border rounded-3 shadow-lg">

                            <div class="list-group-item d-flex align-items-center bg-info-light border-0 border-bottom py-3">

                                <i class="fas fa-file-invoice me-3 text-primary fa-lg"></i>

                                <div>

                                    <div class="fw-bold">درخواست توسط متقاضی ثبت شد</div>

                                    <div class="small text-muted"><?php echo e($detailRequest->created_at ? $detailRequest->created_at->format('Y/m/d H:i') : 'نامشخص'); ?></div>

                                </div>

                            </div>

                            <?php $__empty_1 = true; $__currentLoopData = $detailRequest->approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ap): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                                <div class="list-group-item d-flex align-items-start border-0 border-bottom py-3 approval-step">

                                    <div class="d-flex align-items-center me-3" style="width: 40px; flex-shrink: 0;">

                                        <i class="fas fa-<?php echo e($ap->status === \App\Models\PettyCashApproval::STATUS_APPROVED ? 'check-circle text-success' : 'times-circle text-danger'); ?> fa-lg"></i>

                                    </div>

                                    <img src="<?php echo e($ap->approver->image ? asset('storage/' . $ap->approver->image) : 'https://ui-avatars.com/api/?name=' . urlencode($ap->approver->name) . '&background=random&color=fff'); ?>"

                                         class="rounded-circle me-3 border shadow-sm" width="40" height="40" alt="<?php echo e($ap->approver->name); ?>">

                                    <div>

                                        <div class="fw-bold"><?php echo e($ap->approver->name); ?></div>

                                        <span class="badge bg-<?php echo e($ap->statusColor()); ?> px-2 py-1 fw-medium"><?php echo e($ap->statusLabel()); ?></span>

                                        <?php if($ap->comments): ?>

                                            <div class="small text-dark mt-1 fst-italic alert alert-light p-2 rounded-3 border-start border-3 border-info">

                                                <i class="fas fa-comment-dots me-1 text-muted"></i>

                                                «<?php echo e($ap->comments); ?>»

                                            </div>

                                        <?php endif; ?>

                                        <div class="small text-muted mt-1"><?php echo e($ap->approved_at ? $ap->approved_at->format('Y/m/d H:i') : 'هنوز اقدام نشده'); ?></div>

                                    </div>

                                </div>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                <div class="list-group-item text-center text-muted py-3"><i class="fas fa-ellipsis-h me-1"></i>منتظر اولین اقدام تأییدکننده...</div>

                            <?php endif; ?>

                            <?php if($detailRequest->status !== \App\Models\PettyCash::STATUS_PENDING): ?>

                                <div class="list-group-item d-flex align-items-center bg-<?php echo e($detailRequest->statusColor()); ?> text-white border-0 rounded-bottom-3 py-3">

                                    <i class="fas fa-flag-checkered me-3 fa-lg"></i>

                                    <div class="fw-bolder h5 mb-0">وضعیت نهایی: <?php echo e($detailRequest->statusLabel()); ?></div>

                                </div>

                            <?php endif; ?>

                        </div>



                        <?php if($detailRequest->status === \App\Models\PettyCash::STATUS_PENDING): ?>

                            <?php

                                $currentUserId = auth()->id();

                                $isApprover = $detailRequest->isApprover($currentUserId);

                                $hasFinalAction = $detailRequest->approvals

                                ->where('user_id', $currentUserId)

                                ->whereIn('status', [\App\Models\PettyCashApproval::STATUS_APPROVED, \App\Models\PettyCashApproval::STATUS_REJECTED])

                                ->isNotEmpty();

                            ?>



                            <?php if($isApprover && !$hasFinalAction): ?>

                                <div class="mt-4 pt-3 border-top border-dashed">

                                    <h6 class="fw-bold text-primary mb-3"><i class="fas fa-user-check me-2"></i>عملیات مورد نیاز</h6>

                                    <div class="d-flex gap-3">

                                        <button wire:click="confirmAction(<?php echo e($detailRequest->id); ?>, 'approve')"

                                                type="button"

                                                class="btn btn-success flex-grow-1 rounded-pill py-2 shadow-lg hover-lift"

                                                data-bs-dismiss="modal"

                                                title="تأیید درخواست">

                                            <i class="fas fa-check me-2"></i> تأیید نهایی

                                        </button>

                                        <button wire:click="confirmAction(<?php echo e($detailRequest->id); ?>, 'reject')"

                                                type="button"

                                                class="btn btn-danger flex-grow-1 rounded-pill py-2 shadow-lg hover-lift"

                                                data-bs-dismiss="modal"

                                                title="رد درخواست">

                                            <i class="fas fa-times me-2"></i> رد کردن

                                        </button>

                                    </div>

                                </div>

                            <?php elseif($hasFinalAction): ?>

                                <div class="mt-4 pt-3 border-top border-dashed">

                                    <div class="alert alert-success rounded-pill text-center py-2 fw-medium shadow-sm">

                                        <i class="fas fa-check-circle me-2"></i> اقدام شما قبلاً ثبت شده است.

                                    </div>

                                </div>

                            <?php endif; ?>

                        <?php endif; ?>



                    </div>

                    <div class="modal-footer bg-light-subtle">

                        <button type="button" class="btn btn-secondary rounded-pill hover-lift" data-bs-dismiss="modal">بستن پنجره</button>

                    </div>

                </div>

            </div>

        </div>

    <?php endif; ?>



        <?php
        $__scriptKey = '4096916440-1';
        ob_start();
    ?>

    <script>

        $wire.on('openModal', ({ name }) => {

            const modalId = name === 'approval-modal' ? 'approvalModal' : 'detailsModal';

            const modal = new bootstrap.Modal(document.getElementById(modalId));

            modal.show();



            document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(tooltipEl => {

                new bootstrap.Tooltip(tooltipEl);

            });

        });



        $wire.on('closeModal', ({ name }) => {

            const modalId = name === 'approval-modal' ? 'approvalModal' : 'detailsModal';

            const modal = bootstrap.Modal.getInstance(document.getElementById(modalId));

            modal?.hide();

        });



        $wire.on('alert', ({ type, message }) => {

            alert(`[${type.toUpperCase()}] ${message}`);

        });



        document.addEventListener('DOMContentLoaded', function () {

            document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(tooltipEl => {

                new bootstrap.Tooltip(tooltipEl);

            });

        });

    </script>

        <?php
        $__output = ob_get_clean();

        \Livewire\store($this)->push('scripts', $__output, $__scriptKey)
    ?>



    <style>

        :root {

            --primary-main: #007bff; /* بوت استرپ آبی */

            --primary-light: #e6f7ff;

            --success-main: #28a745;

            --border-color: var(--bs-border-color);

            --text-muted: var(--bs-secondary-color);

        }



        /* ستون‌های آمار */

        @media (min-width: 1200px) {

            .col-xl-2-4 {

                flex: 0 0 auto;

                width: 20%;

            }

        }

        .shadow-2xl {

            box-shadow: 0 1rem 3rem rgba(0,0,0,.175)!important; /* سایه قوی‌تر برای برجسته‌سازی */

        }



        /* افکت شناور (Lift) */

        .hover-lift {

            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);

        }

        .hover-lift:hover {

            transform: translateY(-5px);

            box-shadow: 0 0.8rem 1.5rem rgba(0,0,0,.15)!important;

        }



        /* انیمیشن کوچک روی آیکون کارت‌های آمار */

        .icon-pulse:hover i {

            animation: pulse-icon 0.5s ease-in-out infinite alternate;

        }

        @keyframes pulse-icon {

            from { transform: scale(1); }

            to { transform: scale(1.1); }

        }



        /* استایل ردیف جدول */

        .hover-row:hover {

            background-color: var(--bs-table-hover-bg) !important;

            box-shadow: 0 0.1rem 0.5rem rgba(0,0,0,.08);

            transform: translateY(-2px);

            transition: all 0.2s ease-in-out;

        }



        /* رنگ‌های روشن سفارشی */

        .bg-primary-light { background-color: #e6f7ff !important; }

        .bg-success-light { background-color: #eaf8ea !important; }

        .bg-warning-light { background-color: #fff9e6 !important; }

        .bg-danger-light { background-color: #ffeeee !important; }

        .bg-info-light { background-color: #e5f6ff !important; }



        .bg-primary-subtle {

            background-color: #e0f0ff !important; /* آبی روشن‌تر برای سربرگ جدول */

        }



        /* ظاهر دکمه وضعیت */

        .status-badge {

            min-width: 90px;

            letter-spacing: 0.5px;

        }

        .status-badge-lg {

            font-size: 1.1rem;

            min-width: 120px;

        }



        /* استایل نوار تأییدکننده‌ها */

        .approver-pill {

            transition: all 0.2s;

        }

        .approver-pill:hover {

            background-color: #f0f0f0 !important;

        }



        /* استایل‌های Pagination (حل مشکل بهم ریختگی) */

        .pagination-container .page-link {

            border-radius: 50px !important;

            min-width: 40px;

            height: 40px;

            padding-top: 8px;

            font-weight: 500;

        }

        .pagination-container .page-item.active .page-link {

            box-shadow: 0 4px 10px rgba(0, 123, 255, 0.4);

        }

    </style>

</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\petty-cash\list-requests.blade.php ENDPATH**/ ?>