<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <title>درخواست #<?php echo e($req->id); ?></title>
    <style>
        body { font-family: Tahoma, Arial, sans-serif; font-size: 12px; }
        .header { border-bottom: 2px solid #333; padding-bottom: 10px; margin-bottom: 20px; }
        .title { font-size: 16px; font-weight: bold; }
        .badge { padding: 2px 8px; border-radius: 4px; }
        .grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 10px; }
        .cell { border: 1px solid #ddd; padding: 10px; }
        .label { font-weight: bold; color: #555; }
        .timeline { margin-top: 20px; }
        .step { margin-bottom: 10px; padding: 10px; border: 1px solid #eee; }
    </style>
</head>
<body>
<div class="header">
    <div class="title">درخواست #<?php echo e($req->id); ?></div>
    <div>ثبت‌کننده: <?php echo e($req->user->name); ?> - <?php echo e($fJ($req->created_at)); ?></div>
</div>

<div class="grid">
    <div class="cell">
        <div class="label">نوع درخواست:</div>
        <div><?php echo e($req->type === 'leave' ? 'مرخصی' : 'ماموریت'); ?></div>
    </div>
    <div class="cell">
        <div class="label">وضعیت:</div>
        <div><?php echo e($statusMap[$req->status]['label'] ?? $req->status); ?></div>
    </div>
    <div class="cell">
        <div class="label">از:</div>
        <div><?php echo e($req->details ? $fJ($req->details->start_datetime) : '—'); ?></div>
    </div>
    <div class="cell">
        <div class="label">تا:</div>
        <div><?php echo e($req->details ? $fJ($req->details->end_datetime) : '—'); ?></div>
    </div>

    <?php if($req->type === 'leave'): ?>
        <div class="cell">
            <div class="label">نوع مرخصی:</div>
            <div><?php echo e($req->details? ($leaveMap[$req->details->leave_type] ?? $req->details->leave_type) : '—'); ?></div>
        </div>
    <?php else: ?>
        <div class="cell">
            <div class="label">پروژه:</div>
            <div><?php echo e($project ? $project->name : '—'); ?></div>
        </div>
        <div class="cell">
            <div class="label">شهر:</div>
            <div><?php echo e($req->details->mission_city ?? '—'); ?></div>
        </div>
        <div class="cell">
            <div class="label">هدف:</div>
            <div><?php echo e($req->details->mission_purpose ?? '—'); ?></div>
        </div>
    <?php endif; ?>
</div>

<div style="margin-top: 20px;">
    <div class="label">توضیحات:</div>
    <div><?php echo e($req->description ?: '—'); ?></div>
</div>

<div class="timeline">
    <div class="label">زنجیره تأیید:</div>
    <?php $__currentLoopData = $req->approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ap): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="step">
            <div><strong>#<?php echo e($ap->step_order); ?> - <?php echo e($ap->approver?->name ?? '—'); ?></strong></div>
            <div>وضعیت: <?php echo e($approvalLabel($ap->status)); ?></div>
            <?php if($ap->decided_at): ?>
                <div>تاریخ: <?php echo e($fJ($ap->decided_at)); ?></div>
            <?php endif; ?>
            <?php if(!empty($ap->comment)): ?>
                <div>یادداشت: <?php echo e($ap->comment); ?></div>
            <?php endif; ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
</body>
</html>
<?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\exports\request.blade.php ENDPATH**/ ?>