<div class="notifier-container">
    <div class="notifier-widget">

        <?php if($notificationSent): ?>
            
            <div class="message-box success-box">
                <span class="message-icon">✅</span>
                <p class="message-text">
                    **درخواست فعال‌سازی با موفقیت ارسال شد.** <br>
                    مدیران سیستم در حال بررسی هستند. لطفاً تا اطلاع ثانوی صبر کنید.
                </p>
            </div>
        <?php else: ?>
            
            <button wire:click="notifyAdmin" class="action-button btn-notify" wire:loading.attr="disabled">
                
                <span wire:loading wire:target="notifyAdmin">در حال ارسال...</span>
                <span wire:loading.remove wire:target="notifyAdmin">

                
                <span wire:loading.remove wire:target="notifyAdmin">
                    <span class="button-icon">🔔</span> اطلاع‌رسانی به مدیر برای فعال‌سازی
                </span>
            </button>
        <?php endif; ?>

        <?php if($errorMessage): ?>
            
            <div class="message-box error-box">
                <span class="message-icon">⚠️</span>
                <p class="message-text">
                    <?php echo e($errorMessage); ?>

                    <br>
                    لطفاً لحظاتی بعد دوباره امتحان کنید یا با پشتیبانی تماس بگیرید.
                </p>
            </div>
        <?php endif; ?>

    </div>

    
    <style>
        .notifier-container {
            width: 100%;
            display: flex;
            justify-content: center;
        }
        .notifier-widget {
            margin-top: 15px;
            width: 100%;
            max-width: 350px;
        }

        .btn-notify {
            background-color: #3498db;
            color: white;
            padding: 14px 25px;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: background-color 0.3s ease, transform 0.1s ease;
            box-shadow: 0 4px 10px rgba(52, 152, 219, 0.3);
            display: flex;
            align-items: center;
            justify-content: center;
            border: none;
        }

        .btn-notify:hover:not([disabled]) {
            background-color: #2980b9;
            transform: translateY(-1px);
        }

        .btn-notify[disabled] {
            opacity: 0.7;
            cursor: not-allowed;
            background-color: #95a5a6;
        }

        .button-icon {
            margin-left: 8px;
            font-size: 1.1em;
        }

        .message-box {
            display: flex;
            align-items: center;
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
            text-align: right;
            line-height: 1.5;
            animation: fadeIn 0.5s ease-out;
        }

        .success-box {
            color: #1a6f3b;
            background-color: #dcf8e5;
            border: 1px solid #a3e0b2;
        }

        .error-box {
            color: #8c2a37;
            background-color: #fcebeb;
            border: 1px solid #f9c2c2;
        }

        .message-icon {
            font-size: 1.8rem;
            margin-left: 10px;
            flex-shrink: 0;
        }

        .message-text {
            margin: 0;
            font-size: 0.95rem;
        }

        /* انیمیشن لودینگ Spinner */
        .loading-spinner {
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-top: 3px solid white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            animation: spin 1s linear infinite;
            margin-left: 10px;
        }

        /* Keyframes */
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\account-inactive-notifier.blade.php ENDPATH**/ ?>