<div class="container-fluid py-5">
    <div class="row justify-content-center">
        <div class="col-12 col-xxl-8">

            
            <?php if(session()->has('success') || session()->has('error')): ?>
                <div
                    class="alert alert-<?php echo e(session()->has('success') ? 'success' : 'danger'); ?> alert-dismissible fade show d-flex align-items-center mb-4 border-0 shadow-sm rounded-4 notification-alert"
                    role="alert"
                >
                    <i class="ti ti-<?php echo e(session()->has('success') ? 'check-circle' : 'alert-octagon'); ?> fs-4 me-3"></i>
                    <div class="flex-grow-1 fw-medium">
                        <?php echo e(session('success') ?? session('error')); ?>

                    </div>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <div class="bg-gradient-header rounded-4 p-4 p-md-5 mb-4 text-white position-relative overflow-hidden shadow-lg header-card">
                <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 position-relative">
                    <div class="me-3">
                        <div class="d-inline-flex align-items-center gap-2 px-3 py-1 rounded-pill bg-white bg-opacity-10 small mb-2">
                            <i class="ti ti-pencil fs-6"></i>
                            <span>ویرایش پست</span>
                        </div>
                        <h2 class="mb-1 fw-bold fs-3 d-flex align-items-center gap-2">
                            <span>مدیریت محتوای انتخاب‌شده</span>
                        </h2>
                        <p class="mb-0 opacity-90 small d-flex align-items-center gap-1">
                            <i class="ti ti-quote fs-5 opacity-75"></i>
                            <span><?php echo e(\Illuminate\Support\Str::limit($title ?? $post->title, 80)); ?></span>
                        </p>
                    </div>

                    <div class="d-flex flex-wrap gap-2">
                        <a href="<?php echo e(route('admin.my-posts')); ?>"
                           class="btn btn-outline-light rounded-pill px-4 fw-medium d-flex align-items-center gap-2 hover-scale">
                            <i class="ti ti-arrow-right fs-5"></i>
                            بازگشت به لیست
                        </a>
                    </div>
                </div>

                <div class="header-card-icon">
                    <i class="ti ti-notes opacity-50"></i>
                </div>
            </div>

            
            <div wire:loading.delay wire:target="updatePost,image,media_file" class="text-center mb-3">
                <div class="spinner-border spinner-border-sm text-primary" role="status">
                    <span class="visually-hidden">در حال ذخیره‌سازی...</span>
                </div>
            </div>

            
            <div class="bg-white rounded-4 shadow-soft border-0 overflow-hidden edit-card">
                <form wire:submit.prevent="updatePost" class="p-4 p-md-5">

                    
                    <div class="section-block mb-4">
                        <div class="section-header d-flex align-items-center gap-2 mb-3">
                            <div class="icon-pill">
                                <i class="ti ti-letter-t"></i>
                            </div>
                            <div>
                                <div class="fw-semibold">اطلاعات متنی پست</div>
                                <div class="small text-muted">عنوان و محتوای اصلی را اینجا ویرایش کنید.</div>
                            </div>
                        </div>

                        
                        <div class="mb-3">
                            <label for="title" class="form-label fw-semibold small text-muted mb-1">
                                عنوان پست
                            </label>
                            <input
                                type="text"
                                id="title"
                                class="form-control form-control-lg rounded-3 <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="یک عنوان جذاب برای پست خود بنویسید..."
                                wire:model.defer="title"
                            >
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback d-block small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div>
                            <label for="content" class="form-label fw-semibold small text-muted mb-1 d-flex justify-content-between">
                                <span>محتوای کامل پست</span>
                                <span class="small text-muted">
                                    حداقل ۱۰ کاراکتر
                                </span>
                            </label>
                            <textarea
                                id="content"
                                rows="10"
                                class="form-control rounded-3 content-textarea <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="محتوای اصلی پست را اینجا بنویسید..."
                                wire:model.defer="content"
                            ></textarea>
                            <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback d-block small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    
                    <div class="section-block mb-4">
                        <div class="section-header d-flex align-items-center gap-2 mb-3">
                            <div class="icon-pill icon-pill-secondary">
                                <i class="ti ti-photo-video"></i>
                            </div>
                            <div>
                                <div class="fw-semibold">رسانه‌های پست</div>
                                <div class="small text-muted">تصویر شاخص و فایل‌های پیوست را مدیریت کنید.</div>
                            </div>
                        </div>

                        
                        <div class="mb-4">
                            <label class="form-label fw-semibold small text-muted mb-2 d-flex align-items-center gap-2">
                                <i class="ti ti-photo fs-5 text-primary"></i>
                                <span>تصویر شاخص</span>
                            </label>

                            <div class="row g-3 align-items-start">
                                
                                <div class="col-md-4">
                                    <div class="media-preview-card text-center">
                                        <?php if($current_image): ?>
                                            <img
                                                src="<?php echo e(asset('storage/' . $current_image)); ?>"
                                                alt="تصویر شاخص"
                                                class="img-fluid rounded-3 mb-2"
                                                style="max-height: 160px; object-fit: cover;"
                                            >
                                            <div class="form-check mt-2 text-start">
                                                <input class="form-check-input" type="checkbox" id="remove_image" wire:model="remove_image">
                                                <label class="form-check-label small text-muted" for="remove_image">
                                                    حذف تصویر فعلی
                                                </label>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-muted small py-4">
                                                <i class="ti ti-photo fs-1 d-block mb-2 opacity-50"></i>
                                                تصویری ثبت نشده است.
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                
                                <div class="col-md-8">
                                    <div class="upload-box p-3 rounded-3 border border-dashed">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="upload-icon">
                                                <i class="ti ti-upload fs-3"></i>
                                            </div>
                                            <div class="flex-grow-1">
                                                <div class="fw-semibold small mb-1">
                                                    انتخاب تصویر جدید
                                                </div>
                                                <div class="small text-muted mb-2">
                                                    روی دکمه زیر کلیک کنید و تصویر موردنظر را انتخاب نمایید.
                                                </div>
                                                <div class="input-group input-group-sm">
                                                    <input
                                                        type="file"
                                                        class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        id="image"
                                                        wire:model="image"
                                                        accept="image/*"
                                                    >
                                                </div>
                                                <div class="form-text small text-muted mt-1">
                                                    فرمت‌های مجاز: JPG, PNG, WEBP – حداکثر ۲ مگابایت.
                                                </div>
                                                <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback d-block small mt-1"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                <?php if($image): ?>
                                                    <div class="mt-3">
                                                        <div class="small text-muted mb-1">پیش‌نمایش تصویر جدید:</div>
                                                        <img src="<?php echo e($image->temporaryUrl()); ?>" class="img-fluid rounded-3" style="max-height: 160px; object-fit: cover;">
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div>
                            <label class="form-label fw-semibold small text-muted mb-2 d-flex align-items-center gap-2">
                                <i class="ti ti-paperclip fs-5 text-primary"></i>
                                <span>فایل پیوست (ویدیو، PDF، ZIP و ...)</span>
                            </label>

                            <div class="row g-3 align-items-start">
                                
                                <div class="col-md-6">
                                    <div class="media-preview-card">
                                        <?php if($current_media_file): ?>
                                            <div class="d-flex align-items-center justify-content-between gap-2">
                                                <div class="d-flex align-items-center gap-2">
                                                    <i class="ti ti-file-text fs-3 text-primary"></i>
                                                    <div class="small">
                                                        <div class="fw-semibold text-dark text-truncate" style="max-width: 220px;">
                                                            <?php echo e(basename($current_media_file)); ?>

                                                        </div>
                                                        <a
                                                            href="<?php echo e(asset('storage/' . $current_media_file)); ?>"
                                                            target="_blank"
                                                            class="text-primary small text-decoration-none"
                                                        >
                                                            دانلود / مشاهده فایل
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-check mt-2">
                                                <input class="form-check-input" type="checkbox" id="remove_media_file" wire:model="remove_media_file">
                                                <label class="form-check-label small text-muted" for="remove_media_file">
                                                    حذف فایل فعلی
                                                </label>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-muted small py-2">
                                                هیچ فایل پیوستی ثبت نشده است.
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                
                                <div class="col-md-6">
                                    <div class="upload-box p-3 rounded-3 border border-dashed">
                                        <div class="d-flex align-items-start gap-3">
                                            <div class="upload-icon upload-icon-soft">
                                                <i class="ti ti-cloud-upload fs-4"></i>
                                            </div>
                                            <div class="flex-grow-1">
                                                <div class="fw-semibold small mb-1">
                                                    انتخاب فایل پیوست جدید
                                                </div>
                                                <div class="small text-muted mb-2">
                                                    می‌توانید ویدیو، PDF، ZIP و سایر فایل‌های مجاز را بارگذاری کنید.
                                                </div>
                                                <input
                                                    type="file"
                                                    class="form-control form-control-sm <?php $__errorArgs = ['media_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    id="media_file"
                                                    wire:model="media_file"
                                                >
                                                <div class="form-text small text-muted mt-1">
                                                    حداکثر حجم فایل: ۱۰ مگابایت.
                                                </div>
                                                <?php $__errorArgs = ['media_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback d-block small mt-1"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                <?php if($media_file): ?>
                                                    <div class="mt-2 small text-muted">
                                                        فایل انتخاب‌شده: <?php echo e($media_file->getClientOriginalName()); ?>

                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="section-block mb-4">
                        <div class="section-header d-flex align-items-center gap-2 mb-3">
                            <div class="icon-pill icon-pill-success">
                                <i class="ti ti-broadcast"></i>
                            </div>
                            <div>
                                <div class="fw-semibold">وضعیت انتشار</div>
                                <div class="small text-muted">مشخص کنید این پست برای کاربران نمایش داده شود یا در حالت پیش‌نویس بماند.</div>
                            </div>
                        </div>

                        <div class="py-3 px-3 bg-gray-50 rounded-3 d-flex flex-wrap align-items-center justify-content-between gap-3">
                            <div>
                                <div class="fw-semibold text-dark">
                                    وضعیت فعلی:
                                    <span class="badge rounded-pill ms-1 <?php echo e($is_published ? 'bg-success-subtle text-success' : 'bg-warning-subtle text-warning'); ?>">
                                        <?php echo e($is_published ? 'منتشر شده' : 'پیش‌نویس'); ?>

                                    </span>
                                </div>
                                <div class="small text-muted mt-1">
                                    می‌توانید هر زمان که خواستید وضعیت انتشار را تغییر دهید.
                                </div>
                            </div>

                            <div class="d-flex align-items-center gap-2">
                                <span class="small text-muted">
                                    <?php echo e($is_published ? 'فعال برای عموم' : 'غیرفعال (فقط خودتان می‌بینید)'); ?>

                                </span>
                                <div class="form-check form-switch m-0">
                                    <input
                                        class="form-check-input publish-switch"
                                        type="checkbox"
                                        role="switch"
                                        id="is_published"
                                        wire:model="is_published"
                                    >
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="pt-3 mt-2 border-top d-flex justify-content-end gap-2">
                        <a
                            href="<?php echo e(route('admin.my-posts')); ?>"
                            class="btn btn-light border rounded-pill px-4 fw-medium d-flex align-items-center gap-2"
                        >
                            <i class="ti ti-x"></i>
                            انصراف
                        </a>

                        <button
                            type="submit"
                            class="btn btn-primary rounded-pill px-4 fw-semibold d-flex align-items-center gap-2"
                            wire:loading.attr="disabled"
                            wire:target="updatePost,image,media_file"
                        >
                            <span wire:loading.remove wire:target="updatePost,image,media_file">
                                <i class="ti ti-device-floppy"></i>
                                ذخیره تغییرات
                            </span>
                            <span wire:loading wire:target="updatePost,image,media_file" class="d-flex align-items-center gap-2">
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                در حال ذخیره...
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <style>
        :root {
            --primary: #0f766e;
            --primary-light: #ccfbf1;
            --primary-dark: #115e59;
            --gray-50: #f9fafb;
            --gray-100: #f3f4f6;
        }

        .bg-gradient-header {
            background: radial-gradient(circle at top left, rgba(255,255,255,0.18), transparent 40%),
            linear-gradient(135deg, var(--primary-dark), var(--primary));
        }

        .header-card-icon {
            position: absolute;
            top: -10px;
            left: -10px;
            font-size: 9rem;
            color: rgba(255, 255, 255, 0.08);
            transform: rotate(-15deg);
        }

        .notification-alert {
            background: linear-gradient(135deg, #10b981, #059669) !important;
            color: white !important;
        }

        .btn-close-white {
            filter: brightness(0) invert(1);
        }

        .shadow-soft {
            box-shadow: 0 18px 45px rgba(15, 23, 42, 0.08);
        }

        .edit-card {
            backdrop-filter: blur(6px);
        }

        .section-block {
            padding: 16px 18px;
            border-radius: 18px;
            border: 1px solid rgba(148, 163, 184, 0.18);
            background: linear-gradient(135deg, #ffffff, #f9fafb);
        }

        .section-header .icon-pill {
            width: 34px;
            height: 34px;
            border-radius: 999px;
            background: rgba(15, 118, 110, 0.1);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: var(--primary-dark);
        }

        .icon-pill-secondary {
            background: rgba(59, 130, 246, 0.1);
            color: #1d4ed8;
        }

        .icon-pill-success {
            background: rgba(34, 197, 94, 0.1);
            color: #16a34a;
        }

        .media-preview-card {
            border-radius: 16px;
            border: 1px dashed rgba(148, 163, 184, 0.6);
            background-color: var(--gray-50);
            padding: 10px 12px;
        }

        .upload-box {
            background-color: #ffffff;
        }

        .upload-box .upload-icon {
            width: 40px;
            height: 40px;
            border-radius: 999px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(37, 99, 235, 0.08);
            color: #1d4ed8;
        }

        .upload-icon-soft {
            background: rgba(148, 163, 184, 0.16);
            color: #6b7280;
        }

        .bg-gray-50 {
            background-color: var(--gray-50);
        }

        .publish-switch {
            width: 46px;
            height: 24px;
            cursor: pointer;
            box-shadow: 0 0 0 2px rgba(15, 118, 110, 0.1);
        }
        .publish-switch:checked {
            background-color: var(--primary);
            border-color: var(--primary);
        }

        .content-textarea {
            min-height: 240px;
            resize: vertical;
        }

        .hover-scale {
            transition: transform 0.18s ease, box-shadow 0.18s ease;
        }
        .hover-scale:hover {
            transform: translateY(-1px);
            box-shadow: 0 6px 18px rgba(15, 23, 42, 0.18);
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\post\edit-post.blade.php ENDPATH**/ ?>