<div>

    <div class="container-fluid">
        <!-- هدر و مسیر سایت -->
        <div class="card bg-light-info shadow-none position-relative overflow-hidden">
            <div class="card-body px-4 py-3">
                <div class="row align-items-center">
                    <?php if(session()->has('message')): ?>
                        <div class="alert alert-info">
                            <?php echo e(session('message')); ?>

                        </div>
                    <?php endif; ?>
                    <div class="col-9">
                        <h4 class="fw-semibold mb-8">مدیریت کالاها</h4>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-muted text-decoration-none" href="<?php echo e(route('admin.dashboard')); ?>">داشبورد</a></li>
                                <li class="breadcrumb-item" aria-current="page">مدیریت کالاها</li>
                            </ol>
                        </nav>
                    </div>
                    <div class="col-3">
                        <div class="text-center mb-n5">
                            <img src="../../dist/images/breadcrumb/ChatBc.png" alt="" class="img-fluid mb-n4">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- فرم ثبت/ویرایش کالا در مودال -->
        <section>
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="mb-3 d-flex justify-content-between align-items-center">
                                <span>فرم مدیریت کالاها</span>
                                <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#itemModal">
                                    <i class="ti ti-plus me-2"></i>افزودن کالا
                                </button>
                            </h5>
                            <!-- مودال ثبت/ویرایش کالا -->
                            <div class="modal fade" id="itemModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">
                                                <?php echo e($editId ? 'ویرایش کالا' : 'ثبت کالای جدید'); ?>

                                            </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click="resetFields"></button>
                                        </div>
                                        <form wire:submit.prevent="saveItem">
                                            <div class="modal-body">
                                                <div class="mb-3">
                                                    <label for="name" class="form-label">نام کالا</label>
                                                    <input type="text" class="form-control" wire:model="name" id="name" placeholder="نام کالا را وارد کنید">
                                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="code" class="form-label">کد کالا</label>
                                                    <input type="text" class="form-control" wire:model="code" id="code" placeholder="کد کالا را وارد کنید">
                                                    <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="resetFields">انصراف</button>
                                                <button type="submit" class="btn btn-primary">
                                                    <?php echo e($editId ? 'ویرایش' : 'ثبت'); ?>

                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- جستجوی سریع -->
        <section>
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="input-group">
                                <span class="input-group-text"><i class="ti ti-search"></i></span>
                                <input type="text" class="form-control" wire:model.live="search" placeholder="جستجوی کالا...">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- لیست کالاها -->
        <section>
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="mb-3">لیست کالاها</h5>
                            <div class="table-responsive">
                                <table class="table table-hover align-middle">
                                    <thead class="table-light">
                                    <tr>
                                        <th width="40%">نام کالا</th>
                                        <th width="30%">کد کالا</th>
                                        <th width="30%" class="text-center">عملیات</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="position-relative">
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <span class="me-2 bg-light-info rounded-circle p-2">
                                                        <i class="ti ti-package text-info"></i>
                                                    </span>
                                                    <span><?php echo e($item->name); ?></span>
                                                </div>
                                            </td>
                                            <td><?php echo e($item->code); ?></td>
                                            <td class="text-center">
                                                <div class="d-flex justify-content-center gap-2">
                                                    <button class="btn btn-sm btn-primary rounded-pill px-3" data-bs-toggle="modal" data-bs-target="#itemModal" wire:click="editItem(<?php echo e($item->id); ?>)">
                                                        <i class="ti ti-edit me-1"></i>ویرایش
                                                    </button>
                                                    <button class="btn btn-sm btn-danger rounded-pill px-3" wire:click="deleteItem(<?php echo e($item->id); ?>)" onclick="return confirm('آیا از حذف این کالا مطمئن هستید؟')">
                                                        <i class="ti ti-trash me-1"></i>حذف
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="mt-3">
                                <?php echo e($items->links()); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- اسکریپت برای بستن خودکار پیام موفقیت -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let alert = document.querySelector('.alert-info');
            if (alert) {
                setTimeout(() => {
                    alert.style.display = 'none';
                }, 5000);
            }
        });
    </script>

    <style>
        /* انیمیشن hover برای سطرها */
        .table-hover tbody tr:hover {
            background-color: rgba(0, 123, 255, 0.05) !important;
            transition: background-color 0.2s ease;
        }
        /* هدر ثابت (در صورت نیاز به اسکرول عمودی) */
        @media (min-width: 992px) {
            .table-responsive {
                max-height: 500px;
                overflow-y: auto;
            }
            .table-responsive thead {
                position: sticky;
                top: 0;
                background-color: #f8f9fa;
                z-index: 1;
            }
        }
        /* دکمه‌های گرد و زیبا */
        .btn.rounded-pill {
            border-radius: 50px !important;
        }
        /* آیکون کالا */
        .bg-light-info {
            background-color: rgba(13, 110, 253, 0.1);
        }
    </style>


</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\item\item-management.blade.php ENDPATH**/ ?>