<div>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold">پست‌های من</h4>
        <button wire:click="create" class="btn btn-primary rounded-pill px-4">پست جدید</button>
    </div>

    <input type="text" class="form-control mb-3" placeholder="جستجو..." wire:model.debounce.500ms="search">

    <?php if(session()->has('success')): ?>
        <div class="alert alert-success my-2"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if(session()->has('error')): ?>
        <div class="alert alert-danger my-2"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <?php if($this->posts->count()): ?>
        <div class="row g-3">
            <?php $__currentLoopData = $this->posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-md-6 col-lg-4">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <h5 class="card-title text-truncate"><?php echo e($post->title); ?></h5>
                            <p class="card-text text-muted small mb-2"><?php echo e(\Illuminate\Support\Str::limit($post->content, 80)); ?></p>
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-secondary">نویسنده: <?php echo e($post->user->name); ?></small>
                                <small class="text-secondary"><?php echo e($post->created_at->diffForHumans()); ?></small>
                            </div>
                            <div class="mt-2 d-flex gap-2">
                                <button wire:click="edit(<?php echo e($post->id); ?>)" class="btn btn-sm btn-outline-info rounded-pill">ویرایش</button>
                                <button wire:click="delete(<?php echo e($post->id); ?>)" class="btn btn-sm btn-outline-danger rounded-pill" onclick="return confirm('حذف شود؟')">حذف</button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="mt-4">
            <?php echo e($this->posts->links()); ?>

        </div>
    <?php else: ?>
        <div class="alert alert-info mt-4">هیچ پستی یافت نشد.</div>
    <?php endif; ?>

    
    <?php if($showForm): ?>
        <div class="modal fade show d-block" tabindex="-1" style="background:rgba(0,0,0,0.2)">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content border-0 rounded-4">
                    <div class="modal-header border-0">
                        <h5 class="modal-title"><?php echo e($mode === 'edit' ? 'ویرایش پست' : 'پست جدید'); ?></h5>
                        <button type="button" class="btn-close" wire:click="closeForm"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="save">
                            <div class="mb-3">
                                <label class="form-label">عنوان</label>
                                <input type="text" wire:model.defer="title" class="form-control rounded-3" required>
                                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">متن پست</label>
                                <textarea wire:model.defer="content" rows="5" class="form-control rounded-3" required></textarea>
                                <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="d-flex gap-2">
                                <button class="btn btn-success rounded-pill px-4"><?php echo e($mode === 'edit' ? 'ذخیره تغییرات' : 'ثبت پست'); ?></button>
                                <button type="button" class="btn btn-secondary rounded-pill px-4" wire:click="closeForm">انصراف</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    <?php endif; ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\user\user-posts.blade.php ENDPATH**/ ?>