<div class="container-fluid py-5 px-lg-5" dir="rtl" style="font-family: 'Vazirmatn', sans-serif; background: #f4f6f8; min-height: 100vh;">

    <style>
        :root {
            --p-forest-black: #022c22;
            --p-jade: #10b981;
            --p-glass: rgba(255, 255, 255, 0.9);
            --p-border: rgba(0, 0, 0, 0.04);
        }

        .reveal-up { animation: luxFadeUp 0.8s cubic-bezier(0.16, 1, 0.3, 1) both; }
        @keyframes luxFadeUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }

        /* 🏔️ هدر فوق لوکس یشمی */
        .sky-command-center {

            background: linear-gradient(135deg, #65a293 0%, #053e33 100%);
            border-radius: 45px; padding: 60px 70px; color: white;
            position: relative; overflow: hidden;
            box-shadow: 0 35px 70px -15px rgba(2, 44, 34, 0.4);
            margin-bottom: 50px; border: 1px solid rgba(255,255,255,0.05);
        }

        .sky-command-center::after {
            content: ''; position: absolute; bottom: -20%; right: -5%; width: 500px; height: 500px;
            background: radial-gradient(circle, rgba(16, 185, 129, 0.1) 0%, transparent 70%);
            filter: blur(50px);
        }

        .stats-capsule {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(15px);
            border-radius: 25px; padding: 20px 40px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .stats-capsule:hover { background: rgba(255, 255, 255, 0.08); transform: translateY(-5px); border-color: var(--p-jade); }

        /* ✨ کارت‌های بنتو استودیویی */
        .lux-card {
            background: var(--p-glass); backdrop-filter: blur(25px);
            border-radius: 40px; border: 1px solid #fff;
            box-shadow: 0 15px 35px -10px rgba(0,0,0,0.03);
        }

        /* 📁 گره‌های شبکه */
        .node-item {
            cursor: pointer; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border-radius: 32px; border: 1.5px solid var(--p-border); background: #fff;
        }
        .node-item:hover {
            transform: translateY(-12px); border-color: var(--p-jade);
            box-shadow: 0 25px 50px -15px rgba(16, 185, 129, 0.2);
        }
        .node-item.selected { border-color: var(--p-jade); background: #f0fdf4; border-width: 2px; }

        .file-icon-lux {
            width: 70px; height: 70px; border-radius: 24px;
            display: flex; align-items: center; justify-content: center;
            background: #f8fafc; border: 1px solid #edf2f7; transition: 0.3s;
        }
        .node-item:hover .file-icon-lux { background: var(--p-forest-black); color: white !important; }

        /* 🖋️ اینپوت‌های کریستالی */
        .glass-input {
            border-radius: 18px !important; border: 2px solid #eef2f6 !important; padding: 14px 22px !important;
            background: #f8fafc !important; transition: 0.3s; font-weight: 600;
        }
        .glass-input:focus { border-color: var(--p-jade) !important; background: #fff !important; box-shadow: 0 0 0 5px rgba(16, 185, 129, 0.1) !important; }

        .btn-prime {
            background: var(--p-forest-black); color: white; border-radius: 20px; padding: 15px 40px;
            font-weight: 800; border: none; transition: 0.3s; box-shadow: 0 15px 30px rgba(2, 44, 34, 0.25);
        }
        .btn-prime:hover { background: var(--p-jade); transform: translateY(-3px); box-shadow: 0 20px 40px rgba(16, 185, 129, 0.3); }

        .badge-tag { font-size: 0.7rem; padding: 5px 12px; border-radius: 10px; background: #f0fdf4; color: #065f46; border: 1px solid #dcfce7; font-weight: 700; }
        .breadcrumb-item + .breadcrumb-item::before { color: rgba(255,255,255,0.3); }

        .format-circle {
            width: 35px; height: 35px; border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            font-weight: 900; font-size: 0.6rem; color: var(--p-forest-black);
            background: white; border: 2px solid #fff; box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
    </style>

    <div class="sky-command-center reveal-up">
        <div class="row align-items-center position-relative z-index-2">
            <div class="col-lg-7">
                <div class="d-flex align-items-center gap-3 mb-4">
                    <span class="badge bg-white bg-opacity-10 text-jade border border-white border-opacity-20 px-4 py-2 rounded-pill fw-bold small shadow-sm">
                        <i class="ti ti-shield-check me-2"></i> پلتفرم امن مدیریت اسناد
                    </span>
                    <span class="text-white opacity-20">/</span>
                    <span class="small fw-bold text-white opacity-40 tracking-widest"><?php echo e($section->project->name); ?></span>
                </div>
                <h1 class="fw-black display-3 mb-2 text-white" style="letter-spacing: -2px;">مرکز کنترل مستندات</h1>
                <p class="text-white opacity-50 fs-5 mb-0 fw-medium">آرشیو رسمی و مهندسی داده در بخش <span class="text-jade fw-bold"><?php echo e($section->name); ?></span></p>
            </div>
            <div class="col-lg-5 mt-4 mt-lg-0">
                <div class="d-flex gap-4 justify-content-lg-end">
                    <div class="stats-capsule text-center">
                        <div class="h1 fw-black mb-0"><?php echo e(count($this->existingFiles)); ?></div>
                        <small class="opacity-40 fw-bold small uppercase">TOTAL FILES</small>
                    </div>
                    <div class="stats-capsule text-center" style="border-color: var(--p-jade);">
                        <div class="h1 fw-black mb-0 text-jade"><?php echo e(count($this->folders)); ?></div>
                        <small class="opacity-40 fw-bold small uppercase">FOLDERS</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="lux-card p-4 mb-5 reveal-up" style="animation-delay: 0.1s">
        <div class="row g-4 align-items-center">
            <div class="col-lg-4 border-start border-light">
                <div class="p-5 border border-2 border-dashed rounded-4 bg-light bg-opacity-50 text-center transition-all"
                     style="cursor: pointer; border-color: #cbd5e1 !important;"
                     onclick="document.getElementById('fileInput').click()">
                    <i class="ti ti-cloud-upload fs-1 text-jade mb-3 d-block"></i>
                    <h6 class="fw-bold text-forest-black">انتخاب اسناد فنی</h6>
                    <p class="text-muted small mb-0">PDF, DWG, Office یا ZIP</p>
                    <input type="file" id="fileInput" wire:model="files" multiple class="d-none">
                </div>

                <?php if($uploadProgress > 0 && $uploadProgress < 100): ?>
                    <div class="progress rounded-pill mt-4" style="height: 10px;">
                        <div class="progress-bar bg-jade" style="width: <?php echo e($uploadProgress); ?>%"></div>
                    </div>
                <?php endif; ?>

                <button wire:click="uploadFiles" class="btn btn-prime w-100 mt-4 shadow-lg" wire:loading.attr="disabled" <?php if(empty($files)): ?> disabled <?php endif; ?>>
                    <span wire:loading.remove>تایید و ثبت در پایگاه داده</span>
                    <span wire:loading class="spinner-border spinner-border-sm"></span>
                </button>
            </div>

            <div class="col-lg-8">
                <?php if(!empty($files)): ?>
                    <div class="table-responsive rounded-4 border bg-white shadow-sm scrollbar-thin" style="max-height: 350px;">
                        <table class="table table-sm align-middle mb-0">
                            <thead class="bg-light">
                            <tr>
                                <th class="py-3 px-4 fw-bold small text-muted">نام فایل اصلی</th>
                                <th class="py-3 fw-bold small text-muted">نام شناسایی سند</th>
                                <th class="py-3 text-center"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr wire:key="up-<?php echo e($index); ?>">
                                    <td class="p-3 small fw-bold text-muted"><?php echo e(Str::limit($file->getClientOriginalName(), 30)); ?></td>
                                    <td class="p-3">
                                        <input type="text" class="form-control form-control-sm glass-input" wire:model.defer="fileNames.<?php echo e($index); ?>" placeholder="کد فنی...">
                                    </td>
                                    <td class="text-center"><button wire:click="removeFile(<?php echo e($index); ?>)" class="btn text-danger"><i class="ti ti-circle-x-filled fs-4"></i></button></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5 opacity-30">
                        <i class="ti ti-file-import display-3 mb-2"></i>
                        <p class="fw-bold">لیست آپلود خالی است</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="lux-card reveal-up shadow-sm" style="animation-delay: 0.2s">
        <div class="p-4 border-bottom d-flex align-items-center justify-content-between flex-wrap gap-4">
            <div class="d-flex align-items-center gap-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 bg-white border p-2 px-4 rounded-pill shadow-sm">
                        <li class="breadcrumb-item"><a href="#" wire:click.prevent="backToRoot"><i class="ti ti-home-2 text-jade fs-5"></i></a></li>
                        <?php $__currentLoopData = $this->breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="breadcrumb-item active small fw-bold text-dark"><?php echo e($crumb->name); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ol>
                </nav>
                <form wire:submit.prevent="createNewFolder" class="d-flex gap-2">
                    <input type="text" wire:model.defer="newFolderName" class="form-control glass-input form-control-sm w-auto shadow-sm" placeholder="پوشه جدید...">
                    <button class="btn btn-prime rounded-circle p-0 d-flex align-items-center justify-content-center" type="submit" style="width: 42px; height: 42px;"><i class="ti ti-folder-plus fs-5"></i></button>
                </form>
            </div>

            <div class="d-flex align-items-center gap-3">
                <div class="position-relative">
                    <i class="ti ti-search position-absolute top-50 start-3 translate-middle-y text-muted opacity-50"></i>
                    <input type="text" wire:model.live.debounce.400ms="search" class="form-control glass-input form-control-sm ps-5 w-auto shadow-sm" placeholder="جستجو در مخزن...">
                </div>
                <div class="btn-group p-1 bg-white border rounded-pill shadow-sm">
                    <button wire:click="$set('viewMode', 'grid')" class="btn btn-sm <?php echo e($viewMode == 'grid' ? 'btn-success bg-jade rounded-pill' : 'btn-light border-0'); ?> px-3"><i class="ti ti-layout-grid"></i></button>
                    <button wire:click="$set('viewMode', 'table')" class="btn btn-sm <?php echo e($viewMode == 'table' ? 'btn-success bg-jade rounded-pill' : 'btn-light border-0'); ?> px-3"><i class="ti ti-list"></i></button>
                </div>
            </div>
        </div>

        <div class="card-body p-5">
            <?php if($viewMode === 'grid'): ?>
                <div class="row g-4">
                    <?php $__currentLoopData = $this->folders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $folder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-6 col-sm-4 col-md-3 col-xl-2" wire:key="f-<?php echo e($folder->id); ?>">
                            <div class="node-item p-4 text-center h-100 <?php echo e(in_array($folder->id, $selectedFolders) ? 'selected' : ''); ?>" wire:click="enterFolder(<?php echo e($folder->id); ?>)">
                                <input type="checkbox" wire:model.live="selectedFolders" value="<?php echo e($folder->id); ?>" class="form-check-input position-absolute top-0 start-0 m-3" onclick="event.stopPropagation()">
                                <div class="file-icon-lux mx-auto mb-3 shadow-sm text-warning"><i class="ti ti-folder-filled display-4"></i></div>
                                <div class="fw-black text-forest-black text-truncate small px-1"><?php echo e($folder->name); ?></div>
                                <div class="text-muted small fw-bold opacity-60"><i class="ti ti-database me-1"></i> <?php echo e($this->getFolderSize($folder->id)); ?></div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php $__currentLoopData = $this->existingFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-6 col-sm-4 col-md-3 col-xl-2" wire:key="fi-<?php echo e($file->id); ?>">
                            <div class="node-item p-4 text-center h-100 d-flex flex-column align-items-center <?php echo e(in_array($file->id, $selectedFiles) ? 'selected' : ''); ?>">
                                <input type="checkbox" wire:model.live="selectedFiles" value="<?php echo e($file->id); ?>" class="form-check-input position-absolute top-0 start-0 m-3">

                                <div class="position-relative mb-3">
                                    <div class="file-icon-lux shadow-sm text-jade">
                                        <i class="ti <?php echo e($this->getFileIcon($file->type)); ?> fs-1"></i>
                                    </div>
                                    <span class="position-absolute bottom-0 end-0 format-circle" style="transform: translate(10px, 5px);">
                                        <?php echo e(strtoupper(Str::afterLast($file->type, '/'))); ?>

                                    </span>
                                </div>

                                <div class="fw-black text-forest-black text-truncate w-100 small mb-1"><?php echo e($file->name); ?></div>
                                <div class="text-muted mb-3 fw-bold" style="font-size: 0.65rem;"><?php echo e($this->formatSize($file->size)); ?></div>

                                <div class="mt-auto d-flex gap-1 justify-content-center">
                                    <button wire:click="openPreview(<?php echo e($file->id); ?>)" class="btn btn-sm btn-light border rounded-pill p-2 px-3 shadow-sm" title="پیش‌نمایش"><i class="ti ti-eye fs-6"></i></button>
                                    <button wire:click="download(<?php echo e($file->id); ?>)" class="btn btn-sm btn-light border rounded-pill p-2 px-3 shadow-sm text-success" title="دانلود"><i class="ti ti-download fs-6"></i></button>
                                    <button wire:click="editFile(<?php echo e($file->id); ?>)" class="btn btn-sm btn-light border rounded-pill p-2 px-3 shadow-sm text-primary" title="ویرایش"><i class="ti ti-pencil fs-6"></i></button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="table-responsive rounded-4 border overflow-hidden shadow-sm bg-white">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                        <tr>
                            <th style="width: 60px" class="ps-4">
                                <input type="checkbox" class="form-check-input" wire:click="selectAll" <?php if(count($selectedFiles) + count($selectedFolders) > 0): ?> checked <?php endif; ?>>
                            </th>
                            <th class="py-4 fw-bold small text-muted">نام و فرمت سند</th>
                            <th class="py-4 fw-bold small text-muted">تگ‌های فنی</th>
                            <th class="py-4 text-center fw-bold small text-muted">حجم کل</th>
                            <th class="py-4 pe-4 text-end fw-bold small text-muted">عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $this->folders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $folder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="table-row-lux cursor-pointer" wire:click="enterFolder(<?php echo e($folder->id); ?>)">
                                <td class="ps-4"><input type="checkbox" wire:model.live="selectedFolders" value="<?php echo e($folder->id); ?>" class="form-check-input" onclick="event.stopPropagation()"></td>
                                <td class="fw-bold fs-6 text-forest-black"><i class="ti ti-folder-filled fs-3 me-3 text-warning"></i> <?php echo e($folder->name); ?></td>
                                <td class="small text-muted italic">دایرکتوری سیستمی DCC</td>
                                <td class="text-center fw-bold small text-muted"><?php echo e($this->getFolderSize($folder->id)); ?></td>
                                <td class="pe-4 text-end"><i class="ti ti-chevron-left opacity-30"></i></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $this->existingFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="table-row-lux">
                                <td class="ps-4"><input type="checkbox" wire:model.live="selectedFiles" value="<?php echo e($file->id); ?>" class="form-check-input"></td>
                                <td>
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="format-circle text-white" style="background: var(--p-forest-black);">
                                            <?php echo e(strtoupper(Str::afterLast($file->type, '/'))); ?>

                                        </div>
                                        <div>
                                            <div class="fw-bold text-forest-black small"><?php echo e($file->name); ?></div>
                                            <div class="small text-muted opacity-60 text-truncate" style="max-width: 250px"><?php echo e($file->description ?: 'بدون توضیحات فنی'); ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td><?php $__empty_1 = true; $__currentLoopData = $file->tags ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?> <span class="badge-tag"><?php echo e($tag); ?></span> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?> <span class="opacity-20">—</span> <?php endif; ?></td>
                                <td class="text-center fw-bold small opacity-60"><?php echo e($this->formatSize($file->size)); ?></td>
                                <td class="pe-4 text-end">
                                    <div class="btn-group rounded-pill overflow-hidden bg-white border px-2 shadow-sm">
                                        <button wire:click="openPreview(<?php echo e($file->id); ?>)" class="btn btn-white btn-sm p-2 text-dark border-0"><i class="ti ti-eye fs-5"></i></button>
                                        <button wire:click="download(<?php echo e($file->id); ?>)" class="btn btn-white btn-sm p-2 text-success border-0"><i class="ti ti-download fs-5"></i></button>
                                        <button wire:click="editFile(<?php echo e($file->id); ?>)" class="btn btn-white btn-sm p-2 text-primary border-0"><i class="ti ti-edit fs-5"></i></button>
                                        <button wire:click="showHistory(<?php echo e($file->id); ?>)" class="btn btn-white btn-sm p-2 text-info border-0"><i class="ti ti-history fs-5"></i></button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if(count($selectedFiles) + count($selectedFolders) > 0): ?>
        <div class="fixed-bottom mb-5 d-flex justify-content-center reveal-up">
            <div class="bg-forest text-white px-5 py-3 rounded-pill shadow-2xl d-flex align-items-center gap-5 border border-white border-opacity-10" style="backdrop-filter: blur(25px); background: rgba(2, 44, 34, 0.96) !important;">
                <div class="d-flex align-items-center gap-3 border-start ps-5 border-white border-opacity-20">
                    <span class="text-jade h4 fw-black mb-0"><?php echo e(count($selectedFiles) + count($selectedFolders)); ?></span>
                    <small class="opacity-50 fw-bold uppercase tracking-widest small">آیتم منتخب</small>
                </div>

                <div class="d-flex gap-2">
                    <button wire:click="deleteSelectedFiles" wire:confirm="این عملیات برگشت ناپذیر است. تایید؟" class="btn btn-danger btn-sm rounded-pill px-4 fw-bold shadow">حذف نهایی</button>
                    <button wire:click="downloadSelectedAsZip" class="btn btn-success btn-sm rounded-pill px-4 fw-bold shadow">خروجی ZIP</button>

                    <div class="dropdown">
                        <button class="btn btn-info btn-sm rounded-pill px-4 fw-bold dropdown-toggle text-white shadow" data-bs-toggle="dropdown">جابجایی</button>
                        <ul class="dropdown-menu dropdown-menu-dark rounded-4 shadow-xl border-white border-opacity-10">
                            <li><button class="dropdown-item py-2 fw-bold" wire:click="$set('targetFolderId', 'root'); moveItems()"><i class="ti ti-home me-2 text-jade"></i> ریشه اصلی</button></li>
                            <li><hr class="dropdown-divider opacity-20"></li>
                            <?php $__currentLoopData = App\Models\Folder::where('section_id', $section->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!in_array($f->id, $selectedFolders)): ?>
                                    <li><button class="dropdown-item py-2" wire:click="$set('targetFolderId', <?php echo e($f->id); ?>); moveItems()"><i class="ti ti-folder me-2 text-warning"></i> به: <?php echo e($f->name); ?></button></li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>

                    <button wire:click="resetSelection" class="btn btn-outline-light btn-sm rounded-pill px-4 border-0 opacity-50">لغو</button>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="modal fade shadow-lg" id="previewModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content border-0 rounded-4 overflow-hidden shadow-2xl">
                <div class="modal-header bg-forest-black text-white border-0 p-4" style="background: var(--p-forest-black);">
                    <h5 class="modal-title fw-black" id="previewTitle">پیش‌نمایش مستند</h5>
                    <button type="button" class="btn-close btn-close-white shadow-none" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-0 bg-dark" style="height: 80vh; background: #000;">
                    <div id="previewContent" class="h-100 w-100 d-flex align-items-center justify-content-center">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('livewire.admin.sections.modals.file-modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('livewire:initialized', () => {
            const initPopovers = () => {
                document.querySelectorAll('[data-bs-toggle="popover"]').forEach(el => {
                    if (!bootstrap.Popover.getInstance(el)) new bootstrap.Popover(el, { html: true });
                });
            };
            initPopovers();
            Livewire.hook('morph.updated', () => { initPopovers(); });

            // هندلر پیش‌نمایش زنده
            Livewire.on('open-preview-modal', (data) => {
                const content = document.getElementById('previewContent');
                const title = document.getElementById('previewTitle');
                const fileData = data[0];

                title.innerText = fileData.name;
                content.innerHTML = '';

                // نمایش لودینگ
                content.innerHTML = '<div class="spinner-border text-jade" role="status"></div>';

                setTimeout(() => {
                    if (fileData.type.includes('image')) {
                        content.innerHTML = `<img src="${fileData.url}" class="img-fluid" style="max-height: 100%; object-fit: contain;">`;
                    } else if (fileData.type.includes('pdf')) {
                        content.innerHTML = `<iframe src="${fileData.url}#toolbar=0" width="100%" height="100%" border="0"></iframe>`;
                    } else if (fileData.type.includes('text')) {
                        content.innerHTML = `<iframe src="${fileData.url}" width="100%" height="100%" style="background: #fff;"></iframe>`;
                    } else {
                        content.innerHTML = `
                            <div class="text-center text-white">
                                <i class="ti ti-file-off display-1 opacity-20 mb-4 d-block"></i>
                                <h5 class="fw-bold">پیش‌نمایش برای این فایل مقدور نیست</h5>
                                <p class="opacity-50">فرمت فایل: ${fileData.type}</p>
                                <a href="${fileData.url}" class="btn btn-jade rounded-pill px-5 mt-3">دانلود و مشاهده آفلاین</a>
                            </div>`;
                    }
                }, 500);

                new bootstrap.Modal('#previewModal').show();
            });

            Livewire.on('show-edit-modal', () => { new bootstrap.Modal('#editFileModal').show(); });
            Livewire.on('hide-edit-modal', () => {
                bootstrap.Modal.getInstance('#editFileModal')?.hide();
                cleanBackdrops();
            });
            Livewire.on('show-history-modal', () => { new bootstrap.Modal('#historyModal').show(); });

            function cleanBackdrops() {
                document.body.classList.remove('modal-open');
                document.querySelectorAll('.modal-backdrop').forEach(el => el.remove());
                document.body.style.overflow = '';
            }
        });
    </script>
<?php $__env->stopPush(); ?><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\sections\section-file-upload.blade.php ENDPATH**/ ?>