<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>
        /* تنظیمات پایه */
        @page { margin: 0.5cm; }
        body {
            font-family: 'vazir', sans-serif;
            direction: rtl;
            color: #1e293b;
            line-height: 1.6;
            margin: 0;
            padding: 1.2cm;
            font-size: 11px;
            position: relative;
        }

        /* کادر دو رنگ دور کل صفحه (Executive Frame) */
        body::before {
            content: "";
            position: fixed;
            top: 0.4cm; bottom: 0.4cm; left: 0.4cm; right: 0.4cm;
            border: 2px solid #1e3a8a; /* سرمه‌ای سازمانی */
            z-index: -1;
        }
        body::after {
            content: "";
            position: fixed;
            top: 0.55cm; bottom: 0.55cm; left: 0.55cm; right: 0.55cm;
            border: 1px solid #94a3b8; /* خاکستری-آبی روشن */
            z-index: -1;
        }

        /* واترمارک محو */
        .watermark {
            position: fixed;
            top: 50%; left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 70px;
            color: rgba(30, 58, 138, 0.03);
            z-index: -1000;
            font-weight: bold;
            white-space: nowrap;
        }

        /* هدر رسمی */
        .header-main {
            margin-bottom: 25px;
            border-bottom: 2px solid #1e3a8a;
            padding-bottom: 12px;
        }
        .header-table { width: 100%; border-collapse: collapse; }
        .doc-title {
            font-size: 22px;
            font-weight: bold;
            text-align: center;
            color: #1e3a8a;
            letter-spacing: -1px;
        }
        .meta-text { font-size: 10px; color: #64748b; line-height: 1.8; }
        .meta-value { color: #1e3a8a; font-weight: bold; }

        /* بخش اطلاعات (Modern Bento Style) */
        .info-container {
            margin-bottom: 20px;
            width: 100%;
            border-collapse: collapse;
        }
        .info-cell {
            border: 1px solid #e2e8f0;
            padding: 10px 15px;
            width: 50%;
            vertical-align: top;
            background-color: #ffffff;
        }
        .label {
            font-size: 9px;
            color: #64748b;
            font-weight: bold;
            display: block;
            margin-bottom: 4px;
            text-transform: uppercase;
        }
        .value { font-size: 12px; font-weight: bold; color: #334155; }

        /* جدول اقلام */
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5px;
            border-radius: 8px;
            overflow: hidden;
        }
        .items-table th {
            border: 1px solid #1e3a8a;
            background: #1e3a8a;
            color: #ffffff;
            font-size: 10px;
            padding: 12px 5px;
            text-align: center;
        }
        .items-table td {
            padding: 10px 5px;
            text-align: center;
            border: 1px solid #e2e8f0;
            color: #334155;
        }
        .items-table tr:nth-child(even) { background-color: #f8fafc; }

        /* باکس مجموع کل */
        .total-row { background: #eff6ff !important; font-weight: bold; }
        .total-box {
            border: 2px solid #1e3a8a !important;
            color: #1e3a8a;
            padding: 12px !important;
        }
        .total-label { text-align: left !important; padding-left: 20px !important; font-size: 12px; }
        .total-value { font-size: 16px !important; }

        /* بخش امضاها */
        .signatures-section {
            margin-top: 40px;
            width: 100%;
            border-collapse: collapse;
        }
        .sig-card {
            width: 33.33%;
            padding: 20px 10px;
            text-align: center;
            vertical-align: top;
            border: 1px dashed #cbd5e1;
        }
        .sig-role {
            font-size: 11px;
            font-weight: bold;
            margin-bottom: 6px;
            display: block;
            color: #1e3a8a;
            border-bottom: 1px solid #e2e8f0;
            padding-bottom: 4px;
        }
        .sig-name { font-size: 10px; color: #64748b; margin-bottom: 12px; display: block; font-weight: bold; }

        .sig-box {
            height: 90px;
            display: block;
            margin: 5px auto;
        }
        .user-sign {
            max-width: 130px;
            max-height: 80px;
            filter: contrast(1.1) sepia(100%) hue-rotate(190deg) saturate(200%); /* افکت آبی جوهری برای امضا */
        }
        .sig-date { font-size: 9px; color: #94a3b8; margin-top: 8px; display: block; }

        .footer {
            position: fixed;
            bottom: 0.8cm; left: 1.2cm; right: 1.2cm;
            text-align: center;
            font-size: 9px;
            color: #94a3b8;
            border-top: 1px solid #e2e8f0;
            padding-top: 10px;
        }
    </style>
</head>
<body>


<div class="header-main">
    <table class="header-table">
        <tr>
            <td style="width: 30%;" class="meta-text">
                تاریخ ثبت: <span class="meta-value"><?php echo e(jdate($request->created_at)->format('Y/m/d')); ?></span><br>
                شماره پرونده: <span class="meta-value">PR-<?php echo e($request->id); ?></span><br>
                وضعیت: <span style="color: #059669; font-weight: bold;">تایید شده</span>
            </td>
            <td class="doc-title">درخواست خرید کالا و خدمات</td>
            <td style="width: 30%; text-align: left;">



                <?php if($companyLogo): ?>
                    <img src="<?php echo e($companyLogo); ?>" width="65" style="max-height: 55px;">
                <?php else: ?>
                    <div style="color: #1e3a8a; font-weight: bold;">LOGO</div>
                <?php endif; ?>
            </td>
        </tr>
    </table>
</div>

<table class="info-container">
    <tr>
        <td class="info-cell">
            <span class="label">پروژه مقصد / واحد کارگاهی</span>
            <span class="value"><?php echo e($request->project->name); ?></span>
        </td>
        <td class="info-cell">
            <span class="label">متقاضی ثبت / مسئول واحد</span>
            <span class="value"><?php echo e($request->user->name); ?></span>
        </td>
    </tr>
    <tr>
        <td class="info-cell">
            <span class="label">زمان‌بندی مورد نیاز (فوریت)</span>
            <span class="value"><?php echo e(jdate($request->required_by)->format('%d %B %Y')); ?></span>
        </td>
        <td class="info-cell">
            <span class="label">مرکز هزینه / ردیف بودجه</span>
            <span class="value"><?php echo e($request->costCenter->name ?? 'تدارکات عمومی'); ?></span>
        </td>
    </tr>
    <?php if($request->description): ?>
        <tr>
            <td colspan="2" class="info-cell" style="width: 100%; border-top: none;">
                <span class="label">شرح ضرورت و ملاحظات فنی درخواست</span>
                <span class="value" style="font-weight: normal; font-size: 11px; line-height: 1.8; color: #475569;"><?php echo e($request->description); ?></span>
            </td>
        </tr>
    <?php endif; ?>
</table>

<table class="items-table">
    <thead>
    <tr>
        <th style="width: 40px;">ردیف</th>
        <th style="text-align: right;">شرح دقیق کالا یا خدمات درخواستی</th>
        <th style="width: 70px;">مقدار</th>
        <th style="width: 130px;">برآورد نهایی (ریال)</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $request->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td style="color: #94a3b8; font-weight: bold;"><?php echo e($index + 1); ?></td>
            <td style="text-align: right; font-weight: bold; color: #1e293b;"><?php echo e($item->displayName); ?></td>
            <td style="font-size: 12px; color: #1e3a8a; font-weight: bold;"><?php echo e($item->quantity); ?></td>
            <td style="font-weight: bold; font-size: 12px; color: #1e293b;"><?php echo e(number_format($item->subtotal)); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <tr class="total-row">
        <td colspan="3" class="total-label total-box">جمع کل برآورد هزینه (ریال):</td>
        <td class="total-value total-box"><?php echo e(number_format($request->total_price)); ?></td>
    </tr>
    </tbody>
</table>

<table class="signatures-section">
    <tr>
        <?php $__currentLoopData = $approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td class="sig-card">
                <span class="sig-role"><?php echo e($app['role']); ?></span>
                <span class="sig-name"><?php echo e($app['name']); ?></span>
                <div class="sig-box">
                    <?php if($app['signature']): ?>
                        
                        <img src="<?php echo e($app['signature']); ?>" class="user-sign">
                    <?php else: ?>
                        <div style="padding-top: 35px; color: #e2e8f0; font-size: 9px;">در انتظار اقدام</div>
                    <?php endif; ?>
                </div>
                <span class="sig-date"><?php echo e($app['date'] ?: '---'); ?></span>
            </td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tr>
</table>

<div class="footer">
    این سند در سامانه یکپارچه تدارکات (ERP) تولید شده و دارای امضای الکترونیک معتبر است.<br>
    <?php echo e($request->user->company->name ?? 'مجموعه صنعتی و خدماتی'); ?> | واحد تدارکات و پشتیبانی
</div>
</body>
</html><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\purchase\pdf-print.blade.php ENDPATH**/ ?>