<div x-data="templateManager()" x-cloak>

    <style>
        .template-container {
            background: #f8fafc;
            min-height: 100vh;
            padding: 2rem;
        }

        .main-card {
            background: white;
            border-radius: 12px;
            padding: 2rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }

        .btn-primary-custom {
            background: #4f46e5;
            border: none;
            border-radius: 8px;
            padding: 10px 20px;
            color: white;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-primary-custom:hover {
            background: #4338ca;
            transform: translateY(-1px);
        }

        .search-input {
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            padding: 10px 15px;
            width: 100%;
            max-width: 400px;
        }

        .search-input:focus {
            border-color: #4f46e5;
            outline: none;
            box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.1);
        }

        .table-custom {
            width: 100%;
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .table-custom thead {
            background: #374151;
        }

        .table-custom th {
            padding: 1rem;
            color: white;
            font-weight: 600;
            text-align: right;
        }

        .table-custom td {
            padding: 1rem;
            border-bottom: 1px solid #f3f4f6;
        }

        .table-custom tbody tr:hover {
            background: #f9fafb;
        }

        .badge-custom {
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            color: white;
        }

        .content-preview {
            max-width: 300px;
            cursor: pointer;
            color: #6b7280;
        }

        .content-preview:hover {
            color: #4f46e5;
        }

        .custom-tooltip {
            position: fixed;
            z-index: 10000;
            background: rgba(0, 0, 0, 0.9);
            color: white;
            padding: 10px 15px;
            border-radius: 8px;
            font-size: 13px;
            max-width: 350px;
            line-height: 1.5;
            pointer-events: none;
        }

        .modal-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 9999;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .modal-content-custom {
            background: white;
            border-radius: 12px;
            padding: 2rem;
            width: 100%;
            max-width: 800px;
            max-height: 90vh;
            overflow-y: auto;
        }

        .form-control-custom {
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            padding: 10px 15px;
            width: 100%;
        }

        .form-control-custom:focus {
            border-color: #4f46e5;
            outline: none;
            box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.1);
        }

        .content-textarea {
            min-height: 300px;
            font-family: 'IRANSans', 'Tahoma', sans-serif;
            font-size: 14px;
            line-height: 1.6;
            direction: rtl;
            text-align: right;
            resize: vertical;
        }

        .empty-state {
            text-align: center;
            padding: 3rem 2rem;
            color: #6b7280;
        }

        .loading-spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid transparent;
            border-top: 2px solid currentColor;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        @media (max-width: 768px) {
            .template-container {
                padding: 1rem;
            }

            .main-card {
                padding: 1.5rem;
            }
        }
    </style>

    <script>
        function templateManager() {
            return {
                showTooltip: false,
                tooltipContent: '',
                tooltipX: 0,
                tooltipY: 0,

                confirmDelete(templateId, templateName) {
                    if (confirm('آیا از حذف قالب "' + templateName + '" مطمئن هستید؟')) {
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('deleteTemplate', templateId);
                    }
                },

                handleHover(event, content) {
                    this.tooltipContent = content;

                    let x = event.clientX + 15;
                    let y = event.clientY + 15;

                    this.tooltipX = x;
                    this.tooltipY = y;
                    this.showTooltip = true;
                },

                hideTooltip() {
                    this.showTooltip = false;
                }
            }
        }
    </script>

    
    <div x-show="showTooltip" class="custom-tooltip"
         :style="'top: ' + tooltipY + 'px; left: ' + tooltipX + 'px;'">
        <div x-text="tooltipContent"></div>
    </div>

    <div class="template-container">
        <div class="main-card">
            
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h4 class="text-gray-800 mb-1">
                        <i class="fas fa-magic text-primary me-2"></i>
                        مدیریت قالب‌های نامه
                    </h4>
                    <p class="text-gray-600 mb-0">مدیریت قالب‌های متنی آماده</p>
                </div>
                <button class="btn-primary-custom" wire:click="createTemplate">
                    <i class="fas fa-plus me-2"></i>
                    ایجاد قالب جدید
                </button>
            </div>

            
            <div class="mb-4">
                <input type="text" class="search-input"
                       wire:model.live.debounce.300ms="search"
                       placeholder="جستجو در عنوان، محتوا یا نوع...">
            </div>

            
            <div class="table-responsive">
                <table class="table-custom">
                    <thead>
                    <tr>
                        <th wire:click="sortBy('id')" style="cursor: pointer; width: 80px;">#</th>
                        <th wire:click="sortBy('name')" style="cursor: pointer;">عنوان</th>
                        <th wire:click="sortBy('type')" style="cursor: pointer;">نوع</th>
                        <th>پیش‌نمایش</th>
                        <th wire:click="sortBy('is_public')" style="cursor: pointer;">دسترسی</th>
                        <th wire:click="sortBy('created_at')" style="cursor: pointer;">تاریخ ایجاد</th>
                        <th style="width: 150px;">عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="text-gray-500">#<?php echo e($template->id); ?></td>
                            <td class="fw-bold text-gray-800"><?php echo e($template->name); ?></td>
                            <td>
                                <span class="badge-custom" style="background-color: <?php echo e($templateTypeColors[$template->type] ?? '#6b7280'); ?>;">
                                    <?php echo e($templateTypes[$template->type] ?? $template->type); ?>

                                </span>
                            </td>
                            <td>
                                <div class="content-preview"
                                     x-on:mouseover="handleHover($event, $el.getAttribute('data-content'))"
                                     x-on:mouseleave="hideTooltip()"
                                     data-content="<?php echo e(Str::limit(strip_tags($template->content), 200)); ?>">
                                    <?php echo e(Str::limit(strip_tags($template->content), 40)); ?>

                                </div>
                            </td>
                            <td>
                                <span class="badge bg-<?php echo e($template->is_public ? 'success' : 'secondary'); ?>">
                                    <?php echo e($template->is_public ? 'عمومی' : 'خصوصی'); ?>

                                </span>
                            </td>
                            <td class="text-nowrap">
                                <?php echo e($template->created_at->format('Y/m/d')); ?>

                            </td>
                            <td>
                                <div class="d-flex gap-2">
                                    <button class="btn btn-sm btn-outline-primary"
                                            wire:click="editTemplate(<?php echo e($template->id); ?>)">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-outline-danger"
                                            x-on:click="confirmDelete(<?php echo e($template->id); ?>, '<?php echo e(addslashes($template->name)); ?>')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7">
                                <div class="empty-state">
                                    <i class="fas fa-inbox fa-2x mb-3 text-gray-400"></i>
                                    <p class="text-gray-600">هیچ قالب متنی یافت نشد</p>
                                    <?php if(!$search): ?>
                                        <button class="btn-primary-custom mt-2" wire:click="createTemplate">
                                            ایجاد اولین قالب
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>

            
            <?php if($templates->hasPages()): ?>
                <div class="mt-4">
                    <?php echo e($templates->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>

    
    <?php if($showModal): ?>
        <div class="modal-backdrop">
            <div class="modal-content-custom">
                <div class="modal-header border-bottom pb-3 mb-4">
                    <h5 class="modal-title fw-bold">
                        <?php echo e($templateId ? 'ویرایش قالب' : 'ایجاد قالب جدید'); ?>

                    </h5>
                    <button type="button" class="btn-close" wire:click="closeModal"></button>
                </div>

                <form wire:submit="saveTemplate">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-semibold">عنوان قالب *</label>
                                <input type="text" class="form-control-custom" wire:model="name">
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-semibold">نوع قالب *</label>
                                <select class="form-control-custom" wire:model="type">
                                    <option value="">انتخاب کنید</option>
                                    <?php $__currentLoopData = $templateTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value); ?>"><?php echo e($label); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">شرح مختصر</label>
                            <textarea class="form-control-custom" rows="3" wire:model="description"></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">محتوای قالب *</label>
                            <textarea class="form-control-custom content-textarea" wire:model="content" rows="12"></textarea>
                            <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" wire:model="is_public" id="isPublic">
                            <label class="form-check-label" for="isPublic">
                                قالب عمومی (قابل استفاده توسط همه کاربران)
                            </label>
                        </div>
                    </div>

                    <div class="modal-footer border-top pt-3">
                        <button type="button" class="btn btn-secondary" wire:click="closeModal">انصراف</button>
                        <button type="submit" class="btn-primary-custom">
                        <span wire:loading.remove>
                            <?php echo e($templateId ? 'بروزرسانی' : 'ذخیره'); ?>

                        </span>
                            <span wire:loading>
                            <span class="loading-spinner me-2"></span>
                            در حال ذخیره...
                        </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\template\template-manager.blade.php ENDPATH**/ ?>