<?php

use Illuminate\Support\Facades\Password;
use Livewire\Attributes\Layout;
use Livewire\Volt\Component;

?>

<div class="min-h-screen flex flex-col lg:flex-row items-center justify-center bg-gradient-to-br from-slate-950 via-blue-900 to-teal-950 px-4 py-12 relative" dir="rtl">
    <!-- سمت چپ (برندینگ) -->
    <div class="hidden lg:flex lg:w-1/2 lg:pr-14 items-center justify-center animate-fade-in">
        <div class="text-center max-w-lg mx-auto space-y-7">
            <div class="flex justify-center mb-2">
                <div class="w-20 h-20 bg-gradient-to-br from-cyan-600 to-teal-500 rounded-full flex items-center justify-center shadow-2xl shadow-cyan-700/50">
                    <svg class="w-10 h-10 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                </div>
            </div>
            <h2 class="text-3xl font-bold text-white leading-tight drop-shadow">
                به <span class="bg-gradient-to-r from-cyan-200 via-teal-200 to-indigo-200 text-transparent bg-clip-text">سامانه اتوماسیون</span> خوش آمدید
            </h2>
            <p class="text-slate-400 leading-relaxed text-md">
                بازیابی رمز عبور در لحظات
            </p>
            <p class="text-slate-300 leading-relaxed text-md">
                امنیت بالا، تجربه‌ی روان کاربری.
            </p>
        </div>
    </div>

    <!-- فرم بازیابی رمز عبور -->
    <div class="w-full lg:w-1/2 lg:pl-14">
        <div class="w-full max-w-lg mx-auto px-8 py-12 shadow-2xl rounded-3xl border border-cyan-700/30 bg-slate-900/95 backdrop-blur-sm text-white relative z-10 animate-float">

            <!-- Head -->
            <div class="text-center mb-8">
                <div class="flex justify-center mb-4">
                    <div class="w-16 h-16 bg-gradient-to-br from-cyan-600 to-teal-500 rounded-2xl flex items-center justify-center shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                        </svg>
                    </div>
                </div>
                <h2 class="text-2xl md:text-3xl font-black bg-gradient-to-r from-cyan-200 via-teal-100 to-indigo-100 text-transparent bg-clip-text drop-shadow">
                    بازیابی رمز عبور
                </h2>
                <p class="text-cyan-200 text-sm mt-2">ایمیل خود را وارد کنید تا لینک بازنشانی ارسال شود</p>
            </div>

            <form wire:submit="sendPasswordResetLink" class="space-y-6">
                <!-- ایمیل -->
                <div class="relative">
                    <input wire:model="email"
                           type="email"
                           placeholder="ایمیل شرکتی"
                           class="w-full px-4 py-3 rounded-2xl border-2 border-slate-800 bg-slate-950/80 text-slate-100 placeholder-slate-400 focus:border-cyan-400 focus:ring-2 focus:ring-cyan-400/20 outline-none transition shadow"
                           dir="rtl"
                           required />
                    <label for="email" class="absolute right-5 -top-2.5 text-xs px-1 bg-slate-900/95 text-cyan-300">آدرس ایمیل</label>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="text-rose-400 text-xs mt-1 block"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- دکمه ارسال -->
                <button type="submit"
                        class="w-full py-3 mt-2 bg-gradient-to-r from-cyan-600 via-teal-500 to-indigo-600 hover:from-cyan-700 hover:to-indigo-700 text-white font-bold text-base rounded-xl shadow-lg transition-all duration-300 flex items-center justify-center group relative overflow-hidden"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="sendPasswordResetLink" class="flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 19v-8.93a2 2 0 01.89-1.664l7-4.666a2 2 0 012.22 0l7 4.666A2 2 0 0121 10.07V19M3 19a2 2 0 002 2h14a2 2 0 002-2M3 19l6.75-4.5M21 19l-6.75-4.5M3 10l6.75 4.5M21 10l-6.75 4.5" />
                        </svg>
                        ارسال لینک بازیابی
                    </span>
                    <span wire:loading wire:target="sendPasswordResetLink" class="flex items-center">
                        <svg class="animate-spin h-4 w-4 ml-2 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        در حال ارسال...
                    </span>
                </button>
            </form>

            <!-- بازگشت به لاگین -->
            <div class="mt-8 pt-6 border-t border-slate-800 text-center">
                <p class="text-slate-400 text-sm mb-3">به حساب خود دسترسی دارید؟</p>
                <a href="<?php echo e(route('login')); ?>" wire:navigate
                   class="inline-flex items-center px-5 py-2.5 border-2 border-cyan-500 text-cyan-300 hover:bg-cyan-500/10 rounded-xl text-sm font-semibold transition-colors group">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1.5 group-hover:scale-110 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1" />
                    </svg>
                    بازگشت به ورود
                </a>
            </div>
        </div>
    </div>

    <style>
        @keyframes fade-in {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }
        .animate-fade-in {
            animation: fade-in 0.8s cubic-bezier(0.5, 0.2, 0.3, 1);
        }
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\pages\auth\forgot-password.blade.php ENDPATH**/ ?>