<div class="container py-4 modern-task-dashboard">

    <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-3 border-bottom pb-3">
        <div>
            <h4 class="fw-bold text-dark-primary mb-1"><i class="ti ti-checklist me-2 text-action-primary"></i> لیست تسک‌های پروژه</h4>
            <span class="small text-secondary-light ms-2">
                <span class="fw-bold text-action-primary"><?php echo e(number_format($filteredCount)); ?></span> از <?php echo e(number_format($totalCount)); ?> تسک (تسک‌های فیلتر شده)
            </span>
        </div>
        <div class="d-flex gap-3 align-items-center">
            <button class="btn btn-outline-secondary btn-sm toggle-view-btn rounded-pill px-3 animate-hover" wire:click="toggleView" title="سوییچ نمایش">
                <i class="ti ti-layout-<?php echo e($viewType == 'table' ? 'board-split' : 'list-details'); ?> fs-5"></i>
                <span class="d-none d-md-inline ms-1"><?php echo e($viewType == 'table' ? 'نمایش کارتی' : 'نمایش جدولی'); ?></span>
            </button>
            <a href="<?php echo e(route('admin.project.task.create', ['project' => $projectId])); ?>" class="btn btn-action-primary btn-sm rounded-pill px-4 shadow-sm animate-hover">
                <i class="ti ti-plus me-1"></i> تسک جدید
            </a>
        </div>
    </div>

    <div class="card shadow-lg-md border-0 rounded-4 p-4 mb-4 bg-gray-light">
        <div class="row g-3 align-items-center">
            <div class="col-12 col-md-4">
                <input type="text" wire:model.debounce.400ms="search" class="form-control rounded-pill shadow-sm" placeholder="جستجوی عنوان یا توضیح...">
            </div>
            <div class="col-12 col-md-7 d-flex gap-3 flex-wrap align-items-center">
                
                <select wire:model="status" class="form-select form-select-sm task-select">
                    <option value="">همه وضعیت‌ها</option>
                    <?php $__currentLoopData = $labels['statuses']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>"><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <select wire:model="priority" class="form-select form-select-sm task-select">
                    <option value="">همه اولویت‌ها</option>
                    <?php $__currentLoopData = $labels['priorities']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>"><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                
                <?php if($search || $status || $priority): ?>
                    <button class="btn btn-outline-danger btn-sm rounded-pill d-flex align-items-center animate-hover" wire:click="resetFilters">
                        <i class="ti ti-filter-off me-1"></i> حذف فیلترها
                    </button>
                <?php endif; ?>
            </div>
        </div>
    </div>


    <?php if($viewType == 'table'): ?>
        <div class="card shadow-lg border-0 rounded-4 overflow-hidden">
            <div class="table-responsive">
                <table class="table align-middle mb-0 table-hover-row task-table-modern">
                    <thead class="bg-primary-table-header text-white">
                    <tr>
                        <th class="py-3 px-4">عنوان / نوع</th>
                        <th class="py-3">مسئول</th>
                        <th class="py-3">مهلت</th>
                        <th class="py-3">پیشرفت</th>
                        <th class="py-3">وضعیت</th>
                        <th class="py-3">اولویت</th>
                        <th class="text-end py-3 px-4">عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="task-row-<?php echo e($task->status); ?>">
                            <td class="px-4">
                                <a href="<?php echo e(route('admin.project.task.show', [$projectId, $task->id])); ?>" class="fw-bold text-dark-primary text-decoration-none hover-text-action">
                                    <?php echo e($task->title); ?>

                                </a>
                                <div class="badge bg-secondary-soft text-secondary small mt-1">#<?php echo e($task->id); ?> - <?php echo e(Str::title($task->type)); ?></div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="avatar-sm"><?php echo e($task->assignedUser->name[0] ?? '-'); ?></span>
                                    <span class="small text-dark-primary"><?php echo e($task->assignedUser->name ?? '-'); ?></span>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark">
                                    <?php echo e($task->due_date ? jdate($task->due_date)->format('Y/m/d') : '-'); ?>

                                </span>
                            </td>
                            <td>
                                <div class="progress-bar-stack" style="--progress: <?php echo e($task->progress_percent); ?>%">
                                    <div class="progress-bar-fill"></div>
                                    <span class="progress-bar-text"><?php echo e($task->progress_percent); ?>%</span>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-<?php echo e($task->status); ?>">
                                    <i class="ti ti-circle-filled small me-1"></i> <?php echo e($task->status_label); ?>

                                </span>
                            </td>
                            <td>
                                <span class="badge bg-priority-<?php echo e($task->priority); ?>">
                                    <i class="ti ti-flag"></i> <?php echo e($labels['priorities'][$task->priority] ?? Str::title($task->priority)); ?>

                                </span>
                            </td>
                            <td class="text-end px-4">
                                <div class="btn-group">
                                    <a href="<?php echo e(route('admin.project.task.edit', [$projectId, $task->id])); ?>" class="btn btn-light btn-sm" title="ویرایش"><i class="ti ti-edit"></i></a>
                                    <a href="<?php echo e(route('admin.project.task.show', [$projectId, $task->id])); ?>" class="btn btn-outline-secondary btn-sm" title="مشاهده"><i class="ti ti-eye"></i></a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="7" class="text-center text-muted py-4">تسکی مطابق با فیلترها وجود ندارد.</td></tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="card-footer bg-white border-top d-flex justify-content-center py-3"><?php echo e($tasks->links()); ?></div>
        </div>

    <?php else: ?>
        <div class="row row-cols-1 row-cols-md-3 g-4">
            <?php $__empty_1 = true; $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col">
                    <div class="card shadow-lg-sm rounded-4 h-100 card-glow-hover task-card-<?php echo e($task->priority); ?>">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h6 class="fw-bold text-dark-primary mb-0 hover-text-action">
                                    <a href="<?php echo e(route('admin.project.task.show', [$projectId, $task->id])); ?>" class="text-dark-primary text-decoration-none"><?php echo e($task->title); ?></a>
                                </h6>
                                <span class="badge bg-<?php echo e($task->status); ?>">
                                    <?php echo e($task->status_label); ?>

                                </span>
                            </div>

                            <div class="small text-secondary-light mb-3">
                                <i class="ti ti-calendar me-1"></i> مهلت: <?php echo e($task->due_date ? jdate($task->due_date)->format('Y/m/d') : '-'); ?>

                            </div>

                            <div class="progress-bar-stack" style="--progress: <?php echo e($task->progress_percent); ?>%">
                                <div class="progress-bar-fill"></div>
                                <span class="progress-bar-text"><?php echo e($task->progress_percent); ?>% تکمیل</span>
                            </div>

                            <div class="d-flex justify-content-between align-items-center mt-3 border-top pt-3">
                                <div class="d-flex align-items-center gap-2">
                                    <span class="avatar-sm"><?php echo e($task->assignedUser->name[0] ?? '-'); ?></span>
                                    <span class="small text-dark-primary"><?php echo e($task->assignedUser->name ?? '-'); ?></span>
                                </div>
                                <div class="btn-group">
                                    <a href="<?php echo e(route('admin.project.task.edit', [$projectId, $task->id])); ?>" class="btn btn-soft-secondary btn-sm" title="ویرایش"><i class="ti ti-edit"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12 text-center py-5 empty-state-box">
                    <div class="fw-bold mb-2 fs-5 text-secondary-light">تسکی مطابق با فیلترها وجود ندارد.</div>
                    <a href="<?php echo e(route('admin.project.task.create', ['project' => $projectId])); ?>" class="btn btn-info rounded-pill px-4 mt-2">ایجاد اولین تسک</a>
                </div>
            <?php endif; ?>
        </div>
        <div class="my-3 d-flex justify-content-center"><?php echo e($tasks->links()); ?></div>
    <?php endif; ?>

    <style>
        /* --- Modern Task Dashboard Variables --- */
        :root {
            --dark-primary: #2C3E50; /* Deep Blue-Gray for main titles and table header */
            --action-primary: #7C5DFA; /* Vibrant Purple for main actions, links, progress */
            --primary-rgb: 124, 93, 250; /* RGB for shadow effects */
            --secondary-light: #6B7280; /* Muted Gray for secondary text */
            --border-color: #E0E7EB; /* Light Gray for subtle borders */
            --body-bg: #F8FAFC; /* Overall page background */
            --gray-light: #F1F5F9; /* Very light gray for filter background */
            --hover-color: #F0F3FF; /* Light lavender for row/card hover */

            /* Status/Priority Colors */
            --success-color: #10B981;
            --warning-color: #F59E0B;
            --danger-color: #EF4444;
            --info-color: #03A9F4;
            --secondary-color: #6B7280;

            --primary-light: #E0F2FF; /* Light blue for 'New' status */
            --warning-soft: #FFFBEB; /* Very light yellow for 'In Progress' */
            --success-soft: #ECFDF5; /* Very light green for 'Done' */
            --danger-soft: #FCECEB; /* Very light red for 'On Hold' */
            --info-soft: #EBF8FF; /* Very light blue for 'Normal' priority */
        }

        /* --- Base Aesthetics --- */
        .text-dark-primary { color: var(--dark-primary) !important; }
        .text-secondary-light { color: var(--secondary-light) !important; }
        .text-action-primary { color: var(--action-primary) !important; }
        .bg-gray-light { background-color: var(--gray-light) !important; }
        .hover-text-action:hover { color: var(--action-primary) !important; }

        /* --- General Styling --- */
        .card { border: 1px solid var(--border-color) !important; transition: all .2s ease; }
        .rounded-4 { border-radius: 1.13rem !important; }
        .shadow-lg-md { box-shadow: 0 6px 15px rgba(0,0,0,0.08) !important; }
        .animate-hover { transition: all .2s ease; }
        .animate-hover:hover { transform: translateY(-1px); }
        .btn-action-primary { background-color: var(--action-primary); border-color: var(--action-primary); color: white; }
        .btn-action-primary:hover { background-color: #3A0CA3; border-color: #3A0CA3; }
        .btn-soft-secondary { background-color: var(--gray-light); color: var(--secondary-light); border: none; }
        .btn-soft-secondary:hover { background-color: var(--border-color); }
        .task-select { border-radius: 50rem !important; height: 38px; }

        /* --- Avatar --- */
        .avatar-sm {
            width: 32px;
            height: 32px;
            font-size: 0.9em;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background-color: var(--primary-light);
            color: var(--action-primary);
            font-weight: bold;
            flex-shrink: 0;
        }

        /* --- Card Glow Hover (Kanban) --- */
        .card-glow-hover:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 20px rgba(var(--primary-rgb), 0.15) !important;
            border-color: var(--action-primary) !important;
        }
        /* Card Border based on Priority */
        .task-card-critical { border-left: 5px solid var(--danger-color) !important; }
        .task-card-high { border-left: 5px solid var(--danger-color) !important; }
        .task-card-normal { border-left: 5px solid var(--info-color) !important; }
        .task-card-low { border-left: 5px solid var(--success-color) !important; }

        /* --- Table Styles --- */
        .task-table-modern thead { background-color: var(--dark-primary); }
        .task-table-modern th { color: white; border: none !important; }
        .table-hover-row { border-bottom: 1px solid var(--border-color); }
        .table-hover-row:hover { background-color: var(--hover-color) !important; }
        .task-row-done { background-color: var(--success-soft) !important; }

        /* --- Status/Priority Badges --- */
        .badge { font-weight: 600 !important; padding: 0.5em 0.8em; border-radius: 9999px; }

        .badge.bg-new { background-color: var(--primary-light) !important; color: var(--action-primary) !important; }
        .badge.bg-in_progress { background-color: var(--warning-soft) !important; color: var(--warning-color) !important; }
        .badge.bg-done { background-color: var(--success-soft) !important; color: var(--success-color) !important; }
        .badge.bg-on_hold { background-color: var(--danger-soft) !important; color: var(--danger-color) !important; }

        .badge.bg-priority-low { background-color: var(--secondary-soft) !important; color: var(--secondary-color) !important; }
        .badge.bg-priority-normal { background-color: var(--info-soft) !important; color: var(--info-color) !important; }
        .badge.bg-priority-high { background-color: var(--danger-soft) !important; color: var(--danger-color) !important; }
        .badge.bg-priority-critical { background-color: var(--dark-primary) !important; color: white !important; }

        /* --- Progress Bar Stack --- */
        .progress-bar-stack {
            position: relative;
            height: 18px;
            background-color: var(--border-color);
            border-radius: 9px;
            overflow: hidden;
            margin: 5px 0;
        }
        .progress-bar-fill {
            height: 100%;
            width: var(--progress);
            transition: width 0.4s ease;
            background-color: var(--action-primary); /* Default color */
        }
        .progress-bar-stack[style*="--progress: 100%"] .progress-bar-fill {
            background-color: var(--success-color); /* Success color for 100% */
        }
        .progress-bar-text {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 11px;
            font-weight: 600;
            color: var(--dark-primary);
            z-index: 10;
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\task\list-tasks.blade.php ENDPATH**/ ?>