<div wire:ignore.self class="modal fade" id="editFileModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-2xl rounded-5 overflow-hidden backdrop-blur-xl bg-white bg-opacity-95">
            <form wire:submit.prevent="updateFile">
                <div class="modal-header bg-gradient-to-r from-slate-900 to-slate-800 text-white p-4 border-0">
                    <div class="d-flex align-items-center">
                        <div class="p-2 bg-info bg-opacity-20 rounded-3 me-3">
                            <i class="ti ti-edit-circle fs-3 text-info"></i>
                        </div>
                        <div>
                            <h5 class="modal-title fw-black mb-0">ویرایش مستند فنی</h5>
                            <small class="opacity-50 fw-bold small">DOCUMENT METADATA EDIT</small>
                        </div>
                    </div>
                    <button type="button" class="btn-close btn-close-white shadow-none" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body p-4">
                    <div class="mb-4">
                        <label class="form-label small fw-black text-muted text-uppercase tracking-widest">Document Name / کد شناسایی</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light border-0 rounded-start-4"><i class="ti ti-hash text-primary"></i></span>
                            <input type="text" wire:model.defer="editedFileName" class="form-control glass-input border-0 bg-light shadow-none rounded-end-4 <?php $__errorArgs = ['editedFileName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="نام یا کد رسمی سند...">
                        </div>
                        <?php $__errorArgs = ['editedFileName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback fw-bold mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-4">
                        <label class="form-label small fw-black text-muted text-uppercase tracking-widest">Classification Tags / تگ‌ها</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light border-0 rounded-start-4"><i class="ti ti-tags text-primary"></i></span>
                            <input type="text" wire:model.defer="editedTags" class="form-control glass-input border-0 bg-light shadow-none rounded-end-4" placeholder="مثلاً: معماری، تایید شده، نهایی">
                        </div>
                        <div class="form-text small opacity-60 mt-2 px-2"><i class="ti ti-info-circle me-1"></i>تگ‌ها را با کاما (,) از هم جدا کنید.</div>
                    </div>

                    <div class="mb-0">
                        <label class="form-label small fw-black text-muted text-uppercase tracking-widest">Engineering Notes / ملاحظات فنی</label>
                        <textarea wire:model.defer="editedDescription" class="form-control glass-input border-0 bg-light shadow-none rounded-4" rows="4" placeholder="جزئیات تغییرات، ورژن‌بندی یا یادداشتهای مدیر پروژه..."></textarea>
                    </div>
                </div>

                <div class="modal-footer border-0 p-4 pt-0">
                    <button type="button" class="btn btn-light rounded-pill px-4 fw-bold flex-grow-1 border" data-bs-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-prime px-5 flex-grow-1 shadow-lg">
                        <span wire:loading.remove wire:target="updateFile"><i class="ti ti-device-floppy me-2"></i>ذخیره نهایی</span>
                        <span wire:loading wire:target="updateFile" class="spinner-border spinner-border-sm"></span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div wire:ignore.self class="modal fade" id="historyModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow-2xl rounded-5 overflow-hidden backdrop-blur-xl bg-white bg-opacity-95">
            <div class="modal-header bg-white p-4 border-bottom d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <div class="p-2 bg-primary bg-opacity-10 rounded-3 me-3">
                        <i class="ti ti-history fs-3 text-primary"></i>
                    </div>
                    <div>
                        <h5 class="modal-title fw-black mb-0">تالار ممیزی و تاریخچه فعالیت</h5>
                        <small class="opacity-50 fw-bold small">DOCUMENT AUDIT TRAIL</small>
                    </div>
                </div>
                <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body p-0" style="max-height: 70vh; overflow-y: auto;">
                <?php if($historyFile): ?>
                    <div class="p-4 bg-light bg-opacity-50 border-bottom sticky-top backdrop-blur-md">
                        <div class="d-flex align-items-center">
                            <div class="file-icon-lux bg-white shadow-sm me-3 mb-0" style="width: 55px; height: 55px;">
                                <i class="ti <?php echo e($this->getFileIcon($historyFile->type)); ?> fs-2 text-primary"></i>
                            </div>
                            <div>
                                <h6 class="fw-black text-dark mb-1"><?php echo e($historyFile->name); ?></h6>
                                <div class="d-flex gap-2">
                                    <span class="badge bg-white text-muted border px-2 py-1 rounded-2 fw-bold" style="font-size: 0.6rem;">ID: #<?php echo e($historyFile->id); ?></span>
                                    <span class="badge bg-primary bg-opacity-10 text-primary border border-primary border-opacity-20 px-2 py-1 rounded-2 fw-bold" style="font-size: 0.6rem;"><?php echo e(strtoupper(Str::afterLast($historyFile->type, '/'))); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="p-5">
                        <div class="timeline-dcc">
                            <?php $__empty_1 = true; $__currentLoopData = $fileHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $act): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="timeline-item d-flex gap-4 mb-5 position-relative">
                                    <div class="timeline-line"></div>
                                    <div class="timeline-indicator bg-white border-3 border-primary shadow-md"></div>
                                    <div class="flex-grow-1">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <span class="badge bg-slate-900 text-white rounded-pill px-3 py-1 fw-bold small" style="font-size: 0.65rem;">
                                                <i class="ti ti-point-filled me-1 text-info"></i> <?php echo e($act['action']); ?>

                                            </span>
                                            <small class="text-muted fw-bold"><i class="ti ti-clock-hour-4 me-1 text-primary"></i> <?php echo e($act['date']); ?></small>
                                        </div>
                                        <div class="card border-0 bg-white shadow-sm rounded-4 p-3 border-start border-4 border-primary">
                                            <div class="text-dark small fw-bold mb-3 opacity-80"><?php echo e($act['details']); ?></div>
                                            <div class="d-flex align-items-center pt-2 border-top border-light">
                                                <div class="bg-primary text-white rounded-circle me-2 d-flex align-items-center justify-content-center fw-bold" style="width: 25px; height: 25px; font-size: 0.6rem;"><?php echo e(Str::limit($act['user'], 1, '')); ?></div>
                                                <div class="small fw-black text-muted">توسط کارشناس: <span class="text-primary"><?php echo e($act['user']); ?></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="text-center py-5 opacity-40">
                                    <i class="ti ti-database-x display-1 mb-3"></i>
                                    <h5 class="fw-black">دیتایی برای نمایش وجود ندارد</h5>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary mb-3" style="width: 3rem; height: 3rem;" role="status"></div>
                        <p class="text-muted fw-bold animate__animated animate__pulse animate__infinite">در حال واکشی اطلاعات از دیتابیس مرکزی...</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div wire:ignore.self class="modal fade" id="moveModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-2xl rounded-5 overflow-hidden">
            <div class="modal-header bg-info text-white p-4 border-0">
                <h5 class="modal-title fw-black d-flex align-items-center">
                    <i class="ti ti-folder-share me-2 fs-3"></i> جابجایی مستندات
                </h5>
                <button type="button" class="btn-close btn-close-white shadow-none" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-4 bg-light">
                <div class="alert bg-white border-start border-4 border-info rounded-4 shadow-sm mb-4">
                    <div class="small fw-black text-info mb-1 uppercase">Target Destination</div>
                    <div class="small text-muted fw-bold">لطفاً پوشه مقصد را برای انتقال فایل‌های انتخاب شده تعیین کنید.</div>
                </div>

                <div class="list-group rounded-4 border-0 shadow-sm overflow-hidden">
                    <button wire:click="backToRoot(); moveItems()" class="list-group-item list-group-item-action p-3 fw-bold border-0 border-bottom">
                        <i class="ti ti-home-2 me-2 text-primary"></i> انتقال به ریشه اصلی (Root)
                    </button>
                    <?php $__currentLoopData = $allFolders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $folder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button wire:click="$set('targetFolderId', <?php echo e($folder->id); ?>); moveItems()" class="list-group-item list-group-item-action p-3 fw-bold border-0 border-bottom">
                            <i class="ti ti-folder-filled me-2 text-warning"></i> <?php echo e($folder->name); ?>

                        </button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div wire:ignore.self class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content border-0 shadow-2xl rounded-5 overflow-hidden backdrop-blur-xl bg-white bg-opacity-95">
            <div class="modal-body p-5 text-center">
                <div class="mb-4 text-danger position-relative d-inline-block">
                    <i class="ti ti-alert-triangle-filled display-1 opacity-20"></i>
                    <i class="ti ti-trash-x-filled position-absolute top-50 start-50 translate-middle fs-1"></i>
                </div>
                <h5 class="fw-black text-dark mb-3">حذف سیستمی مستند</h5>
                <p class="text-muted small mb-5 px-2 fw-medium">آیا از حذف دائمی این رکورد و فایل فیزیکی آن از سرور واحد DCC اطمینان دارید؟</p>

                <div class="d-flex gap-3">
                    <button type="button" class="btn btn-light rounded-pill px-4 fw-bold flex-grow-1 border" data-bs-dismiss="modal">لغو</button>
                    <button wire:click="deleteSelectedFiles" class="btn btn-danger rounded-pill px-4 fw-black flex-grow-1 shadow-danger py-2">تأیید حذف نهایی</button>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* 🛠️ Engineering UI Kits */
    .timeline-dcc { position: relative; padding-right: 2rem; }
    .timeline-line {
        position: absolute; right: 0.65rem; top: 0.5rem; bottom: -1.5rem;
        width: 3px; background: linear-gradient(to bottom, var(--p-indigo), #f1f5f9);
        border-radius: 10px;
    }
    .timeline-item:last-child .timeline-line { display: none; }
    .timeline-indicator {
        width: 22px; height: 22px; border-radius: 50%;
        position: relative; z-index: 2; margin-top: 5px;
        background: white !important;
    }
    .glass-input:focus {
        background: #fff !important;
        box-shadow: 0 0 0 5px rgba(67, 97, 238, 0.1) !important;
        border-color: var(--p-indigo) !important;
    }
    .hover-scale { transition: 0.3s; }
    .hover-scale:hover { transform: scale(1.1); }
    .backdrop-blur-md { backdrop-filter: blur(8px); }
</style><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\sections\section-files.blade.php ENDPATH**/ ?>