
<?php
    $isCurrentUser = $comment->user_id === Auth::id();

    // --- رنگ‌ها و استایل‌ها ---
    $bubbleColor = $isCurrentUser ? 'var(--primary-50)' : 'var(--gray-100)';
    $shadowColor = $isCurrentUser ? 'rgba(82, 99, 255, 0.2)' : 'rgba(0, 0, 0, 0.05)';
    $bubbleShadow = "0 2px 5px {$shadowColor}";

    // --- تنظیمات پاسخ‌ها و فواصل ---
    // اگر پاسخ است، پس‌زمینه سفیدتر و حاشیه چپ ظریف برای عمق‌دهی
    $effectiveBubbleColor = $isReply ? 'var(--card-bg)' : $bubbleColor;

    // کلاس‌های مارجین: mt-4 برای سطح اول، mt-2 برای پاسخ‌ها
    $wrapperClass = $isReply ? 'mt-2' : 'mt-4';

    $avatarSize = $isReply ? '28px' : '36px';
    $contentLineHeight = '1.5';

    // جهت‌دهی
    $mainFlex = $isCurrentUser ? 'd-flex flex-row-reverse' : 'd-flex';
    $avatarMargin = $isCurrentUser ? 'ms-3' : 'me-3';
    // حذف bubbleClass: از flex-grow-1 در کانتینر استفاده می‌کنیم تا جایگذاری بهتر شود.
?>

<style>
    /* --------------------------------------
       استایل‌های نهایی مینیمال و منظم
    ----------------------------------------- */
    .comment-avatar-ring.current-user {
        padding: 1px;
        border: 2px solid var(--primary);
        border-radius: 50%;
        background-color: white;
    }
    .comment-avatar-ring img {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        object-fit: cover;
    }
    .comment-bubble {
        transition: all 0.2s ease-in-out;
        border-radius: 12px;
        position: relative;
        /* عرض بر اساس محتوا */
        max-width: 90%;
        width: fit-content;
    }
    .comment-user-info {
        padding-bottom: 0;
        font-weight: 600;
        margin-bottom: 0 !important;
    }
    /* کنترل فاصله پاسخ‌ها و عمق‌دهی */
    .nested-reply-wrapper {
        /* FIX: ایجاد عمق‌دهی بصری با خط عمودی برای پاسخ‌ها */
        border-left: 2px solid var(--gray-200);
        padding-left: 10px;
        margin-left: 15px;
    }
    /* کنترل فاصله عمودی بین پیام‌ها در حالت بازگشتی */
    .nested-reply-wrapper > div {
        margin-top: 8px !important;
    }
</style>


<div class="<?php echo e($mainFlex); ?> <?php echo e($wrapperClass); ?> align-items-start" id="comment-<?php echo e($comment->id); ?>">

    
    <div class="flex-shrink-0 <?php echo e($avatarMargin); ?>" style="width: <?php echo e($avatarSize); ?>; height: <?php echo e($avatarSize); ?>;">
        <div class="comment-avatar-ring <?php echo e($isCurrentUser ? 'current-user' : ''); ?>" style="width: 100%; height: 100%;">
            <img src="<?php echo e($this->getUserProfilePhotoUrl($comment->user)); ?>"
                 alt="<?php echo e($comment->user->name ?? 'کاربر'); ?>"
                 style="width: 100%; height: 100%;">
        </div>
    </div>

    
    <div class="d-flex flex-column" style="max-width: 90%; <?php echo e($isCurrentUser ? 'margin-left: auto;' : 'margin-right: auto;'); ?>">

        <div class="comment-bubble p-3"
             style="background: <?php echo e($effectiveBubbleColor); ?>;
                    box-shadow: <?php echo e($bubbleShadow); ?>;
                    border: 1px solid var(--border-color);
                    border-radius: 12px;
                    /* تنظیم شکل گوشه برای شبیه سازی پیام رسان ها */
                    border-top-left-radius: <?php echo e($isCurrentUser ? '12px' : '4px'); ?>;
                    border-top-right-radius: <?php echo e($isCurrentUser ? '4px' : '12px'); ?>;
                    ">

            
            <div class="comment-user-info d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <span style="color: <?php echo e($isCurrentUser ? 'var(--primary-700)' : 'var(--gray-900)'); ?>; font-size: 0.9rem;">
                        <?php echo e($comment->user->name ?? 'کاربر ناشناس'); ?>

                        <?php if($isCurrentUser): ?> <small class="text-primary fw-normal ms-1">(شما)</small> <?php endif; ?>
                    </span>
                </div>

                <div class="dropdown ms-2">
                    <button class="btn btn-sm text-muted p-0" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-xs"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end shadow-sm border-0 rounded-3">
                        <li><a class="dropdown-item small" wire:click.prevent="replyTo(<?php echo e($comment->id); ?>)"><i class="fas fa-reply me-1 text-info"></i> پاسخ دادن</a></li>
                        <?php if($isCurrentUser): ?>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item small text-danger" wire:click.prevent="deleteComment(<?php echo e($comment->id); ?>)"><i class="fas fa-trash-alt me-1"></i> حذف پیام</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>

            <div class="comment-body pt-1" style="line-height: <?php echo e($contentLineHeight); ?>; color: var(--gray-900); font-size: 0.95rem;">
                <?php echo e($comment->body); ?>

            </div>

            
            <div class="text-muted small mt-1 <?php echo e($isCurrentUser ? 'text-start' : 'text-end'); ?>" style="font-size: 0.7rem;">
                <?php echo e($this->formatShamsiDate($comment->created_at, 'H:i | Y/m/d')); ?>

            </div>

        </div>

        
        <?php if($replyParentId === $comment->id): ?>
            <div class="p-2 bg-white border border-primary rounded-4 mt-2 shadow-sm" style="max-width: 90%; <?php echo e($isCurrentUser ? 'margin-left: auto;' : ''); ?>">
                <small class="fw-bold text-primary d-block mb-1">در حال پاسخ به <?php echo e($comment->user->name); ?></small>
            </div>
        <?php endif; ?>

        
        <?php if($comment->replies->isNotEmpty()): ?>
            <div class="nested-reply-wrapper w-100">
                <?php $__currentLoopData = $comment->replies->sortBy('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo $__env->make('livewire.admin.letter.partials.comment-styled', [
                        'comment' => $reply,
                        'replyParentId' => $replyParentId,
                        'isReply' => true,
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\partials\comment-styled.blade.php ENDPATH**/ ?>