<div wire:ignore.self class="modal fade" id="editFileModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg" style="border-radius: 20px; overflow: hidden;">
            <form wire:submit.prevent="updateFile">
                <div class="modal-header bg-dark text-white border-0 py-3 px-4">
                    <h6 class="modal-title fw-black d-flex align-items-center">
                        <i class="ti ti-edit-circle me-2 fs-4 text-info"></i>
                        ویرایش اطلاعات فنی سند
                    </h6>
                    <button type="button" class="btn-close btn-close-white shadow-none" data-bs-dismiss="modal" wire:click="resetForms"></button>
                </div>

                <div class="modal-body p-4">
                    <div class="mb-4">
                        <label class="form-label small fw-black text-muted text-uppercase tracking-wider">Document Name / نام سند</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light border-end-0 rounded-start-3"><i class="ti ti-file-description"></i></span>
                            <input type="text" wire:model.defer="editedFileName" class="form-control dcc-input border-start-0 rounded-end-3 shadow-none <?php $__errorArgs = ['editedFileName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="مثلاً: نقشه فونداسیون - تیپ A">
                        </div>
                        <?php $__errorArgs = ['editedFileName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1 fw-bold"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-4">
                        <label class="form-label small fw-black text-muted text-uppercase tracking-wider">Tags / کلمات کلیدی</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light border-end-0 rounded-start-3"><i class="ti ti-tags"></i></span>
                            <input type="text" wire:model.defer="editedTags" class="form-control dcc-input border-start-0 rounded-end-3 shadow-none" placeholder="با کاما جدا کنید (مثل: نقشه, معماری, نهایی)">
                        </div>
                        <div class="form-text small opacity-50">تگ‌ها به جستجوی سریع‌تر در آرشیو کمک می‌کنند.</div>
                    </div>

                    <div class="mb-0">
                        <label class="form-label small fw-black text-muted text-uppercase tracking-wider">Description / توضیحات تکمیلی</label>
                        <textarea wire:model.defer="editedDescription" class="form-control dcc-input rounded-3 shadow-none" rows="4" placeholder="جزئیات تغییرات یا توضیحات مهندسی..."></textarea>
                    </div>
                </div>

                <div class="modal-footer bg-light border-0 py-3 px-4 d-flex justify-content-between">
                    <button type="button" class="btn btn-outline-secondary rounded-pill px-4 fw-bold small" data-bs-dismiss="modal" wire:click="resetForms">انصراف</button>
                    <button type="submit" class="btn btn-dcc-primary shadow-sm px-4 py-2">
                        <span wire:loading.remove wire:target="updateFile"><i class="ti ti-device-floppy me-1"></i> بروزرسانی نهایی</span>
                        <span wire:loading wire:target="updateFile" class="spinner-border spinner-border-sm"></span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div wire:ignore.self class="modal fade" id="historyModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg" style="border-radius: 20px; overflow: hidden;">
            <div class="modal-header border-0 bg-light py-3 px-4 border-bottom">
                <h6 class="modal-title fw-black d-flex align-items-center text-dark">
                    <i class="ti ti-history me-2 fs-4 text-primary"></i>
                    تاریخچه تغییرات و دسترسی‌های سند
                </h6>
                <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body p-4 bg-white" style="max-height: 70vh; overflow-y: auto;">
                <?php if($historyFile): ?>
                    <div class="d-flex align-items-center mb-4 p-3 bg-light rounded-4 border">
                        <div class="file-icon-box bg-white shadow-sm me-3">
                            <i class="ti <?php echo e($this->getFileIcon($historyFile->type)); ?> fs-3 text-primary"></i>
                        </div>
                        <div>
                            <div class="fw-black text-dark fs-5"><?php echo e($historyFile->name); ?></div>
                            <div class="small text-muted">ID: <?php echo e($historyFile->id); ?> | Type: <?php echo e(strtoupper(Str::afterLast($historyFile->type, '/'))); ?></div>
                        </div>
                    </div>

                    <div class="timeline-dcc">
                        <?php $__currentLoopData = $fileHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $act): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="timeline-item d-flex gap-3 mb-4 position-relative">
                                <div class="timeline-line"></div>
                                <div class="timeline-dot bg-primary shadow-primary"></div>
                                <div class="flex-grow-1 card border-0 bg-light bg-opacity-50 rounded-4 p-3 border border-white">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <span class="badge bg-white text-primary border rounded-pill px-3 py-1 fw-black small"><?php echo e($act['action']); ?></span>
                                        <small class="text-muted fw-bold small"><i class="ti ti-clock me-1"></i> <?php echo e($act['date']); ?></small>
                                    </div>
                                    <p class="small text-dark mb-2 fw-medium"><?php echo e($act['details']); ?></p>
                                    <div class="small fw-black text-muted d-flex align-items-center">
                                        <i class="ti ti-user-circle me-1 fs-5"></i>
                                        توسط: <span class="text-primary ms-1"><?php echo e($act['user']); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary mb-3" role="status"></div>
                        <p class="text-muted fw-bold">در حال بازیابی تاریخچه از پایگاه داده...</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div wire:ignore.self class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content border-0 shadow-2xl rounded-4 overflow-hidden">
            <div class="modal-body p-4 text-center">
                <div class="mb-3 text-danger">
                    <i class="ti ti-alert-triangle-filled display-1"></i>
                </div>
                <h5 class="fw-black text-dark mb-2">تأیید حذف سیستمی</h5>
                <p class="text-muted small mb-4 px-3">آیا از حذف دائمی این سند اطمینان دارید؟ این عملیات در واحد DCC غیرقابل بازگشت است.</p>

                <div class="d-flex gap-2 justify-content-center">
                    <button type="button" class="btn btn-light rounded-pill px-4 fw-bold small flex-grow-1" data-bs-dismiss="modal">لغو</button>
                    <button wire:click="deleteSelectedFiles" class="btn btn-danger rounded-pill px-4 fw-black flex-grow-1 shadow-danger">حذف قطعی</button>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* 📈 Timeline Engineering Styles */
    .timeline-dcc { padding-right: 15px; }
    .timeline-item { position: relative; }
    .timeline-line {
        position: absolute; right: 6px; top: 15px; bottom: -30px;
        width: 2px; background: #e2e8f0; z-index: 1;
    }
    .timeline-item:last-child .timeline-line { display: none; }
    .timeline-dot {
        width: 14px; height: 14px; border-radius: 50%;
        background: var(--dcc-accent); z-index: 2; margin-top: 5px;
        border: 3px solid #fff;
    }
    .shadow-primary { box-shadow: 0 0 10px rgba(59, 130, 246, 0.4); }
    .btn-xs { padding: 0.25rem 0.5rem; font-size: 0.7rem; border-radius: 5px; }
    .scrollbar-thin::-webkit-scrollbar { width: 4px; }
    .scrollbar-thin::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
</style><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\sections\modals\file-modals.blade.php ENDPATH**/ ?>