<div class="container-fluid py-4">
    <style>
        :root {
            /* MODERN CLEAN PALETTE */
            --primary: #3b82f6; /* Blue-500 */
            --primary-dark: #1e40af; /* Blue-800 */
            --accent: #10b981; /* Green for success/callouts */
            --bg-light: #f9fafb;
            --card-bg: #ffffff;
            --border-color: #e5e7eb;
            --text-dark: #1f2937;
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
        }

        /* Base styles */
        .modern-card {
            border-radius: 1rem !important;
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
        }

        .modern-card .card-header {
            background-color: var(--primary);
            border-top-left-radius: 0.9rem !important;
            border-top-right-radius: 0.9rem !important;
            padding: 1.25rem;
        }

        /* Input/Form styling */
        .form-control-lg, .form-select-lg {
            border-radius: 0.65rem;
            padding: 0.75rem 1.25rem;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.25);
        }

        /* Attachment list */
        .file-preview-item {
            border-radius: 0.5rem;
            margin-bottom: 0.5rem;
            background-color: var(--bg-light);
            border: 1px solid var(--border-color);
            transition: all 0.2s;
        }
        .file-preview-item:hover {
            background-color: #eef2ff;
        }

        /* Target selection buttons */
        .target-button {
            border-radius: 9999px;
            font-weight: 600;
            transition: all 0.2s;
        }

        /* Custom user list */
        .user-list-group-item {
            transition: background-color 0.1s;
        }
        .user-list-group-item:hover {
            background-color: var(--primary-50);
        }

        /* Status bar for custom users */
        .selected-users-summary {
            background-color: #e0f7fa; /* Light cyan */
            color: #00838f;
            font-weight: 600;
            border-radius: 0.75rem;
            padding: 0.75rem 1rem;
            border: 1px solid #b2ebf2;
        }
    </style>

    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">

            
            <?php if(session()->has('success') || session()->has('error')): ?>
                <div class="alert alert-<?php echo e(session()->has('success') ? 'success' : 'danger'); ?> d-flex align-items-center justify-content-between rounded-3 shadow-sm mb-4">
                    <div>
                        <i class="ti ti-<?php echo e(session()->has('success') ? 'check-circle' : 'alert-triangle'); ?> me-2"></i>
                        <?php echo e(session('success') ?? session('error')); ?>

                    </div>
                    <button class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="card modern-card">
                <div class="card-header text-white">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center gap-2">
                            <i class="ti ti-bell-filled fs-4"></i>
                            <h5 class="mb-0 fw-bold">ارسال اطلاعیه جدید</h5>
                        </div>
                        <span class="small opacity-75">سیستم اطلاعیه را به پنل و ایمیل مخاطبان ارسال می‌کند</span>
                    </div>
                </div>

                <div class="card-body p-4 p-md-5">
                    <form wire:submit.prevent="sendAnnouncement" enctype="multipart/form-data" novalidate>

                        
                        <h6 class="fw-bold mb-3 text-primary"><i class="ti ti-file-text me-2"></i> محتوا و عنوان</h6>
                        <hr class="mt-0 mb-4">

                        
                        <div class="mb-4">
                            <label class="form-label fw-bold">عنوان <span class="text-danger">*</span></label>
                            <input type="text" class="form-control form-control-lg <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   wire:model.defer="title" maxlength="255" placeholder="عنوان جذاب و مختصر برای اطلاعیه...">
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="mb-4">
                            <label class="form-label fw-bold">متن اطلاعیه <span class="text-danger">*</span></label>
                            <textarea class="form-control <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="8"
                                      wire:model.defer="content" placeholder="شامل جزئیات، زمان، مکان و نکات مهم..."></textarea>
                            <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="mb-5">
                            <label class="form-label fw-bold d-flex align-items-center gap-2">
                                <i class="ti ti-paperclip"></i> فایل‌های پیوست (اختیاری)
                                <span class="badge text-bg-secondary fw-normal">حداکثر ۱۰ فایل، ۱۰MB</span>
                            </label>
                            <input type="file"
                                   class="form-control <?php $__errorArgs = ['files'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php $__errorArgs = ['files.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   wire:model="files" multiple
                                   accept=".pdf,.doc,.docx,.xls,.xlsx,.jpg,.jpeg,.png,.zip,.webp">

                            <div class="form-text mt-2">
                                <i class="ti ti-info-circle me-1"></i> فرمت‌های مجاز: PDF, DOC(X), XLS(X), JPG/PNG, ZIP, WEBP
                            </div>

                            <div class="small mt-2" wire:loading wire:target="files">
                                <i class="ti ti-loader animate-spin me-1"></i> **در حال بارگذاری فایل‌ها...**
                            </div>

                            <?php $__errorArgs = ['files'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <?php $__errorArgs = ['files.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <?php if(!empty($filePreviews)): ?>
                                <div class="mt-3">
                                    <h6 class="fw-bold mb-2">فایل‌های آماده پیوست:</h6>
                                    <div class="row g-2">
                                        <?php $__currentLoopData = $filePreviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $fp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-12 col-md-6" wire:key="fp-<?php echo e($i); ?>">
                                                <div class="file-preview-item p-3 d-flex align-items-center justify-content-between">
                                                    <div class="d-flex align-items-center gap-3 overflow-hidden">
                                                        <?php if($fp['is_image']): ?>
                                                            <img src="<?php echo e($fp['url']); ?>" alt="preview" class="rounded flex-shrink-0" style="width:40px;height:40px;object-fit:cover">
                                                        <?php else: ?>
                                                            <i class="ti ti-file-text fs-4 text-primary flex-shrink-0"></i>
                                                        <?php endif; ?>
                                                        <div class="text-truncate">
                                                            <div class="fw-medium text-truncate"><?php echo e($fp['name']); ?></div>
                                                            <small class="text-muted"><?php echo e($fp['size_kb']); ?> KB</small>
                                                        </div>
                                                    </div>
                                                    <button type="button" class="btn btn-sm btn-outline-danger btn-icon-sm flex-shrink-0" wire:click="removeFile(<?php echo e($i); ?>)" title="حذف فایل">
                                                        <i class="ti ti-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                        
                        <h6 class="fw-bold mb-3 text-primary"><i class="ti ti-target-arrow me-2"></i> انتخاب مخاطبین</h6>
                        <hr class="mt-0 mb-4">

                        
                        <div class="mb-4">
                            <label class="form-label fw-bold">ارسال به <span class="text-danger">*</span></label>
                            <div class="d-flex flex-wrap gap-3">
                                <?php $__currentLoopData = [
                                    ['all','همه کاربران سیستم', 'ti-users'],
                                    ['company','یک شرکت خاص', 'ti-building'],
                                    ['department','یک دپارتمان خاص', 'ti-sitemap'],
                                    ['custom','انتخاب دستی کاربران', 'ti-user-plus']
                                ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as [$val,$label,$icon]): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button type="button"
                                            class="btn target-button <?php echo e($target_type===$val ? 'btn-primary shadow' : 'btn-outline-secondary'); ?> px-4"
                                            wire:click="$set('target_type','<?php echo e($val); ?>')">
                                        <i class="ti <?php echo e($icon); ?> me-2"></i> <?php echo e($label); ?>

                                    </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php $__errorArgs = ['target_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <?php if($target_type === 'company' || $target_type === 'department'): ?>
                            <div class="mb-4 border border-info rounded-4 p-4 bg-light">
                                <p class="fw-bold text-info"><i class="ti ti-filter me-2"></i> فیلتر شرکت/دپارتمان</p>
                                <div class="row g-3">

                                    
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">شرکت <span class="text-danger">*</span></label>
                                        <select class="form-select form-select-lg <?php $__errorArgs = ['company_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                wire:model.live.number="company_id">
                                            <option value="">انتخاب شرکت...</option>
                                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['company_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    
                                    <?php if($target_type === 'department'): ?>
                                        
                                        <div class="col-md-6" wire:key="dep-<?php echo e($depsVersion); ?>-<?php echo e((int)$company_id); ?>">
                                            <label class="form-label fw-medium">دپارتمان <span class="text-danger">*</span></label>

                                            <div wire:loading.class="opacity-50" wire:target="company_id">
                                                <select class="form-select form-select-lg <?php $__errorArgs = ['department_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        wire:model.number="department_id"
                                                    <?php echo e($company_id ? '' : 'disabled'); ?>>
                                                    <?php if(!$company_id): ?>
                                                        <option value="">ابتدا شرکت را انتخاب کنید</option>
                                                    <?php elseif(empty($departmentsOptions)): ?>
                                                        <option value="">دپارتمانی برای این شرکت یافت نشد</option>
                                                    <?php else: ?>
                                                        <option value="">انتخاب دپارتمان...</option>
                                                        <?php $__currentLoopData = $departmentsOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($dep['id']); ?>"><?php echo e($dep['name']); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>

                                            <?php $__errorArgs = ['department_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                        <?php endif; ?>

                        
                        <?php if($target_type === 'custom'): ?>
                            <div class="mb-4 border border-secondary rounded-4 p-4 bg-light">
                                <div class="d-flex flex-wrap gap-2 align-items-center justify-content-between mb-3">
                                    <div class="fw-bold text-dark"><i class="ti ti-list-check me-2"></i> انتخاب دستی کاربران</div>
                                    <div class="d-flex gap-2">
                                        <button type="button" class="btn btn-sm btn-outline-primary" wire:click="selectAllOnPage" wire:loading.attr="disabled">
                                            <i class="ti ti-list-details me-1"></i> انتخاب همه در این صفحه
                                        </button>
                                        <button type="button" class="btn btn-sm btn-outline-danger" wire:click="clearAllUsers" wire:loading.attr="disabled">
                                            <i class="ti ti-square-off me-1"></i> پاک کردن همه (<?php echo e(count($selected_users)); ?>)
                                        </button>
                                    </div>
                                </div>

                                
                                <div class="row g-3 mb-4">
                                    <div class="col-md-6">
                                        <input type="text" class="form-control"
                                               placeholder="جستجو با نام یا ایمیل..." wire:model.debounce.350ms="search_users">
                                    </div>
                                    <div class="col-md-6">
                                        <select class="form-select" wire:model.live.number="company_id">
                                            <option value="">فیلتر شرکت...</option>
                                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-6" wire:key="dep-filter-<?php echo e($depsVersion); ?>-<?php echo e((int)$company_id); ?>">
                                        <div wire:loading.class="opacity-50" wire:target="company_id">
                                            <select class="form-select" wire:model.live.number="department_id" <?php echo e($company_id ? '' : 'disabled'); ?>>
                                                <?php if(!$company_id): ?>
                                                    <option value="">فیلتر دپارتمان (شرکت را انتخاب کنید)</option>
                                                <?php elseif(empty($departmentsOptions)): ?>
                                                    <option value="">دپارتمانی برای این شرکت یافت نشد</option>
                                                <?php else: ?>
                                                    <option value="">فیلتر دپارتمان...</option>
                                                    <?php $__currentLoopData = $departmentsOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($dep['id']); ?>"><?php echo e($dep['name']); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <select class="form-select" wire:model.live="perPage">
                                            <option value="20">۲۰ کاربر در صفحه</option>
                                            <option value="50">۵۰ کاربر در صفحه</option>
                                        </select>
                                    </div>
                                </div>

                                <?php $paginated = $users; ?>

                                <div class="mb-3">
                                    <?php if(count($selected_users)): ?>
                                        <div class="selected-users-summary">
                                            <i class="ti ti-user-check me-2"></i> **<?php echo e(count($selected_users)); ?>** کاربر انتخاب شده است.
                                            <?php $__errorArgs = ['selected_users'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger d-block mt-1"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    <?php else: ?>
                                        <?php $__errorArgs = ['selected_users'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger fw-bold mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php endif; ?>
                                </div>


                                <div class="border rounded-3 overflow-hidden">
                                    <div wire:loading.flex wire:target="search_users, perPage, company_id, department_id" class="text-muted justify-content-center py-4">
                                        <i class="ti ti-loader animate-spin me-1"></i> در حال بارگذاری کاربران...
                                    </div>

                                    <?php if(!$paginated->count()): ?>
                                        <div class="text-center text-muted py-5 bg-white">
                                            <i class="ti ti-search-off fs-1 d-block mb-2"></i>
                                            کاربری با فیلترهای انتخابی پیدا نشد.
                                        </div>
                                    <?php else: ?>
                                        <div class="list-group list-group-flush">
                                            <?php $__currentLoopData = $paginated; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <label class="list-group-item d-flex align-items-center justify-content-between user-list-group-item" wire:key="user-<?php echo e($user->id); ?>">
                                                    <div class="d-flex align-items-center gap-3">
                                                        <input class="form-check-input mt-0" type="checkbox"
                                                               wire:click="toggleUserSelection(<?php echo e($user->id); ?>)"
                                                            <?php if(in_array($user->id, $selected_users,true)): echo 'checked'; endif; ?>>
                                                        <div>
                                                            <div class="fw-medium"><?php echo e($user->name); ?></div>
                                                            <small class="text-muted d-block"><?php echo e($user->email); ?></small>
                                                            <div class="mt-1 d-flex flex-wrap gap-2">
                                                                <?php if($user->company): ?>
                                                                    <span class="badge bg-light text-secondary"><i class="ti ti-building me-1"></i><?php echo e($user->company->name); ?></span>
                                                                <?php endif; ?>
                                                                <?php if($user->department): ?>
                                                                    <span class="badge bg-light text-secondary"><i class="ti ti-sitemap me-1"></i><?php echo e($user->department->name); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <span class="badge bg-secondary opacity-75 d-none d-md-inline">ID: <?php echo e($user->id); ?></span>
                                                </label>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>

                                        <div class="p-3 bg-white border-top">
                                            <?php echo e($paginated->onEachSide(1)->links()); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>

                            </div>
                        <?php endif; ?>

                        
                        <div class="position-sticky bottom-0 bg-white pt-4 mt-4 border-top" style="z-index:100; margin-left: -2.5rem; margin-right: -2.5rem; padding-left: 2.5rem; padding-right: 2.5rem;">
                            <div class="d-flex gap-3 justify-content-end">
                                <button type="button" wire:click="$refresh" class="btn btn-outline-secondary btn-lg" wire:loading.attr="disabled">
                                    <i class="ti ti-refresh me-1"></i> ریست فرم
                                </button>
                                <button type="submit" class="btn btn-primary btn-lg px-5 shadow" wire:loading.attr="disabled">
                                    <span wire:loading.remove><i class="ti ti-send me-1"></i> **ارسال اطلاعیه**</span>
                                    <span wire:loading><i class="ti ti-loader animate-spin me-1"></i> در حال ارسال...</span>
                                </button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>

        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            // Script is identical to the original, ensuring the Swal confirmation works seamlessly
            async function safeConfirm({title, text}) {
                if (window.Swal) {
                    const res = await Swal.fire({
                        title: title || 'تایید',
                        text: text || 'مطمئن هستید؟',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'بله',
                        cancelButtonText: 'لغو',
                        reverseButtons: true,
                        buttonsStyling: false,
                        customClass: { confirmButton: 'btn btn-primary', cancelButton: 'btn btn-outline-secondary' }
                    });
                    return res.isConfirmed;
                }
                return window.confirm(text || 'Are you sure?');
            }

            document.addEventListener('livewire:init', () => {
                Livewire.on('confirm:send', async (data) => {
                    const ok = await safeConfirm({ title: data.title, text: data.text });
                    if (ok) Livewire.dispatch('confirmedSend');
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\announcement\create-announcement.blade.php ENDPATH**/ ?>