<?php $__currentLoopData = $nodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $node): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    
    <div class="dept-node-item-container" style="padding-right: <?php echo e($depth * 20); ?>px;" wire:key="dep-<?php echo e($node['id']); ?>">

        <div class="d-flex align-items-center gap-3 dept-node-header dept-node-hover-effect">

            
            <?php if(!empty($node['children'])): ?>
                <button type="button" class="btn btn-sm btn-link text-action-primary p-0 dept-toggle-btn"
                        onclick="toggleChildren(<?php echo e($node['id']); ?>)" title="نمایش زیرمجموعه‌ها">
                    <i class="ti ti-chevron-down node-arrow" id="arrow-<?php echo e($node['id']); ?>"></i>
                </button>
            <?php else: ?>
                
                <div style="width: 20px; flex-shrink: 0;"></div>
            <?php endif; ?>

            
            <span class="node-title-strip fw-bold text-dark-primary d-flex align-items-center gap-2 flex-grow-1"
                  <?php if($node['color']): ?> style="border-right: 5px solid <?php echo e($node['color']); ?>; padding-right: 12px; margin-right: -12px;" <?php endif; ?>>
                <span class="status-dot status-<?php echo e($node['status']); ?>"></span>
                <?php echo e($node['name']); ?>

            </span>

            <small class="text-secondary-light badge bg-light-soft fw-medium node-code-badge"><?php echo e($node['code'] ?? '—'); ?></small>

            
            <span class="badge bg-soft-info text-info fw-medium node-user-count">
                <i class="ti ti-users me-1"></i> <?php echo e($node['users_count']); ?> نفر
            </span>
            <span class="badge status-badge status-<?php echo e($node['status']); ?>">
                 <?php echo e($node['status'] === 'active' ? 'فعال' : 'غیرفعال'); ?>

            </span>

            
            <div class="ms-3 d-flex gap-2 actions-group">

                <button wire:click="openMembersModal(<?php echo e($node['id']); ?>)"
                        class="btn btn-sm btn-outline-action-primary p-1 rounded-circle action-btn-size" title="مدیریت اعضا">
                    <i class="ti ti-user-plus fs-5"></i>
                </button>

                <button wire:click="edit(<?php echo e($node['id']); ?>)"
                        class="btn btn-sm btn-outline-warning p-1 rounded-circle action-btn-size" title="ویرایش">
                    <i class="ti ti-pencil fs-5"></i>
                </button>

                <button wire:click="delete(<?php echo e($node['id']); ?>)"
                        wire:confirm="آیا مطمئن هستید که این دپارتمان حذف شود؟"
                        class="btn btn-sm btn-outline-danger p-1 rounded-circle action-btn-size" title="حذف">
                    <i class="ti ti-trash fs-5"></i>
                </button>
            </div>
        </div>

        
        <?php if(!empty($node['children'])): ?>
            <div id="children-<?php echo e($node['id']); ?>" class="mt-2 children-list" style="display: none;">
                <?php echo $__env->make('livewire.admin.departments.tree-node', ['nodes' => $node['children'], 'depth' => $depth + 1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        <?php endif; ?>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<script>
    // 💡 تابع جاوااسکریپت برای مدیریت باز و بسته کردن گره‌ها
    function toggleChildren(id) {
        const childrenDiv = document.getElementById(`children-${id}`);
        const arrow = document.getElementById(`arrow-${id}`);

        if (childrenDiv.style.display === 'none' || childrenDiv.style.display === '') {
            childrenDiv.style.display = 'block';
            if (arrow) arrow.style.transform = 'rotate(180deg)';
        } else {
            childrenDiv.style.display = 'none';
            if (arrow) arrow.style.transform = 'rotate(0deg)';
        }
    }
</script>

<style>
    /* --- CSS Global Variables (Assuming Parent Has Them) --- */
    :root {
        --action-color: #4361EE;
        --warning-color: #F59E0B;
        --danger-color: #EF4444;
        --success-color: #10B981;
        --dark-primary: #1F2937;
        --secondary-light: #6B7280;
        --border-color: #E5E7EB;
        --primary-light-bg: #F0F3FF;
        --light-soft: #F8FAFB;
    }

    /* === Node Item Styling === */
    .dept-node-item-container {
        border-bottom: 1px dashed var(--border-color);
        padding: 10px 0;
        margin-left: 5px;
    }

    .dept-node-item-container:last-of-type {
        border-bottom: none;
    }

    .dept-node-header {
        position: relative;
        padding: 0.5rem 0;
        border-radius: 8px;
        transition: background-color 0.2s ease;
    }

    .dept-node-hover-effect:hover {
        background-color: var(--light-soft);
    }

    .node-title-strip {
        /* Ensure the title is vertically centered with the color strip */
        display: flex;
        align-items: center;
        flex-shrink: 0;
    }

    /* Status Dot */
    .status-dot {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        display: inline-block;
        margin-left: 8px;
        flex-shrink: 0;
    }
    .status-active { background-color: var(--success-color); }
    .status-inactive { background-color: var(--secondary-light); }

    /* Indentation for Children */
    .children-list {
        border-left: 2px solid #E5E7EB;
        padding-left: 1rem;
        margin-left: 0.5rem;
    }

    /* Toggle Button Animation */
    .node-arrow {
        transition: transform 0.3s ease;
        font-size: 1.1rem;
    }

    /* Action Buttons (Mini Circles) */
    .action-btn-size {
        width: 30px !important;
        height: 30px !important;
        padding: 0 !important;
        font-size: 0.8rem;
    }
    .actions-group {
        flex-shrink: 0;
    }

    .btn-outline-action-primary {
        color: var(--action-color);
        border-color: var(--action-color);
    }
    .btn-outline-action-primary:hover {
        background-color: var(--action-color);
        color: white;
    }

    .btn-outline-warning { color: var(--warning-color); border-color: var(--warning-color); }
    .btn-outline-danger { color: var(--danger-color); border-color: var(--danger-color); }

    /* Utility */
    .bg-light-soft { background-color: #F8FAFB !important; }
    .bg-soft-primary { background-color: var(--primary-light-bg) !important; }
</style><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\departments\tree-node.blade.php ENDPATH**/ ?>